/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.results.locks;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.netbeans.lib.profiler.results.locks.LockGraphBuilder;
import org.netbeans.lib.profiler.results.locks.MonitorInfo;

class ThreadInfo {
    private final int threadId;
    private final Map<MonitorInfo, MonitorDetail> waitMonitors;
    private final Map<MonitorInfo, MonitorDetail> ownerMonitors;
    private OpenMonitor openMonitor;
    private final String threadName;
    private final String threadClassName;

    ThreadInfo(int id, String name, String className) {
        this.threadId = id;
        this.threadName = name;
        this.threadClassName = className;
        this.waitMonitors = new HashMap<MonitorInfo, MonitorDetail>();
        this.ownerMonitors = new HashMap<MonitorInfo, MonitorDetail>();
    }

    void openMonitor(ThreadInfo owner, MonitorInfo mi, long timeStamp) {
        assert (this.openMonitor == null);
        this.openMonitor = new OpenMonitor(mi, owner, timeStamp);
    }

    void closeMonitor(MonitorInfo mi, long timeStamp) {
        assert (this.openMonitor != null);
        assert (mi.equals(this.openMonitor.monitor));
        long wait = timeStamp - this.openMonitor.timeStamp;
        if (LockGraphBuilder.LOG.isLoggable(Level.FINEST)) {
            LockGraphBuilder.LOG.log(Level.FINEST, "Monitor exit mId = {0}, time diff = {1}", new Object[]{Integer.toHexString(mi.hashCode()), wait});
        }
        ThreadInfo.addMonitor(this.waitMonitors, mi, this.openMonitor.owner, wait);
        ThreadInfo.addMonitor(this.openMonitor.owner.ownerMonitors, mi, this, wait);
        this.openMonitor = null;
    }

    private static void addMonitor(Map<MonitorInfo, MonitorDetail> monitors, MonitorInfo mi, ThreadInfo ti, long wait) {
        MonitorDetail m = monitors.get(mi);
        if (m == null) {
            m = new MonitorDetail(mi);
            monitors.put(mi, m);
        }
        m.addWait(ti, wait);
    }

    void timeAdjust(long timeDiff) {
        if (this.openMonitor != null) {
            this.openMonitor.timeAdjust(timeDiff);
            this.openMonitor.monitor.timeAdjust(this, timeDiff);
        }
    }

    boolean isEmpty() {
        return this.waitMonitors.isEmpty() && this.ownerMonitors.isEmpty();
    }

    List<MonitorDetail> cloneWaitMonitorDetails() {
        return ThreadInfo.cloneMonitorDetails(this.waitMonitors);
    }

    List<MonitorDetail> cloneOwnerMonitorDetails() {
        return ThreadInfo.cloneMonitorDetails(this.ownerMonitors);
    }

    private static List<MonitorDetail> cloneMonitorDetails(Map<MonitorInfo, MonitorDetail> monitors) {
        ArrayList<MonitorDetail> details = new ArrayList<MonitorDetail>(monitors.size());
        for (MonitorDetail m : monitors.values()) {
            details.add(new MonitorDetail(m));
        }
        return details;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof ThreadInfo) {
            ThreadInfo mi = (ThreadInfo)obj;
            return mi.threadId == this.threadId;
        }
        return false;
    }

    public int hashCode() {
        return this.threadId;
    }

    String getName() {
        return this.threadName;
    }

    private static class OpenMonitor {
        final MonitorInfo monitor;
        final ThreadInfo owner;
        long timeStamp;

        OpenMonitor(MonitorInfo mi, ThreadInfo ti, long ts0) {
            assert (mi != null);
            assert (ti != null);
            this.monitor = mi;
            this.owner = ti;
            this.timeStamp = ts0;
        }

        private void timeAdjust(long timeDiff) {
            this.timeStamp += timeDiff;
        }
    }

    static class MonitorDetail {
        final MonitorInfo monitor;
        final Map<ThreadInfo, MonitorInfo.ThreadDetail> threads;
        long count;
        long waitTime;

        private MonitorDetail(MonitorInfo mi) {
            this.monitor = mi;
            this.threads = new HashMap<ThreadInfo, MonitorInfo.ThreadDetail>();
        }

        MonitorDetail(MonitorDetail m) {
            this.monitor = m.monitor;
            this.count = m.count;
            this.waitTime = m.waitTime;
            this.threads = new HashMap<ThreadInfo, MonitorInfo.ThreadDetail>();
            for (MonitorInfo.ThreadDetail td : m.threads.values()) {
                this.threads.put(td.threadInfo, td);
            }
        }

        List<MonitorInfo.ThreadDetail> cloneThreadDetails() {
            return MonitorInfo.cloneThreadDetails(this.threads);
        }

        private void addWait(ThreadInfo ti, long wait) {
            this.waitTime += wait;
            ++this.count;
            if (ti != null) {
                this.addThread(ti, wait);
            }
        }

        private void addThread(ThreadInfo ti, long wait) {
            MonitorInfo.ThreadDetail td = this.threads.get(ti);
            if (td == null) {
                td = new MonitorInfo.ThreadDetail(ti);
                this.threads.put(ti, td);
            }
            td.addWait(null, wait);
        }
    }
}

