/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.verification;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.text.BadLocationException;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.csl.api.EditList;
import org.netbeans.modules.csl.api.Hint;
import org.netbeans.modules.csl.api.HintFix;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.api.Rule;
import org.netbeans.modules.csl.spi.support.CancelSupport;
import org.netbeans.modules.php.api.PhpVersion;
import org.netbeans.modules.php.editor.CodeUtils;
import org.netbeans.modules.php.editor.parser.PHPParseResult;
import org.netbeans.modules.php.editor.parser.astnodes.ASTNode;
import org.netbeans.modules.php.editor.parser.astnodes.Block;
import org.netbeans.modules.php.editor.parser.astnodes.Expression;
import org.netbeans.modules.php.editor.parser.astnodes.FormalParameter;
import org.netbeans.modules.php.editor.parser.astnodes.LambdaFunctionDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.ReturnStatement;
import org.netbeans.modules.php.editor.parser.astnodes.Statement;
import org.netbeans.modules.php.editor.parser.astnodes.visitors.DefaultVisitor;
import org.netbeans.modules.php.editor.verification.Bundle;
import org.netbeans.modules.php.editor.verification.PHPRuleContext;
import org.netbeans.modules.php.editor.verification.SuggestionRule;
import org.netbeans.modules.php.editor.verification.VerificationUtils;
import org.openide.filesystems.FileObject;

public class ArrowFunctionSuggestion
extends SuggestionRule {
    private static final String HINT_ID = "Arrow.Function.Suggestion";

    public String getId() {
        return HINT_ID;
    }

    public String getDescription() {
        return Bundle.ArrowFunctionSuggestion_Description();
    }

    public String getDisplayName() {
        return Bundle.ArrowFunctionSuggestion_DisplayName();
    }

    @Override
    public void invoke(PHPRuleContext context, List<Hint> result) {
        FileObject fileObject;
        PHPParseResult phpParseResult = (PHPParseResult)context.parserResult;
        if (phpParseResult.getProgram() == null) {
            return;
        }
        if (CancelSupport.getDefault().isCancelled()) {
            return;
        }
        BaseDocument doc = context.doc;
        int caretOffset = this.getCaretOffset();
        OffsetRange lineBounds = VerificationUtils.createLineBounds(caretOffset, doc);
        if (lineBounds.containsInclusive(caretOffset) && (fileObject = phpParseResult.getSnapshot().getSource().getFileObject()) != null && this.isAtLeastPhp74(fileObject)) {
            CheckVisitor checkVisitor = new CheckVisitor(fileObject, this, context.doc, lineBounds);
            phpParseResult.getProgram().accept(checkVisitor);
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            result.addAll(checkVisitor.getHints());
        }
    }

    protected boolean isAtLeastPhp74(FileObject fileObject) {
        return CodeUtils.isPhpVersionGreaterThan(fileObject, PhpVersion.PHP_73);
    }

    private static final class CheckVisitor
    extends DefaultVisitor {
        private final FileObject fileObject;
        private final ArrowFunctionSuggestion suggestion;
        private final BaseDocument document;
        private final OffsetRange lineRange;
        private final List<FixInfo> fixInfos = new ArrayList<FixInfo>();

        public CheckVisitor(FileObject fileObject, ArrowFunctionSuggestion suggestion, BaseDocument document, OffsetRange lineRange) {
            this.fileObject = fileObject;
            this.suggestion = suggestion;
            this.document = document;
            this.lineRange = lineRange;
        }

        public List<Hint> getHints() {
            ArrayList<Hint> hints = new ArrayList<Hint>();
            for (int i = this.fixInfos.size() - 1; 0 <= i; --i) {
                if (CancelSupport.getDefault().isCancelled()) {
                    return Collections.emptyList();
                }
                hints.add(new Hint((Rule)this.suggestion, Bundle.ArrowFunctionSuggestion_Hint_Description(), this.fileObject, this.lineRange, this.createFixes(this.fixInfos.get(i)), 500));
            }
            return hints;
        }

        private List<HintFix> createFixes(FixInfo fixInfo) {
            ArrayList<HintFix> hintFixes = new ArrayList<HintFix>();
            hintFixes.add(fixInfo.createFix(this.document));
            return hintFixes;
        }

        @Override
        public void scan(ASTNode node) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            if (node != null && VerificationUtils.isBefore(node.getStartOffset(), this.lineRange.getEnd())) {
                super.scan(node);
            }
        }

        @Override
        public void visit(LambdaFunctionDeclaration node) {
            OffsetRange nodeRange = new OffsetRange(node.getStartOffset(), node.getEndOffset());
            if (this.lineRange.overlaps(nodeRange)) {
                this.processLambdaFunctionDeclaration(node);
            }
        }

        private void processLambdaFunctionDeclaration(LambdaFunctionDeclaration node) {
            Expression expression;
            Statement statement;
            List<Statement> statements;
            Block body = node.getBody();
            if (body != null && (statements = body.getStatements()).size() == 1 && (statement = statements.get(0)) instanceof ReturnStatement && (expression = ((ReturnStatement)statement).getExpression()) != null) {
                this.fixInfos.add(new FixInfo(node, expression));
            }
            super.visit(node);
        }
    }

    private static final class Fix
    implements HintFix {
        private final FixInfo fixInfo;
        private final BaseDocument document;

        private Fix(FixInfo fixInfo, BaseDocument document) {
            this.fixInfo = fixInfo;
            this.document = document;
        }

        public String getDescription() {
            return Bundle.ArrowFunctionSuggestion_Fix_Description();
        }

        public void implement() throws Exception {
            EditList edits = new EditList(this.document);
            OffsetRange lambdaFunctionRange = this.fixInfo.getLambdaFunctionDeclarationRange();
            String arrowFunctionText = String.format("fn%s(%s)%s => %s", this.fixInfo.getReference(), this.fixInfo.getFormalParameter(this.document), this.fixInfo.getReturnType(this.document), this.fixInfo.getReturnExpression(this.document));
            edits.replace(lambdaFunctionRange.getStart(), lambdaFunctionRange.getLength(), arrowFunctionText, true, 0);
            edits.apply();
        }

        public boolean isSafe() {
            return true;
        }

        public boolean isInteractive() {
            return false;
        }
    }

    private static final class FixInfo {
        private final LambdaFunctionDeclaration lambdaFunction;
        private final Expression returnExpression;

        public FixInfo(LambdaFunctionDeclaration lambdaFunction, Expression returnExpression) {
            this.lambdaFunction = lambdaFunction;
            this.returnExpression = returnExpression;
        }

        public OffsetRange getLambdaFunctionDeclarationRange() {
            return new OffsetRange(this.lambdaFunction.getStartOffset(), this.lambdaFunction.getEndOffset());
        }

        public String getFormalParameter(BaseDocument document) throws BadLocationException {
            List<FormalParameter> parameters = this.lambdaFunction.getFormalParameters();
            if (parameters.isEmpty()) {
                return "";
            }
            int startOffset = parameters.get(0).getStartOffset();
            int endOffset = parameters.get(parameters.size() - 1).getEndOffset();
            return document.getText(startOffset, endOffset - startOffset);
        }

        public String getReturnType(BaseDocument document) throws BadLocationException {
            Expression returnType = this.lambdaFunction.getReturnType();
            if (returnType != null) {
                return ": " + document.getText(returnType.getStartOffset(), returnType.getEndOffset() - returnType.getStartOffset());
            }
            return "";
        }

        public String getReturnExpression(BaseDocument document) throws BadLocationException {
            return document.getText(this.returnExpression.getStartOffset(), this.returnExpression.getEndOffset() - this.returnExpression.getStartOffset());
        }

        public String getReference() {
            return this.lambdaFunction.isReference() ? "&" : "";
        }

        public HintFix createFix(BaseDocument document) {
            return new Fix(this, document);
        }
    }
}

