/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.problems;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.execution.MavenExecutionResult;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.building.ModelBuildingException;
import org.apache.maven.model.building.ModelProblem;
import org.apache.maven.model.resolution.UnresolvableModelException;
import org.apache.maven.plugin.PluginManagerException;
import org.apache.maven.plugin.PluginResolutionException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuildingException;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.java.queries.SourceForBinaryQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.maven.InternalActionDelegate;
import org.netbeans.modules.maven.NbArtifactFixer;
import org.netbeans.modules.maven.NbMavenProjectImpl;
import org.netbeans.modules.maven.actions.OpenPOMAction;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.maven.embedder.EmbedderFactory;
import org.netbeans.modules.maven.embedder.MavenEmbedder;
import org.netbeans.modules.maven.modelcache.MavenProjectCache;
import org.netbeans.modules.maven.problems.Bundle;
import org.netbeans.modules.maven.problems.ProblemReporterImpl;
import org.netbeans.modules.maven.problems.SanityBuildAction;
import org.netbeans.spi.project.ActionProgress;
import org.netbeans.spi.project.ActionProvider;
import org.netbeans.spi.project.ui.ProjectProblemResolver;
import org.netbeans.spi.project.ui.ProjectProblemsProvider;
import org.openide.filesystems.FileUtil;
import org.openide.util.Cancellable;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.Pair;
import org.openide.util.RequestProcessor;
import org.openide.util.lookup.Lookups;

public class MavenModelProblemsProvider
implements ProjectProblemsProvider,
InternalActionDelegate,
SanityBuildAction.SanityBuildNeededChecker {
    static final RequestProcessor RP = new RequestProcessor(MavenModelProblemsProvider.class);
    private static final Logger LOG = Logger.getLogger(MavenModelProblemsProvider.class.getName());
    private final PropertyChangeSupport support = new PropertyChangeSupport(this);
    private final Project project;
    private final PrimingActionProvider primingProvider = new PrimingActionProvider();
    private ProblemReporterImpl problemReporter;
    private Pair<Collection<ProjectProblemsProvider.ProjectProblem>, Boolean> problemsCache = null;
    private boolean projectListenerSet;
    private Reference<MavenProject> analysedProject = new WeakReference<Object>(null);
    private final PropertyChangeListener projectListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("MavenProject".equals(evt.getPropertyName())) {
                MavenModelProblemsProvider.this.firePropertyChange();
            }
        }
    };
    private boolean sanityBuildStatus;
    private boolean checkMissing = true;
    private Reference<SanityBuildAction> cachedSanityBuild = new WeakReference<Object>(null);
    private static final String[] PROBLEM_ACTIONS = new String[]{"prime"};

    public MavenModelProblemsProvider(Project project) {
        this.project = project;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.support.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.support.removePropertyChangeListener(listener);
    }

    public Collection<? extends ProjectProblemsProvider.ProjectProblem> getProblems() {
        Collection<? extends ProjectProblemsProvider.ProjectProblem> prbs = this.doGetProblems(false);
        return prbs != null ? prbs : Collections.emptyList();
    }

    @Override
    public boolean isSanityBuildNeeded() {
        return (Boolean)this.doGetProblems1(true).second();
    }

    Collection<? extends ProjectProblemsProvider.ProjectProblem> doGetProblems(boolean sync) {
        return (Collection)this.doGetProblems1(sync).first();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Pair<Collection<ProjectProblemsProvider.ProjectProblem>, Boolean> doGetProblems1(boolean sync) {
        Callable<Pair> c;
        CompletableFuture<MavenProject> pending = ((NbMavenProjectImpl)this.project).getFreshOriginalMavenProject();
        MavenModelProblemsProvider mavenModelProblemsProvider = this;
        synchronized (mavenModelProblemsProvider) {
            MavenProject o;
            block15: {
                if (!this.projectListenerSet) {
                    this.projectListenerSet = true;
                    this.problemReporter = ((NbMavenProjectImpl)this.project.getLookup().lookup(NbMavenProjectImpl.class)).getProblemReporter();
                    assert (this.problemReporter != null);
                    ((NbMavenProject)this.project.getLookup().lookup(NbMavenProject.class)).addPropertyChangeListener(this.projectListener);
                }
                o = this.analysedProject.get();
                if (pending.isDone()) {
                    try {
                        MavenProject updatedPrj = pending.get();
                        LOG.log(Level.FINER, "Called getProblems for {0}, analysed = {1}, current = {2}", new Object[]{this.project, System.identityHashCode(o), System.identityHashCode(updatedPrj)});
                        Object wasprocessed = updatedPrj.getContextValue(MavenModelProblemsProvider.class.getName());
                        if (o != updatedPrj || wasprocessed == null) break block15;
                        Pair<Collection<ProjectProblemsProvider.ProjectProblem>, Boolean> cached = this.problemsCache;
                        LOG.log(Level.FINER, "getProblems: Project was processed, cached is: {0}", cached);
                        if (cached != null) {
                            return cached;
                        }
                    }
                    catch (InterruptedException | ExecutionException ex) {
                        LOG.log(Level.FINER, "Project load for {0} threw exception {1}", new Object[]{this.project, ex.getMessage()});
                        LOG.log(Level.FINER, "Stacktrace:", ex);
                    }
                } else {
                    LOG.log(Level.FINER, "Called getProblems for {0}, analysed = {1}, current = PENDING", new Object[]{this.project, System.identityHashCode(o)});
                }
            }
            SanityBuildAction sba = this.cachedSanityBuild.get();
            if (sba != null && sba.getPendingResult() == null) {
                this.cachedSanityBuild.clear();
            }
            c = () -> {
                MavenProject prj;
                try {
                    prj = ((NbMavenProjectImpl)this.project).getFreshOriginalMavenProject().get();
                    LOG.log(Level.FINER, "Evaluating getProblems for {0}, analysed = {1}, current = {2}", new Object[]{this.project, System.identityHashCode(o), System.identityHashCode(prj)});
                }
                catch (InterruptedException | ExecutionException ex) {
                    LOG.log(Level.FINER, "Project load for {0} threw exception {1}", new Object[]{this.project, ex.getMessage()});
                    LOG.log(Level.FINER, "Stacktrace:", ex);
                    return Pair.of(new ArrayList(), (Object)this.sanityBuildStatus);
                }
                Object wasprocessed2 = prj.getContextValue(MavenModelProblemsProvider.class.getName());
                MavenModelProblemsProvider mavenModelProblemsProvider = this;
                synchronized (mavenModelProblemsProvider) {
                    if (wasprocessed2 != null) {
                        Pair<Collection<ProjectProblemsProvider.ProjectProblem>, Boolean> cached = this.problemsCache;
                        LOG.log(Level.FINER, "getProblems: Project was processed #2, cached is: {0}", cached);
                        if (cached != null) {
                            return cached;
                        }
                    }
                }
                int round = 0;
                ArrayList<ProjectProblemsProvider.ProjectProblem> toRet = null;
                while (round <= 1) {
                    try {
                        LOG.log(Level.FINER, "Analysing project {0}@{1}, round {2}", new Object[]{prj, System.identityHashCode(prj), round});
                        boolean ok = false;
                        MavenModelProblemsProvider mavenModelProblemsProvider2 = this;
                        synchronized (mavenModelProblemsProvider2) {
                            block21: {
                                try {
                                    this.sanityBuildStatus = false;
                                    this.checkMissing = round < 1;
                                    toRet = new ArrayList<ProjectProblemsProvider.ProjectProblem>();
                                    MavenExecutionResult res = MavenProjectCache.getExecutionResult(prj);
                                    if (res != null && res.hasExceptions()) {
                                        Collection<ProjectProblemsProvider.ProjectProblem> exceptions = this.reportExceptions(res);
                                        LOG.log(Level.FINE, "Project has loaded with exceptions: {0}", exceptions);
                                        toRet.addAll(exceptions);
                                    }
                                    toRet.addAll(this.doArtifactChecks(prj));
                                    LOG.log(Level.FINER, "getProblems: Project {1} processing finished, result is: {0}", new Object[]{toRet, prj});
                                    ok = true;
                                    if (!ok && round <= 0) break block21;
                                }
                                catch (Throwable throwable) {
                                    if (ok || round > 0) {
                                        LOG.log(Level.FINER, "Project {0} problems: {1}, sanity {2}, ok {3}, round {4}", new Object[]{prj, this.sanityBuildStatus, ok, round});
                                        prj.setContextValue(MavenModelProblemsProvider.class.getName(), new Object());
                                        this.problemsCache = Pair.of(toRet, (Object)this.sanityBuildStatus);
                                        this.analysedProject = new WeakReference<MavenProject>(prj);
                                    }
                                    this.checkMissing = true;
                                    throw throwable;
                                }
                                LOG.log(Level.FINER, "Project {0} problems: {1}, sanity {2}, ok {3}, round {4}", new Object[]{prj, this.sanityBuildStatus, ok, round});
                                prj.setContextValue(MavenModelProblemsProvider.class.getName(), new Object());
                                this.problemsCache = Pair.of(toRet, (Object)this.sanityBuildStatus);
                                this.analysedProject = new WeakReference<MavenProject>(prj);
                            }
                            this.checkMissing = true;
                        }
                    }
                    catch (ProblemReporterImpl.ArtifactFoundException ex) {
                        assert (round < 1);
                        LOG.log(Level.FINER, "getProblems: Project {1} reported missing artifact that actually exists, restarting - {0} round", new Object[]{++round, prj});
                        NbMavenProject.fireMavenProjectReload(this.project);
                        try {
                            prj = ((NbMavenProjectImpl)this.project).getFreshOriginalMavenProject().get();
                            continue;
                        }
                        catch (InterruptedException | ExecutionException ex2) {
                            LOG.log(Level.FINER, "Project load for {0} threw exception {1}", new Object[]{this.project, ex2.getMessage()});
                            LOG.log(Level.FINER, "Stacktrace:", ex2);
                        }
                    }
                    break;
                }
                if (prj != null && !this.sanityBuildStatus) {
                    prj.setContextValue("org.netbeans.modules.maven.problems.primingNotDone", null);
                    LOG.log(Level.FINE, "Clearing priming status of {0}, fallback status is {1}", new Object[]{prj, NbMavenProject.isErrorPlaceholder(prj)});
                }
                this.firePropertyChange();
                return Pair.of(toRet, (Object)this.sanityBuildStatus);
            };
        }
        if (sync || Boolean.getBoolean("test.reload.sync")) {
            try {
                return c.call();
            }
            catch (Exception ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        } else {
            RP.submit(c);
        }
        return Pair.of(null, (Object)true);
    }

    private void firePropertyChange() {
        this.support.firePropertyChange("problems", null, null);
    }

    private void addMissingArtifact(Artifact a) {
        this.problemReporter.addMissingArtifact(a, this.checkMissing);
    }

    private static String artifactId(Artifact a) {
        return a.getGroupId() + ":" + a.getArtifactId() + ":" + a.getVersion() + ":" + (a.getClassifier() == null ? "" : a.getClassifier()) + "/" + a.getType();
    }

    public Collection<ProjectProblemsProvider.ProjectProblem> doArtifactChecks(@NonNull MavenProject project) {
        ArrayList<ProjectProblemsProvider.ProjectProblem> toRet = new ArrayList<ProjectProblemsProvider.ProjectProblem>();
        LOG.log(Level.FINE, "Performing artifact checks for {0}", project);
        if (MavenProjectCache.unknownBuildParticipantObserved(project)) {
            StringBuilder sb = new StringBuilder();
            for (String s : MavenProjectCache.getUnknownBuildParticipantsClassNames(project)) {
                sb.append(s).append("\n");
            }
            toRet.add(ProjectProblemsProvider.ProjectProblem.createWarning((String)Bundle.ERR_Participant(), (String)Bundle.MSG_Participant(sb.toString())));
        }
        toRet.addAll(this.checkParents(project));
        boolean missingNonSibling = false;
        ArrayList<Artifact> missingJars = new ArrayList<Artifact>();
        ArrayList artifactsToCheck = new ArrayList(project.getArtifacts());
        MavenProject partial = MavenProjectCache.getPartialProject(project);
        Collection<Artifact> placeholders = MavenProjectCache.getPlaceholderArtifacts(project);
        if (LOG.isLoggable(Level.FINER)) {
            LOG.log(Level.FINER, "Checking artifacts: {0}", artifactsToCheck);
            if (partial != null && partial != project) {
                Collection<Artifact> partialPlaceholders = MavenProjectCache.getPlaceholderArtifacts(partial);
                LOG.log(Level.FINER, "Partial project for {0}@{1} is: {2}@{3}, placeholder artifacts: {4}", new Object[]{project, System.identityHashCode(project), partial, System.identityHashCode(partial), partialPlaceholders});
            }
            LOG.log(Level.FINER, "Placeholder artifacts for {0}@{1}: {2}", new Object[]{project, System.identityHashCode(project), placeholders});
        }
        HashSet toCheck = new HashSet(project.getArtifacts());
        if (placeholders != null) {
            Set ids = toCheck.stream().map(MavenModelProblemsProvider::artifactId).collect(Collectors.toSet());
            placeholders.stream().filter(a -> !ids.contains(MavenModelProblemsProvider.artifactId(a))).forEach(toCheck::add);
        }
        for (Artifact art : toCheck) {
            File file = art.getFile();
            LOG.log(Level.FINEST, "Checking {0}", art);
            if (file == null || !file.exists()) {
                LOG.log(Level.FINEST, "File does not exist for {0}", art);
                if ("system".equals(art.getScope())) {
                    toRet.add(ProjectProblemsProvider.ProjectProblem.createWarning((String)Bundle.ERR_SystemScope(), (String)Bundle.MSG_SystemScope(), (ProjectProblemResolver)new ProblemReporterImpl.MavenProblemResolver(OpenPOMAction.instance().createContextAwareInstance(Lookups.fixed((Object[])new Object[]{project})), "SCOPE_DEPENDENCY")));
                    continue;
                }
                this.addMissingArtifact(art);
                if (file == null) {
                    missingNonSibling = true;
                } else {
                    SourceForBinaryQuery.Result2 result;
                    URL archiveUrl = FileUtil.urlForArchiveOrDir((File)file);
                    LOG.log(Level.FINEST, "File for {0} is {1}, archive URL {2}", new Object[]{art, file, archiveUrl});
                    if (!(archiveUrl == null || (result = SourceForBinaryQuery.findSourceRoots2((URL)archiveUrl)).preferSources() && result.getRoots().length != 0)) {
                        LOG.log(Level.FINE, "Missing nonsibling artifact: {0}", art);
                        missingNonSibling = true;
                    }
                }
                missingJars.add(art);
                continue;
            }
            if (!NbArtifactFixer.isFallbackFile(file)) continue;
            LOG.log(Level.FINEST, "Artifact is a fallback {0} with file {1}", new Object[]{art, file});
            this.addMissingArtifact(art);
            missingJars.add(art);
            missingNonSibling = true;
        }
        if (!missingJars.isEmpty()) {
            StringBuilder mess = new StringBuilder();
            for (Artifact art : missingJars) {
                mess.append(art.getId()).append('\n');
            }
            LOG.log(Level.FINER, "Project is missing artifacts: {0}, nonlocal = {1}", new Object[]{missingJars, missingNonSibling});
            if (missingNonSibling) {
                toRet.add(ProjectProblemsProvider.ProjectProblem.createWarning((String)Bundle.ERR_NonLocal(), (String)Bundle.MSG_NonLocal(mess), (ProjectProblemResolver)this.createSanityBuildAction()));
            }
        }
        return toRet;
    }

    private Collection<ProjectProblemsProvider.ProjectProblem> checkParents(@NonNull MavenProject project) {
        List mdls = MavenEmbedder.getModelDescriptors((MavenProject)project);
        boolean first = true;
        if (mdls == null) {
            return Collections.emptyList();
        }
        ArrayList<ProjectProblemsProvider.ProjectProblem> toRet = new ArrayList<ProjectProblemsProvider.ProjectProblem>();
        for (MavenEmbedder.ModelDescription m : mdls) {
            if (first) {
                first = false;
                continue;
            }
            if (!"F@LLB@CK".equals(m.getName())) continue;
            toRet.add(ProjectProblemsProvider.ProjectProblem.createError((String)Bundle.ERR_NoParent(), (String)Bundle.MSG_NoParent(m.getId()), (ProjectProblemResolver)this.createSanityBuildAction()));
            this.addMissingArtifact(EmbedderFactory.getProjectEmbedder().createArtifact(m.getGroupId(), m.getArtifactId(), m.getVersion(), "pom"));
        }
        return toRet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SanityBuildAction createSanityBuildAction() {
        MavenModelProblemsProvider mavenModelProblemsProvider = this;
        synchronized (mavenModelProblemsProvider) {
            Future<ProjectProblemsProvider.Result> r;
            SanityBuildAction a = this.cachedSanityBuild.get();
            this.sanityBuildStatus = true;
            LOG.log(Level.FINE, "Creating sanity build action for {0}", this.project.getProjectDirectory());
            if (a != null && (r = a.getPendingResult()) != null) {
                return a;
            }
            a = new SanityBuildAction(this.project, this::isSanityBuildNeeded);
            ((NbMavenProject)this.project.getLookup().lookup(NbMavenProject.class)).getMavenProject().setContextValue("org.netbeans.modules.maven.problems.primingNotDone", (Object)true);
            this.cachedSanityBuild = new WeakReference<SanityBuildAction>(a);
            return a;
        }
    }

    private Collection<ProjectProblemsProvider.ProjectProblem> reportExceptions(MavenExecutionResult res) {
        ArrayList<ProjectProblemsProvider.ProjectProblem> toRet = new ArrayList<ProjectProblemsProvider.ProjectProblem>();
        for (Throwable e : res.getExceptions()) {
            LOG.log(Level.FINE, "Error on loading project " + String.valueOf(this.project.getProjectDirectory()), e);
            if (e instanceof ArtifactResolutionException) {
                toRet.add(ProjectProblemsProvider.ProjectProblem.createError((String)Bundle.TXT_Artifact_Resolution_problem(), (String)this.getDescriptionText(e)));
                this.addMissingArtifact(((ArtifactResolutionException)e).getArtifact());
                continue;
            }
            if (e instanceof ArtifactNotFoundException) {
                toRet.add(ProjectProblemsProvider.ProjectProblem.createError((String)Bundle.TXT_Artifact_Not_Found(), (String)this.getDescriptionText(e)));
                this.addMissingArtifact(((ArtifactNotFoundException)e).getArtifact());
                continue;
            }
            if (e instanceof ProjectBuildingException) {
                LOG.log(Level.FINE, "Creating sanity build action for {0}", this.project.getProjectDirectory());
                toRet.add(ProjectProblemsProvider.ProjectProblem.createError((String)Bundle.TXT_Cannot_Load_Project(), (String)this.getDescriptionText(e), (ProjectProblemResolver)this.createSanityBuildAction()));
                if (!(e.getCause() instanceof ModelBuildingException)) continue;
                ModelBuildingException mbe = (ModelBuildingException)e.getCause();
                for (ModelProblem mp : mbe.getProblems()) {
                    LOG.log(Level.FINE, mp.toString(), mp.getException());
                    if (mp.getException() instanceof UnresolvableModelException) {
                        UnresolvableModelException ume = (UnresolvableModelException)mp.getException();
                        this.addMissingArtifact(EmbedderFactory.getProjectEmbedder().createProjectArtifact(ume.getGroupId(), ume.getArtifactId(), ume.getVersion()));
                        continue;
                    }
                    if (mp.getException() instanceof PluginResolutionException) {
                        Plugin plugin = ((PluginResolutionException)mp.getException()).getPlugin();
                        this.addMissingArtifact(EmbedderFactory.getProjectEmbedder().createArtifact(plugin.getGroupId(), plugin.getArtifactId(), plugin.getVersion(), "jar"));
                        continue;
                    }
                    if (!(mp.getException() instanceof PluginManagerException)) continue;
                    PluginManagerException ex = (PluginManagerException)mp.getException();
                    this.addMissingArtifact(EmbedderFactory.getProjectEmbedder().createArtifact(ex.getPluginGroupId(), ex.getPluginArtifactId(), ex.getPluginVersion(), "jar"));
                }
                continue;
            }
            String msg = e.getMessage();
            if (msg != null) {
                LOG.log(Level.INFO, "Exception thrown while loading maven project at " + String.valueOf(this.project.getProjectDirectory()), e);
                toRet.add(ProjectProblemsProvider.ProjectProblem.createError((String)Bundle.TXT_Cannot_read_model(), (String)msg));
                continue;
            }
            String path = this.project.getProjectDirectory().getPath();
            toRet.add(ProjectProblemsProvider.ProjectProblem.createError((String)Bundle.TXT_Cannot_read_model(), (String)Bundle.TXT_NoMsg(path)));
            LOG.log(Level.WARNING, "Exception thrown while loading maven project at " + path, e);
        }
        return toRet;
    }

    private String getDescriptionText(Throwable e) {
        String msg = e.getMessage();
        if (msg != null) {
            return msg;
        }
        String path = this.project.getProjectDirectory().getPath();
        return Bundle.TXT_NoMsg(path);
    }

    @Override
    public ActionProvider getActionProvider() {
        return this.primingProvider;
    }

    private boolean attachCancellable(Lookup context, CompletableFuture primingHandle) {
        Consumer c = (Consumer)context.lookup(Consumer.class);
        if (c != null) {
            int index = 0;
            Class<?>[] interfaces = c.getClass().getInterfaces();
            for (Type t : c.getClass().getGenericInterfaces()) {
                if (interfaces[index].getName().equals(Consumer.class.getName()) && ((ParameterizedType)t).getActualTypeArguments()[0].getTypeName().equals(Cancellable.class.getName())) {
                    c.accept(() -> primingHandle.cancel(true));
                    return true;
                }
                ++index;
            }
        }
        return false;
    }

    private class PrimingActionProvider
    implements ActionProvider {
        private PrimingActionProvider() {
        }

        public String[] getSupportedActions() {
            return PROBLEM_ACTIONS;
        }

        public void invokeAction(String command, Lookup context) throws IllegalArgumentException {
            ActionProgress listener = ActionProgress.start((Lookup)context);
            if (!PROBLEM_ACTIONS[0].equals(command)) {
                throw new IllegalArgumentException(command);
            }
            Collection<? extends ProjectProblemsProvider.ProjectProblem> probs = MavenModelProblemsProvider.this.doGetProblems(true);
            SanityBuildAction saba = MavenModelProblemsProvider.this.cachedSanityBuild.get();
            if (saba == null) {
                LOG.log(Level.FINE, "Sanity build action does not exist");
                listener.finished(true);
            } else {
                LOG.log(Level.FINE, "Resolving sanity build action");
                CompletableFuture<ProjectProblemsProvider.Result> primingHandle = saba.resolve(context);
                MavenModelProblemsProvider.this.attachCancellable(context, primingHandle);
                primingHandle.whenComplete((a, e) -> listener.finished(e == null));
            }
        }

        public boolean isActionEnabled(String command, Lookup context) throws IllegalArgumentException {
            if (!PROBLEM_ACTIONS[0].equals(command)) {
                return false;
            }
            Collection<? extends ProjectProblemsProvider.ProjectProblem> probs = MavenModelProblemsProvider.this.doGetProblems(false);
            if (probs == null) {
                LOG.log(Level.FINE, "Priming action enabled because problems are not yet evaluated.");
                return true;
            }
            if (probs.isEmpty()) {
                LOG.log(Level.FINE, "Priming action disabled, no problems found.");
                return false;
            }
            SanityBuildAction saba = MavenModelProblemsProvider.this.cachedSanityBuild.get();
            if (saba == null) {
                LOG.log(Level.FINE, "Problems present, but no SanityBuildAction created");
                return false;
            }
            Future<ProjectProblemsProvider.Result> res = saba.getPendingResult();
            LOG.log(Level.FINE, "Sanity build state is: {0}", res == null || res.isDone());
            return res == null || !res.isDone();
        }
    }
}

