/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.truffle.breakpoints.impl;

import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.ArrayReference;
import com.sun.jdi.BooleanValue;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.ClassType;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.IntegerValue;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.InvocationException;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.StringReference;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.Value;
import com.sun.jdi.VirtualMachine;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.jpda.CallStackFrame;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.debugger.jpda.JPDAThread;
import org.netbeans.api.debugger.jpda.LocalVariable;
import org.netbeans.api.debugger.jpda.MethodBreakpoint;
import org.netbeans.api.debugger.jpda.event.JPDABreakpointEvent;
import org.netbeans.api.debugger.jpda.event.JPDABreakpointListener;
import org.netbeans.modules.debugger.jpda.JPDADebuggerImpl;
import org.netbeans.modules.debugger.jpda.expr.JDIVariable;
import org.netbeans.modules.debugger.jpda.jdi.ClassNotPreparedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ClassTypeWrapper;
import org.netbeans.modules.debugger.jpda.jdi.InternalExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ObjectCollectedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ObjectReferenceWrapper;
import org.netbeans.modules.debugger.jpda.jdi.UnsupportedOperationExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.VMDisconnectedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.models.JPDAThreadImpl;
import org.netbeans.modules.debugger.jpda.truffle.PersistentValues;
import org.netbeans.modules.debugger.jpda.truffle.access.TruffleAccess;
import org.netbeans.modules.debugger.jpda.truffle.breakpoints.impl.TruffleBreakpointsRegistry;
import org.netbeans.modules.debugger.jpda.truffle.source.Source;
import org.netbeans.modules.debugger.jpda.truffle.source.SourceBinaryTranslator;
import org.netbeans.modules.javascript2.debug.breakpoints.JSBreakpointStatus;
import org.netbeans.modules.javascript2.debug.breakpoints.JSLineBreakpoint;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.Mutex;

public class TruffleBreakpointsHandler {
    private static final Logger LOG = Logger.getLogger(TruffleBreakpointsHandler.class.getName());
    private static final String ACCESSOR_SET_LINE_BREAKPOINT = "setLineBreakpoint";
    private static final String ACCESSOR_SET_LINE_BREAKPOINT_SIGNAT = "(Ljava/lang/String;IILjava/lang/String;)[Lcom/oracle/truffle/api/debug/Breakpoint;";
    private static final String ACCESSOR_SET_LINE_BREAKPOINT_MGR_SIGNAT = "(Lorg/netbeans/modules/debugger/jpda/backend/truffle/JPDATruffleDebugManager;Ljava/lang/String;IILjava/lang/String;)Lcom/oracle/truffle/api/debug/Breakpoint;";
    public static final String ACCESSOR_REMOVE_BREAKPOINT = "removeBreakpoint";
    public static final String ACCESSOR_REMOVE_BREAKPOINT_SIGNAT = "(Ljava/lang/Object;)V";
    private static final String ACCESSOR_LINE_BREAKPOINT_RESOLVED = "breakpointResolvedAccess";
    private final JPDADebugger debugger;
    private ClassType accessorClass;
    private volatile boolean initialBreakpointsSubmitted = false;
    private final Map<JSLineBreakpoint, Set<ObjectReference>> breakpointsMap = new HashMap<JSLineBreakpoint, Set<ObjectReference>>();
    private final JSBreakpointPropertyChangeListener breakpointsChangeListener = new JSBreakpointPropertyChangeListener();
    private final Object breakpointResolvedHandlerLock = new Object();
    private Breakpoint breakpointResolvedHandler;

    public TruffleBreakpointsHandler(JPDADebugger debugger) {
        this.debugger = debugger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        Map<JSLineBreakpoint, Set<ObjectReference>> map = this.breakpointsMap;
        synchronized (map) {
            for (JSLineBreakpoint jsbp : this.breakpointsMap.keySet()) {
                jsbp.removePropertyChangeListener((PropertyChangeListener)this.breakpointsChangeListener);
            }
        }
        if (this.breakpointResolvedHandler != null) {
            DebuggerManager.getDebuggerManager().removeBreakpoint(this.breakpointResolvedHandler);
        }
        TruffleBreakpointsRegistry.getDefault().dispose(this.debugger);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setBreakpointResolvedHandler(ClassType accessorClass) {
        Object object = this.breakpointResolvedHandlerLock;
        synchronized (object) {
            if (this.breakpointResolvedHandler == null) {
                MethodBreakpoint methodBreakpoint = MethodBreakpoint.create((String)accessorClass.name(), (String)ACCESSOR_LINE_BREAKPOINT_RESOLVED);
                methodBreakpoint.setSession(this.debugger);
                methodBreakpoint.setHidden(true);
                methodBreakpoint.setSuspend(1);
                methodBreakpoint.addJPDABreakpointListener(new JPDABreakpointListener(){

                    public void breakpointReached(JPDABreakpointEvent event) {
                        JSLineBreakpoint breakpoint;
                        LocalVariable[] localVariables;
                        try {
                            CallStackFrame[] topFrame = event.getThread().getCallStack(0, 1);
                            localVariables = topFrame[0].getLocalVariables();
                        }
                        catch (AbsentInformationException ex) {
                            localVariables = null;
                        }
                        if (localVariables != null && (breakpoint = TruffleBreakpointsHandler.this.findBreakpoint((ObjectReference)((JDIVariable)localVariables[0]).getJDIValue())) != null) {
                            int line = (Integer)localVariables[1].createMirrorObject();
                            breakpoint.setLine(line);
                            JSBreakpointStatus.setValid((JSLineBreakpoint)breakpoint, (String)"resolved");
                        }
                        event.resume();
                    }
                });
                DebuggerManager.getDebuggerManager().addBreakpoint((Breakpoint)methodBreakpoint);
                this.breakpointResolvedHandler = methodBreakpoint;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JSLineBreakpoint findBreakpoint(ObjectReference bpValue) {
        Map<JSLineBreakpoint, Set<ObjectReference>> map = this.breakpointsMap;
        synchronized (map) {
            for (Map.Entry<JSLineBreakpoint, Set<ObjectReference>> bpEntry : this.breakpointsMap.entrySet()) {
                if (!bpEntry.getValue().contains(bpValue)) continue;
                return bpEntry.getKey();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void submitBreakpoints(ClassType accessorClass, ObjectReference debugManager, JPDAThreadImpl t) throws InvocationException {
        assert (t.isMethodInvoking());
        this.accessorClass = accessorClass;
        this.setBreakpointResolvedHandler(accessorClass);
        Object[] breakpoints = DebuggerManager.getDebuggerManager().getBreakpoints();
        this.initialBreakpointsSubmitted = true;
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "DebugManagerHandler: Breakpoints to submit = {0}", breakpoints);
        }
        HashMap<JSLineBreakpoint, ObjectReference> bpsMap = new HashMap<JSLineBreakpoint, ObjectReference>();
        for (Object breakpoint : breakpoints) {
            ObjectReference bpImpl;
            JSLineBreakpoint bp;
            FileObject fileObject;
            if (!(breakpoint instanceof JSLineBreakpoint) || (fileObject = (bp = (JSLineBreakpoint)breakpoint).getFileObject()) == null) continue;
            URI uri = Source.getTruffleInternalURI(fileObject);
            if (uri == null) {
                uri = SourceBinaryTranslator.source2Binary(fileObject);
            }
            if (bp.isEnabled()) {
                bpImpl = this.setLineBreakpoint(debugManager, t, uri, bp.getLineNumber(), TruffleBreakpointsHandler.getIgnoreCount(bp), bp.getCondition());
                TruffleBreakpointsRegistry.getDefault().add(this.debugger, bp, bpImpl);
                try {
                    this.updateResolved(bp, bpImpl, t.getThreadReference());
                }
                catch (Exception ex) {
                    Exceptions.printStackTrace((Throwable)Exceptions.attachMessage((Throwable)ex, (String)("Testing resolved breakpoint at " + String.valueOf(uri) + ":" + bp.getLineNumber())));
                }
            } else {
                bpImpl = null;
            }
            bpsMap.put(bp, bpImpl);
            bp.addPropertyChangeListener((PropertyChangeListener)this.breakpointsChangeListener);
        }
        Map<JSLineBreakpoint, Set<ObjectReference>> map = this.breakpointsMap;
        synchronized (map) {
            for (Map.Entry bpEntry : bpsMap.entrySet()) {
                Set<ObjectReference> impls = this.breakpointsMap.get(bpEntry.getKey());
                if (impls == null) {
                    impls = new HashSet<ObjectReference>();
                    this.breakpointsMap.put((JSLineBreakpoint)bpEntry.getKey(), impls);
                }
                impls.add((ObjectReference)bpEntry.getValue());
            }
        }
    }

    private void updateResolved(JSLineBreakpoint breakpoint, ObjectReference bp, ThreadReference tr) throws InternalExceptionWrapper, VMDisconnectedExceptionWrapper, ClassNotPreparedExceptionWrapper, InvalidTypeException, ClassNotLoadedException, IncompatibleThreadStateException, InvocationException, ObjectCollectedExceptionWrapper {
        ClassType breakpointClass = (ClassType)bp.referenceType();
        Method isResolvedMethod = ClassTypeWrapper.concreteMethodByName((ClassType)breakpointClass, (String)"isResolved", (String)"()Z");
        BooleanValue isResolvedValue = (BooleanValue)ObjectReferenceWrapper.invokeMethod((ObjectReference)bp, (ThreadReference)tr, (Method)isResolvedMethod, Collections.emptyList(), (int)1);
        if (isResolvedValue.value()) {
            JSBreakpointStatus.setValid((JSLineBreakpoint)breakpoint, (String)"resolved");
        }
    }

    private static int getIgnoreCount(JSLineBreakpoint bp) {
        int ignoreCount = 0;
        if (Breakpoint.HIT_COUNT_FILTERING_STYLE.GREATER.equals((Object)bp.getHitCountFilteringStyle())) {
            ignoreCount = bp.getHitCountFilter();
        }
        return ignoreCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ObjectReference setLineBreakpoint(ObjectReference debugManager, JPDAThreadImpl t, URI uri, int line, int ignoreCount, String condition) throws InvocationException {
        assert (t.isMethodInvoking());
        ThreadReference tr = t.getThreadReference();
        VirtualMachine vm = tr.virtualMachine();
        PersistentValues persistents = new PersistentValues(vm);
        try {
            Method setLineBreakpointMethod = ClassTypeWrapper.concreteMethodByName((ClassType)this.accessorClass, (String)ACCESSOR_SET_LINE_BREAKPOINT, (String)ACCESSOR_SET_LINE_BREAKPOINT_MGR_SIGNAT);
            if (setLineBreakpointMethod == null) {
                throw new IllegalStateException("Method setLineBreakpoint with signature:\n(Lorg/netbeans/modules/debugger/jpda/backend/truffle/JPDATruffleDebugManager;Ljava/lang/String;IILjava/lang/String;)Lcom/oracle/truffle/api/debug/Breakpoint;\nis not present in accessor class " + String.valueOf(this.accessorClass));
            }
            StringReference uriRef = persistents.mirrorOf(uri.toString());
            IntegerValue lineRef = vm.mirrorOf(line);
            IntegerValue icRef = vm.mirrorOf(ignoreCount);
            StringReference conditionRef = condition != null ? persistents.mirrorOf(condition) : null;
            List<Value> args = Arrays.asList(debugManager, uriRef, lineRef, icRef, conditionRef);
            ObjectReference ret = (ObjectReference)ClassTypeWrapper.invokeMethod((ClassType)this.accessorClass, (ThreadReference)tr, (Method)setLineBreakpointMethod, args, (int)1);
            ret.disableCollection();
            ObjectReference objectReference = ret;
            return objectReference;
        }
        catch (ClassNotLoadedException | IncompatibleThreadStateException | InvalidTypeException | ClassNotPreparedExceptionWrapper | InternalExceptionWrapper | ObjectCollectedExceptionWrapper | UnsupportedOperationExceptionWrapper | VMDisconnectedExceptionWrapper ex) {
            Exceptions.printStackTrace((Throwable)Exceptions.attachMessage((Throwable)ex, (String)("Setting breakpoint to " + String.valueOf(uri) + ":" + line)));
            ObjectReference objectReference = null;
            return objectReference;
        }
        finally {
            persistents.collect();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void submitBP(final JSLineBreakpoint bp) {
        FileObject fileObject = bp.getFileObject();
        if (fileObject == null) {
            return;
        }
        URI tiuri = Source.getTruffleInternalURI(fileObject);
        final URI uri = tiuri != null ? tiuri : SourceBinaryTranslator.source2Binary(fileObject);
        final int line = bp.getLineNumber();
        final int ignoreCount = TruffleBreakpointsHandler.getIgnoreCount(bp);
        final String condition = bp.getCondition();
        final ArrayReference[] bpRef = new ArrayReference[]{null};
        if (bp.isEnabled()) {
            try {
                final Method setLineBreakpointMethod = ClassTypeWrapper.concreteMethodByName((ClassType)this.accessorClass, (String)ACCESSOR_SET_LINE_BREAKPOINT, (String)ACCESSOR_SET_LINE_BREAKPOINT_SIGNAT);
                if (setLineBreakpointMethod == null) {
                    throw new IllegalStateException("Method setLineBreakpoint with signature:\n(Ljava/lang/String;IILjava/lang/String;)[Lcom/oracle/truffle/api/debug/Breakpoint;\nis not present in accessor class " + String.valueOf(this.accessorClass));
                }
                TruffleAccess.methodCallingAccess(this.debugger, new TruffleAccess.MethodCallsAccess(){
                    final /* synthetic */ TruffleBreakpointsHandler this$0;
                    {
                        this.this$0 = this$0;
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void callMethods(JPDAThread thread) throws InvocationException {
                        ThreadReference tr = ((JPDAThreadImpl)thread).getThreadReference();
                        VirtualMachine vm = tr.virtualMachine();
                        PersistentValues persistents = new PersistentValues(vm);
                        try {
                            StringReference uriRef = persistents.mirrorOf(uri.toString());
                            IntegerValue lineRef = vm.mirrorOf(line);
                            IntegerValue icRef = vm.mirrorOf(ignoreCount);
                            StringReference conditionRef = condition != null ? persistents.mirrorOf(condition) : null;
                            List<Value> args = Arrays.asList(uriRef, lineRef, icRef, conditionRef);
                            ArrayReference ret = (ArrayReference)ClassTypeWrapper.invokeMethod((ClassType)this.this$0.accessorClass, (ThreadReference)tr, (Method)setLineBreakpointMethod, args, (int)1);
                            ret.disableCollection();
                            bpRef[0] = ret;
                            for (Value v : ret.getValues()) {
                                if (!(v instanceof ObjectReference)) continue;
                                TruffleBreakpointsRegistry.getDefault().add(this.this$0.debugger, bp, (ObjectReference)v);
                                this.this$0.updateResolved(bp, (ObjectReference)v, tr);
                            }
                        }
                        catch (ClassNotLoadedException | IncompatibleThreadStateException | InvalidTypeException | ClassNotPreparedExceptionWrapper | InternalExceptionWrapper | ObjectCollectedExceptionWrapper | UnsupportedOperationExceptionWrapper | VMDisconnectedExceptionWrapper ex) {
                            Exceptions.printStackTrace((Throwable)Exceptions.attachMessage((Throwable)ex, (String)("Setting breakpoint to " + String.valueOf(uri) + ":" + line)));
                        }
                        finally {
                            persistents.collect();
                        }
                    }
                });
            }
            catch (ClassNotPreparedExceptionWrapper | InternalExceptionWrapper | VMDisconnectedExceptionWrapper setLineBreakpointMethod) {
                // empty catch block
            }
        }
        bp.addPropertyChangeListener((PropertyChangeListener)this.breakpointsChangeListener);
        HashSet<ObjectReference> breakpoints = new HashSet<ObjectReference>();
        ArrayReference bpArray = bpRef[0];
        if (bpArray != null) {
            List<Value> values = bpArray.getValues();
            for (Value v : values) {
                if (!(v instanceof ObjectReference)) continue;
                breakpoints.add((ObjectReference)v);
            }
            bpArray.enableCollection();
        }
        if (!breakpoints.isEmpty()) {
            Map<JSLineBreakpoint, Set<ObjectReference>> map = this.breakpointsMap;
            synchronized (map) {
                this.breakpointsMap.put(bp, breakpoints);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean removeBP(JSLineBreakpoint bp) {
        Set<ObjectReference> bpImpls;
        bp.removePropertyChangeListener((PropertyChangeListener)this.breakpointsChangeListener);
        Map<JSLineBreakpoint, Set<ObjectReference>> map = this.breakpointsMap;
        synchronized (map) {
            bpImpls = this.breakpointsMap.remove(bp);
        }
        if (bpImpls == null) {
            return false;
        }
        final boolean[] successPtr = new boolean[]{false};
        try {
            final Method removeLineBreakpointMethod = ClassTypeWrapper.concreteMethodByName((ClassType)this.accessorClass, (String)ACCESSOR_REMOVE_BREAKPOINT, (String)ACCESSOR_REMOVE_BREAKPOINT_SIGNAT);
            TruffleAccess.methodCallingAccess(this.debugger, new TruffleAccess.MethodCallsAccess(){
                final /* synthetic */ TruffleBreakpointsHandler this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void callMethods(JPDAThread thread) throws InvocationException {
                    ThreadReference tr = ((JPDAThreadImpl)thread).getThreadReference();
                    try {
                        for (ObjectReference bpImpl : bpImpls) {
                            List<Value> args = Arrays.asList(bpImpl);
                            try {
                                ClassTypeWrapper.invokeMethod((ClassType)this.this$0.accessorClass, (ThreadReference)tr, (Method)removeLineBreakpointMethod, args, (int)1);
                                successPtr[0] = true;
                            }
                            catch (ClassNotLoadedException | IncompatibleThreadStateException | InvalidTypeException | InternalExceptionWrapper | ObjectCollectedExceptionWrapper ex) {
                                Exceptions.printStackTrace((Throwable)ex);
                            }
                            TruffleBreakpointsRegistry.getDefault().remove(this.this$0.debugger, bpImpl);
                            bpImpl.enableCollection();
                        }
                    }
                    catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
                        // empty catch block
                    }
                }
            });
        }
        catch (ClassNotPreparedExceptionWrapper | InternalExceptionWrapper | VMDisconnectedExceptionWrapper throwable) {
            // empty catch block
        }
        return successPtr[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean setBreakpointProperty(JSLineBreakpoint bp, TruffleBPMethods method, final List<? extends Value> args) {
        Set<ObjectReference> bpImpls;
        Map<JSLineBreakpoint, Set<ObjectReference>> map = this.breakpointsMap;
        synchronized (map) {
            bpImpls = this.breakpointsMap.get(bp);
        }
        if (bpImpls == null) {
            if (bp.isEnabled()) {
                this.submitBP(bp);
                return true;
            }
            return false;
        }
        final boolean[] successPtr = new boolean[]{false};
        try {
            final Method setBreakpointPropertyMethod = ClassTypeWrapper.concreteMethodByName((ClassType)((ClassType)ObjectReferenceWrapper.referenceType((ObjectReference)bpImpls.iterator().next())), (String)method.getMethodName(), (String)method.getMethodSignature());
            TruffleAccess.methodCallingAccess(this.debugger, new TruffleAccess.MethodCallsAccess(){
                final /* synthetic */ TruffleBreakpointsHandler this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void callMethods(JPDAThread thread) throws InvocationException {
                    ThreadReference tr = ((JPDAThreadImpl)thread).getThreadReference();
                    try {
                        for (ObjectReference bpImpl : bpImpls) {
                            try {
                                ObjectReferenceWrapper.invokeMethod((ObjectReference)bpImpl, (ThreadReference)tr, (Method)setBreakpointPropertyMethod, (List)args, (int)1);
                                successPtr[0] = true;
                            }
                            catch (ClassNotLoadedException | IncompatibleThreadStateException | InvalidTypeException | InternalExceptionWrapper | ObjectCollectedExceptionWrapper ex) {
                                Exceptions.printStackTrace((Throwable)ex);
                            }
                        }
                    }
                    catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
                        // empty catch block
                    }
                }
            });
        }
        catch (ClassNotPreparedExceptionWrapper | InternalExceptionWrapper | ObjectCollectedExceptionWrapper | VMDisconnectedExceptionWrapper throwable) {
            // empty catch block
        }
        return successPtr[0];
    }

    public void breakpointAdded(JSLineBreakpoint jsLineBreakpoint) {
        if (this.initialBreakpointsSubmitted) {
            if (Mutex.EVENT.isReadAccess()) {
                ((JPDADebuggerImpl)this.debugger).getRequestProcessor().post(() -> this.submitBP(jsLineBreakpoint));
            } else {
                this.submitBP(jsLineBreakpoint);
            }
        }
    }

    public void breakpointRemoved(JSLineBreakpoint jsLineBreakpoint) {
        if (this.initialBreakpointsSubmitted) {
            if (Mutex.EVENT.isReadAccess()) {
                ((JPDADebuggerImpl)this.debugger).getRequestProcessor().post(() -> this.removeBP(jsLineBreakpoint));
            } else {
                this.removeBP(jsLineBreakpoint);
            }
        }
    }

    private class JSBreakpointPropertyChangeListener
    implements PropertyChangeListener {
        private JSBreakpointPropertyChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            List<Value> args;
            TruffleBPMethods method;
            final JSLineBreakpoint jsbp = (JSLineBreakpoint)evt.getSource();
            String propertyName = evt.getPropertyName();
            VirtualMachine vm = ((JPDADebuggerImpl)TruffleBreakpointsHandler.this.debugger).getVirtualMachine();
            if (vm == null) {
                return;
            }
            final PersistentValues persistents = new PersistentValues(vm);
            switch (propertyName) {
                case "enabled": {
                    method = TruffleBPMethods.setEnabled;
                    args = Collections.singletonList(vm.mirrorOf(jsbp.isEnabled()));
                    break;
                }
                case "condition": {
                    method = TruffleBPMethods.setCondition;
                    String condition = jsbp.getCondition();
                    StringReference conditionRef = condition != null ? persistents.mirrorOf0(condition) : null;
                    args = Collections.singletonList(conditionRef);
                    break;
                }
                case "hitCountFilter": {
                    method = TruffleBPMethods.setIgnoreCount;
                    args = Collections.singletonList(vm.mirrorOf(TruffleBreakpointsHandler.getIgnoreCount(jsbp)));
                    break;
                }
                default: {
                    return;
                }
            }
            ((JPDADebuggerImpl)TruffleBreakpointsHandler.this.debugger).getRequestProcessor().post(new Runnable(){
                final /* synthetic */ JSBreakpointPropertyChangeListener this$1;
                {
                    this.this$1 = this$1;
                }

                @Override
                public void run() {
                    try {
                        this.this$1.TruffleBreakpointsHandler.this.setBreakpointProperty(jsbp, method, args);
                    }
                    finally {
                        persistents.collect();
                    }
                }
            });
        }
    }

    private static enum TruffleBPMethods {
        setEnabled,
        setIgnoreCount,
        setCondition;


        public String getMethodName() {
            return this.name();
        }

        public String getMethodSignature() {
            switch (this.ordinal()) {
                case 0: {
                    return "(Z)V";
                }
                case 1: {
                    return "(I)V";
                }
                case 2: {
                    return "(Ljava/lang/String;)V";
                }
            }
            throw new IllegalStateException(this.name());
        }
    }
}

