/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.admissionregistration.v1alpha1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.admissionregistration.v1alpha1.MatchResources;
import io.fabric8.kubernetes.api.model.admissionregistration.v1alpha1.MatchResourcesBuilder;
import io.fabric8.kubernetes.api.model.admissionregistration.v1alpha1.MatchResourcesFluentImpl;
import io.fabric8.kubernetes.api.model.admissionregistration.v1alpha1.ParamKind;
import io.fabric8.kubernetes.api.model.admissionregistration.v1alpha1.ParamKindBuilder;
import io.fabric8.kubernetes.api.model.admissionregistration.v1alpha1.ParamKindFluentImpl;
import io.fabric8.kubernetes.api.model.admissionregistration.v1alpha1.ValidatingAdmissionPolicySpec;
import io.fabric8.kubernetes.api.model.admissionregistration.v1alpha1.ValidatingAdmissionPolicySpecFluent;
import io.fabric8.kubernetes.api.model.admissionregistration.v1alpha1.Validation;
import io.fabric8.kubernetes.api.model.admissionregistration.v1alpha1.ValidationBuilder;
import io.fabric8.kubernetes.api.model.admissionregistration.v1alpha1.ValidationFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class ValidatingAdmissionPolicySpecFluentImpl<A extends ValidatingAdmissionPolicySpecFluent<A>>
extends BaseFluent<A>
implements ValidatingAdmissionPolicySpecFluent<A> {
    private String failurePolicy;
    private MatchResourcesBuilder matchConstraints;
    private ParamKindBuilder paramKind;
    private ArrayList<ValidationBuilder> validations = new ArrayList();
    private Map<String, Object> additionalProperties;

    public ValidatingAdmissionPolicySpecFluentImpl() {
    }

    public ValidatingAdmissionPolicySpecFluentImpl(ValidatingAdmissionPolicySpec instance) {
        if (instance != null) {
            this.withFailurePolicy(instance.getFailurePolicy());
            this.withMatchConstraints(instance.getMatchConstraints());
            this.withParamKind(instance.getParamKind());
            this.withValidations(instance.getValidations());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    @Override
    public String getFailurePolicy() {
        return this.failurePolicy;
    }

    @Override
    public A withFailurePolicy(String failurePolicy) {
        this.failurePolicy = failurePolicy;
        return (A)this;
    }

    @Override
    public Boolean hasFailurePolicy() {
        return this.failurePolicy != null;
    }

    @Override
    @Deprecated
    public MatchResources getMatchConstraints() {
        return this.matchConstraints != null ? this.matchConstraints.build() : null;
    }

    @Override
    public MatchResources buildMatchConstraints() {
        return this.matchConstraints != null ? this.matchConstraints.build() : null;
    }

    @Override
    public A withMatchConstraints(MatchResources matchConstraints) {
        this._visitables.get((Object)"matchConstraints").remove(this.matchConstraints);
        if (matchConstraints != null) {
            this.matchConstraints = new MatchResourcesBuilder(matchConstraints);
            this._visitables.get((Object)"matchConstraints").add(this.matchConstraints);
        } else {
            this.matchConstraints = null;
            this._visitables.get((Object)"matchConstraints").remove(this.matchConstraints);
        }
        return (A)this;
    }

    @Override
    public Boolean hasMatchConstraints() {
        return this.matchConstraints != null;
    }

    @Override
    public ValidatingAdmissionPolicySpecFluent.MatchConstraintsNested<A> withNewMatchConstraints() {
        return new MatchConstraintsNestedImpl();
    }

    @Override
    public ValidatingAdmissionPolicySpecFluent.MatchConstraintsNested<A> withNewMatchConstraintsLike(MatchResources item) {
        return new MatchConstraintsNestedImpl(item);
    }

    @Override
    public ValidatingAdmissionPolicySpecFluent.MatchConstraintsNested<A> editMatchConstraints() {
        return this.withNewMatchConstraintsLike(this.getMatchConstraints());
    }

    @Override
    public ValidatingAdmissionPolicySpecFluent.MatchConstraintsNested<A> editOrNewMatchConstraints() {
        return this.withNewMatchConstraintsLike(this.getMatchConstraints() != null ? this.getMatchConstraints() : new MatchResourcesBuilder().build());
    }

    @Override
    public ValidatingAdmissionPolicySpecFluent.MatchConstraintsNested<A> editOrNewMatchConstraintsLike(MatchResources item) {
        return this.withNewMatchConstraintsLike(this.getMatchConstraints() != null ? this.getMatchConstraints() : item);
    }

    @Override
    @Deprecated
    public ParamKind getParamKind() {
        return this.paramKind != null ? this.paramKind.build() : null;
    }

    @Override
    public ParamKind buildParamKind() {
        return this.paramKind != null ? this.paramKind.build() : null;
    }

    @Override
    public A withParamKind(ParamKind paramKind) {
        this._visitables.get((Object)"paramKind").remove(this.paramKind);
        if (paramKind != null) {
            this.paramKind = new ParamKindBuilder(paramKind);
            this._visitables.get((Object)"paramKind").add(this.paramKind);
        } else {
            this.paramKind = null;
            this._visitables.get((Object)"paramKind").remove(this.paramKind);
        }
        return (A)this;
    }

    @Override
    public Boolean hasParamKind() {
        return this.paramKind != null;
    }

    @Override
    public A withNewParamKind(String apiVersion, String kind) {
        return this.withParamKind(new ParamKind(apiVersion, kind));
    }

    @Override
    public ValidatingAdmissionPolicySpecFluent.ParamKindNested<A> withNewParamKind() {
        return new ParamKindNestedImpl();
    }

    @Override
    public ValidatingAdmissionPolicySpecFluent.ParamKindNested<A> withNewParamKindLike(ParamKind item) {
        return new ParamKindNestedImpl(item);
    }

    @Override
    public ValidatingAdmissionPolicySpecFluent.ParamKindNested<A> editParamKind() {
        return this.withNewParamKindLike(this.getParamKind());
    }

    @Override
    public ValidatingAdmissionPolicySpecFluent.ParamKindNested<A> editOrNewParamKind() {
        return this.withNewParamKindLike(this.getParamKind() != null ? this.getParamKind() : new ParamKindBuilder().build());
    }

    @Override
    public ValidatingAdmissionPolicySpecFluent.ParamKindNested<A> editOrNewParamKindLike(ParamKind item) {
        return this.withNewParamKindLike(this.getParamKind() != null ? this.getParamKind() : item);
    }

    @Override
    public A addToValidations(int index, Validation item) {
        if (this.validations == null) {
            this.validations = new ArrayList();
        }
        ValidationBuilder builder = new ValidationBuilder(item);
        if (index < 0 || index >= this.validations.size()) {
            this._visitables.get((Object)"validations").add(builder);
            this.validations.add(builder);
        } else {
            this._visitables.get((Object)"validations").add(index, builder);
            this.validations.add(index, builder);
        }
        return (A)this;
    }

    @Override
    public A setToValidations(int index, Validation item) {
        if (this.validations == null) {
            this.validations = new ArrayList();
        }
        ValidationBuilder builder = new ValidationBuilder(item);
        if (index < 0 || index >= this.validations.size()) {
            this._visitables.get((Object)"validations").add(builder);
            this.validations.add(builder);
        } else {
            this._visitables.get((Object)"validations").set(index, builder);
            this.validations.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToValidations(Validation ... items) {
        if (this.validations == null) {
            this.validations = new ArrayList();
        }
        for (Validation item : items) {
            ValidationBuilder builder = new ValidationBuilder(item);
            this._visitables.get((Object)"validations").add(builder);
            this.validations.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToValidations(Collection<Validation> items) {
        if (this.validations == null) {
            this.validations = new ArrayList();
        }
        for (Validation item : items) {
            ValidationBuilder builder = new ValidationBuilder(item);
            this._visitables.get((Object)"validations").add(builder);
            this.validations.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromValidations(Validation ... items) {
        for (Validation item : items) {
            ValidationBuilder builder = new ValidationBuilder(item);
            this._visitables.get((Object)"validations").remove(builder);
            if (this.validations == null) continue;
            this.validations.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromValidations(Collection<Validation> items) {
        for (Validation item : items) {
            ValidationBuilder builder = new ValidationBuilder(item);
            this._visitables.get((Object)"validations").remove(builder);
            if (this.validations == null) continue;
            this.validations.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromValidations(Predicate<ValidationBuilder> predicate) {
        if (this.validations == null) {
            return (A)this;
        }
        Iterator<ValidationBuilder> each = this.validations.iterator();
        List visitables = this._visitables.get((Object)"validations");
        while (each.hasNext()) {
            ValidationBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<Validation> getValidations() {
        return this.validations != null ? ValidatingAdmissionPolicySpecFluentImpl.build(this.validations) : null;
    }

    @Override
    public List<Validation> buildValidations() {
        return this.validations != null ? ValidatingAdmissionPolicySpecFluentImpl.build(this.validations) : null;
    }

    @Override
    public Validation buildValidation(int index) {
        return this.validations.get(index).build();
    }

    @Override
    public Validation buildFirstValidation() {
        return this.validations.get(0).build();
    }

    @Override
    public Validation buildLastValidation() {
        return this.validations.get(this.validations.size() - 1).build();
    }

    @Override
    public Validation buildMatchingValidation(Predicate<ValidationBuilder> predicate) {
        for (ValidationBuilder item : this.validations) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingValidation(Predicate<ValidationBuilder> predicate) {
        for (ValidationBuilder item : this.validations) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withValidations(List<Validation> validations) {
        if (this.validations != null) {
            this._visitables.get((Object)"validations").clear();
        }
        if (validations != null) {
            this.validations = new ArrayList();
            for (Validation item : validations) {
                this.addToValidations(item);
            }
        } else {
            this.validations = null;
        }
        return (A)this;
    }

    @Override
    public A withValidations(Validation ... validations) {
        if (this.validations != null) {
            this.validations.clear();
            this._visitables.remove((Object)"validations");
        }
        if (validations != null) {
            for (Validation item : validations) {
                this.addToValidations(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasValidations() {
        return this.validations != null && !this.validations.isEmpty();
    }

    @Override
    public A addNewValidation(String expression, String message, String reason) {
        return this.addToValidations(new Validation(expression, message, reason));
    }

    @Override
    public ValidatingAdmissionPolicySpecFluent.ValidationsNested<A> addNewValidation() {
        return new ValidationsNestedImpl();
    }

    @Override
    public ValidatingAdmissionPolicySpecFluent.ValidationsNested<A> addNewValidationLike(Validation item) {
        return new ValidationsNestedImpl(-1, item);
    }

    @Override
    public ValidatingAdmissionPolicySpecFluent.ValidationsNested<A> setNewValidationLike(int index, Validation item) {
        return new ValidationsNestedImpl(index, item);
    }

    @Override
    public ValidatingAdmissionPolicySpecFluent.ValidationsNested<A> editValidation(int index) {
        if (this.validations.size() <= index) {
            throw new RuntimeException("Can't edit validations. Index exceeds size.");
        }
        return this.setNewValidationLike(index, this.buildValidation(index));
    }

    @Override
    public ValidatingAdmissionPolicySpecFluent.ValidationsNested<A> editFirstValidation() {
        if (this.validations.size() == 0) {
            throw new RuntimeException("Can't edit first validations. The list is empty.");
        }
        return this.setNewValidationLike(0, this.buildValidation(0));
    }

    @Override
    public ValidatingAdmissionPolicySpecFluent.ValidationsNested<A> editLastValidation() {
        int index = this.validations.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last validations. The list is empty.");
        }
        return this.setNewValidationLike(index, this.buildValidation(index));
    }

    @Override
    public ValidatingAdmissionPolicySpecFluent.ValidationsNested<A> editMatchingValidation(Predicate<ValidationBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.validations.size(); ++i) {
            if (!predicate.test(this.validations.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching validations. No match found.");
        }
        return this.setNewValidationLike(index, this.buildValidation(index));
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ValidatingAdmissionPolicySpecFluentImpl that = (ValidatingAdmissionPolicySpecFluentImpl)o;
        if (!Objects.equals(this.failurePolicy, that.failurePolicy)) {
            return false;
        }
        if (!Objects.equals(this.matchConstraints, that.matchConstraints)) {
            return false;
        }
        if (!Objects.equals(this.paramKind, that.paramKind)) {
            return false;
        }
        if (!Objects.equals(this.validations, that.validations)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.failurePolicy, this.matchConstraints, this.paramKind, this.validations, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.failurePolicy != null) {
            sb.append("failurePolicy:");
            sb.append(this.failurePolicy + ",");
        }
        if (this.matchConstraints != null) {
            sb.append("matchConstraints:");
            sb.append(this.matchConstraints + ",");
        }
        if (this.paramKind != null) {
            sb.append("paramKind:");
            sb.append(this.paramKind + ",");
        }
        if (this.validations != null && !this.validations.isEmpty()) {
            sb.append("validations:");
            sb.append(this.validations + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    class ValidationsNestedImpl<N>
    extends ValidationFluentImpl<ValidatingAdmissionPolicySpecFluent.ValidationsNested<N>>
    implements ValidatingAdmissionPolicySpecFluent.ValidationsNested<N>,
    Nested<N> {
        ValidationBuilder builder;
        int index;

        ValidationsNestedImpl(int index, Validation item) {
            this.index = index;
            this.builder = new ValidationBuilder(this, item);
        }

        ValidationsNestedImpl() {
            this.index = -1;
            this.builder = new ValidationBuilder(this);
        }

        @Override
        public N and() {
            return (N)ValidatingAdmissionPolicySpecFluentImpl.this.setToValidations(this.index, this.builder.build());
        }

        @Override
        public N endValidation() {
            return this.and();
        }
    }

    class ParamKindNestedImpl<N>
    extends ParamKindFluentImpl<ValidatingAdmissionPolicySpecFluent.ParamKindNested<N>>
    implements ValidatingAdmissionPolicySpecFluent.ParamKindNested<N>,
    Nested<N> {
        ParamKindBuilder builder;

        ParamKindNestedImpl(ParamKind item) {
            this.builder = new ParamKindBuilder(this, item);
        }

        ParamKindNestedImpl() {
            this.builder = new ParamKindBuilder(this);
        }

        @Override
        public N and() {
            return (N)ValidatingAdmissionPolicySpecFluentImpl.this.withParamKind(this.builder.build());
        }

        @Override
        public N endParamKind() {
            return this.and();
        }
    }

    class MatchConstraintsNestedImpl<N>
    extends MatchResourcesFluentImpl<ValidatingAdmissionPolicySpecFluent.MatchConstraintsNested<N>>
    implements ValidatingAdmissionPolicySpecFluent.MatchConstraintsNested<N>,
    Nested<N> {
        MatchResourcesBuilder builder;

        MatchConstraintsNestedImpl(MatchResources item) {
            this.builder = new MatchResourcesBuilder(this, item);
        }

        MatchConstraintsNestedImpl() {
            this.builder = new MatchResourcesBuilder(this);
        }

        @Override
        public N and() {
            return (N)ValidatingAdmissionPolicySpecFluentImpl.this.withMatchConstraints(this.builder.build());
        }

        @Override
        public N endMatchConstraints() {
            return this.and();
        }
    }
}

