/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.lsp.client.bindings;

import java.awt.Color;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.stream.Collectors;
import javax.swing.text.Document;
import javax.swing.text.StyledDocument;
import org.netbeans.modules.editor.errorstripe.privatespi.Mark;
import org.netbeans.modules.editor.errorstripe.privatespi.MarkProvider;
import org.netbeans.modules.editor.errorstripe.privatespi.Status;
import org.openide.text.NbDocument;

public class OccurrencesMarkProvider
extends MarkProvider {
    private static final Map<Document, Reference<OccurrencesMarkProvider>> providers = new WeakHashMap<Document, Reference<OccurrencesMarkProvider>>();
    private List<Mark> occurrences = Collections.emptyList();

    public static synchronized OccurrencesMarkProvider get(Document doc) {
        OccurrencesMarkProvider p;
        Reference<OccurrencesMarkProvider> ref = providers.get(doc);
        OccurrencesMarkProvider occurrencesMarkProvider = p = ref != null ? ref.get() : null;
        if (p == null) {
            p = new OccurrencesMarkProvider();
            providers.put(doc, new WeakReference<OccurrencesMarkProvider>(p));
        }
        return p;
    }

    public List<Mark> getMarks() {
        return Collections.unmodifiableList(this.occurrences);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOccurrences(Document doc, List<int[]> bag, Color color, String tooltip) {
        List<Mark> old;
        OccurrencesMarkProvider occurrencesMarkProvider = this;
        synchronized (occurrencesMarkProvider) {
            old = this.occurrences;
            this.occurrences = doc.getProperty(OccurrencesMarkProvider.class) == null || bag == null ? Collections.emptyList() : bag.stream().map(hs -> new MarkImpl(doc, hs[0], color, tooltip)).collect(Collectors.toList());
        }
        this.firePropertyChange("marks", old, this.occurrences);
    }

    private static final class MarkImpl
    implements Mark {
        private final int line;
        private final Color color;
        private final String tooltip;

        public MarkImpl(Document doc, int startOffset, Color color, String tooltip) {
            this.line = NbDocument.findLineNumber((StyledDocument)((StyledDocument)doc), (int)startOffset);
            this.color = color;
            this.tooltip = tooltip;
        }

        public int getType() {
            return 1;
        }

        public Status getStatus() {
            return Status.STATUS_OK;
        }

        public int getPriority() {
            return 1000;
        }

        public Color getEnhancedColor() {
            return this.color;
        }

        public int[] getAssignedLines() {
            return new int[]{this.line, this.line};
        }

        public String getShortDescription() {
            return this.tooltip;
        }
    }
}

