/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.multitabs.impl;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.dnd.Autoscroll;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.core.multitabs.ButtonFactory;
import org.netbeans.core.multitabs.Controller;
import org.netbeans.core.multitabs.Settings;
import org.netbeans.core.multitabs.TabDisplayer;
import org.netbeans.core.multitabs.TabbedImpl;
import org.netbeans.core.multitabs.impl.ControlsToolbar;
import org.netbeans.core.multitabs.impl.ProjectSupport;
import org.netbeans.core.multitabs.impl.ScrollAction;
import org.netbeans.core.multitabs.impl.TabTableUI;
import org.netbeans.swing.tabcontrol.TabData;
import org.netbeans.swing.tabcontrol.TabDataModel;

abstract class AbstractTabDisplayer
extends TabDisplayer
implements MouseWheelListener,
Autoscroll {
    protected Controller controller;
    protected final JScrollPane scrollPane;
    protected final int orientation;
    private final JToolBar controls;
    private final JLabel lblFullPath = new JLabel();
    private final ScrollAction scrollLeft;
    private final ScrollAction scrollRight;
    private final ChangeListener fullPathListener;
    private final ChangeListener projectsListener;
    private final Autoscroller autoscroller = new Autoscroller();

    public AbstractTabDisplayer(TabDataModel tabModel, int tabsLocation) {
        super(tabModel);
        this.setLayout(new BorderLayout(3, 3));
        this.orientation = tabsLocation == 1 || tabsLocation == 3 ? 0 : 1;
        this.scrollPane = new JScrollPane();
        this.controls = new ControlsToolbar();
        this.lblFullPath.setBorder(BorderFactory.createEmptyBorder(0, 3, 2, 3));
        Font defaultFont = this.lblFullPath.getFont();
        this.lblFullPath.setFont(defaultFont.deriveFont(defaultFont.getSize2D() - 2.0f));
        JPanel controlsPanel = new JPanel(new BorderLayout());
        controlsPanel.setOpaque(false);
        if (TabTableUI.IS_AQUA) {
            Color backColor = UIManager.getColor("NbSplitPane.background");
            if (null != backColor) {
                this.setBackground(backColor);
                this.setOpaque(true);
            }
            Color white = Color.white;
            white = white.darker();
            this.lblFullPath.setForeground(white);
        }
        switch (tabsLocation) {
            case 1: 
            case 3: {
                this.add((Component)this.scrollPane, "Center");
                controlsPanel.add((Component)this.controls, "North");
                this.add((Component)controlsPanel, "East");
                if (!Settings.getDefault().isShowFullPath()) break;
                this.add((Component)this.lblFullPath, "South");
                break;
            }
            case 2: 
            case 4: {
                this.add((Component)this.scrollPane, "Center");
                controlsPanel.add((Component)this.controls, "East");
                this.add((Component)controlsPanel, "North");
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid orientation: " + tabsLocation);
            }
        }
        this.configureScrollPane(this.scrollPane);
        this.scrollLeft = new ScrollAction(this.scrollPane, tabsLocation, true);
        this.scrollRight = new ScrollAction(this.scrollPane, tabsLocation, false);
        this.controls.add(ButtonFactory.createScrollLeftButton(this.scrollLeft));
        this.controls.add(ButtonFactory.createScrollRightButton(this.scrollRight));
        this.addMouseWheelListener(this);
        this.projectsListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                AbstractTabDisplayer.this.repaint();
            }
        };
        this.fullPathListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        AbstractTabDisplayer.this.updateFullPath();
                    }
                });
            }
        };
        tabModel.addChangeListener(this.fullPathListener);
    }

    private void configureScrollPane(JScrollPane scrollPane) {
        scrollPane.setHorizontalScrollBarPolicy(31);
        scrollPane.setVerticalScrollBarPolicy(21);
        scrollPane.setBorder(BorderFactory.createEmptyBorder());
        scrollPane.setOpaque(false);
        scrollPane.getViewport().setOpaque(false);
        scrollPane.setFocusable(false);
        scrollPane.setWheelScrollingEnabled(false);
        scrollPane.setViewportBorder(BorderFactory.createEmptyBorder());
        scrollPane.addComponentListener(new ComponentListener(){

            @Override
            public void componentResized(ComponentEvent e) {
                AbstractTabDisplayer.this.showSelectedTab();
            }

            @Override
            public void componentMoved(ComponentEvent e) {
            }

            @Override
            public void componentShown(ComponentEvent e) {
            }

            @Override
            public void componentHidden(ComponentEvent e) {
            }
        });
    }

    @Override
    public Color getBackground() {
        Color activeBackground = UIManager.getColor("nb.multitabs.activeBackground");
        if (activeBackground != null && TabbedImpl.isActive(this)) {
            return activeBackground;
        }
        Color background = UIManager.getColor("nb.multitabs.background");
        if (background != null) {
            return background;
        }
        return super.getBackground();
    }

    @Override
    public void attach(Controller controller) {
        this.controller = controller;
        this.controls.add(ButtonFactory.createDropDownButton(controller));
        this.controls.add(ButtonFactory.createMaximizeButton(controller));
    }

    @Override
    public void addNotify() {
        super.addNotify();
        ProjectSupport projects = ProjectSupport.getDefault();
        if (projects.isEnabled()) {
            projects.addChangeListener(this.projectsListener);
        }
        if (null != this.controller) {
            this.controller.addSelectionChangeListener(this.fullPathListener);
        }
        this.updateFullPath();
    }

    @Override
    public void removeNotify() {
        ProjectSupport.getDefault().removeChangeListener(this.projectsListener);
        super.removeNotify();
        if (null != this.controller) {
            this.controller.removeSelectionChangeListener(this.fullPathListener);
        }
    }

    private void updateFullPath() {
        TabData tab;
        if (!this.lblFullPath.isVisible() || null == this.controller) {
            return;
        }
        String text = null;
        int selIndex = this.controller.getSelectedIndex();
        if (selIndex >= 0 && selIndex < this.tabModel.size() && null != (tab = this.tabModel.getTab(selIndex))) {
            text = tab.getTooltip();
        }
        this.lblFullPath.setText(text);
    }

    @Override
    public final void mouseWheelMoved(MouseWheelEvent e) {
        this.scrollLeft.mouseWheelMoved(e);
        if (e.isConsumed()) {
            return;
        }
        this.scrollRight.mouseWheelMoved(e);
    }

    private void showSelectedTab() {
        if (null == this.controller) {
            return;
        }
        int selIndex = this.controller.getSelectedIndex();
        if (selIndex < 0 || selIndex >= this.controller.getTabModel().size()) {
            return;
        }
        Rectangle rect = this.getTabBounds(selIndex);
        if (null == rect) {
            return;
        }
        this.scrollPane.getViewport().scrollRectToVisible(rect);
    }

    @Override
    public Rectangle getTabsArea() {
        return this.scrollPane.getBounds();
    }

    @Override
    public Insets getAutoscrollInsets() {
        if (this.orientation == 0) {
            return new Insets(0, 25, 0, 25);
        }
        return new Insets(25, 0, 25, 0);
    }

    @Override
    public void autoscroll(Point cursorLocn) {
        Rectangle tabsArea = this.getTabsArea();
        if (!tabsArea.contains(cursorLocn)) {
            this.autoscroller.stop();
            return;
        }
        if (this.orientation == 0) {
            if (cursorLocn.x < tabsArea.x + 25) {
                this.autoscroller.start(true);
            } else if (cursorLocn.x > tabsArea.x + tabsArea.width - 25) {
                this.autoscroller.start(false);
            } else {
                this.autoscroller.stop();
            }
        } else if (cursorLocn.y < tabsArea.y + 25) {
            this.autoscroller.start(true);
        } else if (cursorLocn.y > tabsArea.y + tabsArea.height - 25) {
            this.autoscroller.start(false);
        } else {
            this.autoscroller.stop();
        }
    }

    private class Autoscroller
    implements ActionListener {
        private int direction = 0;
        private Timer timer;

        private Autoscroller() {
        }

        public void start(boolean scrollLeft) {
            int newDirection;
            int n = newDirection = scrollLeft ? -1 : 1;
            if (null == this.timer || !this.timer.isRunning() || this.direction != newDirection) {
                if (null == this.timer) {
                    this.timer = new Timer(300, this);
                    this.timer.setRepeats(true);
                }
                this.direction = newDirection;
                this.timer.start();
            }
        }

        public void stop() {
            if (null != this.timer) {
                this.timer.stop();
            }
            this.direction = 0;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.direction < 0) {
                if (AbstractTabDisplayer.this.scrollLeft.isEnabled()) {
                    AbstractTabDisplayer.this.scrollLeft.actionPerformed(e);
                } else {
                    this.timer.stop();
                }
            } else if (this.direction > 0) {
                if (AbstractTabDisplayer.this.scrollRight.isEnabled()) {
                    AbstractTabDisplayer.this.scrollRight.actionPerformed(e);
                } else {
                    this.timer.stop();
                }
            }
        }
    }
}

