/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.api;

import java.util.Arrays;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.profiler.spi.ProjectUtilitiesProvider;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;

public final class ProjectUtilities {
    public static Lookup.Provider getMainProject() {
        return ProjectUtilities.provider().getMainProject();
    }

    public static Lookup.Provider[] getOpenedProjects() {
        return ProjectUtilities.provider().getOpenedProjects();
    }

    public static String getDisplayName(Lookup.Provider project) {
        return ProjectUtilities.provider().getDisplayName(project);
    }

    public static FileObject getProjectDirectory(Lookup.Provider project) {
        return ProjectUtilities.provider().getProjectDirectory(project);
    }

    public static Icon getIcon(Lookup.Provider project) {
        return ProjectUtilities.provider().getIcon(project);
    }

    public static boolean hasSubprojects(Lookup.Provider project) {
        return ProjectUtilities.provider().hasSubprojects(project);
    }

    public static void fetchSubprojects(Lookup.Provider project, Set<Lookup.Provider> subprojects) {
        ProjectUtilities.provider().fetchSubprojects(project, subprojects);
    }

    public static Lookup.Provider getProject(FileObject fobj) {
        return ProjectUtilities.provider().getProject(fobj);
    }

    public static void addOpenProjectsListener(ChangeListener listener) {
        ProjectUtilities.provider().addOpenProjectsListener(listener);
    }

    public static void removeOpenProjectsListener(ChangeListener listener) {
        ProjectUtilities.provider().removeOpenProjectsListener(listener);
    }

    public static Lookup.Provider[] getSortedProjects(Lookup.Provider[] projects) {
        Lookup.Provider[] sorted = Arrays.copyOf(projects, projects.length);
        Arrays.sort(sorted, (p1, p2) -> ProjectUtilities.getDisplayName(p1).compareToIgnoreCase(ProjectUtilities.getDisplayName(p2)));
        return sorted;
    }

    private static ProjectUtilitiesProvider provider() {
        return (ProjectUtilitiesProvider)Lookup.getDefault().lookup(ProjectUtilitiesProvider.class);
    }
}

