/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.auth.internal;

import com.oracle.bmc.ConfigFileReader;
import com.oracle.bmc.util.internal.FileUtils;
import com.oracle.bmc.util.internal.StringUtils;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigFileDelegationTokenUtils {
    private static final String OCI_DELEGATION_TOKEN_FILE_KEY = "delegation_token_file";
    private static final String OCI_DELEGATION_TOKEN = "delegation_token";
    private static final Logger LOG = LoggerFactory.getLogger(ConfigFileDelegationTokenUtils.class);

    private ConfigFileDelegationTokenUtils() {
        throw new UnsupportedOperationException("This class cannot be instantiated.");
    }

    public static String parseAndGetToken(ConfigFileReader.ConfigFile effectiveConfigFile) throws IOException {
        if (effectiveConfigFile.get(OCI_DELEGATION_TOKEN) != null) {
            return effectiveConfigFile.get(OCI_DELEGATION_TOKEN);
        }
        String delegationTokenFilePath = ConfigFileDelegationTokenUtils.getDelegationTokenFilePath(effectiveConfigFile);
        if (StringUtils.isBlank(delegationTokenFilePath)) {
            return "";
        }
        StringBuilder tokenBuilder = new StringBuilder();
        try (Stream<String> stream = Files.lines(Paths.get(FileUtils.expandUserHome(delegationTokenFilePath), new String[0]), StandardCharsets.UTF_8);){
            stream.forEach(s -> tokenBuilder.append((String)s));
        }
        catch (IOException e) {
            LOG.warn("Exception in reading or parsing delegation token file", (Throwable)e);
        }
        return tokenBuilder.toString();
    }

    private static String getDelegationTokenFilePath(ConfigFileReader.ConfigFile configFile) {
        String delegationTokenFilePath = configFile.get(OCI_DELEGATION_TOKEN_FILE_KEY);
        File delegationTokenFile = null;
        if (!StringUtils.isBlank(delegationTokenFilePath)) {
            delegationTokenFile = new File(FileUtils.expandUserHome(delegationTokenFilePath));
            if (delegationTokenFile.exists() && delegationTokenFile.isFile()) {
                LOG.debug("Loading delegation token from file: '%s'", (Object)delegationTokenFile.getAbsolutePath());
            } else {
                LOG.debug(String.format("Can't load the delegation token from file '%s' because it does not exist or it is not a file.", delegationTokenFile.getAbsolutePath()));
            }
        }
        return delegationTokenFilePath;
    }
}

