/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.catalog;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.net.MalformedURLException;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.xml.catalog.lib.Util;
import org.openide.DialogDescriptor;
import org.openide.util.NbBundle;

public class CatalogEntryPanel
extends JPanel {
    private DialogDescriptor enclosingDesc;
    private JButton browseButton;
    private ButtonGroup buttonGroup1;
    private JLabel descLabel;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JRadioButton publicRB;
    private JTextField publicTF;
    private JRadioButton systemRB;
    private JTextField systemTF;
    private JLabel titleLabel;
    private JLabel uriLabel;
    private JTextField uriTF;

    public CatalogEntryPanel() {
        this.initComponents();
        DocListener docListener = new DocListener(this);
        this.publicTF.getDocument().addDocumentListener(docListener);
        this.systemTF.getDocument().addDocumentListener(docListener);
        this.uriTF.getDocument().addDocumentListener(docListener);
        this.getAccessibleContext().setAccessibleName(this.titleLabel.getText());
        this.getAccessibleContext().setAccessibleDescription(this.descLabel.getText());
    }

    void setEnclosingDesc(DialogDescriptor enclosingDesc) {
        this.enclosingDesc = enclosingDesc;
    }

    public String getPublicId() {
        return this.publicTF.getText();
    }

    public boolean isPublic() {
        return this.publicRB.isSelected();
    }

    public String getSystemId() {
        return this.systemTF.getText();
    }

    public String getUri() {
        return this.uriTF.getText();
    }

    private void checkValues() {
        if (this.enclosingDesc == null) {
            return;
        }
        if (this.getUri().length() == 0) {
            this.enclosingDesc.setValid(false);
        } else if (this.isPublic() && this.getPublicId().length() == 0) {
            this.enclosingDesc.setValid(false);
        } else if (!this.isPublic() && this.getSystemId().length() == 0) {
            this.enclosingDesc.setValid(false);
        } else {
            this.enclosingDesc.setValid(true);
        }
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.publicRB = new JRadioButton();
        this.systemRB = new JRadioButton();
        this.publicTF = new JTextField();
        this.systemTF = new JTextField();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.uriLabel = new JLabel();
        this.uriTF = new JTextField();
        this.browseButton = new JButton();
        this.titleLabel = new JLabel();
        this.descLabel = new JLabel();
        this.setToolTipText("");
        this.setLayout(new GridBagLayout());
        this.buttonGroup1.add(this.publicRB);
        this.publicRB.setMnemonic(NbBundle.getMessage(CatalogEntryPanel.class, (String)"RADIO_publicId_mnem").charAt(0));
        this.publicRB.setSelected(true);
        this.publicRB.setText(NbBundle.getMessage(CatalogEntryPanel.class, (String)"RADIO_publicId"));
        this.publicRB.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                CatalogEntryPanel.this.publicRBItemStateChanged(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        this.add((Component)this.publicRB, gridBagConstraints);
        this.buttonGroup1.add(this.systemRB);
        this.systemRB.setMnemonic(NbBundle.getMessage(CatalogEntryPanel.class, (String)"RADIO_systemId_mnem").charAt(0));
        this.systemRB.setText(NbBundle.getMessage(CatalogEntryPanel.class, (String)"RADIO_systemId"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 5, 0, 0);
        this.add((Component)this.systemRB, gridBagConstraints);
        this.publicTF.setColumns(40);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.add((Component)this.publicTF, gridBagConstraints);
        this.systemTF.setColumns(25);
        this.systemTF.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(10, 5, 0, 5);
        this.add((Component)this.systemTF, gridBagConstraints);
        this.jLabel1.setText(NbBundle.getMessage(CatalogEntryPanel.class, (String)"HINT_publicId"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.add((Component)this.jLabel1, gridBagConstraints);
        this.jLabel2.setText(NbBundle.getMessage(CatalogEntryPanel.class, (String)"HINT_systemId"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.add((Component)this.jLabel2, gridBagConstraints);
        this.uriLabel.setDisplayedMnemonic(NbBundle.getMessage(CatalogEntryPanel.class, (String)"LBL_uri_mnem").charAt(0));
        this.uriLabel.setLabelFor(this.uriTF);
        this.uriLabel.setText(NbBundle.getMessage(CatalogEntryPanel.class, (String)"LBL_uri"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(20, 5, 5, 0);
        this.add((Component)this.uriLabel, gridBagConstraints);
        this.uriTF.setEditable(false);
        this.uriTF.setColumns(35);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(20, 5, 5, 0);
        this.add((Component)this.uriTF, gridBagConstraints);
        this.browseButton.setMnemonic(NbBundle.getMessage(CatalogEntryPanel.class, (String)"LBL_browse_mnem").charAt(0));
        this.browseButton.setText(NbBundle.getMessage(CatalogEntryPanel.class, (String)"LBL_browse"));
        this.browseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CatalogEntryPanel.this.browseButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(20, 5, 5, 5);
        this.add((Component)this.browseButton, gridBagConstraints);
        this.titleLabel.setText(NbBundle.getMessage(CatalogEntryPanel.class, (String)"HINT_panel"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 10, 5);
        this.add((Component)this.titleLabel, gridBagConstraints);
        this.descLabel.setText(NbBundle.getMessage(CatalogEntryPanel.class, (String)"LBL_catalogEntryDesc"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(20, 5, 5, 5);
        this.add((Component)this.descLabel, gridBagConstraints);
    }

    private void publicRBItemStateChanged(ItemEvent evt) {
        if (this.publicRB.isSelected()) {
            this.publicTF.setEditable(true);
            this.systemTF.setEditable(false);
        } else {
            this.publicTF.setEditable(false);
            this.systemTF.setEditable(true);
        }
        this.checkValues();
    }

    private void browseButtonActionPerformed(ActionEvent evt) {
        String maskTitle;
        String dialogTitle = NbBundle.getMessage(CatalogEntryPanel.class, (String)"TITLE_SelectDTDorSchema");
        File f = Util.selectFile("dtd xsd DTD XSD", dialogTitle, maskTitle = NbBundle.getMessage(CatalogEntryPanel.class, (String)"TXT_DTDorSchema"));
        if (f == null) {
            return;
        }
        try {
            String location = f.toURI().toURL().toExternalForm();
            this.uriTF.setText(location);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
    }

    private class DocListener
    implements DocumentListener {
        CatalogEntryPanel panel;

        public DocListener(CatalogEntryPanel panel) {
            this.panel = panel;
        }

        @Override
        public void changedUpdate(DocumentEvent evt) {
            this.panel.checkValues();
        }

        @Override
        public void insertUpdate(DocumentEvent evt) {
            this.panel.checkValues();
        }

        @Override
        public void removeUpdate(DocumentEvent evt) {
            this.panel.checkValues();
        }
    }
}

