/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.objectstorage.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.objectstorage.model.ReencryptObjectDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class ReencryptObjectRequest
extends BmcRequest<ReencryptObjectDetails> {
    private String namespaceName;
    private String bucketName;
    private String objectName;
    private ReencryptObjectDetails reencryptObjectDetails;
    private String versionId;
    private String opcClientRequestId;

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public String getObjectName() {
        return this.objectName;
    }

    public ReencryptObjectDetails getReencryptObjectDetails() {
        return this.reencryptObjectDetails;
    }

    public String getVersionId() {
        return this.versionId;
    }

    public String getOpcClientRequestId() {
        return this.opcClientRequestId;
    }

    @InternalSdk
    public ReencryptObjectDetails getBody$() {
        return this.reencryptObjectDetails;
    }

    public Builder toBuilder() {
        return new Builder().namespaceName(this.namespaceName).bucketName(this.bucketName).objectName(this.objectName).reencryptObjectDetails(this.reencryptObjectDetails).versionId(this.versionId).opcClientRequestId(this.opcClientRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",namespaceName=").append(String.valueOf(this.namespaceName));
        sb.append(",bucketName=").append(String.valueOf(this.bucketName));
        sb.append(",objectName=").append(String.valueOf(this.objectName));
        sb.append(",reencryptObjectDetails=").append(String.valueOf((Object)this.reencryptObjectDetails));
        sb.append(",versionId=").append(String.valueOf(this.versionId));
        sb.append(",opcClientRequestId=").append(String.valueOf(this.opcClientRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ReencryptObjectRequest)) {
            return false;
        }
        ReencryptObjectRequest other = (ReencryptObjectRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.namespaceName, other.namespaceName) && Objects.equals(this.bucketName, other.bucketName) && Objects.equals(this.objectName, other.objectName) && Objects.equals((Object)this.reencryptObjectDetails, (Object)other.reencryptObjectDetails) && Objects.equals(this.versionId, other.versionId) && Objects.equals(this.opcClientRequestId, other.opcClientRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.namespaceName == null ? 43 : this.namespaceName.hashCode());
        result = result * 59 + (this.bucketName == null ? 43 : this.bucketName.hashCode());
        result = result * 59 + (this.objectName == null ? 43 : this.objectName.hashCode());
        result = result * 59 + (this.reencryptObjectDetails == null ? 43 : this.reencryptObjectDetails.hashCode());
        result = result * 59 + (this.versionId == null ? 43 : this.versionId.hashCode());
        result = result * 59 + (this.opcClientRequestId == null ? 43 : this.opcClientRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ReencryptObjectRequest, ReencryptObjectDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String namespaceName = null;
        private String bucketName = null;
        private String objectName = null;
        private ReencryptObjectDetails reencryptObjectDetails = null;
        private String versionId = null;
        private String opcClientRequestId = null;

        public Builder namespaceName(String namespaceName) {
            this.namespaceName = namespaceName;
            return this;
        }

        public Builder bucketName(String bucketName) {
            this.bucketName = bucketName;
            return this;
        }

        public Builder objectName(String objectName) {
            this.objectName = objectName;
            return this;
        }

        public Builder reencryptObjectDetails(ReencryptObjectDetails reencryptObjectDetails) {
            this.reencryptObjectDetails = reencryptObjectDetails;
            return this;
        }

        public Builder versionId(String versionId) {
            this.versionId = versionId;
            return this;
        }

        public Builder opcClientRequestId(String opcClientRequestId) {
            this.opcClientRequestId = opcClientRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ReencryptObjectRequest o) {
            this.namespaceName(o.getNamespaceName());
            this.bucketName(o.getBucketName());
            this.objectName(o.getObjectName());
            this.reencryptObjectDetails(o.getReencryptObjectDetails());
            this.versionId(o.getVersionId());
            this.opcClientRequestId(o.getOpcClientRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ReencryptObjectRequest build() {
            ReencryptObjectRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(ReencryptObjectDetails body) {
            this.reencryptObjectDetails(body);
            return this;
        }

        public ReencryptObjectRequest buildWithoutInvocationCallback() {
            ReencryptObjectRequest request = new ReencryptObjectRequest();
            request.namespaceName = this.namespaceName;
            request.bucketName = this.bucketName;
            request.objectName = this.objectName;
            request.reencryptObjectDetails = this.reencryptObjectDetails;
            request.versionId = this.versionId;
            request.opcClientRequestId = this.opcClientRequestId;
            return request;
        }
    }
}

