/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.registry.uddi.infomodel;

import com.sun.xml.registry.uddi.infomodel.ExternalLinkImpl;
import com.sun.xml.registry.uddi.infomodel.InternationalStringImpl;
import com.sun.xml.registry.uddi.infomodel.RegistryObjectImpl;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.ResourceBundle;
import javax.xml.registry.JAXRException;
import javax.xml.registry.UnexpectedObjectException;
import javax.xml.registry.UnsupportedCapabilityException;
import javax.xml.registry.infomodel.ClassificationScheme;
import javax.xml.registry.infomodel.Concept;
import javax.xml.registry.infomodel.ExternalLink;
import javax.xml.registry.infomodel.Key;
import javax.xml.registry.infomodel.RegistryObject;

public class ConceptImpl
extends RegistryObjectImpl
implements Concept,
Serializable {
    transient boolean childrenLoaded = false;
    transient boolean isPredefined = false;
    String value;
    ConceptImpl parentConcept;
    ClassificationScheme classificationScheme;
    ArrayList children = new ArrayList();

    public ConceptImpl() {
    }

    public ConceptImpl(Key key) {
        this();
        this.key = key;
    }

    public ConceptImpl(Key key, String description, String name) {
        this(key);
        this.description = new InternationalStringImpl(description);
        this.name = new InternationalStringImpl(name);
    }

    public ConceptImpl(RegistryObject parent, String name, String value) throws JAXRException {
        this();
        if (parent instanceof ClassificationScheme) {
            ((ClassificationScheme)parent).addChildConcept((Concept)this);
        } else if (parent instanceof Concept) {
            ((Concept)parent).addChildConcept((Concept)this);
        }
        this.name = new InternationalStringImpl(name);
        this.value = value;
    }

    public String getValue() throws JAXRException {
        if (this.value == null) {
            this.getObject();
        }
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
        this.setIsModified(true);
    }

    public void addChildConcept(Concept concept) throws JAXRException {
        if (concept != null && !this.children.contains(concept)) {
            ((ConceptImpl)concept).setParentConcept(this);
            this.children.add(concept);
            this.setIsModified(true);
        }
    }

    public void addChildConcepts(Collection concepts) throws JAXRException {
        if (concepts == null) {
            return;
        }
        Iterator iter = concepts.iterator();
        try {
            while (iter.hasNext()) {
                Concept concept = (Concept)iter.next();
                this.addChildConcept(concept);
            }
        }
        catch (ClassCastException cce) {
            throw new UnexpectedObjectException(ResourceBundle.getBundle("com/sun/xml/registry/uddi/LocalStrings").getString("ConceptImpl:Objects_in_collection_must_be_concepts"), (Throwable)cce);
        }
    }

    public void removeChildConcept(Concept concept) {
        if (concept != null) {
            this.children.remove(concept);
            this.setIsModified(true);
        }
    }

    public void removeChildConcepts(Collection concepts) {
        if (concepts != null) {
            this.children.removeAll(concepts);
            this.setIsModified(true);
        }
    }

    public int getChildConceptCount() {
        return this.children.size();
    }

    public Collection getChildrenConcepts() throws JAXRException {
        return (Collection)this.children.clone();
    }

    public Collection getDescendantConcepts() throws JAXRException {
        ArrayList descendants = new ArrayList(this.children);
        for (Concept child : this.children) {
            if (child.getChildConceptCount() <= 0) continue;
            descendants.addAll(child.getDescendantConcepts());
        }
        return descendants;
    }

    public Concept getParentConcept() throws JAXRException {
        return this.parentConcept;
    }

    public ClassificationScheme getClassificationScheme() throws JAXRException {
        if (this.classificationScheme != null) {
            return this.classificationScheme;
        }
        return this.parentConcept != null ? this.parentConcept.getClassificationScheme() : null;
    }

    public void setClassificationScheme(ClassificationScheme scheme) {
        this.classificationScheme = scheme;
    }

    public String getPath() throws JAXRException {
        if (this.parentConcept == null) {
            return "/" + this.classificationScheme.getKey().getId() + "/" + this.value;
        }
        return "/" + this.parentConcept.getPath() + "/" + this.value;
    }

    public RegistryObject getParent() {
        if (this.parentConcept != null) {
            return this.parentConcept;
        }
        return this.classificationScheme;
    }

    public boolean isPredefined() {
        return this.isPredefined;
    }

    public void setPredefined(boolean predefined) {
        this.isPredefined = predefined;
    }

    public boolean getChildrenLoaded() throws JAXRException {
        return this.childrenLoaded;
    }

    public void setParentConcept(Concept parent) {
        if (parent instanceof ConceptImpl) {
            this.parentConcept = (ConceptImpl)parent;
        }
    }

    @Override
    public void addExternalLink(ExternalLink link) throws JAXRException {
        if (this.externalLinks.size() > 0) {
            throw new UnsupportedCapabilityException(ResourceBundle.getBundle("com/sun/xml/registry/uddi/LocalStrings").getString("ConceptImpl:ExternalLink_already_exists,_cannot_add_more."));
        }
        if (link != null) {
            ExternalLinkImpl externalLink = (ExternalLinkImpl)link;
            externalLink.addLinkedObject(this);
            this.externalLinks.add(externalLink);
            this.setIsModified(true);
        }
    }

    @Override
    public void addExternalLinks(Collection links) throws JAXRException {
        if (this.externalLinks.size() > 0) {
            throw new UnsupportedCapabilityException(ResourceBundle.getBundle("com/sun/xml/registry/uddi/LocalStrings").getString("ConceptImpl:ExternalLink_already_exists,_cannot_add_more."));
        }
        if (links != null) {
            if (links.size() > 1) {
                throw new UnsupportedCapabilityException(ResourceBundle.getBundle("com/sun/xml/registry/uddi/LocalStrings").getString("ConceptImpl:Cannot_add_more_than_one_ExternalLink"));
            }
            Iterator iter = links.iterator();
            try {
                while (iter.hasNext()) {
                    this.addExternalLink((ExternalLink)iter.next());
                }
            }
            catch (ClassCastException e) {
                throw new UnexpectedObjectException(ResourceBundle.getBundle("com/sun/xml/registry/uddi/LocalStrings").getString("ConceptImpl:Objects_in_collection_must_be_ExternalLinks"), (Throwable)e);
            }
        }
    }

    @Override
    public void setExternalLinks(Collection links) throws JAXRException {
        if (links == null) {
            this.externalLinks.clear();
            return;
        }
        if (links.size() > 1) {
            throw new UnsupportedCapabilityException(ResourceBundle.getBundle("com/sun/xml/registry/uddi/LocalStrings").getString("ConceptImpl:Cannot_set_more_than_one_link."));
        }
        this.externalLinks.clear();
        this.addExternalLinks(links);
    }
}

