/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.index.context;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.store.Directory;
import org.apache.maven.index.artifact.GavCalculator;
import org.apache.maven.index.context.DocumentFilter;
import org.apache.maven.index.context.IndexCreator;

public interface IndexingContext {
    public static final String INDEX_FILE_PREFIX = "nexus-maven-repository-index";
    public static final String INDEX_REMOTE_PROPERTIES_FILE = "nexus-maven-repository-index.properties";
    public static final String INDEX_UPDATER_PROPERTIES_FILE = "nexus-maven-repository-index-updater.properties";
    public static final String INDEX_PACKER_PROPERTIES_FILE = "nexus-maven-repository-index-packer.properties";
    public static final String INDEX_PROPERTY_PREFIX = "nexus.index.";
    public static final String INDEX_ID = "nexus.index.id";
    public static final String INDEX_LEGACY_TIMESTAMP = "nexus.index.time";
    public static final String INDEX_TIMESTAMP = "nexus.index.timestamp";
    public static final String INDEX_CHUNK_PREFIX = "nexus.index.incremental-";
    public static final String INDEX_TIME_FORMAT = "yyyyMMddHHmmss.SSS Z";
    public static final String INDEX_TIME_DAY_FORMAT = "yyyyMMdd";
    public static final String INDEX_CHUNK_COUNTER = "nexus.index.last-incremental";
    public static final String INDEX_CHAIN_ID = "nexus.index.chain-id";

    public String getId();

    public String getRepositoryId();

    public File getRepository();

    public String getRepositoryUrl();

    public String getIndexUpdateUrl();

    public boolean isSearchable();

    public void setSearchable(boolean var1);

    public Date getTimestamp();

    public void updateTimestamp() throws IOException;

    public void updateTimestamp(boolean var1) throws IOException;

    public void updateTimestamp(boolean var1, Date var2) throws IOException;

    public int getSize() throws IOException;

    public IndexSearcher acquireIndexSearcher() throws IOException;

    public void releaseIndexSearcher(IndexSearcher var1) throws IOException;

    public IndexWriter getIndexWriter() throws IOException;

    public List<IndexCreator> getIndexCreators();

    public Analyzer getAnalyzer();

    public void commit() throws IOException;

    public void rollback() throws IOException;

    public void optimize() throws IOException;

    public void close(boolean var1) throws IOException;

    public void purge() throws IOException;

    public void merge(Directory var1) throws IOException;

    public void merge(Directory var1, DocumentFilter var2) throws IOException;

    public void merge(Directory var1, DocumentFilter var2, Set<String> var3, Set<String> var4) throws IOException;

    public void replace(Directory var1) throws IOException;

    public void replace(Directory var1, Set<String> var2, Set<String> var3) throws IOException;

    public Directory getIndexDirectory();

    public File getIndexDirectoryFile();

    public GavCalculator getGavCalculator();

    public void setAllGroups(Collection<String> var1) throws IOException;

    public Set<String> getAllGroups() throws IOException;

    public void setRootGroups(Collection<String> var1) throws IOException;

    public Set<String> getRootGroups() throws IOException;

    public void rebuildGroups() throws IOException;

    public boolean isReceivingUpdates();
}

