/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.jemmy;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.PrintWriter;

public class TestOut {
    private InputStream input;
    private PrintWriter output;
    private PrintWriter errput;
    private PrintWriter golden_output;
    private BufferedReader buffInput;
    private boolean autoFlushMode = true;

    public TestOut(InputStream in, PrintStream out, PrintStream err) {
        this(in, out, err, null);
    }

    public TestOut(InputStream in, PrintStream out, PrintStream err, PrintStream golden) {
        PrintWriter tout = null;
        if (out != null) {
            tout = new PrintWriter(out);
        }
        PrintWriter terr = null;
        if (err != null) {
            terr = new PrintWriter(err);
        }
        PrintWriter tgolden = null;
        if (golden != null) {
            tgolden = new PrintWriter(golden);
        }
        this.initStreams(in, tout, terr, tgolden);
    }

    public TestOut(InputStream in, PrintWriter out, PrintWriter err) {
        this(in, out, err, null);
    }

    public TestOut(InputStream in, PrintWriter out, PrintWriter err, PrintWriter golden) {
        this.initStreams(in, out, err, golden);
        this.autoFlushMode = true;
    }

    public TestOut() {
        this(System.in, new PrintWriter(System.out), new PrintWriter(System.err), null);
    }

    public static TestOut getNullOutput() {
        return new TestOut((InputStream)null, (PrintWriter)null, (PrintWriter)null);
    }

    public boolean setAutoFlushMode(boolean autoFlushMode) {
        boolean oldValue = this.getAutoFlushMode();
        this.autoFlushMode = autoFlushMode;
        return oldValue;
    }

    public boolean getAutoFlushMode() {
        return this.autoFlushMode;
    }

    public int read() throws IOException {
        if (this.input != null) {
            return this.input.read();
        }
        return -1;
    }

    public String readLine() throws IOException {
        if (this.buffInput != null) {
            return this.buffInput.readLine();
        }
        return null;
    }

    public void print(String line) {
        if (this.output != null) {
            this.output.print(line);
        }
    }

    public void printLine(String line) {
        if (this.output != null) {
            this.output.println(line);
            if (this.autoFlushMode) {
                this.output.flush();
            }
        }
    }

    public void printGolden(String line) {
        if (this.golden_output != null) {
            this.golden_output.println(line);
            if (this.autoFlushMode) {
                this.golden_output.flush();
            }
        }
    }

    public void printErrLine(String line) {
        if (this.errput != null) {
            this.errput.println(line);
            if (this.autoFlushMode) {
                this.errput.flush();
            }
        }
    }

    public void printLine(boolean toOut, String line) {
        if (toOut) {
            this.printLine(line);
        } else {
            this.printErrLine(line);
        }
    }

    public void printTrace(String text) {
        this.printLine("Trace:");
        this.printLine(text);
    }

    public void printError(String text) {
        this.printErrLine("Error:");
        this.printErrLine(text);
    }

    public void printStackTrace(Throwable e) {
        if (this.errput != null) {
            e.printStackTrace(this.errput);
            if (this.autoFlushMode) {
                this.errput.flush();
            }
        }
    }

    public InputStream getInput() {
        return this.input;
    }

    public PrintWriter getOutput() {
        return this.output;
    }

    public PrintWriter getErrput() {
        return this.errput;
    }

    public PrintWriter getGolden() {
        return this.golden_output;
    }

    public TestOut createErrorOutput() {
        return new TestOut(null, null, this.getErrput());
    }

    public void flush() {
        if (this.output != null) {
            this.output.flush();
        }
        if (this.errput != null) {
            this.errput.flush();
        }
        if (this.golden_output != null) {
            this.golden_output.flush();
        }
    }

    private void initStreams(InputStream in, PrintWriter out, PrintWriter err, PrintWriter golden) {
        this.input = in;
        this.output = out;
        this.errput = err;
        this.golden_output = golden;
        this.buffInput = this.input != null ? new BufferedReader(new InputStreamReader(in)) : null;
    }
}

