/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.universe;

import java.io.File;
import java.io.FilenameFilter;
import java.net.URI;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.apisupport.project.ApisupportAntUtils;
import org.netbeans.modules.apisupport.project.SuiteProvider;
import org.netbeans.modules.apisupport.project.spi.NbModuleProvider;
import org.netbeans.modules.apisupport.project.ui.customizer.ClusterInfo;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.util.Utilities;

public final class ClusterUtils {
    private ClusterUtils() {
    }

    public static boolean isValidCluster(File file) {
        return new File(file, "config/Modules").isDirectory();
    }

    public static File getClusterDirectory(Project prj) {
        File clusterDir = ClusterUtils.getClusterDirectory((NbModuleProvider)prj.getLookup().lookup(NbModuleProvider.class));
        if (clusterDir != null) {
            return clusterDir;
        }
        SuiteProvider sprv = (SuiteProvider)prj.getLookup().lookup(SuiteProvider.class);
        if (sprv != null) {
            return sprv.getClusterDirectory();
        }
        return null;
    }

    private static File getClusterDirectory(NbModuleProvider nbmp) {
        File jar;
        if (nbmp != null && (jar = nbmp.getModuleJarLocation()) != null) {
            return jar.getParentFile().getParentFile();
        }
        return null;
    }

    public static File evaluateClusterPathEntry(String rawEntry, File root, PropertyEvaluator eval, File nbPlatformRoot) {
        File parent;
        Matcher cm;
        File path;
        final Pattern pat = Pattern.compile("(?:.*[\\\\/])?([^/\\\\]*?)([0-9.]+)?[/\\\\]?$");
        String nbDirProp = "${nbplatform.active.dir}";
        if (((String)rawEntry).startsWith("${nbplatform.active.dir}")) {
            rawEntry = nbPlatformRoot.getAbsolutePath() + ((String)rawEntry).substring("${nbplatform.active.dir}".length());
        }
        if (!(path = PropertyUtils.resolveFile((File)root, (String)eval.evaluate((String)rawEntry))).exists() && (cm = pat.matcher(path.getAbsolutePath())).matches() && (parent = path.getParentFile()) != null) {
            File[] alternate = parent.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    Matcher am = pat.matcher(name);
                    return am.matches() && cm.group(1).equalsIgnoreCase(am.group(1));
                }
            });
            if (alternate == null) {
                return path;
            }
            if (alternate.length > 0 && alternate[0].isDirectory()) {
                return alternate[0];
            }
        }
        return path;
    }

    public static Set<ClusterInfo> evaluateClusterPath(File root, PropertyEvaluator eval, File nbPlatformRoot) {
        LinkedHashSet<ClusterInfo> clusterPath = new LinkedHashSet<ClusterInfo>();
        String cpp = eval.getProperty("cluster.path");
        String[] paths = PropertyUtils.tokenizePath((String)(cpp != null ? cpp : ""));
        String cpwdcp = eval.getProperty("cluster.path.with.disabled.clusters");
        String[] pathsWDC = cpwdcp != null ? PropertyUtils.tokenizePath((String)cpwdcp) : null;
        String[] wp = pathsWDC != null ? pathsWDC : paths;
        HashSet<String> enabledPaths = new HashSet<String>();
        if (pathsWDC != null) {
            enabledPaths.addAll(Arrays.asList(paths));
        }
        HashMap<File, String> srcRootsMap = new HashMap<File, String>();
        HashMap<File, String> jRootsMap = new HashMap<File, String>();
        Map props = eval.getProperties();
        for (Map.Entry entry : props.entrySet()) {
            File cf;
            String cd;
            String key = (String)entry.getKey();
            if (!key.startsWith("extcluster.")) continue;
            if (key.endsWith(".sources")) {
                cd = key.substring("extcluster.".length(), key.length() - ".sources".length());
                cf = PropertyUtils.resolveFile((File)root, (String)cd);
                srcRootsMap.put(cf, (String)entry.getValue());
                continue;
            }
            if (!key.endsWith(".javadoc")) continue;
            cd = key.substring("extcluster.".length(), key.length() - ".javadoc".length());
            cf = PropertyUtils.resolveFile((File)root, (String)cd);
            jRootsMap.put(cf, (String)entry.getValue());
        }
        for (String path : wp) {
            File cd = ClusterUtils.evaluateClusterPathEntry(path, root, eval, nbPlatformRoot);
            boolean isPlaf = cd.getParentFile().equals(nbPlatformRoot);
            Project prj = null;
            Project _prj = FileOwnerQuery.getOwner((URI)Utilities.toURI((File)cd));
            if (_prj != null && cd.equals(ClusterUtils.getClusterDirectory(_prj))) {
                prj = _prj;
            }
            boolean enabled = pathsWDC == null || enabledPaths.contains(path);
            URL[] srcRoots = null;
            if (srcRootsMap.containsKey(cd)) {
                srcRoots = ApisupportAntUtils.findURLs((String)srcRootsMap.get(cd));
            }
            URL[] jRoots = null;
            if (jRootsMap.containsKey(cd)) {
                jRoots = ApisupportAntUtils.findURLs((String)jRootsMap.get(cd));
            }
            clusterPath.add(ClusterInfo.createFromCP(cd, prj, isPlaf, srcRoots, jRoots, enabled));
        }
        return clusterPath;
    }
}

