/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cordova.updatetask;

import java.io.File;
import java.io.IOException;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.util.FileUtils;
import org.netbeans.modules.cordova.updatetask.AndroidManifest;
import org.netbeans.modules.cordova.updatetask.CordovaTask;
import org.netbeans.modules.cordova.updatetask.DeviceConfig;
import org.netbeans.modules.cordova.updatetask.SourceConfig;

public class AndroidUpdateTask
extends CordovaTask {
    public void execute() throws BuildException {
        File manifestFile = new File(this.getProject().getBaseDir().getAbsolutePath() + "/" + this.getProperty("cordova.platforms") + "/android/AndroidManifest.xml");
        File configFile = this.getConfigFile();
        File androidConfigFile = new File(this.getProject().getBaseDir().getAbsolutePath() + "/" + this.getProperty("cordova.platforms") + "/android/res/xml/config.xml");
        try {
            AndroidManifest androidManifest = new AndroidManifest(manifestFile);
            this.updateAndroidManifest(androidManifest);
            androidManifest.save();
            DeviceConfig androidConfig = new DeviceConfig(androidConfigFile);
            SourceConfig config = new SourceConfig(configFile);
            this.updateAndroidConfig(config, androidConfig);
            androidConfig.save();
            this.updateResources(config);
        }
        catch (IOException ex) {
            throw new BuildException((Throwable)ex);
        }
    }

    private void updateAndroidManifest(AndroidManifest manifest) {
        manifest.setName(this.getProperty("android.project.activity"));
        manifest.setPackage(this.getProperty("android.project.package"));
    }

    private void updateAndroidConfig(SourceConfig config, DeviceConfig androidConfig) {
        androidConfig.setAccess(config.getAccess());
    }

    private void updateResources(SourceConfig config) throws IOException {
        String icon = config.getIcon("android", 36, 36);
        this.copy(icon, "drawable-ldpi/icon");
        icon = config.getIcon("android", 48, 48);
        this.copy(icon, "drawable-mdpi/icon");
        icon = config.getIcon("android", 72, 72);
        this.copy(icon, "drawable-hdpi/icon");
        icon = config.getIcon("android", 96, 96);
        this.copy(icon, "drawable-xhdpi/icon");
        this.copy(icon, "drawable/icon");
        String splash = config.getSplash("android", 320, 200);
        this.copy(splash, "drawable-ldpi/splash_landscape");
        splash = config.getSplash("android", 200, 320);
        this.copy(splash, "drawable-ldpi/splash_portrait");
        splash = config.getSplash("android", 480, 320);
        this.copy(splash, "drawable-mdpi/splash_landscape");
        splash = config.getSplash("android", 320, 480);
        this.copy(splash, "drawable-mdpi/splash_portrait");
        splash = config.getSplash("android", 800, 480);
        this.copy(splash, "drawable-hdpi/splash_landscape");
        splash = config.getSplash("android", 480, 800);
        this.copy(splash, "drawable-hdpi/splash_portrait");
        splash = config.getSplash("android", 1280, 720);
        this.copy(splash, "drawable-xhdpi/splash_landscape");
        splash = config.getSplash("android", 720, 1280);
        this.copy(splash, "drawable-xhdpi/splash_portrait");
        splash = config.getSplash("android", 1280, 720);
        this.copy(splash, "drawable/splash_landscape");
        splash = config.getSplash("android", 720, 1280);
        this.copy(splash, "drawable/splash_portrait");
    }

    private void copy(String source, String dest) throws IOException {
        if (source == null) {
            return;
        }
        String ext = source.substring(source.indexOf("."));
        String prjPath = this.getProject().getBaseDir().getPath();
        FileUtils.getFileUtils().copyFile(prjPath + "/" + this.getProperty("site.root") + "/" + source, prjPath + "/" + this.getProject().getProperty("cordova.platforms") + "/android/res/" + dest + ext);
    }
}

