/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetVolumeAttachmentRequest
extends BmcRequest<Void> {
    private String volumeAttachmentId;

    public String getVolumeAttachmentId() {
        return this.volumeAttachmentId;
    }

    public Builder toBuilder() {
        return new Builder().volumeAttachmentId(this.volumeAttachmentId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",volumeAttachmentId=").append(String.valueOf(this.volumeAttachmentId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetVolumeAttachmentRequest)) {
            return false;
        }
        GetVolumeAttachmentRequest other = (GetVolumeAttachmentRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.volumeAttachmentId, other.volumeAttachmentId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.volumeAttachmentId == null ? 43 : this.volumeAttachmentId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetVolumeAttachmentRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String volumeAttachmentId = null;

        public Builder volumeAttachmentId(String volumeAttachmentId) {
            this.volumeAttachmentId = volumeAttachmentId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetVolumeAttachmentRequest o) {
            this.volumeAttachmentId(o.getVolumeAttachmentId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetVolumeAttachmentRequest build() {
            GetVolumeAttachmentRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetVolumeAttachmentRequest buildWithoutInvocationCallback() {
            GetVolumeAttachmentRequest request = new GetVolumeAttachmentRequest();
            request.volumeAttachmentId = this.volumeAttachmentId;
            return request;
        }
    }
}

