/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.fish.payara.micro.plugin;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Map;
import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import org.netbeans.api.scripting.Scripting;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;

public class TemplateUtil {
    private static final String ENCODING_PROPERTY_NAME = "encoding";

    private static URL getResourceURL(String resource) {
        ClassLoader loader = (ClassLoader)Lookup.getDefault().lookup(ClassLoader.class);
        if (loader == null) {
            loader = Thread.currentThread().getContextClassLoader();
        }
        return loader.getResource(resource.startsWith("/") ? resource.substring(1) : resource);
    }

    public static InputStream loadResource(String resource) {
        InputStream inputStream = null;
        try {
            inputStream = TemplateUtil.getResourceURL(resource).openStream();
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return inputStream;
    }

    public static String expandTemplate(Reader reader, Map<String, Object> values) {
        StringWriter writer = new StringWriter();
        ScriptEngine eng = TemplateUtil.getScriptEngine();
        Bindings bind = eng.getContext().getBindings(100);
        if (values != null) {
            bind.putAll((Map<? extends String, ? extends Object>)values);
        }
        bind.put(ENCODING_PROPERTY_NAME, (Object)Charset.defaultCharset().name());
        eng.getContext().setWriter(writer);
        try {
            eng.eval(reader);
        }
        catch (ScriptException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return writer.toString();
    }

    private static ScriptEngine getScriptEngine() {
        return Scripting.createManager().getEngineByName("freemarker");
    }
}

