module RemoteExploitDataService
  EXPLOIT_API_PATH = '/api/v1/exploits'

  def report_exploit_attempt(host, opts)
    opts[:host] = host
    opts[:exploit_report_type] = "attempt"
    self.post_data_async(EXPLOIT_API_PATH, opts)
  end

  def report_exploit_failure(opts)
    opts[:exploit_report_type] = "failure"
    self.post_data_async(EXPLOIT_API_PATH, opts)
  end

  def report_exploit_success(opts)
    opts[:exploit_report_type] = "success"
    self.post_data_async(EXPLOIT_API_PATH, opts)
  end

end