/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.IOException;
import org.jboss.logging.Logger;
import org.keycloak.common.util.Base64Url;
import org.keycloak.common.util.ObjectUtil;
import org.keycloak.util.JsonSerialization;

public class ClientData {
    protected static final Logger logger = Logger.getLogger(ClientData.class);
    @JsonProperty(value="ru")
    private String redirectUri;
    @JsonProperty(value="rt")
    private String responseType;
    @JsonProperty(value="rm")
    private String responseMode;
    @JsonProperty(value="st")
    private String state;

    public ClientData() {
    }

    public ClientData(String redirectUri, String responseType, String responseMode, String state) {
        this.redirectUri = redirectUri;
        this.responseType = responseType;
        this.responseMode = responseMode;
        this.state = state;
    }

    public String getRedirectUri() {
        return this.redirectUri;
    }

    public void setRedirectUri(String redirectUri) {
        this.redirectUri = redirectUri;
    }

    public String getResponseType() {
        return this.responseType;
    }

    public void setResponseType(String responseType) {
        this.responseType = responseType;
    }

    public String getResponseMode() {
        return this.responseMode;
    }

    public void setResponseMode(String responseMode) {
        this.responseMode = responseMode;
    }

    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public String toString() {
        return String.format("ClientData [ redirectUri=%s, responseType=%s, responseMode=%s, state=%s ]", this.redirectUri, this.responseType, this.responseMode, this.state);
    }

    public static ClientData decodeClientDataFromParameter(String clientDataParam) throws IOException {
        if (ObjectUtil.isBlank((CharSequence)clientDataParam)) {
            return null;
        }
        byte[] cdataJson = Base64Url.decode((String)clientDataParam);
        return (ClientData)JsonSerialization.readValue((byte[])cdataJson, ClientData.class);
    }

    public String encode() {
        try {
            return Base64Url.encode((byte[])JsonSerialization.writeValueAsBytes((Object)this));
        }
        catch (IOException ioe) {
            throw new RuntimeException("Not possible to serialize clientData");
        }
    }
}

