/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.jaxb.mapping;

import java.util.EnumSet;
import java.util.Locale;
import org.hibernate.generator.EventType;

public enum GenerationTiming {
    NEVER,
    INSERT,
    UPDATE,
    ALWAYS;


    public boolean includesInsert() {
        return this == INSERT || this == ALWAYS;
    }

    public boolean includesUpdate() {
        return this == UPDATE || this == ALWAYS;
    }

    public boolean includes(GenerationTiming timing) {
        return switch (this.ordinal()) {
            default -> throw new IncompatibleClassChangeError();
            case 0 -> {
                if (timing == NEVER) {
                    yield true;
                }
                yield false;
            }
            case 1 -> timing.includesInsert();
            case 2 -> timing.includesUpdate();
            case 3 -> true;
        };
    }

    public static GenerationTiming parseFromName(String name) {
        return switch (name.toLowerCase(Locale.ROOT)) {
            case "insert" -> INSERT;
            case "update" -> UPDATE;
            case "always" -> ALWAYS;
            default -> NEVER;
        };
    }

    public EnumSet<EventType> getEventTypes() {
        return switch (this.ordinal()) {
            default -> throw new IncompatibleClassChangeError();
            case 3 -> EnumSet.allOf(EventType.class);
            case 1 -> EnumSet.of(EventType.INSERT);
            case 2 -> EnumSet.of(EventType.UPDATE);
            case 0 -> null;
        };
    }
}

