/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.operators.multi;

import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.helpers.Subscriptions;
import io.smallrye.mutiny.operators.multi.AbstractMultiOperator;
import io.smallrye.mutiny.operators.multi.MultiOperatorProcessor;
import io.smallrye.mutiny.subscription.MultiSubscriber;
import java.util.Objects;
import java.util.concurrent.Flow;
import java.util.function.Consumer;

public final class MultiOnSubscribeInvokeOp<T>
extends AbstractMultiOperator<T, T> {
    private final Consumer<? super Flow.Subscription> onSubscribe;

    public MultiOnSubscribeInvokeOp(Multi<? extends T> upstream, Consumer<? super Flow.Subscription> onSubscribe) {
        super(upstream);
        this.onSubscribe = onSubscribe;
    }

    @Override
    public void subscribe(MultiSubscriber<? super T> actual) {
        OnSubscribeSubscriber subscriber = new OnSubscribeSubscriber(Objects.requireNonNull(actual, "Subscriber must not be `null`"));
        this.upstream.subscribe().withSubscriber(subscriber);
    }

    private final class OnSubscribeSubscriber
    extends MultiOperatorProcessor<T, T> {
        OnSubscribeSubscriber(MultiSubscriber<? super T> downstream) {
            super(downstream);
        }

        @Override
        public void onSubscribe(Flow.Subscription s) {
            if (this.compareAndSetUpstreamSubscription(null, s)) {
                try {
                    MultiOnSubscribeInvokeOp.this.onSubscribe.accept(s);
                }
                catch (Throwable e) {
                    Subscriptions.fail(this.downstream, e);
                    this.getAndSetUpstreamSubscription(Subscriptions.CANCELLED).cancel();
                    return;
                }
                this.downstream.onSubscribe(this);
            } else {
                s.cancel();
            }
        }
    }
}

