/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.mapping.internal;

import org.hibernate.FetchMode;
import org.hibernate.engine.FetchStyle;
import org.hibernate.engine.FetchTiming;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.persister.collection.AbstractCollectionPersister;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.sql.results.graph.FetchOptions;
import org.hibernate.type.AnyType;
import org.hibernate.type.AssociationType;
import org.hibernate.type.CollectionType;
import org.hibernate.type.EntityType;

public final class FetchOptionsHelper {
    private static final CoreMessageLogger LOG = CoreLogging.messageLogger(FetchOptionsHelper.class);

    private FetchOptionsHelper() {
    }

    public static FetchStyle determineFetchStyleByMetadata(FetchMode mappingFetchMode, AssociationType type, SessionFactoryImplementor sessionFactory) {
        if (!(type instanceof EntityType) && !(type instanceof CollectionType)) {
            return FetchStyle.SELECT;
        }
        if (mappingFetchMode == FetchMode.JOIN) {
            return FetchStyle.JOIN;
        }
        if (type instanceof EntityType) {
            EntityPersister persister = (EntityPersister)((Object)type.getAssociatedJoinable(sessionFactory));
            if (persister.isBatchLoadable()) {
                return FetchStyle.BATCH;
            }
            if (mappingFetchMode == FetchMode.SELECT) {
                return FetchStyle.SELECT;
            }
            if (!persister.hasProxy()) {
                return FetchStyle.JOIN;
            }
        } else {
            CollectionPersister persister = (CollectionPersister)((Object)type.getAssociatedJoinable(sessionFactory));
            if (persister instanceof AbstractCollectionPersister && persister.isSubselectLoadable()) {
                return FetchStyle.SUBSELECT;
            }
            if (persister.getBatchSize() > 0) {
                return FetchStyle.BATCH;
            }
        }
        return FetchStyle.SELECT;
    }

    public static FetchTiming determineFetchTiming(FetchStyle style, AssociationType type, SessionFactoryImplementor sessionFactory) {
        switch (style) {
            case JOIN: {
                return FetchTiming.IMMEDIATE;
            }
        }
        return FetchOptionsHelper.isSubsequentSelectDelayed(type, sessionFactory) ? FetchTiming.DELAYED : FetchTiming.IMMEDIATE;
    }

    public static FetchTiming determineFetchTiming(FetchStyle style, AssociationType type, boolean lazy, String role, SessionFactoryImplementor sessionFactory) {
        switch (style) {
            case JOIN: {
                if (lazy) {
                    LOG.fetchModeJoinWithLazyWarning(role);
                    return FetchTiming.DELAYED;
                }
                return FetchTiming.IMMEDIATE;
            }
        }
        return FetchOptionsHelper.isSubsequentSelectDelayed(type, sessionFactory) ? FetchTiming.DELAYED : FetchTiming.IMMEDIATE;
    }

    private static boolean isSubsequentSelectDelayed(AssociationType type, SessionFactoryImplementor sessionFactory) {
        if (type instanceof AnyType) {
            return false;
        }
        if (type instanceof EntityType) {
            EntityPersister entityPersister = (EntityPersister)((Object)type.getAssociatedJoinable(sessionFactory));
            return entityPersister.getEntityMetamodel().isLazy();
        }
        CollectionPersister cp = (CollectionPersister)((Object)type.getAssociatedJoinable(sessionFactory));
        return cp.isLazy() || cp.isExtraLazy();
    }

    public static boolean isJoinFetched(FetchOptions fetchOptions) {
        return fetchOptions.getTiming() == FetchTiming.IMMEDIATE && fetchOptions.getStyle() == FetchStyle.JOIN;
    }
}

