/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.storage.ldap;

import java.util.List;
import org.keycloak.models.UserModel;
import org.keycloak.models.utils.UserModelDelegate;
import org.keycloak.storage.ldap.LDAPStorageProvider;
import org.keycloak.storage.ldap.mappers.LDAPTransaction;

public class LDAPWritesOnlyUserModelDelegate
extends UserModelDelegate {
    private final LDAPStorageProvider provider;

    public LDAPWritesOnlyUserModelDelegate(UserModel delegate, LDAPStorageProvider provider) {
        super(delegate);
        this.provider = provider;
    }

    public void setUsername(String username) {
        if (!this.isAttributeUpdatedInLDAP("username")) {
            super.setUsername(username);
        }
    }

    public void setEnabled(boolean enabled) {
        if (!this.isAttributeUpdatedInLDAP("enabled")) {
            super.setEnabled(enabled);
        }
    }

    public void setSingleAttribute(String name, String value) {
        if (!this.isAttributeUpdatedInLDAP(name)) {
            super.setSingleAttribute(name, value);
        }
    }

    public void setAttribute(String name, List<String> values) {
        if (!this.isAttributeUpdatedInLDAP(name)) {
            super.setAttribute(name, values);
        }
    }

    public void removeAttribute(String name) {
        if (!this.isAttributeUpdatedInLDAP(name)) {
            super.removeAttribute(name);
        }
    }

    public void addRequiredAction(String action) {
        if (!this.isRequiredActionUpdatedInLDAP(action)) {
            super.addRequiredAction(action);
        }
    }

    public void removeRequiredAction(String action) {
        if (!this.isRequiredActionUpdatedInLDAP(action)) {
            super.removeRequiredAction(action);
        }
    }

    public void addRequiredAction(UserModel.RequiredAction action) {
        if (!this.isRequiredActionUpdatedInLDAP(action.toString())) {
            super.addRequiredAction(action);
        }
    }

    public void removeRequiredAction(UserModel.RequiredAction action) {
        if (!this.isRequiredActionUpdatedInLDAP(action.toString())) {
            super.removeRequiredAction(action);
        }
    }

    public void setFirstName(String firstName) {
        if (!this.isAttributeUpdatedInLDAP("firstName")) {
            super.setFirstName(firstName);
        }
    }

    public void setLastName(String lastName) {
        if (!this.isAttributeUpdatedInLDAP("lastName")) {
            super.setLastName(lastName);
        }
    }

    public void setEmail(String email) {
        if (!this.isAttributeUpdatedInLDAP("email")) {
            super.setEmail(email);
        }
    }

    public void setEmailVerified(boolean verified) {
        if (!this.isAttributeUpdatedInLDAP("emailVerified")) {
            super.setEmailVerified(verified);
        }
    }

    protected boolean isAttributeUpdatedInLDAP(String attributeName) {
        LDAPTransaction transaction = this.provider.getUserManager().getTransaction(this.getId());
        if (transaction == null) {
            return false;
        }
        return transaction.isAttributeUpdated(attributeName);
    }

    protected boolean isRequiredActionUpdatedInLDAP(String requiredActionName) {
        LDAPTransaction transaction = this.provider.getUserManager().getTransaction(this.getId());
        if (transaction == null) {
            return false;
        }
        return transaction.isRequiredActionUpdated(requiredActionName);
    }
}

