/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.internals;

import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.kafka.clients.consumer.CloseOptions;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerGroupMetadata;
import org.apache.kafka.clients.consumer.ConsumerRebalanceListener;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.clients.consumer.OffsetAndTimestamp;
import org.apache.kafka.clients.consumer.OffsetCommitCallback;
import org.apache.kafka.clients.consumer.SubscriptionPattern;
import org.apache.kafka.clients.consumer.internals.AsyncKafkaConsumer;
import org.apache.kafka.clients.consumer.internals.StreamsRebalanceData;
import org.apache.kafka.clients.consumer.internals.StreamsRebalanceListener;
import org.apache.kafka.common.Metric;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.metrics.KafkaMetric;

public abstract class ConsumerWrapper
implements Consumer<byte[], byte[]> {
    protected AsyncKafkaConsumer<byte[], byte[]> delegate;

    public void wrapConsumer(AsyncKafkaConsumer<byte[], byte[]> delegate, Map<String, Object> config, Optional<StreamsRebalanceData> streamsRebalanceData) {
        this.delegate = delegate;
    }

    public Set<TopicPartition> assignment() {
        return this.delegate.assignment();
    }

    public Set<String> subscription() {
        return this.delegate.subscription();
    }

    public void subscribe(Collection<String> topics) {
        this.delegate.subscribe(topics);
    }

    public void subscribe(Collection<String> topics, ConsumerRebalanceListener callback) {
        this.delegate.subscribe(topics, callback);
    }

    public void subscribe(Collection<String> topics, StreamsRebalanceListener streamsRebalanceListener) {
        this.delegate.subscribe(topics, streamsRebalanceListener);
    }

    public void assign(Collection<TopicPartition> partitions) {
        this.delegate.assign(partitions);
    }

    public void subscribe(Pattern pattern, ConsumerRebalanceListener callback) {
        this.delegate.subscribe(pattern, callback);
    }

    public void subscribe(Pattern pattern) {
        this.delegate.subscribe(pattern);
    }

    public void subscribe(SubscriptionPattern pattern, ConsumerRebalanceListener callback) {
        this.delegate.subscribe(pattern, callback);
    }

    public void subscribe(SubscriptionPattern pattern) {
        this.delegate.subscribe(pattern);
    }

    public void unsubscribe() {
        this.delegate.unsubscribe();
    }

    public ConsumerRecords<byte[], byte[]> poll(Duration timeout) {
        return this.delegate.poll(timeout);
    }

    public void commitSync() {
        this.delegate.commitSync();
    }

    public void commitSync(Duration timeout) {
        this.delegate.commitSync(timeout);
    }

    public void commitSync(Map<TopicPartition, OffsetAndMetadata> offsets) {
        this.delegate.commitSync(offsets);
    }

    public void commitSync(Map<TopicPartition, OffsetAndMetadata> offsets, Duration timeout) {
        this.delegate.commitSync(offsets, timeout);
    }

    public void commitAsync() {
        this.delegate.commitAsync();
    }

    public void commitAsync(OffsetCommitCallback callback) {
        this.delegate.commitAsync(callback);
    }

    public void commitAsync(Map<TopicPartition, OffsetAndMetadata> offsets, OffsetCommitCallback callback) {
        this.delegate.commitAsync(offsets, callback);
    }

    public void registerMetricForSubscription(KafkaMetric metric) {
        this.delegate.registerMetricForSubscription(metric);
    }

    public void unregisterMetricFromSubscription(KafkaMetric metric) {
        this.delegate.unregisterMetricFromSubscription(metric);
    }

    public void seek(TopicPartition partition, long offset) {
        this.delegate.seek(partition, offset);
    }

    public void seek(TopicPartition partition, OffsetAndMetadata offsetAndMetadata) {
        this.delegate.seek(partition, offsetAndMetadata);
    }

    public void seekToBeginning(Collection<TopicPartition> partitions) {
        this.delegate.seekToBeginning(partitions);
    }

    public void seekToEnd(Collection<TopicPartition> partitions) {
        this.delegate.seekToEnd(partitions);
    }

    public long position(TopicPartition partition) {
        return this.delegate.position(partition);
    }

    public long position(TopicPartition partition, Duration timeout) {
        return this.delegate.position(partition, timeout);
    }

    public Map<TopicPartition, OffsetAndMetadata> committed(Set<TopicPartition> partitions) {
        return this.delegate.committed(partitions);
    }

    public Map<TopicPartition, OffsetAndMetadata> committed(Set<TopicPartition> partitions, Duration timeout) {
        return this.delegate.committed(partitions, timeout);
    }

    public Uuid clientInstanceId(Duration timeout) {
        return this.delegate.clientInstanceId(timeout);
    }

    public Map<MetricName, ? extends Metric> metrics() {
        return this.delegate.metrics();
    }

    public List<PartitionInfo> partitionsFor(String topic) {
        return this.delegate.partitionsFor(topic);
    }

    public List<PartitionInfo> partitionsFor(String topic, Duration timeout) {
        return this.delegate.partitionsFor(topic, timeout);
    }

    public Map<String, List<PartitionInfo>> listTopics() {
        return this.delegate.listTopics();
    }

    public Map<String, List<PartitionInfo>> listTopics(Duration timeout) {
        return this.delegate.listTopics(timeout);
    }

    public Set<TopicPartition> paused() {
        return this.delegate.paused();
    }

    public void pause(Collection<TopicPartition> partitions) {
        this.delegate.pause(partitions);
    }

    public void resume(Collection<TopicPartition> partitions) {
        this.delegate.resume(partitions);
    }

    public Map<TopicPartition, OffsetAndTimestamp> offsetsForTimes(Map<TopicPartition, Long> timestampsToSearch) {
        return this.delegate.offsetsForTimes(timestampsToSearch);
    }

    public Map<TopicPartition, OffsetAndTimestamp> offsetsForTimes(Map<TopicPartition, Long> timestampsToSearch, Duration timeout) {
        return this.delegate.offsetsForTimes(timestampsToSearch, timeout);
    }

    public Map<TopicPartition, Long> beginningOffsets(Collection<TopicPartition> partitions) {
        return this.delegate.beginningOffsets(partitions);
    }

    public Map<TopicPartition, Long> beginningOffsets(Collection<TopicPartition> partitions, Duration timeout) {
        return this.delegate.beginningOffsets(partitions, timeout);
    }

    public Map<TopicPartition, Long> endOffsets(Collection<TopicPartition> partitions) {
        return this.delegate.endOffsets(partitions);
    }

    public Map<TopicPartition, Long> endOffsets(Collection<TopicPartition> partitions, Duration timeout) {
        return this.delegate.endOffsets(partitions, timeout);
    }

    public OptionalLong currentLag(TopicPartition topicPartition) {
        return this.delegate.currentLag(topicPartition);
    }

    public ConsumerGroupMetadata groupMetadata() {
        return this.delegate.groupMetadata();
    }

    public void enforceRebalance() {
        this.delegate.enforceRebalance();
    }

    public void enforceRebalance(String reason) {
        this.delegate.enforceRebalance(reason);
    }

    public void close() {
        this.delegate.close();
    }

    @Deprecated
    public void close(Duration timeout) {
        this.delegate.close(timeout);
    }

    public void close(CloseOptions option) {
        this.delegate.close(option);
    }

    public void wakeup() {
        this.delegate.wakeup();
    }
}

