/*
 * Decompiled with CFR 0.152.
 */
package org.jsampler.view.classic;

import javax.swing.table.AbstractTableModel;
import org.jsampler.AudioDeviceModel;
import org.jsampler.CC;
import org.jsampler.event.AudioDeviceEvent;
import org.jsampler.event.AudioDeviceListener;
import org.jsampler.event.ListEvent;
import org.jsampler.event.ListListener;
import org.jsampler.view.classic.ClassicI18n;
import org.linuxsampler.lscp.AudioOutputDevice;

class AudioDevicesTableModel
extends AbstractTableModel {
    protected static final int ACTIVE_COLUMN_INDEX = 0;
    protected static final int DEVICE_ID_COLUMN_INDEX = 1;
    protected static final int CHANNELS_COLUMN_INDEX = 2;
    private final String[] columnNames = new String[]{"", ClassicI18n.i18n.getLabel("AudioDevicesTableModel.deviceID"), ClassicI18n.i18n.getLabel("AudioDevicesTableModel.channels")};
    private AudioDeviceModel[] deviceList;

    AudioDevicesTableModel() {
        CC.getSamplerModel().addAudioDeviceListListener(new Handler());
        this.deviceList = CC.getSamplerModel().getAudioDevices();
    }

    public AudioDeviceModel getAudioDeviceModel(int n) {
        return this.deviceList[n];
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public int getRowCount() {
        return this.deviceList.length;
    }

    @Override
    public String getColumnName(int n) {
        return this.columnNames[n];
    }

    @Override
    public Object getValueAt(int n, int n2) {
        switch (n2) {
            case 0: {
                return this.deviceList[n].getDeviceInfo().isActive();
            }
            case 1: {
                return this.deviceList[n].getDeviceId();
            }
            case 2: {
                return this.deviceList[n].getDeviceInfo().getChannelCount();
            }
        }
        return null;
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        switch (n2) {
            case 0: {
                boolean bl = (Boolean)object;
                this.deviceList[n].getDeviceInfo().setActive(bl);
                this.deviceList[n].setBackendActive(bl);
                break;
            }
            case 2: {
                int n3 = (Integer)object;
                this.getAudioDeviceModel(n).setBackendChannelCount(n3);
                break;
            }
            default: {
                return;
            }
        }
        this.fireTableCellUpdated(n, n2);
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        switch (n2) {
            case 0: {
                return true;
            }
            case 1: {
                return false;
            }
            case 2: {
                return true;
            }
        }
        return false;
    }

    public Class getColumnClass(int n) {
        return this.getValueAt(0, n).getClass();
    }

    static /* synthetic */ AudioDeviceModel[] access$102(AudioDevicesTableModel audioDevicesTableModel, AudioDeviceModel[] audioDeviceModelArray) {
        audioDevicesTableModel.deviceList = audioDeviceModelArray;
        return audioDeviceModelArray;
    }

    private class Handler
    implements AudioDeviceListener,
    ListListener<AudioDeviceModel> {
        private Handler() {
        }

        @Override
        public void entryAdded(ListEvent<AudioDeviceModel> listEvent) {
            for (AudioDeviceModel audioDeviceModel : AudioDevicesTableModel.this.deviceList) {
                audioDeviceModel.removeAudioDeviceListener(this);
            }
            AudioDevicesTableModel.access$102(AudioDevicesTableModel.this, CC.getSamplerModel().getAudioDevices());
            for (AudioDeviceModel audioDeviceModel : AudioDevicesTableModel.this.deviceList) {
                audioDeviceModel.addAudioDeviceListener(this);
            }
            AudioDevicesTableModel.this.fireTableDataChanged();
        }

        @Override
        public void entryRemoved(ListEvent<AudioDeviceModel> listEvent) {
            for (AudioDeviceModel audioDeviceModel : AudioDevicesTableModel.this.deviceList) {
                audioDeviceModel.removeAudioDeviceListener(this);
            }
            AudioDevicesTableModel.access$102(AudioDevicesTableModel.this, CC.getSamplerModel().getAudioDevices());
            for (AudioDeviceModel audioDeviceModel : AudioDevicesTableModel.this.deviceList) {
                audioDeviceModel.addAudioDeviceListener(this);
            }
            AudioDevicesTableModel.this.fireTableDataChanged();
        }

        @Override
        public void settingsChanged(AudioDeviceEvent audioDeviceEvent) {
            for (int i = 0; i < AudioDevicesTableModel.this.deviceList.length; ++i) {
                AudioOutputDevice audioOutputDevice = AudioDevicesTableModel.this.deviceList[i].getDeviceInfo();
                AudioOutputDevice audioOutputDevice2 = audioDeviceEvent.getAudioDeviceModel().getDeviceInfo();
                if (audioOutputDevice.getDeviceId() != audioOutputDevice2.getDeviceId()) continue;
                AudioDevicesTableModel.this.fireTableRowsUpdated(i, i);
            }
        }
    }
}

