/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.data;

public class FractionalSeconds {
    private final long _numerator;
    private final byte _divisorDigits;

    public FractionalSeconds(long l, long l2, int n) {
        int n2 = n;
        long l3 = l2;
        while (n2 > 13) {
            --n2;
            l3 /= 10L;
        }
        long l4 = FractionalSeconds.getMultiplier(n2);
        this._numerator = (l * l4 + l3) * 60L * 60L;
        this._divisorDigits = (byte)n2;
    }

    public FractionalSeconds(long l, long l2, long l3, int n) {
        long l4 = FractionalSeconds.getMultiplier(n);
        this._numerator = ((l * 60L + l2) * l4 + l3) * 60L;
        this._divisorDigits = (byte)n;
    }

    public FractionalSeconds(long l, long l2, long l3, long l4, int n) {
        long l5 = FractionalSeconds.getMultiplier(n);
        this._numerator = ((l * 60L + l2) * 60L + l3) * l5 + l4;
        this._divisorDigits = (byte)n;
    }

    public static FractionalSeconds fromDouble(double d, int n) {
        double d2 = Math.abs(d) * (double)FractionalSeconds.getMultiplier(n);
        long l = (long)(d2 * 60.0 * 60.0);
        return new FractionalSeconds(l, (byte)n);
    }

    private FractionalSeconds(long l, byte by) {
        this._numerator = l;
        this._divisorDigits = by;
    }

    public int getTotalSeconds() {
        long l = this._numerator / FractionalSeconds.getMultiplier(this._divisorDigits);
        return (int)l;
    }

    public int getWholeDegrees() {
        return this.getTotalSeconds() / 60 / 60;
    }

    public int getWholeMinutes() {
        return this.getTotalSeconds() / 60 % 60;
    }

    public int getWholeSeconds() {
        return this.getTotalSeconds() % 60;
    }

    public String getFractionDegrees() {
        return FractionalSeconds.getFractionString(this._numerator / 60L / 60L, this._divisorDigits);
    }

    public String getFractionDegrees(int n) {
        if (n != this._divisorDigits) {
            return this.roundToSeconds(n).divideBy(3600L).getFractionSeconds();
        }
        return this.getFractionDegrees();
    }

    public String getFractionMinutes() {
        return FractionalSeconds.getFractionString(this._numerator / 60L, this._divisorDigits);
    }

    public String getFractionMinutes(int n) {
        if (n != this._divisorDigits) {
            return this.roundToSeconds(n).divideBy(60L).getFractionSeconds();
        }
        return this.getFractionMinutes();
    }

    public String getFractionSeconds() {
        return FractionalSeconds.getFractionString(this._numerator, this._divisorDigits);
    }

    public String getFractionSeconds(int n) {
        return this.roundToSeconds(n).getFractionSeconds();
    }

    public double getDouble() {
        return (double)this._numerator * 1.0 / (double)FractionalSeconds.getMultiplier(this._divisorDigits) / 3600.0;
    }

    public FractionalSeconds roundToDegrees(int n) {
        return this.roundTo(3600L, n);
    }

    public FractionalSeconds roundToMinutes(int n) {
        return this.roundTo(60L, n);
    }

    public FractionalSeconds roundToSeconds(int n) {
        return this.roundTo(1L, n);
    }

    private FractionalSeconds roundTo(long l, int n) {
        if (n > this._divisorDigits) {
            long l2 = this._numerator * FractionalSeconds.getMultiplier(n - this._divisorDigits);
            return new FractionalSeconds(l2, (byte)n);
        }
        if (n < this._divisorDigits) {
            long l3 = FractionalSeconds.getMultiplier(this._divisorDigits - n);
            long l4 = this._numerator + l3 / 2L * l;
            return new FractionalSeconds(l4 / l3, (byte)n);
        }
        return this;
    }

    private FractionalSeconds divideBy(long l) {
        return new FractionalSeconds(this._numerator / l, this._divisorDigits);
    }

    private static String getFractionString(long l, byte by) {
        if (by == 0) {
            return "";
        }
        long l2 = FractionalSeconds.getMultiplier(by);
        long l3 = l % l2;
        return String.format("%0" + by + "d", l3);
    }

    private static long getMultiplier(int n) {
        int n2 = n;
        long l = 1L;
        while (n2 > 0) {
            --n2;
            l *= 10L;
        }
        return l;
    }

    public boolean isWithinOneEightyDegrees() {
        long l = 648000L * FractionalSeconds.getMultiplier(this._divisorDigits);
        return this._numerator <= l;
    }

    public FractionalSeconds wrapToThreeSixtyDegrees() {
        return new FractionalSeconds(this._numerator % this.getThreeSixtyDegrees(), this._divisorDigits);
    }

    private long getThreeSixtyDegrees() {
        return 1296000L * FractionalSeconds.getMultiplier(this._divisorDigits);
    }

    public FractionalSeconds invert() {
        return new FractionalSeconds(this.getThreeSixtyDegrees() - this._numerator, this._divisorDigits);
    }
}

