/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.view.swing.features.time.mindmapmode.nodelist;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.freeplane.features.icon.IconController;
import org.freeplane.features.icon.NamedIcon;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.styles.LogicalStyleController;

class IconsHolder
implements Comparable<IconsHolder> {
    private static final Comparator<NamedIcon> ICON_COMPARATOR = Comparator.comparing(NamedIcon::getOrder).thenComparing(NamedIcon::getName);
    private String iconNames = null;
    private List<NamedIcon> icons = null;
    private final NodeModel node;
    private boolean showsStyleIcons;

    public IconsHolder(NodeModel node, boolean showsStyleIcons) {
        this.node = node;
        this.showsStyleIcons = showsStyleIcons;
    }

    private void initialize() {
        List nodeIcons;
        if (this.icons != null) {
            return;
        }
        Collection collection = nodeIcons = this.showsStyleIcons ? IconController.getController().getIcons(this.node, LogicalStyleController.StyleOption.FOR_UNSELECTED_NODE) : this.node.getIcons();
        if (!nodeIcons.isEmpty()) {
            this.icons = new ArrayList<NamedIcon>(nodeIcons);
            ArrayList<NamedIcon> toSort = new ArrayList<NamedIcon>(this.icons);
            Collections.sort(toSort, ICON_COMPARATOR);
            StringBuilder builder = new StringBuilder();
            for (NamedIcon icon : toSort) {
                builder.append(icon.getName()).append(" ");
            }
            this.iconNames = builder.toString();
        } else {
            this.icons = Collections.emptyList();
            this.iconNames = "";
        }
    }

    @Override
    public int compareTo(IconsHolder compareToObject) {
        return this.getIconNames().compareTo(compareToObject.getIconNames());
    }

    public List<NamedIcon> getIcons() {
        this.initialize();
        return this.icons;
    }

    public String toString() {
        return this.getIconNames();
    }

    private String getIconNames() {
        this.initialize();
        return this.iconNames;
    }
}

