/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.view.swing.features.nodehistory;

import java.lang.ref.WeakReference;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.ModeController;
import org.freeplane.view.swing.map.MapView;
import org.freeplane.view.swing.map.MapViewController;
import org.freeplane.view.swing.map.NodeView;

class NodeHolder {
    private final WeakReference<MapView> mMapView;
    private final String mNodeId;
    private boolean reachedByLink;

    public NodeHolder(NodeView pNode) {
        this.mNodeId = pNode.getNode().createID();
        MapView mapView = pNode.getMap();
        this.mMapView = new WeakReference<MapView>(mapView);
        this.reachedByLink = false;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof NodeHolder)) {
            return false;
        }
        NodeHolder nodeHolder = (NodeHolder)obj;
        return nodeHolder.mMapView.get() == this.mMapView.get() && nodeHolder.mNodeId.equals(this.mNodeId);
    }

    public MapView getHoldMapView() {
        return (MapView)this.mMapView.get();
    }

    MapView getMapView() {
        MapView mapView = (MapView)this.mMapView.get();
        Controller controller = mapView.getModeController().getController();
        MapViewController mapViewManager = (MapViewController)controller.getMapViewManager();
        for (MapView m : mapViewManager.getMapViews()) {
            if (m != mapView) continue;
            return mapView;
        }
        return null;
    }

    ModeController getModeController() {
        ModeController modeController = null;
        MapView mapView = this.getMapView();
        if (mapView != null) {
            modeController = mapView.getModeController();
        }
        return modeController;
    }

    public NodeModel getNode() {
        MapView modeController = (MapView)this.mMapView.get();
        if (modeController != null) {
            return modeController.getMap().getNodeForID(this.mNodeId);
        }
        return null;
    }

    public int hashCode() {
        MapView mapView = (MapView)this.mMapView.get();
        return mapView != null ? mapView.hashCode() * 37 : 0 + this.mNodeId.hashCode();
    }

    boolean isIdentical(NodeView pNode) {
        if (pNode == null || pNode.getNode() == null) {
            return false;
        }
        String id = pNode.getNode().createID();
        MapView mapView = pNode.getMap();
        return mapView == this.mMapView.get() && id.equals(this.mNodeId);
    }

    protected boolean isReachedByLink() {
        return this.reachedByLink;
    }

    protected void setReachedByLink(boolean reachedByLink) {
        this.reachedByLink = reachedByLink;
    }
}

