/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.codeexplorer.graph;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import org.freeplane.plugin.codeexplorer.graph.CoupledWeightedEdge;
import org.jgrapht.Graph;
import org.jgrapht.alg.connectivity.ConnectivityInspector;
import org.jgrapht.alg.cycle.CycleDetector;
import org.jgrapht.alg.cycle.JohnsonSimpleCycles;
import org.jgrapht.graph.AsSubgraph;
import org.jgrapht.graph.SimpleDirectedWeightedGraph;
import org.jgrapht.traverse.TopologicalOrderIterator;

public class GraphNodeSort<V> {
    private final Graph<V, CoupledWeightedEdge> graph = new SimpleDirectedWeightedGraph(CoupledWeightedEdge.class);

    public void addEdge(V source, V target, double weight) {
        this.graph.addVertex(source);
        this.graph.addVertex(target);
        CoupledWeightedEdge forwardEdge = (CoupledWeightedEdge)((Object)this.graph.getEdge(source, target));
        CoupledWeightedEdge reverseEdge = (CoupledWeightedEdge)((Object)this.graph.getEdge(target, source));
        if (reverseEdge != null) {
            double reverseWeight = this.graph.getEdgeWeight((Object)reverseEdge);
            if (weight > reverseWeight) {
                this.graph.removeEdge((Object)reverseEdge);
                CoupledWeightedEdge newEdge = (CoupledWeightedEdge)((Object)this.graph.addEdge(source, target));
                newEdge.addCoupling(weight + reverseWeight);
                this.graph.setEdgeWeight((Object)newEdge, weight - reverseWeight);
            } else {
                this.graph.setEdgeWeight((Object)reverseEdge, reverseWeight - weight);
                reverseEdge.addCoupling(weight);
            }
        } else if (forwardEdge != null) {
            double currentWeight = this.graph.getEdgeWeight((Object)forwardEdge);
            this.graph.setEdgeWeight((Object)forwardEdge, currentWeight + weight);
            forwardEdge.addCoupling(weight);
        } else {
            CoupledWeightedEdge newEdge = (CoupledWeightedEdge)((Object)this.graph.addEdge(source, target));
            this.graph.setEdgeWeight((Object)newEdge, weight);
            newEdge.addCoupling(weight);
        }
    }

    public void addNode(V node) {
        this.graph.addVertex(node);
    }

    public List<List<V>> sortNodes(Comparator<V> nodeComparator, Comparator<Set<V>> secondComparator) {
        ConnectivityInspector connectivityInspector = new ConnectivityInspector(this.graph);
        List connectedSets = connectivityInspector.connectedSets();
        Comparator comparator = (set1, set2) -> Integer.compare(set2.size(), set1.size());
        connectedSets.sort(comparator.thenComparing(secondComparator));
        ArrayList<List<V>> finalOrdering = new ArrayList<List<V>>();
        for (Set connectedSet : connectedSets) {
            AsSubgraph connectedSubgraph = new AsSubgraph(this.graph, connectedSet);
            CycleDetector cycleDetector = new CycleDetector((Graph)connectedSubgraph);
            if (cycleDetector.detectCycles()) {
                boolean cyclesLeft = true;
                do {
                    List firstCycle;
                    CoupledWeightedEdge minWeightEdge;
                    JohnsonSimpleCycles cycleFinder = new JohnsonSimpleCycles((Graph)connectedSubgraph);
                    ArrayList<List> cycles = new ArrayList<List>();
                    try {
                        cycleFinder.findSimpleCycles(c -> {
                            cycles.add((List)c);
                            if (cycles.size() >= 100) {
                                throw CycleSearchStopException.INSTANCE;
                            }
                        });
                        cyclesLeft = false;
                    }
                    catch (CycleSearchStopException cycleSearchStopException) {
                        // empty catch block
                    }
                    while (!cycles.isEmpty() && (minWeightEdge = this.findMinWeightEdge((Graph<V, CoupledWeightedEdge>)connectedSubgraph, firstCycle = (List)cycles.get(0))) != null) {
                        Object source = connectedSubgraph.getEdgeSource((Object)minWeightEdge);
                        Object target = connectedSubgraph.getEdgeTarget((Object)minWeightEdge);
                        connectedSubgraph.removeEdge((Object)minWeightEdge);
                        cycles.remove(0);
                        cycles.removeIf(cycle -> this.cycleContainsEdge((V)source, (V)target, (List<V>)cycle));
                    }
                } while (cyclesLeft);
            }
            TopologicalOrderIterator topologicalOrderIterator = new TopologicalOrderIterator((Graph)connectedSubgraph, Comparator.comparingDouble(arg_0 -> this.lambda$sortNodes$3((Graph)connectedSubgraph, arg_0)).reversed().thenComparing(Comparator.comparingDouble(arg_0 -> this.lambda$sortNodes$4((Graph)connectedSubgraph, arg_0))).thenComparing(nodeComparator));
            ArrayList<Object> subgroupOrdering = new ArrayList<Object>();
            finalOrdering.add(subgroupOrdering);
            while (topologicalOrderIterator.hasNext()) {
                Object node = topologicalOrderIterator.next();
                subgroupOrdering.add(node);
            }
        }
        return finalOrdering;
    }

    double calculateConnectionStrength(Set<CoupledWeightedEdge> edges) {
        double strength = edges.stream().mapToDouble(CoupledWeightedEdge::getCoupling).sum();
        return strength;
    }

    private boolean cycleContainsEdge(V source, V target, List<V> cycle) {
        int sourceIndex = cycle.indexOf(source);
        if (sourceIndex == -1) {
            return false;
        }
        int targetIndex = (sourceIndex + 1) % cycle.size();
        return target.equals(cycle.get(targetIndex));
    }

    private CoupledWeightedEdge findMinWeightEdge(Graph<V, CoupledWeightedEdge> graph, List<V> cycle) {
        double minWeight = Double.MAX_VALUE;
        CoupledWeightedEdge minWeightEdge = null;
        for (int i = 0; i < cycle.size(); ++i) {
            V target;
            V source = cycle.get(i);
            CoupledWeightedEdge edge = (CoupledWeightedEdge)((Object)graph.getEdge(source, target = cycle.get((i + 1) % cycle.size())));
            if (edge == null || !(graph.getEdgeWeight((Object)edge) < minWeight)) continue;
            minWeight = graph.getEdgeWeight((Object)edge);
            minWeightEdge = edge;
        }
        return minWeightEdge;
    }

    private /* synthetic */ double lambda$sortNodes$4(Graph connectedSubgraph, Object v) {
        return this.calculateConnectionStrength(connectedSubgraph.outgoingEdgesOf(v));
    }

    private /* synthetic */ double lambda$sortNodes$3(Graph connectedSubgraph, Object v) {
        return this.calculateConnectionStrength(connectedSubgraph.incomingEdgesOf(v));
    }

    private static class CycleSearchStopException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;
        static final CycleSearchStopException INSTANCE = new CycleSearchStopException();

        private CycleSearchStopException() {
        }
    }
}

