/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.commandsearch;

import java.util.LinkedList;
import java.util.List;
import org.freeplane.core.ui.AFreeplaneAction;
import org.freeplane.core.ui.menubuilders.FreeplaneResourceAccessor;
import org.freeplane.core.ui.menubuilders.generic.Entry;
import org.freeplane.core.ui.menubuilders.generic.EntryAccessor;
import org.freeplane.core.util.HtmlUtils;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.commandsearch.MenuItem;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.ModeController;

public class MenuStructureIndexer {
    private EntryAccessor entryAccessor;
    private List<MenuItem> menuItems;

    public MenuStructureIndexer() {
        this.loadMenuItems();
    }

    public List<MenuItem> getMenuItems() {
        return this.menuItems;
    }

    private void loadMenuItems() {
        this.entryAccessor = new EntryAccessor(new FreeplaneResourceAccessor());
        this.menuItems = new LinkedList<MenuItem>();
        ModeController modeController = Controller.getCurrentModeController();
        Entry root = modeController.getUserInputListenerFactory().getGenericMenuStructure().getRoot();
        this.loadMenuItems("Menu", root.getChild("main_menu").children(), true, 0);
    }

    private String translateMenuItemComponent(Entry entry) {
        String menuItemLabel = this.entryAccessor.getText(entry);
        if (menuItemLabel != null) {
            menuItemLabel = TextUtils.removeMnemonic(menuItemLabel);
            menuItemLabel = HtmlUtils.htmlToPlain(menuItemLabel);
        }
        return menuItemLabel;
    }

    private void loadMenuItems(String prefix, List<Entry> menuEntries, boolean toplevel, int depth) {
        for (Entry menuEntry : menuEntries) {
            this.processMenuEntry(menuEntry, prefix, toplevel, depth);
        }
    }

    private void processMenuEntry(Entry menuEntry, String prefix, boolean toplevel, int depth) {
        if (menuEntry.getName().equals("menu_iconByCategory")) {
            return;
        }
        if (menuEntry.builders().contains("separator")) {
            return;
        }
        Object usedBy = menuEntry.getAttribute("usedBy");
        if (usedBy != null && !usedBy.equals("EDITOR")) {
            return;
        }
        String path = this.computePath(menuEntry, prefix, toplevel);
        if (path == null) {
            return;
        }
        if (menuEntry.isLeaf()) {
            this.recordLeafMenuEntry(menuEntry, path);
        } else {
            this.loadMenuItems(path, menuEntry.children(), toplevel && path == prefix, depth + 1);
        }
    }

    private String computePath(Entry menuEntry, String prefix, boolean toplevel) {
        String component;
        Object path = this.contributesToPath(menuEntry) ? ((component = this.translateMenuItemComponent(menuEntry)) == null ? null : (toplevel ? component : prefix + "->" + component)) : prefix;
        return path;
    }

    public boolean contributesToPath(Entry menuEntry) {
        return !menuEntry.getName().isEmpty();
    }

    private void recordLeafMenuEntry(Entry menuEntry, String path) {
        AFreeplaneAction action = menuEntry.getAction();
        if (action != null) {
            this.menuItems.add(new MenuItem(action, path));
        }
    }

    private static /* synthetic */ String lambda$new$0(MenuItem x) {
        return x.getDisplayedText();
    }
}

