/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls.resultset;

import java.util.Objects;
import org.eclipse.core.runtime.IConfigurationElement;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.impl.AbstractDescriptor;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetErrorAction;
import org.jkiss.utils.CommonUtils;

public final class ResultSetErrorActionDescriptor
extends AbstractDescriptor {
    public static final String EXTENSION_ID = "org.jkiss.dbeaver.resultset.error";
    private final String label;
    private final String description;
    private final DBPImage icon;
    private final AbstractDescriptor.ObjectType action;
    private final int order;

    ResultSetErrorActionDescriptor(@NotNull IConfigurationElement config) {
        super(config);
        this.label = config.getAttribute("label");
        this.description = config.getAttribute("description");
        this.icon = Objects.requireNonNull(this.iconToImage(config.getAttribute("icon")));
        this.action = new AbstractDescriptor.ObjectType((AbstractDescriptor)this, config.getAttribute("class"));
        this.order = CommonUtils.toInt((Object)config.getAttribute("order"));
    }

    @NotNull
    public String getLabel() {
        return this.label;
    }

    @NotNull
    public String getDescription() {
        return this.description;
    }

    @NotNull
    public DBPImage getIcon() {
        return this.icon;
    }

    public int getOrder() {
        return this.order;
    }

    @NotNull
    public IResultSetErrorAction createInstance() throws DBException {
        return (IResultSetErrorAction)this.action.createInstance(IResultSetErrorAction.class);
    }
}

