# Lore - Setting

#### Seriously, spoiler alert.
CDDA tells stories using unreliable narrators and a found footage style.  Knowing too much of the lore can ruin your experience.  Don't read this unless you plan to contribute, please!

## Table of Contents
* [Style and Structure](#style-and-structure)
* [Background Information](#background-information)

### Supporting Documents
* [Story Overview](./lore.md)
* [Technology](./technology.md)
* [Background/Timeline](./lore-background.md)
* [Factions](./lore-factions.md)

Cataclysm: Dark Days Ahead is a turn-based survival game set in a post-apocalyptic world.  Struggle to survive in a harsh, persistent, procedurally generated world.  Scavenge the remnants of a dead civilization for food, equipment, or, if you are lucky, a vehicle with a full tank of gas to get you the hell out of Dodge.  Fight to defeat or escape from a wide variety of powerful monstrosities, from zombies to giant insects to killer robots and things far stranger and deadlier, and against the others like yourself, that want what you have…


# Story

The world ended.  You don't know what caused it, but suddenly everywhere was being overrun with monsters of all kinds.  Now only a tiny fraction of humanity is alive, the dead fill the cities, and worse things are stirring in the wilderness.

Civilization is gone, but maybe you can survive.  Maybe you can find others.

For more details on individual features of the story, see:
* [Background](./lore-background.md) - provides more information on the timeline of events leading up to the Cataclysm
* [Factions](./lore-factions.md) - in-depth discussion of in-game factions and how they should affect gameplay

## Style and Structure

Storytelling in CDDA should be fragmented and emergent, to simulate the idea that nobody really knows what happened.  What people know is what they experienced, which was random and chaotic.  There were no news broadcasts informing survivors that a hostile interdimensional force had decided to conquer Earth; one day, the dead started walking, and that was sure weird; while we were all getting used to that, the world broke open and creatures from nightmares moved among us eating people and smashing stuff.  It wasn't much fun, and nobody's quite sure how it happened.

Those with the best knowledge of what happened are dead.  Some of them left notes.  Those notes should be hard to get.

Information about what really went down might be made contradictory, because it's unlikely anyone has a full and clear picture of it.  Much of what is regurgitated as fact is supposition, theory, or sheer crazy ravings.


Also, everyone has PTSD.

## Background Information

**Spoiler alert**.  This section will contain many lore spoilers for elements that are meant to be mysterious or hard to learn in game.

**Summary**:
There are other worlds than this.  Some time back in the nineties, a UFO crashed in the continental US and was captured by the military.  It turned out to be made by humans, from another dimension.  Reverse engineering the technology, the US was able to develop the ability to open portals to other dimensions, which in turn unlocked some interesting new technological innovations.  Years later, as portal research worked towards a practical tool for exploration and travel, the US realized that China was developing a similar technology, and a secret space-race like technological push began.  The push to innovate faster, as well as some other influencing factors, led researchers in the newly formed "XEDRA" research division to explore too far, and too fast.  They brought something back, a barely detectable agent called "XE-037", capable of causing bizarre mutations in subjects and even bringing them back from the dead.  Unbeknownst to XEDRA, this sample was part of a larger hostile entity.  XE-037 escaped containment, and by the time XEDRA realized it, it had infiltrated the groundwater.  It laid in wait for some time, spreading across the planet, until in a blast of activity it activated.  This caused an enormous zombie outbreak, as well as widespread mutations among animal life.  As this spiraled out of control, Earth became the target of a multidimensional portal attack through which the XE-037 master entity took over our world.  Simultaneously, forces from other dimensions entered opportunistically as our dimensional fabric was destabilized.  This was the Cataclysm.

Things are a bit more stable now, but nobody is left alive to appreciate that.

For a detailed explanation of how the Cataclysm came to be, see [the Background document](./lore-background.md).

## XEDRA

XEDRA (Xenophysical Energy Defense Research Agency), a semi-independent branch of DARPA, is the dominant antagonist of the background of the game and the ultimate instigator of the Cataclysm.  They were a top-secret group tasked initially with researching the exploitation of portal technology.  They very quickly branched into a wide number of things that use portals incidentally, from artificial intelligence to mutation and zombification.  They were given an enormous budget to start, which was rapidly expanded through black market sales of rare metals obtained from other dimensions.

**Public Knowledge of XEDRA**: Any organization the size of XEDRA cannot really hide from the public eye.  Their influence on the public was generally hidden through shell companies masquerading as public research groups, shipping companies, and the like.  Brand names like Uncanny and Trans-Coast Logistics are associated with XEDRA.  This obfuscation, as well as the unbelievable nature of the technology they were working with, let them keep what they were *actually* doing hidden from the public.  However, many civilians were aware that *something was up*.  Of these, a fair number correctly guessed that some kind of Manhattan Project secret research was taking place: it was not that hard to track the construction of underground labs and sudden global demand to hire physicists, for example.

That said, XEDRA was not around long enough for word to leak fully.  The world ended while they were still in the golden age of maintaining silence: anyone who knew or figured out that they were working on *portals to other worlds* was easily discredited and ignored as a loon.  Although the tech has existed nascently for decades, a generation-long stall out made it easy again to pass off old hearsay about it as false.  Even the name "XEDRA" was not known to the general public.  It is likely that within a few years, enough would have leaked that the top would have blown off, but not enough time passed.

# Basic Setting Lore

## General Changes to the World

### Pre-Cataclysm Tech Changes

As a general rule, the CDDA world should feel like ours.  We have worked hard to remove pre-Cataclysm bionics and robots that would have had to mean the world was too dramatically different.  The only exception to this is where technology interacts with the benefits of gradual development of portal tech.  For example. radioactive isotopes are far more easily available and have been for decades, with XEDRA taking them from other dimensions and reselling them to fund their projects.  However, any such change that would result in the pre-Cataclysm Earth being unrecognizably different from our own would not mean that we need to add that new tech to the game.  Rather, it means we need to rewrite the lore to keep that change from making it in.  We want it to feel like these changes occured in a recognizable version of our world.

See [the Technology document](./technology.md) for deeper details.

### Effects of Blob Infection

Every living thing on earth is infected by the blob.  In humans, passive blob infection has a few effects.  This has some serious ramifications for gameplay and storytelling.

**Increased Healing**
Blob infection means everyone heals more completely from basic soft tissue injuries.  It doesn't affect immune systems and doesn't have as powerful an effect on broken bones.  It also doesn't allow regeneration… Not unless you die, first.  As the game's code improves, the effect of increased healing is lessened, but in general we're never going to model stuff like permanent nerve damage and unrecoverable scarring, and this is the in-game reason.

In-game this is an explanation for rapid player healing; note that this means that rapid healing is diegetic, ie.  characters in the game world are conscious of the fact that they heal much faster than before, and may comment on it.

**Mutation**
The Blob seems to somehow store a base state for the infected creature (purifier triggers it to revert to this state and can be thought of as a 'basic human' mutagen).  That base state can be copied and imposed on the blob by crafting mutagen that has been exposed to a target organism.  The blob also responds to radiation and certain other toxic challenges by sometimes causing random mutations.

Mutagens work in part by copying a particular creature's phenotype onto the blob, then merging that phenotype with the person consuming the mutagen.  Mutagens do *not* work by modifying the underlying genetics of the organism: they are epigenetic.

**Cognition**
The blob has a potent, albeit often subtle, effect on human cognition.

In about one quarter of the population, changes are basically unnoticeable.

For about half the population, the blob causes an increase in risk-taking behaviour, ranging from mild unsafe practices all the way to people attacking hordes of zombies with a stick.  This effect may be permanent or may be temporary, and resolves at varying speed by person.  Some may be strongly enough affected to be almost indistinguishable from ferals, but not aligned with zombies.

The remaining quarter see a heavy increase in aggressive, violent behaviour, often completely out of character.  The worst of these, about 1/20 of the population, become "ferals", a form of living zombie.  These ferals are not seen as hostile to zombies, and mutate naturally with time just as zombies do.  Ferals still maintain a degree of human intelligence, depending on how severely affected they are… Some can remember tool use, for example.  Ferals led to a great deal of confusion over whether the reports of the dead rising were true, as feral behavior is very similar to that of zombies.  From an out-of-universe perspective, ferals are similar to "rage virus" zombies as seen in 28 days later, but adapted to our lore, and as such are considered zombies internally.

"Blob psychosis" is an *out-of-game* term for the increased violence experienced by this quarter of the population.  Nobody in game calls it that.  Strictly speaking it's not a psychosis, but that term seems to have stuck in our game discussions.

#### Cognition after the Cataclysm
Over time, most affected people acclimate and return to normal.  Some remain somewhat less risk-averse than before (eg players).  Those that tended towards high violence also drift back towards normal cognition slowly, although their actions and the memory of them likely leave them changed permanently.

True ferals are permanently altered.  Like all living humans, their numbers were severely thinned during the Cataclysm; the fact that they weren't targeted by zombies is balanced by the fact that they didn't make much effort to avoid confrontation with police and military forces.

**Ferals Now**
The majority of feral humans are difficult to distinguish from zombies.  They can grasp and use simple tools like clubs and melee weapons, and will avoid dangerous obstacles, open doors, and other very simple actions largely governed by motor memory, but that's about it.  These comprise around 1% of the zombie faction.

About a third of ferals remember more complex things.  These ferals might use complex tools properly, and would understand for example how to use a gun, activate a Hack, or put on a kevlar vest.  They lack forward thinking and executive reasoning, and would be unlikely to engage in complex tactics (they might know how to arm c4, but would not think to put it onto your base wall to blast a way in) but can nevertheless be extremely dangerous.  These comprise around 0.3% of the zombie faction.

A very dangerous tenth or so of ferals maintain most of their human intelligence.  They can use any tools they would have in life, can plan tactics, and can assess your weaknesses and use salvaged materiel to exploit them… Basically anything an NPC should be able to do.  Likely they can talk as well, although probably it would be difficult for them to be too deceptive.  These comprise about 1/1000 of the zombie faction.  Over time these will probably evolve into a variant living form of zombie Masters and become another nemesis level villain for the late game.  Feral Masters would be exceedingly rare, probably 1/10,000 or less, given the low odds of an intelligent feral living long enough to evolve.

### Human Factions and Organizations

This section should be used to discuss both existing and deceased major factions, but it is primarily for factions forming post-cataclysm.

See [the Faction Lore document](./lore-factions.md) for deeper details and implementation ideas.

#### General Philosophy
When creating a faction in Cataclysm, consider the following:

*    All factions were part of the same overall culture only a few months ago.  We're not at a Mad Max: Fury Road stage yet, and if anyone's acting that way they're probably basing it on a major motion picture.
*    No faction should be "good".  Everyone is in this for themselves, everyone is scared, everyone's first goal is not being eaten by zombies and their second goal is making it to the next winter.  There is no time for altruism.
*    No faction should be "evil".  No one is the villain of their own story.  Raiders may not be nice, but they believe they're doing what they need to to survive in this harsh world.
*    Factions should avoid having a single "schtick".  The Free Merchants are merchants who believe in a free market, but that's by far not everything they stand for.  Think about what the average member of your faction does in their day to day life, and remember they can't spend all their time just thinking about how much they like the free market, or cannibalism, or whatever your cool initial idea was.  Expand.

#### Major Factions

See [the Faction Lore document](./lore-factions.md) for more details.

- **Free Merchants**: Based in the refugee center, a mercantile faction that is often the first group the player meets.
- **Hell's Raiders**: An aggressively Nietzschean band of would-be transhumanists that believe the strong should rule.  Connected to many, but of course not all, bandits.
- **Old Guard**: The remnants of the United States Government, attempting to reclaim ground on the mainland from their stronghold of the Second Fleet.
- **Tacoma Commune**: A Free Merchant outpost for stable food production.  
- **Hub 01**: The last stable remnant of XEDRA, a group of AI researchers led by a near-true-AI called Melchior.
- **Isherwood Farm**: 

#### Micro Factions

- **Free Merchant Beggars**: Five beggars living in or near the Free Merchants evac center, but not considered part of the Free Merchants.

### Extradimensional and Alien Forces

There are several key extradimensional factions planned or implemented in Cataclysm.

- **The Blob**, known to XEDRA scientists as XE037, is the entity responsible for the actual Cataclysm itself, and for zombification and mutation.  It was discovered before the Cataclysm and was the key focus of XEDRA research leading up to the zombie outbreak.  Note that "the blob" is not an in-universe term for this entity, but it's easier to type than XE-037 and so is likely to stick in the design notes.
- **Triffids** are a species of intelligent plants that crossed into our world during the initial portal storms of the Cataclysm.  They perceive humans as meat, and little else, but are probably the most human-like of all the extradimensional beings.
- **Mycus** is a dispersed intelligence whose primary interest is growing and encompassing all things.  It is strongly opposed to the Blob, but shares a lot of similarities with it.
- **The Netherum** is a disorganized collection of demonic creatures.  They do not appear to have a central underlying motivation, but are generally hostile or at least not particularly friendly.
- **The Exodii** are non-hostile transhuman refugees from dimensions that have suffered the same apocalypse as this one.  They travel from world to world, surfing the tide of the apocalypse using portal technologies.  They are willing to trade knowledge, materials, and bionics with you, but they may not be as benign as they seem.
- **The Yrax** are a group of non-friendly, non-hostile hyperadvanced robots, here to study the blob.

Also of note, the **Mi-Go** are a non-extradimensional alien race from our own dimension and others, here since prior to the Cataclysm, now swooping in to gather some slaves and some research information.

See [the Faction Lore document](./lore-factions.md) for deeper details and implementation ideas.

See [the Background document](./lore-background.md) for full details on how these aliens got here.
