<?php
/**
 * $Horde: horde/portal.php,v 1.15 2003/05/24 20:20:38 chuck Exp $
 *
 * Copyright 2003 Mike Cochrane <mike@graftonhall.co.nz>
 *
 * See the enclosed file COPYING for license information (LGPL). If you
 * did not receive this file, see http://www.fsf.org/copyleft/lgpl.html.
 */

@define('HORDE_BASE', dirname(__FILE__));
require_once HORDE_BASE . '/lib/base.php';
require_once HORDE_BASE . '/lib/Block.php';
require_once HORDE_BASE . '/lib/Identity.php';
require_once HORDE_BASE . '/lib/Menu.php';
require_once HORDE_BASE . '/lib/Help.php';

if (!Auth::isAuthenticated()) {
    Horde::authenticationFailureRedirect();
}

// Get full name for title
$identity = &new Identity();
$fullname = $identity->getValue('fullname');
if (empty($fullname)) {
    $fullname = Auth::getAuth();
}

// Get refresh interval.
if ($prefs->getValue('summary_refresh_time')) {
    $refresh_time = $prefs->getValue('summary_refresh_time');
    $refresh_url = Horde::applicationUrl('portal.php');
}

// Load layout from preferences.
$layout_pref = @unserialize($prefs->getValue('portal_layout'));

// Store the apps we need to load stylesheets for.
$cssApps = array();
foreach ($layout_pref as $row) {
    foreach ($row as $item) {
        if (is_array($item) && !in_array($item['app'], $cssApps)) {
            $cssApps[] = $item['app'];
        }
    }
}

$title = _("My Summary");
$cssApp = 'app[]=' . implode(ini_get('arg_separator.output') . 'app[]=', $cssApps);
$js_onLoad = null;
require HORDE_TEMPLATES . '/common-header.inc';
require HORDE_TEMPLATES . '/portal/menu.inc';
Help::javascript();
$notification->notify();
require HORDE_TEMPLATES . '/portal/portal_head.inc';

$covered = array();
if (empty($layout_pref)) {
    require HORDE_TEMPLATES . '/portal/empty.inc';
}

foreach ($layout_pref as $row_num => $row) {
    $width = floor(100 / count($row));
    echo "<tr>\n";
    foreach ($row as $col_num => $item) {
        if (isset($covered[$row_num]) && isset($covered[$row_num][$col_num])) {
            continue;
        }
        if (is_array($item)) {
            $block = $registry->callByPackage($item['app'], 'block', $item['params']);
            if (is_a($block, 'Horde_Block')) {
                if (isset($item['height'])) {
                    $block->setHeight($item['height']);
                }
                if (isset($item['width'])) {
                    $block->setWidth($item['width']);
                }
                $rowspan = $block->getHeight();
                $colspan = $block->getWidth();
                $header  = $block->getTitle();
                $content = $block->getContent();
                require HORDE_TEMPLATES . '/portal/block.inc';
                for ($i = 0; $i < $block->getHeight(); $i++) {
                    if (!isset($covered[$row_num + $i])) {
                        $covered[$row_num + $i] = array();
                    }
                    for ($j = 0; $j < $block->getWidth(); $j++) {
                        $covered[$row_num + $i][$col_num + $j] = true;
                    }
                }
            } else {
                require HORDE_TEMPLATES . '/portal/empty.inc';
            }
        } else {
            require HORDE_TEMPLATES . '/portal/empty.inc';
        }
    }
    echo "</tr>\n";
}

require HORDE_TEMPLATES . '/portal/portal_foot.inc';
require HORDE_TEMPLATES . '/common-footer.inc';
