<?php
/**
 * $Horde: nag/view.php,v 1.29 2003/06/16 23:21:23 chuck Exp $
 *
 * Copyright 2001-2003 Jon Parise <jon@horde.org>
 *
 * See the enclosed file COPYING for license information (GPL).  If you
 * did not receive this file, see http://www.fsf.org/copyleft/gpl.html.
 */

define('NAG_BASE', dirname(__FILE__));
require_once NAG_BASE . '/lib/base.php';

/* If we aren't provided with a task, redirect to the task list. */
$task_id = Horde::getFormData('task');
$tasklist_id = Horde::getFormData('tasklist');
if (!isset($task_id)) {
    header('Location: ' . Horde::applicationUrl('list.php', true));
    exit;
}
$share = $GLOBALS['nag_shares']->getShare($tasklist_id);
if (is_a($share, 'PEAR_Error') || !$share->hasPermission(Auth::getAuth(), _PERMS_READ)) {
    $notification->push(_("You do not have permission to view this tasklist."), 'horde.error');
    header('Location: ' . Horde::applicationUrl('list.php', true));
    exit;
}

/* Get the current task list. */
$task = Nag::getTask($tasklist_id, $task_id);

/* Set the page title to the current task's name, if it exists. */
$title = (!$task) ? $task['name'] : _("Task Details");

$js_onLoad = null;
require NAG_TEMPLATES . '/common-header.inc';

$print_view = (Horde::getFormData('print') == 'true');
if ($print_view) {
    require_once $registry->getParam('templates', 'horde') . '/javascript/print.js';
} else {
    $print_link = Horde::addParameter('view.php', 'task=' . $task_id);
    $print_link = Horde::addParameter($print_link, 'tasklist=' . $tasklist_id);
    $print_link = Horde::addParameter($print_link, 'print=true');
    $print_link = Horde::url($print_link);
    if ($browser->hasFeature('javascript')) {
        require_once $registry->getParam('templates', 'horde') . '/javascript/open_print_win.js';
    }

    Nag::menu();
}

/* If the requested task doesn't exist, display an error message. */
if (!$task) {
    require NAG_TEMPLATES . '/view/no-task.inc';
} else {
    /* Set up alarm units and value. */
    $task_alarm = $task['alarm'];
    if (!$task['due']) {
        $task_alarm = 0;
    }
    $alarm_text = Nag::formatAlarm($task_alarm);
    require NAG_TEMPLATES . '/view/headers.inc';
    if (!$print_view) {
        require NAG_TEMPLATES . '/view/navbar.inc';
    }
    require NAG_TEMPLATES . '/view/description.inc';
    if (!$print_view) {
        if (substr_count($task['desc'], "\n") > 10) {
            require NAG_TEMPLATES . '/view/navbar.inc';
        }
        require_once HORDE_BASE . '/lib/Links.php';
        $links = &Horde_Links::singleton($registry->getApp());
        if ($links->listLinkTypes()) {
            $links->viewLinks(array(
                'tasklist' => $tasklist_id,
                'task' => $task_id,
                ));
        }
    }
}

require NAG_TEMPLATES . '/common-footer.inc';
