<?php
/**
 * $Horde: kronolith/workweek.php,v 1.20 2003/05/22 21:48:30 chuck Exp $
 *
 * Copyright 1999, 2000 Charles J. Hagenbuch <chuck@horde.org>
 *
 * See the enclosed file COPYING for license information (GPL).  If you
 * did not receive this file, see http://www.fsf.org/copyleft/gpl.html.
 */

@define('KRONOLITH_BASE', dirname(__FILE__));
require_once KRONOLITH_BASE . '/lib/base.php';
require_once KRONOLITH_BASE . '/lib/WeekView.php';

$week = Horde::getFormData('week');
$year = Horde::getFormData('year');
if ($timestamp = Horde::getFormData('timestamp')) {
    $year = date('Y', $timestamp);
    $week = Kronolith::weekOfYear(date('d', $timestamp), date('m', $timestamp), $year);
}

$weekOb = new Kronolith_WeekView($week, $year, 0, 4);
$title = sprintf(_("Week %d"), $weekOb->week);
$js_onLoad = null;

require KRONOLITH_TEMPLATES . '/common-header.inc';

$print_view = (Horde::getFormData('print') == 'true');
if ($print_view) {
    require_once $registry->getParam('templates', 'horde') . '/javascript/print.js';
} else {    
    $print_link = Horde::addParameter('workweek.php', 'week=' . $week);
    $print_link = Horde::addParameter($print_link, 'year=' . $year);
    $print_link = Horde::addParameter($print_link, 'print=true');
    $print_link = Horde::url($print_link);
    if ($browser->hasFeature('javascript')) {
        require_once $registry->getParam('templates', 'horde') . '/javascript/open_print_win.js';
    }

    Kronolith::menu();
}

$weekOb->html(KRONOLITH_TEMPLATES);

require KRONOLITH_TEMPLATES . '/common-footer.inc';
