<?php
/*
 * $Horde: horde/guest.php,v 1.2 2003/01/03 02:32:01 jan Exp $
 *
 * Copyright 1999-2003 Charles J. Hagenbuch <chuck@horde.org>
 * Copyright 1999-2003 Jon Parise <jon@horde.org>
 *
 * See the enclosed file COPYING for license information (LGPL). If you
 * did not receive this file, see http://www.fsf.org/copyleft/lgpl.html.
 */

define('HORDE_BASE', dirname(__FILE__));
require_once HORDE_BASE . '/lib/base.php';
require_once HORDE_BASE . '/lib/Menu.php';

$apps = $registry->listApps();
$guestapps = array();
foreach ($apps as $app) {
    if ($registry->allowGuests($app) &&
        $app != 'horde') {
        $guestapps[] = $app;
    }
}

// Redirect back to the login screen if there _are_ no applications
// available to guests.
if (!count($guestapps)) {
    header('Location: ' . Horde::applicationUrl('login.php', true));
}

$title = _("Guest Access");
$js_onLoad = null;
require HORDE_TEMPLATES . '/common-header.inc';
require HORDE_TEMPLATES . '/guest/guest.inc';
require HORDE_TEMPLATES . '/common-footer.inc';
