<?php
/**
 * $Horde: horde/admin/setup.php,v 1.8 2003/05/09 01:11:42 chuck Exp $
 *
 * Copyright 1999-2003 Charles J. Hagenbuch <chuck@horde.org>
 * Copyright 1999-2003 Jon Parise <jon@horde.org>
 *
 * See the enclosed file COPYING for license information (LGPL).  If you
 * did not receive this file, see http://www.fsf.org/copyleft/lgpl.html.
 */

define('HORDE_BASE', dirname(__FILE__) . '/..');
require_once HORDE_BASE . '/lib/base.php';
require_once HORDE_BASE . '/lib/Form.php';
require_once HORDE_BASE . '/lib/Form/Renderer.php';
require_once HORDE_BASE . '/lib/Config.php';

if (!Auth::isAdmin()) {
    Horde::fatal('Forbidden.', __FILE__, __LINE__);
}

if (!Horde::extensionExists('domxml')) {
    Horde::fatal(PEAR::raiseError('You need the domxml PHP extension to use the configuration tool.'), __FILE__, __LINE__);
}

$app = Horde::getFormData('app');
if (is_null($app)) {
    $title = _("Horde Configuration");
} else {
    $title = sprintf(_("%s Configuration"), $registry->getParam('name', $app));
}
require HORDE_TEMPLATES . '/common-header.inc';

if ($app !== null &&
    in_array($app, $registry->listApps(array('inactive', 'hidden', 'notoolbar', 'active')))) {
    $vars = Horde_Form::getDefaultVars();
    $cfg = &new ConfigForm($vars, $app);
    if ($vars->getVar('formname')) {
        $cfg->validate($vars);
        if ($cfg->isValid()) {
            $config = &new Horde_Config($app);
            $php = $config->generatePHPConfig($vars);
            $fp = @fopen($registry->getParam('fileroot', $app) . '/config/conf.php', 'w');
            echo '<span class="light">';
            if ($fp) {
                fwrite($fp, String::convertCharset($php, NLS::getCharset(), 'iso-8859-1'));
                fclose($fp);
                $notification->push(sprintf(_("Wrote %s successfully."),
                                            $registry->getParam('fileroot', $app) . '/config/conf.php'), 'horde.success');
            } else {
                $notification->push(sprintf(_("Writing not possible. Copy this code manually to %s."),
                                            $registry->getParam('fileroot', $app) . '/config/conf.php'), 'horde.warning');
            }

            require HORDE_BASE . '/navbar.php';
            echo nl2br(htmlspecialchars($php)) . '</span><br />';
        } else {
            require HORDE_BASE . '/navbar.php';
        }
    } else {
        require HORDE_BASE . '/navbar.php';
    }

    $appname = $registry->getParam('name', $app);
    $r = &new Horde_Form_Renderer();
    $cfg->open($r, $vars, 'setup.php', 'post');
    $r->beginActive(sprintf(_("%s Configuration"), $appname));
    $r->renderFormActive($cfg, $vars);
    $r->submit(sprintf(_("Generate %s Configuration"), $appname));
    $r->end();
    $cfg->close($r);
} else {
    require HORDE_BASE . '/navbar.php';

    $a = $registry->listApps(array('inactive', 'hidden', 'notoolbar', 'active'));
    $apps = array();
    foreach ($a as $app) {
        if (@file_exists($registry->getParam('fileroot', $app) . '/config/conf.xml')) {
            $apps[$app] = $registry->getParam('name', $app) . ' (' . $app . ')';
        }
    }
    asort($apps);
    ?>
<form method="post" action="setup.php" name="appselect">
     <?php Horde::pformInput() ?>
<select name="app" onchange="document.appselect.submit()">
     <?php echo Horde_Form_Renderer::_selectOptions($apps) ?>
</select>
<input type="submit" class="button" name="s" value="<?php echo _("Configure") ?>" />
</form>
<?php
}

require HORDE_TEMPLATES . '/common-footer.inc';
