/*  This file is part of KDevelop
    Copyright 2009 Aleix Pol <aleixpol@kde.org>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#ifndef QTHELPPLUGIN_H
#define QTHELPPLUGIN_H

#include <interfaces/iplugin.h>
#include <interfaces/idocumentationprovider.h>
#include <QHelpEngine>
#include <QAction>

class QtHelpDocumentation;

class QtHelpPlugin : public KDevelop::IPlugin, public KDevelop::IDocumentationProvider
{
	public:
		QtHelpPlugin(QObject *parent, const QVariantList & args);
		virtual KSharedPtr< KDevelop::IDocumentation > documentationForDeclaration (KDevelop::Declaration*);
        
        virtual KSharedPtr< KDevelop::IDocumentation > documentationForIndex(const QModelIndex& idx);
        virtual QAbstractListModel* indexModel();
        
        virtual QIcon icon() const;
        virtual QString name() const;
        
        QHelpEngine* engine() { return &m_engine; }
	private:
		QHelpEngine m_engine;
};

class QtHelpAlternativeLink : public QAction
{
    Q_OBJECT
    public:
        QtHelpAlternativeLink(const QString& name, const QtHelpDocumentation* doc, QObject* parent);
        
    public slots:
        void showUrl();
        
    private:
        const QtHelpDocumentation* mDoc;
        const QString mName;
};

#endif // QTHELPPLUGIN_H
