/* rygel-gst-changelog.c generated by valac, the Vala compiler
 * generated from rygel-gst-changelog.vala, do not modify */

/*
 * Copyright (C) 2008 OpenedHand Ltd.
 * Copyright (C) 2009 Nokia Corporation.
 *
 * Author: Jorn Baayen <jorn@openedhand.com>
 *         Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 */

#include <glib.h>
#include <glib-object.h>
#include <libgupnp/gupnp.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>


#define RYGEL_TYPE_GST_CHANGE_LOG (rygel_gst_change_log_get_type ())
#define RYGEL_GST_CHANGE_LOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_GST_CHANGE_LOG, RygelGstChangeLog))
#define RYGEL_GST_CHANGE_LOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_GST_CHANGE_LOG, RygelGstChangeLogClass))
#define RYGEL_IS_GST_CHANGE_LOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_GST_CHANGE_LOG))
#define RYGEL_IS_GST_CHANGE_LOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_GST_CHANGE_LOG))
#define RYGEL_GST_CHANGE_LOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_GST_CHANGE_LOG, RygelGstChangeLogClass))

typedef struct _RygelGstChangeLog RygelGstChangeLog;
typedef struct _RygelGstChangeLogClass RygelGstChangeLogClass;
typedef struct _RygelGstChangeLogPrivate RygelGstChangeLogPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

struct _RygelGstChangeLog {
	GObject parent_instance;
	RygelGstChangeLogPrivate * priv;
};

struct _RygelGstChangeLogClass {
	GObjectClass parent_class;
};

struct _RygelGstChangeLogPrivate {
	GUPnPService* _service;
	char* service_ns;
	GString* str;
	GeeHashMap* hash;
	guint timeout_id;
};


static gpointer rygel_gst_change_log_parent_class = NULL;

GType rygel_gst_change_log_get_type (void);
#define RYGEL_GST_CHANGE_LOG_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_GST_CHANGE_LOG, RygelGstChangeLogPrivate))
enum  {
	RYGEL_GST_CHANGE_LOG_DUMMY_PROPERTY,
	RYGEL_GST_CHANGE_LOG_SERVICE
};
void rygel_gst_change_log_set_service (RygelGstChangeLog* self, GUPnPService* value);
RygelGstChangeLog* rygel_gst_change_log_new (GUPnPService* service, const char* service_ns);
RygelGstChangeLog* rygel_gst_change_log_construct (GType object_type, GUPnPService* service, const char* service_ns);
GUPnPService* rygel_gst_change_log_get_service (RygelGstChangeLog* self);
char* rygel_gst_change_log_finish (RygelGstChangeLog* self);
static gboolean rygel_gst_change_log_timeout (RygelGstChangeLog* self);
static gboolean _rygel_gst_change_log_timeout_gsource_func (gpointer self);
static void rygel_gst_change_log_ensure_timeout (RygelGstChangeLog* self);
void rygel_gst_change_log_log (RygelGstChangeLog* self, const char* variable, const char* value);
void rygel_gst_change_log_log_with_channel (RygelGstChangeLog* self, const char* variable, const char* value, const char* channel);
static void rygel_gst_change_log_finalize (GObject* obj);
static void rygel_gst_change_log_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void rygel_gst_change_log_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);



RygelGstChangeLog* rygel_gst_change_log_construct (GType object_type, GUPnPService* service, const char* service_ns) {
	RygelGstChangeLog * self;
	char* _tmp0_;
	GString* _tmp1_;
	GeeHashMap* _tmp2_;
	g_return_val_if_fail (service_ns != NULL, NULL);
	self = (RygelGstChangeLog*) g_object_new (object_type, NULL);
	rygel_gst_change_log_set_service (self, service);
	self->priv->service_ns = (_tmp0_ = g_strdup (service_ns), _g_free0 (self->priv->service_ns), _tmp0_);
	self->priv->str = (_tmp1_ = g_string_new (""), _g_string_free0 (self->priv->str), _tmp1_);
	self->priv->hash = (_tmp2_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL), _g_object_unref0 (self->priv->hash), _tmp2_);
	return self;
}


RygelGstChangeLog* rygel_gst_change_log_new (GUPnPService* service, const char* service_ns) {
	return rygel_gst_change_log_construct (RYGEL_TYPE_GST_CHANGE_LOG, service, service_ns);
}


static gboolean rygel_gst_change_log_timeout (RygelGstChangeLog* self) {
	gboolean result;
	char* _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	gupnp_service_notify (self->priv->_service, "LastChange", G_TYPE_STRING, _tmp0_ = rygel_gst_change_log_finish (self), NULL);
	_g_free0 (_tmp0_);
	g_debug ("rygel-gst-changelog.vala:59: LastChange sent");
	gee_abstract_map_clear ((GeeAbstractMap*) self->priv->hash);
	g_string_erase (self->priv->str, (gssize) 0, (gssize) (-1));
	self->priv->timeout_id = (guint) 0;
	result = FALSE;
	return result;
}


static gboolean _rygel_gst_change_log_timeout_gsource_func (gpointer self) {
	return rygel_gst_change_log_timeout (self);
}


static void rygel_gst_change_log_ensure_timeout (RygelGstChangeLog* self) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	if (self->priv->_service != NULL) {
		_tmp0_ = self->priv->timeout_id == 0;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		g_debug ("rygel-gst-changelog.vala:72: Setting up timeout for LastChange");
		self->priv->timeout_id = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 200, _rygel_gst_change_log_timeout_gsource_func, g_object_ref (self), g_object_unref);
	}
}


void rygel_gst_change_log_log (RygelGstChangeLog* self, const char* variable, const char* value) {
	char* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (variable != NULL);
	g_return_if_fail (value != NULL);
	g_debug ("rygel-gst-changelog.vala:78: '%s = %s' logged", variable, value);
	gee_abstract_map_set ((GeeAbstractMap*) self->priv->hash, variable, _tmp0_ = g_strdup_printf ("<%s val=\"%s\"/>", variable, value));
	_g_free0 (_tmp0_);
	rygel_gst_change_log_ensure_timeout (self);
}


void rygel_gst_change_log_log_with_channel (RygelGstChangeLog* self, const char* variable, const char* value, const char* channel) {
	char* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (variable != NULL);
	g_return_if_fail (value != NULL);
	g_return_if_fail (channel != NULL);
	gee_abstract_map_set ((GeeAbstractMap*) self->priv->hash, variable, _tmp0_ = g_strdup_printf ("<%s val=\"%s\" channel=\"%s\"/>", variable, value, channel));
	_g_free0 (_tmp0_);
	rygel_gst_change_log_ensure_timeout (self);
}


char* rygel_gst_change_log_finish (RygelGstChangeLog* self) {
	char* result;
	char* _tmp1_;
	char* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	g_string_append (self->priv->str, _tmp1_ = g_strconcat (_tmp0_ = g_strconcat ("<Event xmlns=\"", self->priv->service_ns, NULL), "\"><InstanceID val=\"0\">", NULL));
	_g_free0 (_tmp1_);
	_g_free0 (_tmp0_);
	{
		GeeCollection* _tmp2_;
		GeeIterator* _tmp3_;
		GeeIterator* _line_it;
		_line_it = (_tmp3_ = gee_iterable_iterator ((GeeIterable*) (_tmp2_ = gee_map_get_values ((GeeMap*) self->priv->hash))), _g_object_unref0 (_tmp2_), _tmp3_);
		while (TRUE) {
			char* line;
			if (!gee_iterator_next (_line_it)) {
				break;
			}
			line = (char*) gee_iterator_get (_line_it);
			g_string_append (self->priv->str, line);
			_g_free0 (line);
		}
		_g_object_unref0 (_line_it);
	}
	g_string_append (self->priv->str, "</InstanceID></Event>");
	result = g_strdup (self->priv->str->str);
	return result;
}


GUPnPService* rygel_gst_change_log_get_service (RygelGstChangeLog* self) {
	GUPnPService* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_service;
	return result;
}


void rygel_gst_change_log_set_service (RygelGstChangeLog* self, GUPnPService* value) {
	g_return_if_fail (self != NULL);
	self->priv->_service = value;
	g_object_notify ((GObject *) self, "service");
}


static void rygel_gst_change_log_class_init (RygelGstChangeLogClass * klass) {
	rygel_gst_change_log_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelGstChangeLogPrivate));
	G_OBJECT_CLASS (klass)->get_property = rygel_gst_change_log_get_property;
	G_OBJECT_CLASS (klass)->set_property = rygel_gst_change_log_set_property;
	G_OBJECT_CLASS (klass)->finalize = rygel_gst_change_log_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_GST_CHANGE_LOG_SERVICE, g_param_spec_object ("service", "service", "service", GUPNP_TYPE_SERVICE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void rygel_gst_change_log_instance_init (RygelGstChangeLog * self) {
	self->priv = RYGEL_GST_CHANGE_LOG_GET_PRIVATE (self);
	self->priv->timeout_id = (guint) 0;
}


static void rygel_gst_change_log_finalize (GObject* obj) {
	RygelGstChangeLog * self;
	self = RYGEL_GST_CHANGE_LOG (obj);
	{
		if (self->priv->timeout_id != 0) {
			g_source_remove (self->priv->timeout_id);
		}
	}
	_g_free0 (self->priv->service_ns);
	_g_string_free0 (self->priv->str);
	_g_object_unref0 (self->priv->hash);
	G_OBJECT_CLASS (rygel_gst_change_log_parent_class)->finalize (obj);
}


GType rygel_gst_change_log_get_type (void) {
	static GType rygel_gst_change_log_type_id = 0;
	if (rygel_gst_change_log_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelGstChangeLogClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_gst_change_log_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelGstChangeLog), 0, (GInstanceInitFunc) rygel_gst_change_log_instance_init, NULL };
		rygel_gst_change_log_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelGstChangeLog", &g_define_type_info, 0);
	}
	return rygel_gst_change_log_type_id;
}


static void rygel_gst_change_log_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	RygelGstChangeLog * self;
	self = RYGEL_GST_CHANGE_LOG (object);
	switch (property_id) {
		case RYGEL_GST_CHANGE_LOG_SERVICE:
		g_value_set_object (value, rygel_gst_change_log_get_service (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void rygel_gst_change_log_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	RygelGstChangeLog * self;
	self = RYGEL_GST_CHANGE_LOG (object);
	switch (property_id) {
		case RYGEL_GST_CHANGE_LOG_SERVICE:
		rygel_gst_change_log_set_service (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}




