/*
 * Pan - A Newsreader for X
 * Copyright (C) 2001  Pan Development Team <pan@rebelbase.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#ifndef __IDENTITY_XML_H__
#define __IDENTITY_XML_H__

#include <glib.h>
#include <pan/identities/identity.h>

void    identity_xml_read      (const gchar  * filename,
                                GPtrArray    * appendme_identities, 
				gchar       ** default_news_id,
				gchar       ** default_mail_id);

void    identity_xml_write     (const gchar  * filename,
                                Identity    ** identities,
                                gint           identities_qty,
				const gchar  * default_news_id,
				const gchar  * default_mail_id);

gchar * identity_xml_to_string (Identity    ** identities,
                                gint           identities_qty,
                                const gchar  * default_news_id,
                                const gchar  * default_mail_id);


#endif
