// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GIOMM_APPLICATION_H
#define _GIOMM_APPLICATION_H


#include <glibmm.h>

// -*- Mode: C++; indent-tabs-mode: nil; c-basic-offset: 2 -*-

/* Copyright (C) 2007 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <giomm/cancellable.h>
#include <glibmm/object.h>
#include <glibmm/variant.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GApplication GApplication;
typedef struct _GApplicationClass GApplicationClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gio
{ class Application_Class; } // namespace Gio
namespace Gio
{

/** @addtogroup giommEnums giomm Enums and Flags */

/**
 * @ingroup giommEnums
 * @par Bitwise operators:
 * <tt>%ApplicationFlags operator|(ApplicationFlags, ApplicationFlags)</tt><br>
 * <tt>%ApplicationFlags operator&(ApplicationFlags, ApplicationFlags)</tt><br>
 * <tt>%ApplicationFlags operator^(ApplicationFlags, ApplicationFlags)</tt><br>
 * <tt>%ApplicationFlags operator~(ApplicationFlags)</tt><br>
 * <tt>%ApplicationFlags& operator|=(ApplicationFlags&, ApplicationFlags)</tt><br>
 * <tt>%ApplicationFlags& operator&=(ApplicationFlags&, ApplicationFlags)</tt><br>
 * <tt>%ApplicationFlags& operator^=(ApplicationFlags&, ApplicationFlags)</tt><br>
 */
enum ApplicationFlags
{
  APPLICATION_FLAGS_NONE = 0x0,
  APPLICATION_IS_SERVICE = (1 << 0),
  APPLICATION_IS_LAUNCHER = (1 << 1),
  APPLICATION_HANDLES_OPEN = (1 << 2),
  APPLICATION_HANDLES_COMMAND_LINE = (1 << 3)
};

/** @ingroup giommEnums */
inline ApplicationFlags operator|(ApplicationFlags lhs, ApplicationFlags rhs)
  { return static_cast<ApplicationFlags>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs)); }

/** @ingroup giommEnums */
inline ApplicationFlags operator&(ApplicationFlags lhs, ApplicationFlags rhs)
  { return static_cast<ApplicationFlags>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs)); }

/** @ingroup giommEnums */
inline ApplicationFlags operator^(ApplicationFlags lhs, ApplicationFlags rhs)
  { return static_cast<ApplicationFlags>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs)); }

/** @ingroup giommEnums */
inline ApplicationFlags operator~(ApplicationFlags flags)
  { return static_cast<ApplicationFlags>(~static_cast<unsigned>(flags)); }

/** @ingroup giommEnums */
inline ApplicationFlags& operator|=(ApplicationFlags& lhs, ApplicationFlags rhs)
  { return (lhs = static_cast<ApplicationFlags>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs))); }

/** @ingroup giommEnums */
inline ApplicationFlags& operator&=(ApplicationFlags& lhs, ApplicationFlags rhs)
  { return (lhs = static_cast<ApplicationFlags>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs))); }

/** @ingroup giommEnums */
inline ApplicationFlags& operator^=(ApplicationFlags& lhs, ApplicationFlags rhs)
  { return (lhs = static_cast<ApplicationFlags>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs))); }


class ActionGroup;

/** TODO
 *
 * @newin{2,26}
 */

class Application : public Glib::Object
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef Application CppObjectType;
  typedef Application_Class CppClassType;
  typedef GApplication BaseObjectType;
  typedef GApplicationClass BaseClassType;

private:  friend class Application_Class;
  static CppClassType application_class_;

private:
  // noncopyable
  Application(const Application&);
  Application& operator=(const Application&);

protected:
  explicit Application(const Glib::ConstructParams& construct_params);
  explicit Application(GApplication* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~Application();

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;


  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GApplication*       gobj()       { return reinterpret_cast<GApplication*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const GApplication* gobj() const { return reinterpret_cast<GApplication*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GApplication* gobj_copy();

private:


protected:
  Application();

public:
  //_WRAP_CREATE()

  
  /** Create a new Application.  This uses a platform-specific
   * mechanism to ensure the current process is the unique owner of the
   * application (as defined by the @a appid). If successful, the
   * Application:is-remote property will be <tt>false</tt>, and it is safe to
   * continue creating other resources such as graphics windows.
   * 
   * If the given @a appid is already running in another process, the the
   * GApplication::activate_with_data signal will be emitted in the
   * remote process, with the data from @a argv and other
   * platform-specific data available.  Subsequently the
   * Application:default-quit property will be evaluated.  If it's
   * <tt>true</tt>, then the current process will terminate.  If <tt>false</tt>, then
   * the application remains in the Application:is-remote state, and
   * you can e.g. call Glib::application_invoke_action(). Note that proxy
   * instances should not call Glib::application_add_action().
   * 
   * This function may do synchronous I/O to obtain unique ownership
   * of the application id, and will block the calling thread in this
   * case.
   * 
   * If the environment does not support the basic functionality of
   * Application, this function will invoke Glib::error(), which by
   * default is a fatal operation.  This may arise for example on
   * UNIX systems using D-Bus when the session bus is not available.
   * 
   * As a convenience, this function is defined to call Glib::type_init() as
   * its very first action.
   * 
   * @newin{2,26}
   * @param appid System-dependent application identifier.
   * @param argc Number of arguments in @a argv.
   * @param argv Argument vector, usually from the <parameter>argv</parameter> parameter of main().
   * @return An application instance.
   */
  static Glib::RefPtr<Application> create(const Glib::ustring& appid, ApplicationFlags flags = APPLICATION_FLAGS_NONE);

  
  static bool is_valid(const Glib::ustring& application_id); 

  
  Glib::ustring get_id() const;
  
  void set_id(const Glib::ustring& application_id);

  
  guint get_inactivity_timeout() const;
  
  void set_inactivity_timeout(guint inactivity_timeout);

  
  ApplicationFlags get_flags() const;
  
  void set_flags(ApplicationFlags flags);

  
  void set_action_group(const Glib::RefPtr<ActionGroup>& action_group);

  
  bool is_registered() const;
  
  bool is_remote() const;

  //TODO: Add a version with no cancellable.
  //Renamed from register() because that is a C++ keyword.
  
  /** By default, Application ensures process uniqueness when
   * initialized, but this behavior is controlled by the
   * GApplication:register property.  If it was given as <tt>false</tt> at
   * construction time, this function allows you to later attempt
   * to ensure uniqueness.  Note that the GApplication:default-quit
   * property no longer applies at this point; if this function returns
   * <tt>false</tt>, platform activation will occur, but the current process
   * will not be terminated.
   * 
   * It is an error to call this function more than once.  It is
   * also an error to call this function if the GApplication:register
   * property was <tt>true</tt> at construction time.
   * @return <tt>true</tt> if registration was successful.
   */
  bool register_application(const Glib::RefPtr<Gio::Cancellable>& cancellable);

  
  void hold();
  
  void release();
  
  void activate();

  //TODO: _WRAP_METHOD(void open(GFile **files, gint n_files, const Glib::ustring& hint), g_application_open)

  
  /** Starts the application.
   * 
   * The default implementation of this virtual function will simply run
   * a main loop.
   * 
   * It is an error to call this function if @a application is a proxy for
   * a remote application.
   * 
   * @newin{2,26}
   */
  void run(int argc, char** argv);
  //TODO: g_application_run_with_arguments)

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The group of actions that the application exports.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_WriteOnly< Glib::RefPtr<ActionGroup> > property_action_group() ;
#endif //#GLIBMM_PROPERTIES_ENABLED


  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The unique identifier for the application.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<Glib::ustring> property_application_id() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** The unique identifier for the application.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<Glib::ustring> property_application_id() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Flags specifying the behaviour of the application.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<ApplicationFlags> property_flags() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Flags specifying the behaviour of the application.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<ApplicationFlags> property_flags() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Iime (ms) to stay alive after becoming idle.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<guint> property_inactivity_timeout() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Iime (ms) to stay alive after becoming idle.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<guint> property_inactivity_timeout() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** If g_application_register() has been called.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_is_registered() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


  #ifdef GLIBMM_PROPERTIES_ENABLED
/** If this application instance is remote.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_is_remote() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


//#m4 __CONVERSION(`const gchar*', `const Glib::ustring&', `Glib::ustring($3)')
//#m4 __CONVERSION(`GVariant*', `const Glib::VariantBase&', `Glib::wrap($3, true)')

  
  /**
   * @par Prototype:
   * <tt>void on_my_%startup()</tt>
   */

  Glib::SignalProxy0< void > signal_startup();

  
  /**
   * @par Prototype:
   * <tt>void on_my_%activate()</tt>
   */

  Glib::SignalProxy0< void > signal_activate();

  //TODO: _WRAP_SIGNAL(void open(GFile** files, int n_files, const Glib::ustring& hint), "open")
  //TODO: Wrap ApplicationCommandLine: _WRAP_SIGNAL(void command_line(const Glib::RefPtr<ApplicationCommandLine>& command_line), "command-line")


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::
  virtual void on_startup();
  virtual void on_activate();


};


} // namespace Gio


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gio::Application
   */
  Glib::RefPtr<Gio::Application> wrap(GApplication* object, bool take_copy = false);
}


#endif /* _GIOMM_APPLICATION_H */

