/* favourite-details.c generated by valac 0.14.0, the Vala compiler
 * generated from favourite-details.vala, do not modify */

/*
 * Copyright (C) 2010 Collabora Ltd.
 * Copyright (C) 2011 Philip Withnall
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors:
 *       Philip Withnall <philip.withnall@collabora.co.uk>
 */

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>


#define FOLKS_TYPE_FAVOURITE_DETAILS (folks_favourite_details_get_type ())
#define FOLKS_FAVOURITE_DETAILS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_TYPE_FAVOURITE_DETAILS, FolksFavouriteDetails))
#define FOLKS_IS_FAVOURITE_DETAILS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_TYPE_FAVOURITE_DETAILS))
#define FOLKS_FAVOURITE_DETAILS_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), FOLKS_TYPE_FAVOURITE_DETAILS, FolksFavouriteDetailsIface))

typedef struct _FolksFavouriteDetails FolksFavouriteDetails;
typedef struct _FolksFavouriteDetailsIface FolksFavouriteDetailsIface;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _FolksFavouriteDetailsChangeIsFavouriteData FolksFavouriteDetailsChangeIsFavouriteData;

typedef enum  {
	FOLKS_PROPERTY_ERROR_NOT_WRITEABLE,
	FOLKS_PROPERTY_ERROR_INVALID_VALUE,
	FOLKS_PROPERTY_ERROR_UNKNOWN_ERROR
} FolksPropertyError;
#define FOLKS_PROPERTY_ERROR folks_property_error_quark ()
struct _FolksFavouriteDetailsIface {
	GTypeInterface parent_iface;
	void (*change_is_favourite) (FolksFavouriteDetails* self, gboolean is_favourite, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*change_is_favourite_finish) (FolksFavouriteDetails* self, GAsyncResult* _res_, GError** error);
	gboolean (*get_is_favourite) (FolksFavouriteDetails* self);
	void (*set_is_favourite) (FolksFavouriteDetails* self, gboolean value);
};

struct _FolksFavouriteDetailsChangeIsFavouriteData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	FolksFavouriteDetails* self;
	gboolean is_favourite;
	const gchar* _tmp0_;
	GError* _tmp1_;
	GError * _inner_error_;
};



GQuark folks_property_error_quark (void);
GType folks_favourite_details_get_type (void) G_GNUC_CONST;
static void folks_favourite_details_real_change_is_favourite_data_free (gpointer _data);
static void folks_favourite_details_real_change_is_favourite (FolksFavouriteDetails* self, gboolean is_favourite, GAsyncReadyCallback _callback_, gpointer _user_data_);
void folks_favourite_details_change_is_favourite (FolksFavouriteDetails* self, gboolean is_favourite, GAsyncReadyCallback _callback_, gpointer _user_data_);
void folks_favourite_details_change_is_favourite_finish (FolksFavouriteDetails* self, GAsyncResult* _res_, GError** error);
static gboolean folks_favourite_details_real_change_is_favourite_co (FolksFavouriteDetailsChangeIsFavouriteData* _data_);
gboolean folks_favourite_details_get_is_favourite (FolksFavouriteDetails* self);
void folks_favourite_details_set_is_favourite (FolksFavouriteDetails* self, gboolean value);


static void folks_favourite_details_real_change_is_favourite_data_free (gpointer _data) {
	FolksFavouriteDetailsChangeIsFavouriteData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (FolksFavouriteDetailsChangeIsFavouriteData, _data_);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void folks_favourite_details_real_change_is_favourite (FolksFavouriteDetails* self, gboolean is_favourite, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	FolksFavouriteDetailsChangeIsFavouriteData* _data_;
	FolksFavouriteDetails* _tmp0_;
	gboolean _tmp1_;
	_data_ = g_slice_new0 (FolksFavouriteDetailsChangeIsFavouriteData);
	_data_->_async_result = g_simple_async_result_new (NULL, _callback_, _user_data_, folks_favourite_details_real_change_is_favourite);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, folks_favourite_details_real_change_is_favourite_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = is_favourite;
	_data_->is_favourite = _tmp1_;
	folks_favourite_details_real_change_is_favourite_co (_data_);
}


static void folks_favourite_details_real_change_is_favourite_finish (FolksFavouriteDetails* self, GAsyncResult* _res_, GError** error) {
	FolksFavouriteDetailsChangeIsFavouriteData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


/**
   * Change whether the contact is a user-defined favourite.
   *
   * It's preferred to call this rather than setting
   * {@link FavouriteDetails.is_favourite} directly, as this method gives error
   * notification and will only return once the favouriteness has been written
   * to the relevant backing store (or the operation's failed).
   *
   * @param is_favourite `true` if the contact is a favourite; `false` otherwise
   * @throws PropertyError if setting the favouriteness failed
   * @since 0.6.2
   */
static gboolean folks_favourite_details_real_change_is_favourite_co (FolksFavouriteDetailsChangeIsFavouriteData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = _ ("Favorite status is not writeable on this contact.");
	_data_->_tmp1_ = g_error_new_literal (FOLKS_PROPERTY_ERROR, FOLKS_PROPERTY_ERROR_NOT_WRITEABLE, _data_->_tmp0_);
	_data_->_inner_error_ = _data_->_tmp1_;
	if (_data_->_inner_error_->domain == FOLKS_PROPERTY_ERROR) {
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	} else {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
		g_clear_error (&_data_->_inner_error_);
		return FALSE;
	}
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


void folks_favourite_details_change_is_favourite (FolksFavouriteDetails* self, gboolean is_favourite, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	FOLKS_FAVOURITE_DETAILS_GET_INTERFACE (self)->change_is_favourite (self, is_favourite, _callback_, _user_data_);
}


void folks_favourite_details_change_is_favourite_finish (FolksFavouriteDetails* self, GAsyncResult* _res_, GError** error) {
	FOLKS_FAVOURITE_DETAILS_GET_INTERFACE (self)->change_is_favourite_finish (self, _res_, error);
}


gboolean folks_favourite_details_get_is_favourite (FolksFavouriteDetails* self) {
	g_return_val_if_fail (self != NULL, FALSE);
	return FOLKS_FAVOURITE_DETAILS_GET_INTERFACE (self)->get_is_favourite (self);
}


void folks_favourite_details_set_is_favourite (FolksFavouriteDetails* self, gboolean value) {
	g_return_if_fail (self != NULL);
	FOLKS_FAVOURITE_DETAILS_GET_INTERFACE (self)->set_is_favourite (self, value);
}


static void folks_favourite_details_base_init (FolksFavouriteDetailsIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
		/**
		   * Whether this contact is a user-defined favourite.
		   */
		g_object_interface_install_property (iface, g_param_spec_boolean ("is-favourite", "is-favourite", "is-favourite", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
		iface->change_is_favourite = folks_favourite_details_real_change_is_favourite;
		iface->change_is_favourite_finish = folks_favourite_details_real_change_is_favourite_finish;
	}
}


/**
 * Interface exposing a {@link Persona}'s or {@link Individual}'s user-defined
 * status as a favourite.
 */
GType folks_favourite_details_get_type (void) {
	static volatile gsize folks_favourite_details_type_id__volatile = 0;
	if (g_once_init_enter (&folks_favourite_details_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (FolksFavouriteDetailsIface), (GBaseInitFunc) folks_favourite_details_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType folks_favourite_details_type_id;
		folks_favourite_details_type_id = g_type_register_static (G_TYPE_INTERFACE, "FolksFavouriteDetails", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (folks_favourite_details_type_id, G_TYPE_OBJECT);
		g_once_init_leave (&folks_favourite_details_type_id__volatile, folks_favourite_details_type_id);
	}
	return folks_favourite_details_type_id__volatile;
}



