/* contacts-app.c generated by valac 0.14.0.1-60fb, the Vala compiler
 * generated from contacts-app.vala, do not modify */

/* -*- Mode: vala; indent-tabs-mode: t; c-basic-offset: 2; tab-width: 8 -*- */
/*
 * Copyright (C) 2011 Alexander Larsson <alexl@redhat.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <gdk/gdk.h>
#include <gio/gio.h>
#include <folks/folks.h>
#include <glib/gi18n-lib.h>
#include <config.h>
#include <contacts-esd-setup.h>


#define CONTACTS_TYPE_APP (contacts_app_get_type ())
#define CONTACTS_APP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_TYPE_APP, ContactsApp))
#define CONTACTS_APP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_TYPE_APP, ContactsAppClass))
#define CONTACTS_IS_APP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_TYPE_APP))
#define CONTACTS_IS_APP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_TYPE_APP))
#define CONTACTS_APP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_TYPE_APP, ContactsAppClass))

typedef struct _ContactsApp ContactsApp;
typedef struct _ContactsAppClass ContactsAppClass;
typedef struct _ContactsAppPrivate ContactsAppPrivate;

#define CONTACTS_TYPE_STORE (contacts_store_get_type ())
#define CONTACTS_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_TYPE_STORE, ContactsStore))
#define CONTACTS_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_TYPE_STORE, ContactsStoreClass))
#define CONTACTS_IS_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_TYPE_STORE))
#define CONTACTS_IS_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_TYPE_STORE))
#define CONTACTS_STORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_TYPE_STORE, ContactsStoreClass))

typedef struct _ContactsStore ContactsStore;
typedef struct _ContactsStoreClass ContactsStoreClass;

#define CONTACTS_TYPE_LIST_PANE (contacts_list_pane_get_type ())
#define CONTACTS_LIST_PANE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_TYPE_LIST_PANE, ContactsListPane))
#define CONTACTS_LIST_PANE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_TYPE_LIST_PANE, ContactsListPaneClass))
#define CONTACTS_IS_LIST_PANE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_TYPE_LIST_PANE))
#define CONTACTS_IS_LIST_PANE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_TYPE_LIST_PANE))
#define CONTACTS_LIST_PANE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_TYPE_LIST_PANE, ContactsListPaneClass))

typedef struct _ContactsListPane ContactsListPane;
typedef struct _ContactsListPaneClass ContactsListPaneClass;

#define CONTACTS_TYPE_CONTACT_PANE (contacts_contact_pane_get_type ())
#define CONTACTS_CONTACT_PANE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_TYPE_CONTACT_PANE, ContactsContactPane))
#define CONTACTS_CONTACT_PANE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_TYPE_CONTACT_PANE, ContactsContactPaneClass))
#define CONTACTS_IS_CONTACT_PANE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_TYPE_CONTACT_PANE))
#define CONTACTS_IS_CONTACT_PANE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_TYPE_CONTACT_PANE))
#define CONTACTS_CONTACT_PANE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_TYPE_CONTACT_PANE, ContactsContactPaneClass))

typedef struct _ContactsContactPane ContactsContactPane;
typedef struct _ContactsContactPaneClass ContactsContactPaneClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define CONTACTS_TYPE_CONTACT (contacts_contact_get_type ())
#define CONTACTS_CONTACT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_TYPE_CONTACT, ContactsContact))
#define CONTACTS_CONTACT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_TYPE_CONTACT, ContactsContactClass))
#define CONTACTS_IS_CONTACT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_TYPE_CONTACT))
#define CONTACTS_IS_CONTACT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_TYPE_CONTACT))
#define CONTACTS_CONTACT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_TYPE_CONTACT, ContactsContactClass))

typedef struct _ContactsContact ContactsContact;
typedef struct _ContactsContactClass ContactsContactClass;
typedef struct _ContactsListPanePrivate ContactsListPanePrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block1Data Block1Data;
typedef struct _ContactsContactPrivate ContactsContactPrivate;
typedef struct _Block2Data Block2Data;
typedef struct _ContactsAppShowIndividualData ContactsAppShowIndividualData;
typedef struct _Block3Data Block3Data;
typedef struct _Block4Data Block4Data;
typedef struct _ContactsAppShowByEmailData ContactsAppShowByEmailData;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_option_context_free0(var) ((var == NULL) ? NULL : (var = (g_option_context_free (var), NULL)))

struct _ContactsApp {
	GtkApplication parent_instance;
	ContactsAppPrivate * priv;
	GtkWindow* window;
};

struct _ContactsAppClass {
	GtkApplicationClass parent_class;
};

struct _ContactsAppPrivate {
	ContactsStore* contacts_store;
	ContactsListPane* list_pane;
	ContactsContactPane* contacts_pane;
};

struct _ContactsListPane {
	GtkFrame parent_instance;
	ContactsListPanePrivate * priv;
	GtkEntry* filter_entry;
};

struct _ContactsListPaneClass {
	GtkFrameClass parent_class;
};

struct _Block1Data {
	int _ref_count_;
	ContactsApp * self;
	gchar* id;
	gpointer _async_data_;
};

typedef gboolean (*ContactsStoreContactMatcher) (ContactsContact* c, void* user_data);
struct _ContactsContact {
	GObject parent_instance;
	ContactsContactPrivate * priv;
	ContactsStore* store;
	FolksPresenceType presence_type;
	gchar* presence_message;
	gboolean is_phone;
	gboolean is_new;
	gboolean is_unedited;
	FolksIndividual* individual;
};

struct _ContactsContactClass {
	GObjectClass parent_class;
};

struct _Block2Data {
	int _ref_count_;
	Block1Data * _data1_;
	GtkMessageDialog* dialog;
};

struct _ContactsAppShowIndividualData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	ContactsApp* self;
	gchar* id;
	Block1Data* _data1_;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	ContactsStore* _tmp2_;
	ContactsContact* _tmp3_;
	ContactsContact* contact;
	ContactsContact* _tmp4_;
	ContactsListPane* _tmp5_;
	ContactsContact* _tmp6_;
	ContactsContactPane* _tmp7_;
	ContactsContact* _tmp8_;
	Block2Data* _data2_;
	ContactsApp* _tmp9_;
	GtkWindow* _tmp10_;
	const gchar* _tmp11_;
	const gchar* _tmp12_;
	GtkMessageDialog* _tmp13_;
	GtkMessageDialog* _tmp14_;
	GtkMessageDialog* _tmp15_;
	const gchar* _tmp16_;
	GtkMessageDialog* _tmp17_;
	GtkMessageDialog* _tmp18_;
};

struct _Block3Data {
	int _ref_count_;
	ContactsApp * self;
	gchar* email_address;
	gpointer _async_data_;
};

struct _Block4Data {
	int _ref_count_;
	Block3Data * _data3_;
	GtkMessageDialog* dialog;
};

struct _ContactsAppShowByEmailData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	ContactsApp* self;
	gchar* email_address;
	Block3Data* _data3_;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	ContactsStore* _tmp2_;
	ContactsContact* _tmp3_;
	ContactsContact* contact;
	ContactsContact* _tmp4_;
	ContactsListPane* _tmp5_;
	ContactsContact* _tmp6_;
	ContactsContactPane* _tmp7_;
	ContactsContact* _tmp8_;
	Block4Data* _data4_;
	ContactsApp* _tmp9_;
	GtkWindow* _tmp10_;
	const gchar* _tmp11_;
	const gchar* _tmp12_;
	GtkMessageDialog* _tmp13_;
	GtkMessageDialog* _tmp14_;
	GtkMessageDialog* _tmp15_;
	const gchar* _tmp16_;
	GtkMessageDialog* _tmp17_;
	GtkMessageDialog* _tmp18_;
};


static gpointer contacts_app_parent_class = NULL;
extern ContactsApp* contacts_app_app;
ContactsApp* contacts_app_app = NULL;
static gchar* contacts_app_individual_id;
static gchar* contacts_app_individual_id = NULL;
static gchar* contacts_app_email_address;
static gchar* contacts_app_email_address = NULL;

GType contacts_app_get_type (void) G_GNUC_CONST;
GType contacts_store_get_type (void) G_GNUC_CONST;
GType contacts_list_pane_get_type (void) G_GNUC_CONST;
GType contacts_contact_pane_get_type (void) G_GNUC_CONST;
#define CONTACTS_APP_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), CONTACTS_TYPE_APP, ContactsAppPrivate))
enum  {
	CONTACTS_APP_DUMMY_PROPERTY
};
static gboolean contacts_app_window_delete_event (ContactsApp* self, GdkEventAny* event);
GType contacts_contact_get_type (void) G_GNUC_CONST;
void contacts_contact_pane_show_contact (ContactsContactPane* self, ContactsContact* new_contact, gboolean edit);
static gboolean contacts_app_window_map_event (ContactsApp* self, GdkEventAny* event);
static gboolean contacts_app_window_key_press_event (ContactsApp* self, GdkEventKey* event);
static void contacts_app_selection_changed (ContactsApp* self, ContactsContact* new_selection);
static void contacts_app_show_individual_data_free (gpointer _data);
void contacts_app_show_individual (ContactsApp* self, const gchar* id, GAsyncReadyCallback _callback_, gpointer _user_data_);
void contacts_app_show_individual_finish (ContactsApp* self, GAsyncResult* _res_);
static gboolean contacts_app_show_individual_co (ContactsAppShowIndividualData* _data_);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (Block1Data* _data1_);
void contacts_store_find_contact (ContactsStore* self, ContactsStoreContactMatcher matcher, void* matcher_target, GAsyncReadyCallback _callback_, gpointer _user_data_);
ContactsContact* contacts_store_find_contact_finish (ContactsStore* self, GAsyncResult* _res_);
static gboolean __lambda71_ (Block1Data* _data1_, ContactsContact* c);
static gboolean ___lambda71__contacts_store_contact_matcher (ContactsContact* c, gpointer self);
static void contacts_app_show_individual_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
void contacts_list_pane_select_contact (ContactsListPane* self, ContactsContact* contact, gboolean ignore_change);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (Block2Data* _data2_);
static void ___lambda72_ (Block2Data* _data2_, gint id);
static void ____lambda72__gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self);
static void contacts_app_show_by_email_data_free (gpointer _data);
void contacts_app_show_by_email (ContactsApp* self, const gchar* email_address, GAsyncReadyCallback _callback_, gpointer _user_data_);
void contacts_app_show_by_email_finish (ContactsApp* self, GAsyncResult* _res_);
static gboolean contacts_app_show_by_email_co (ContactsAppShowByEmailData* _data_);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (Block3Data* _data3_);
static gboolean __lambda73_ (Block3Data* _data3_, ContactsContact* c);
gboolean contacts_contact_has_email (ContactsContact* self, const gchar* email_address);
static gboolean ___lambda73__contacts_store_contact_matcher (ContactsContact* c, gpointer self);
static void contacts_app_show_by_email_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static Block4Data* block4_data_ref (Block4Data* _data4_);
static void block4_data_unref (Block4Data* _data4_);
static void ___lambda74_ (Block4Data* _data4_, gint id);
static void ____lambda74__gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self);
static void contacts_app_create_window (ContactsApp* self);
static gboolean _contacts_app_window_delete_event_gtk_widget_delete_event (GtkWidget* _sender, GdkEventAny* event, gpointer self);
static gboolean _contacts_app_window_map_event_gtk_widget_map_event (GtkWidget* _sender, GdkEventAny* event, gpointer self);
static gboolean _contacts_app_window_key_press_event_gtk_widget_key_press_event (GtkWidget* _sender, GdkEventKey* event, gpointer self);
ContactsListPane* contacts_list_pane_new (ContactsStore* contacts_store);
ContactsListPane* contacts_list_pane_construct (GType object_type, ContactsStore* contacts_store);
static void _contacts_app_selection_changed_contacts_list_pane_selection_changed (ContactsListPane* _sender, ContactsContact* contact, gpointer self);
static void __lambda75_ (ContactsApp* self);
void contacts_contact_pane_new_contact (ContactsContactPane* self, ContactsListPane* list_pane);
static void ___lambda75__contacts_list_pane_create_new (ContactsListPane* _sender, gpointer self);
ContactsContactPane* contacts_contact_pane_new (ContactsStore* contacts_store);
ContactsContactPane* contacts_contact_pane_construct (GType object_type, ContactsStore* contacts_store);
static void contacts_app_real_startup (GApplication* base);
ContactsStore* contacts_store_new (void);
ContactsStore* contacts_store_construct (GType object_type);
static void contacts_app_real_activate (GApplication* base);
static void ___lambda76_ (ContactsApp* self);
static void ____lambda76__contacts_store_quiescent (ContactsStore* _sender, gpointer self);
static gboolean ___lambda77_ (ContactsApp* self);
static gboolean ____lambda77__gsource_func (gpointer self);
static gint contacts_app_real_command_line (GApplication* base, GApplicationCommandLine* command_line);
ContactsApp* contacts_app_new (void);
ContactsApp* contacts_app_construct (GType object_type);
static void contacts_app_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);

static const GOptionEntry CONTACTS_APP_options[3] = {{"individual", 'i', 0, G_OPTION_ARG_STRING, &contacts_app_individual_id, "Show contact with this individual id", NULL}, {"email", 'e', 0, G_OPTION_ARG_STRING, &contacts_app_email_address, "Show contact with this email address", NULL}, {NULL}};

static gboolean contacts_app_window_delete_event (ContactsApp* self, GdkEventAny* event) {
	gboolean result = FALSE;
	ContactsContactPane* _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = self->priv->contacts_pane;
	contacts_contact_pane_show_contact (_tmp0_, NULL, FALSE);
	result = FALSE;
	return result;
}


static gboolean contacts_app_window_map_event (ContactsApp* self, GdkEventAny* event) {
	gboolean result = FALSE;
	ContactsListPane* _tmp0_;
	GtkEntry* _tmp1_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = self->priv->list_pane;
	_tmp1_ = _tmp0_->filter_entry;
	gtk_widget_grab_focus ((GtkWidget*) _tmp1_);
	result = TRUE;
	return result;
}


static gboolean contacts_app_window_key_press_event (ContactsApp* self, GdkEventKey* event) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	GdkEventKey _tmp1_;
	guint _tmp2_;
	guint _tmp3_ = 0U;
	gboolean _tmp6_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp1_ = *event;
	_tmp2_ = _tmp1_.keyval;
	_tmp3_ = gdk_keyval_from_name ("q");
	if (_tmp2_ == _tmp3_) {
		GdkEventKey _tmp4_;
		GdkModifierType _tmp5_;
		_tmp4_ = *event;
		_tmp5_ = _tmp4_.state;
		_tmp0_ = (_tmp5_ & GDK_CONTROL_MASK) != 0;
	} else {
		_tmp0_ = FALSE;
	}
	_tmp6_ = _tmp0_;
	if (_tmp6_) {
		ContactsContactPane* _tmp7_;
		GtkWindow* _tmp8_;
		_tmp7_ = self->priv->contacts_pane;
		contacts_contact_pane_show_contact (_tmp7_, NULL, FALSE);
		_tmp8_ = self->window;
		gtk_widget_destroy ((GtkWidget*) _tmp8_);
	} else {
		gboolean _tmp9_ = FALSE;
		gboolean _tmp10_ = FALSE;
		GdkEventKey _tmp11_;
		guint _tmp12_;
		guint _tmp13_ = 0U;
		gboolean _tmp17_;
		gboolean _tmp20_;
		_tmp11_ = *event;
		_tmp12_ = _tmp11_.keyval;
		_tmp13_ = gdk_keyval_from_name ("s");
		if (_tmp12_ == _tmp13_) {
			_tmp10_ = TRUE;
		} else {
			GdkEventKey _tmp14_;
			guint _tmp15_;
			guint _tmp16_ = 0U;
			_tmp14_ = *event;
			_tmp15_ = _tmp14_.keyval;
			_tmp16_ = gdk_keyval_from_name ("f");
			_tmp10_ = _tmp15_ == _tmp16_;
		}
		_tmp17_ = _tmp10_;
		if (_tmp17_) {
			GdkEventKey _tmp18_;
			GdkModifierType _tmp19_;
			_tmp18_ = *event;
			_tmp19_ = _tmp18_.state;
			_tmp9_ = (_tmp19_ & GDK_CONTROL_MASK) != 0;
		} else {
			_tmp9_ = FALSE;
		}
		_tmp20_ = _tmp9_;
		if (_tmp20_) {
			ContactsListPane* _tmp21_;
			GtkEntry* _tmp22_;
			_tmp21_ = self->priv->list_pane;
			_tmp22_ = _tmp21_->filter_entry;
			gtk_widget_grab_focus ((GtkWidget*) _tmp22_);
		}
	}
	result = FALSE;
	return result;
}


static void contacts_app_selection_changed (ContactsApp* self, ContactsContact* new_selection) {
	ContactsContactPane* _tmp0_;
	ContactsContact* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->contacts_pane;
	_tmp1_ = new_selection;
	contacts_contact_pane_show_contact (_tmp0_, _tmp1_, FALSE);
}


static void contacts_app_show_individual_data_free (gpointer _data) {
	ContactsAppShowIndividualData* _data_;
	_data_ = _data;
	_g_free0 (_data_->id);
	_g_object_unref0 (_data_->self);
	g_slice_free (ContactsAppShowIndividualData, _data_);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


void contacts_app_show_individual (ContactsApp* self, const gchar* id, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	ContactsAppShowIndividualData* _data_;
	ContactsApp* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	_data_ = g_slice_new0 (ContactsAppShowIndividualData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, contacts_app_show_individual);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, contacts_app_show_individual_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = id;
	_tmp2_ = g_strdup (_tmp1_);
	_data_->id = _tmp2_;
	contacts_app_show_individual_co (_data_);
}


void contacts_app_show_individual_finish (ContactsApp* self, GAsyncResult* _res_) {
	ContactsAppShowIndividualData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static Block1Data* block1_data_ref (Block1Data* _data1_) {
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}


static void block1_data_unref (Block1Data* _data1_) {
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		_g_object_unref0 (_data1_->self);
		_g_free0 (_data1_->id);
		g_slice_free (Block1Data, _data1_);
	}
}


static gboolean __lambda71_ (Block1Data* _data1_, ContactsContact* c) {
	ContactsApp * self;
	gboolean result = FALSE;
	ContactsContact* _tmp0_;
	FolksIndividual* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	self = _data1_->self;
	g_return_val_if_fail (c != NULL, FALSE);
	_tmp0_ = c;
	_tmp1_ = _tmp0_->individual;
	_tmp2_ = folks_individual_get_id (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = _data1_->id;
	result = g_strcmp0 (_tmp3_, _tmp4_) == 0;
	return result;
}


static gboolean ___lambda71__contacts_store_contact_matcher (ContactsContact* c, gpointer self) {
	gboolean result;
	result = __lambda71_ (self, c);
	return result;
}


static void contacts_app_show_individual_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	ContactsAppShowIndividualData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	contacts_app_show_individual_co (_data_);
}


static Block2Data* block2_data_ref (Block2Data* _data2_) {
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}


static void block2_data_unref (Block2Data* _data2_) {
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		block1_data_unref (_data2_->_data1_);
		_data2_->_data1_ = NULL;
		_g_object_unref0 (_data2_->dialog);
		g_slice_free (Block2Data, _data2_);
	}
}


static void ___lambda72_ (Block2Data* _data2_, gint id) {
	Block1Data* _data1_;
	ContactsApp * self;
	GtkMessageDialog* _tmp0_;
	_data1_ = _data2_->_data1_;
	self = _data1_->self;
	_tmp0_ = _data2_->dialog;
	gtk_widget_destroy ((GtkWidget*) _tmp0_);
}


static void ____lambda72__gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self) {
	___lambda72_ (self, response_id);
}


static gboolean contacts_app_show_individual_co (ContactsAppShowIndividualData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data1_ = g_slice_new0 (Block1Data);
	_data_->_data1_->_ref_count_ = 1;
	_data_->_data1_->self = g_object_ref (_data_->self);
	_data_->_tmp0_ = _data_->id;
	_data_->_tmp1_ = g_strdup (_data_->_tmp0_);
	_data_->_data1_->id = _data_->_tmp1_;
	_data_->_data1_->_async_data_ = _data_;
	_data_->_tmp2_ = _data_->self->priv->contacts_store;
	_data_->_state_ = 1;
	contacts_store_find_contact (_data_->_tmp2_, ___lambda71__contacts_store_contact_matcher, _data_->_data1_, contacts_app_show_individual_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp3_ = NULL;
	_data_->_tmp3_ = contacts_store_find_contact_finish (_data_->_tmp2_, _data_->_res_);
	_data_->contact = _data_->_tmp3_;
	_data_->_tmp4_ = _data_->contact;
	if (_data_->_tmp4_ != NULL) {
		_data_->_tmp5_ = _data_->self->priv->list_pane;
		_data_->_tmp6_ = _data_->contact;
		contacts_list_pane_select_contact (_data_->_tmp5_, _data_->_tmp6_, FALSE);
		_data_->_tmp7_ = _data_->self->priv->contacts_pane;
		_data_->_tmp8_ = _data_->contact;
		contacts_contact_pane_show_contact (_data_->_tmp7_, _data_->_tmp8_, FALSE);
	} else {
		_data_->_data2_ = g_slice_new0 (Block2Data);
		_data_->_data2_->_ref_count_ = 1;
		_data_->_data2_->_data1_ = block1_data_ref (_data_->_data1_);
		_data_->_tmp9_ = contacts_app_app;
		_data_->_tmp10_ = _data_->_tmp9_->window;
		_data_->_tmp11_ = NULL;
		_data_->_tmp11_ = _ ("No contact with id %s found");
		_data_->_tmp12_ = _data_->_data1_->id;
		_data_->_tmp13_ = (GtkMessageDialog*) gtk_message_dialog_new (_data_->_tmp10_, GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_ERROR, GTK_BUTTONS_CLOSE, _data_->_tmp11_, _data_->_tmp12_);
		_data_->_tmp14_ = g_object_ref_sink (_data_->_tmp13_);
		_data_->_data2_->dialog = _data_->_tmp14_;
		_data_->_tmp15_ = _data_->_data2_->dialog;
		_data_->_tmp16_ = NULL;
		_data_->_tmp16_ = _ ("Contact not found");
		gtk_window_set_title ((GtkWindow*) _data_->_tmp15_, _data_->_tmp16_);
		_data_->_tmp17_ = _data_->_data2_->dialog;
		gtk_widget_show ((GtkWidget*) _data_->_tmp17_);
		_data_->_tmp18_ = _data_->_data2_->dialog;
		g_signal_connect_data ((GtkDialog*) _data_->_tmp18_, "response", (GCallback) ____lambda72__gtk_dialog_response, block2_data_ref (_data_->_data2_), (GClosureNotify) block2_data_unref, 0);
		block2_data_unref (_data_->_data2_);
		_data_->_data2_ = NULL;
	}
	_g_object_unref0 (_data_->contact);
	block1_data_unref (_data_->_data1_);
	_data_->_data1_ = NULL;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void contacts_app_show_by_email_data_free (gpointer _data) {
	ContactsAppShowByEmailData* _data_;
	_data_ = _data;
	_g_free0 (_data_->email_address);
	_g_object_unref0 (_data_->self);
	g_slice_free (ContactsAppShowByEmailData, _data_);
}


void contacts_app_show_by_email (ContactsApp* self, const gchar* email_address, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	ContactsAppShowByEmailData* _data_;
	ContactsApp* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	_data_ = g_slice_new0 (ContactsAppShowByEmailData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, contacts_app_show_by_email);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, contacts_app_show_by_email_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = email_address;
	_tmp2_ = g_strdup (_tmp1_);
	_data_->email_address = _tmp2_;
	contacts_app_show_by_email_co (_data_);
}


void contacts_app_show_by_email_finish (ContactsApp* self, GAsyncResult* _res_) {
	ContactsAppShowByEmailData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static Block3Data* block3_data_ref (Block3Data* _data3_) {
	g_atomic_int_inc (&_data3_->_ref_count_);
	return _data3_;
}


static void block3_data_unref (Block3Data* _data3_) {
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
		_g_object_unref0 (_data3_->self);
		_g_free0 (_data3_->email_address);
		g_slice_free (Block3Data, _data3_);
	}
}


static gboolean __lambda73_ (Block3Data* _data3_, ContactsContact* c) {
	ContactsApp * self;
	gboolean result = FALSE;
	ContactsContact* _tmp0_;
	const gchar* _tmp1_;
	gboolean _tmp2_ = FALSE;
	self = _data3_->self;
	g_return_val_if_fail (c != NULL, FALSE);
	_tmp0_ = c;
	_tmp1_ = _data3_->email_address;
	_tmp2_ = contacts_contact_has_email (_tmp0_, _tmp1_);
	result = _tmp2_;
	return result;
}


static gboolean ___lambda73__contacts_store_contact_matcher (ContactsContact* c, gpointer self) {
	gboolean result;
	result = __lambda73_ (self, c);
	return result;
}


static void contacts_app_show_by_email_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	ContactsAppShowByEmailData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	contacts_app_show_by_email_co (_data_);
}


static Block4Data* block4_data_ref (Block4Data* _data4_) {
	g_atomic_int_inc (&_data4_->_ref_count_);
	return _data4_;
}


static void block4_data_unref (Block4Data* _data4_) {
	if (g_atomic_int_dec_and_test (&_data4_->_ref_count_)) {
		block3_data_unref (_data4_->_data3_);
		_data4_->_data3_ = NULL;
		_g_object_unref0 (_data4_->dialog);
		g_slice_free (Block4Data, _data4_);
	}
}


static void ___lambda74_ (Block4Data* _data4_, gint id) {
	Block3Data* _data3_;
	ContactsApp * self;
	GtkMessageDialog* _tmp0_;
	_data3_ = _data4_->_data3_;
	self = _data3_->self;
	_tmp0_ = _data4_->dialog;
	gtk_widget_destroy ((GtkWidget*) _tmp0_);
}


static void ____lambda74__gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self) {
	___lambda74_ (self, response_id);
}


static gboolean contacts_app_show_by_email_co (ContactsAppShowByEmailData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data3_ = g_slice_new0 (Block3Data);
	_data_->_data3_->_ref_count_ = 1;
	_data_->_data3_->self = g_object_ref (_data_->self);
	_data_->_tmp0_ = _data_->email_address;
	_data_->_tmp1_ = g_strdup (_data_->_tmp0_);
	_data_->_data3_->email_address = _data_->_tmp1_;
	_data_->_data3_->_async_data_ = _data_;
	_data_->_tmp2_ = _data_->self->priv->contacts_store;
	_data_->_state_ = 1;
	contacts_store_find_contact (_data_->_tmp2_, ___lambda73__contacts_store_contact_matcher, _data_->_data3_, contacts_app_show_by_email_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp3_ = NULL;
	_data_->_tmp3_ = contacts_store_find_contact_finish (_data_->_tmp2_, _data_->_res_);
	_data_->contact = _data_->_tmp3_;
	_data_->_tmp4_ = _data_->contact;
	if (_data_->_tmp4_ != NULL) {
		_data_->_tmp5_ = _data_->self->priv->list_pane;
		_data_->_tmp6_ = _data_->contact;
		contacts_list_pane_select_contact (_data_->_tmp5_, _data_->_tmp6_, FALSE);
		_data_->_tmp7_ = _data_->self->priv->contacts_pane;
		_data_->_tmp8_ = _data_->contact;
		contacts_contact_pane_show_contact (_data_->_tmp7_, _data_->_tmp8_, FALSE);
	} else {
		_data_->_data4_ = g_slice_new0 (Block4Data);
		_data_->_data4_->_ref_count_ = 1;
		_data_->_data4_->_data3_ = block3_data_ref (_data_->_data3_);
		_data_->_tmp9_ = contacts_app_app;
		_data_->_tmp10_ = _data_->_tmp9_->window;
		_data_->_tmp11_ = NULL;
		_data_->_tmp11_ = _ ("No contact with email address %s found");
		_data_->_tmp12_ = _data_->_data3_->email_address;
		_data_->_tmp13_ = (GtkMessageDialog*) gtk_message_dialog_new (_data_->_tmp10_, GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_ERROR, GTK_BUTTONS_CLOSE, _data_->_tmp11_, _data_->_tmp12_);
		_data_->_tmp14_ = g_object_ref_sink (_data_->_tmp13_);
		_data_->_data4_->dialog = _data_->_tmp14_;
		_data_->_tmp15_ = _data_->_data4_->dialog;
		_data_->_tmp16_ = NULL;
		_data_->_tmp16_ = _ ("Contact not found");
		gtk_window_set_title ((GtkWindow*) _data_->_tmp15_, _data_->_tmp16_);
		_data_->_tmp17_ = _data_->_data4_->dialog;
		gtk_widget_show ((GtkWidget*) _data_->_tmp17_);
		_data_->_tmp18_ = _data_->_data4_->dialog;
		g_signal_connect_data ((GtkDialog*) _data_->_tmp18_, "response", (GCallback) ____lambda74__gtk_dialog_response, block4_data_ref (_data_->_data4_), (GClosureNotify) block4_data_unref, 0);
		block4_data_unref (_data_->_data4_);
		_data_->_data4_ = NULL;
	}
	_g_object_unref0 (_data_->contact);
	block3_data_unref (_data_->_data3_);
	_data_->_data3_ = NULL;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static gboolean _contacts_app_window_delete_event_gtk_widget_delete_event (GtkWidget* _sender, GdkEventAny* event, gpointer self) {
	gboolean result;
	result = contacts_app_window_delete_event (self, event);
	return result;
}


static gboolean _contacts_app_window_map_event_gtk_widget_map_event (GtkWidget* _sender, GdkEventAny* event, gpointer self) {
	gboolean result;
	result = contacts_app_window_map_event (self, event);
	return result;
}


static gboolean _contacts_app_window_key_press_event_gtk_widget_key_press_event (GtkWidget* _sender, GdkEventKey* event, gpointer self) {
	gboolean result;
	result = contacts_app_window_key_press_event (self, event);
	return result;
}


static void _contacts_app_selection_changed_contacts_list_pane_selection_changed (ContactsListPane* _sender, ContactsContact* contact, gpointer self) {
	contacts_app_selection_changed (self, contact);
}


static void __lambda75_ (ContactsApp* self) {
	ContactsContactPane* _tmp0_;
	ContactsListPane* _tmp1_;
	_tmp0_ = self->priv->contacts_pane;
	_tmp1_ = self->priv->list_pane;
	contacts_contact_pane_new_contact (_tmp0_, _tmp1_);
}


static void ___lambda75__contacts_list_pane_create_new (ContactsListPane* _sender, gpointer self) {
	__lambda75_ (self);
}


static void contacts_app_create_window (ContactsApp* self) {
	ContactsApp* _tmp2_;
	GtkWindow* _tmp3_;
	GtkWindow* _tmp4_;
	GtkWindow* _tmp5_;
	GtkWindow* _tmp6_;
	const gchar* _tmp7_ = NULL;
	GtkWindow* _tmp8_;
	GtkWindow* _tmp9_;
	GtkWindow* _tmp10_;
	GtkWindow* _tmp11_;
	GtkGrid* _tmp12_;
	GtkGrid* _tmp13_;
	GtkGrid* grid;
	GtkWindow* _tmp14_;
	ContactsStore* _tmp15_;
	ContactsListPane* _tmp16_;
	ContactsListPane* _tmp17_;
	ContactsListPane* _tmp18_;
	ContactsListPane* _tmp19_;
	ContactsListPane* _tmp20_;
	ContactsStore* _tmp21_;
	ContactsContactPane* _tmp22_;
	ContactsContactPane* _tmp23_;
	ContactsContactPane* _tmp24_;
	ContactsContactPane* _tmp25_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	{
		GtkCssProvider* _tmp0_;
		GtkCssProvider* provider;
		GdkScreen* _tmp1_ = NULL;
		_tmp0_ = gtk_css_provider_new ();
		provider = _tmp0_;
		gtk_css_provider_load_from_path (provider, PKGDATADIR "/" "gnome-contacts.css", &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_object_unref0 (provider);
			goto __catch0_g_error;
		}
		_tmp1_ = gdk_screen_get_default ();
		gtk_style_context_add_provider_for_screen (_tmp1_, (GtkStyleProvider*) provider, (guint) GTK_STYLE_PROVIDER_PRIORITY_APPLICATION);
		_g_object_unref0 (provider);
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error_);
		_inner_error_ = NULL;
		g_warning ("contacts-app.vala:102: Failed to load custom CSS");
	}
	__finally0:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp2_ = _g_object_ref0 (self);
	_g_object_unref0 (contacts_app_app);
	contacts_app_app = _tmp2_;
	_tmp3_ = (GtkWindow*) gtk_window_new (GTK_WINDOW_TOPLEVEL);
	_tmp4_ = g_object_ref_sink (_tmp3_);
	_g_object_unref0 (self->window);
	self->window = _tmp4_;
	_tmp5_ = self->window;
	gtk_window_set_application (_tmp5_, (GtkApplication*) self);
	_tmp6_ = self->window;
	_tmp7_ = _ ("Contacts");
	gtk_window_set_title (_tmp6_, _tmp7_);
	_tmp8_ = self->window;
	gtk_widget_set_size_request ((GtkWidget*) _tmp8_, 745, 510);
	_tmp9_ = self->window;
	g_signal_connect_object ((GtkWidget*) _tmp9_, "delete-event", (GCallback) _contacts_app_window_delete_event_gtk_widget_delete_event, self, 0);
	_tmp10_ = self->window;
	g_signal_connect_object ((GtkWidget*) _tmp10_, "map-event", (GCallback) _contacts_app_window_map_event_gtk_widget_map_event, self, 0);
	_tmp11_ = self->window;
	g_signal_connect_object ((GtkWidget*) _tmp11_, "key-press-event", (GCallback) _contacts_app_window_key_press_event_gtk_widget_key_press_event, self, 0);
	_tmp12_ = (GtkGrid*) gtk_grid_new ();
	_tmp13_ = g_object_ref_sink (_tmp12_);
	grid = _tmp13_;
	_tmp14_ = self->window;
	gtk_container_add ((GtkContainer*) _tmp14_, (GtkWidget*) grid);
	_tmp15_ = self->priv->contacts_store;
	_tmp16_ = contacts_list_pane_new (_tmp15_);
	_tmp17_ = g_object_ref_sink (_tmp16_);
	_g_object_unref0 (self->priv->list_pane);
	self->priv->list_pane = _tmp17_;
	_tmp18_ = self->priv->list_pane;
	g_signal_connect_object (_tmp18_, "selection-changed", (GCallback) _contacts_app_selection_changed_contacts_list_pane_selection_changed, self, 0);
	_tmp19_ = self->priv->list_pane;
	g_signal_connect_object (_tmp19_, "create-new", (GCallback) ___lambda75__contacts_list_pane_create_new, self, 0);
	_tmp20_ = self->priv->list_pane;
	gtk_grid_attach (grid, (GtkWidget*) _tmp20_, 0, 0, 1, 2);
	_tmp21_ = self->priv->contacts_store;
	_tmp22_ = contacts_contact_pane_new (_tmp21_);
	_tmp23_ = g_object_ref_sink (_tmp22_);
	_g_object_unref0 (self->priv->contacts_pane);
	self->priv->contacts_pane = _tmp23_;
	_tmp24_ = self->priv->contacts_pane;
	gtk_widget_set_hexpand ((GtkWidget*) _tmp24_, TRUE);
	_tmp25_ = self->priv->contacts_pane;
	gtk_grid_attach (grid, (GtkWidget*) _tmp25_, 1, 0, 1, 2);
	gtk_widget_show_all ((GtkWidget*) grid);
	_g_object_unref0 (grid);
}


static void contacts_app_real_startup (GApplication* base) {
	ContactsApp * self;
	ContactsStore* _tmp0_;
	self = (ContactsApp*) base;
	contacts_ensure_eds_accounts ();
	_tmp0_ = contacts_store_new ();
	_g_object_unref0 (self->priv->contacts_store);
	self->priv->contacts_store = _tmp0_;
}


static void ___lambda76_ (ContactsApp* self) {
	ContactsApp* _tmp0_;
	GtkWindow* _tmp1_;
	_tmp0_ = contacts_app_app;
	_tmp1_ = _tmp0_->window;
	gtk_widget_show ((GtkWidget*) _tmp1_);
}


static void ____lambda76__contacts_store_quiescent (ContactsStore* _sender, gpointer self) {
	___lambda76_ (self);
}


static gboolean ___lambda77_ (ContactsApp* self) {
	gboolean result = FALSE;
	ContactsApp* _tmp0_;
	GtkWindow* _tmp1_;
	_tmp0_ = contacts_app_app;
	_tmp1_ = _tmp0_->window;
	gtk_widget_show ((GtkWidget*) _tmp1_);
	result = FALSE;
	return result;
}


static gboolean ____lambda77__gsource_func (gpointer self) {
	gboolean result;
	result = ___lambda77_ (self);
	return result;
}


static void contacts_app_real_activate (GApplication* base) {
	ContactsApp * self;
	GtkWindow* _tmp0_;
	self = (ContactsApp*) base;
	_tmp0_ = self->window;
	if (_tmp0_ == NULL) {
		ContactsStore* _tmp1_;
		contacts_app_create_window (self);
		_tmp1_ = self->priv->contacts_store;
		g_signal_connect_object (_tmp1_, "quiescent", (GCallback) ____lambda76__contacts_store_quiescent, self, 0);
		g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 500, ____lambda77__gsource_func, g_object_ref (self), g_object_unref);
	} else {
		GtkWindow* _tmp2_;
		_tmp2_ = self->window;
		gtk_window_present (_tmp2_);
	}
}


static gint contacts_app_real_command_line (GApplication* base, GApplicationCommandLine* command_line) {
	ContactsApp * self;
	gint result = 0;
	GApplicationCommandLine* _tmp0_;
	gint _tmp1_ = 0;
	gchar** _tmp2_ = NULL;
	gchar** args;
	gint args_length1;
	gint _args_size_;
	gchar** _tmp3_;
	gint _tmp3__length1;
	gchar** _args;
	gint _args_length1;
	gint __args_size_;
	GOptionContext* _tmp4_;
	GOptionContext* context;
	GOptionContext* _tmp5_;
	GOptionContext* _tmp6_;
	GOptionContext* _tmp7_;
	GOptionGroup* _tmp8_ = NULL;
	const gchar* _tmp12_;
	const gchar* _tmp15_;
	GError * _inner_error_ = NULL;
	self = (ContactsApp*) base;
	g_return_val_if_fail (command_line != NULL, 0);
	_tmp0_ = command_line;
	_tmp2_ = g_application_command_line_get_arguments (_tmp0_, &_tmp1_);
	args = _tmp2_;
	args_length1 = _tmp1_;
	_args_size_ = args_length1;
	_tmp3_ = args;
	_tmp3__length1 = args_length1;
	_args = _tmp3_;
	_args_length1 = _tmp3__length1;
	__args_size_ = _args_length1;
	_tmp4_ = g_option_context_new ("— contact management");
	context = _tmp4_;
	_tmp5_ = context;
	g_option_context_add_main_entries (_tmp5_, CONTACTS_APP_options, GETTEXT_PACKAGE);
	_tmp6_ = context;
	g_option_context_set_translation_domain (_tmp6_, GETTEXT_PACKAGE);
	_tmp7_ = context;
	_tmp8_ = gtk_get_option_group (TRUE);
	g_option_context_add_group (_tmp7_, _tmp8_);
	_g_free0 (contacts_app_individual_id);
	contacts_app_individual_id = NULL;
	_g_free0 (contacts_app_email_address);
	contacts_app_email_address = NULL;
	{
		GOptionContext* _tmp9_;
		_tmp9_ = context;
		g_option_context_parse (_tmp9_, &_args_length1, &_args, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch1_g_error;
		}
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* e = NULL;
		GError* _tmp10_;
		const gchar* _tmp11_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp10_ = e;
		_tmp11_ = _tmp10_->message;
		g_printerr ("Unable to parse: %s\n", _tmp11_);
		result = 1;
		_g_error_free0 (e);
		_g_option_context_free0 (context);
		args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
		return result;
	}
	__finally1:
	if (_inner_error_ != NULL) {
		_g_option_context_free0 (context);
		args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	g_application_activate ((GApplication*) self);
	_tmp12_ = contacts_app_individual_id;
	if (_tmp12_ != NULL) {
		ContactsApp* _tmp13_;
		const gchar* _tmp14_;
		_tmp13_ = contacts_app_app;
		_tmp14_ = contacts_app_individual_id;
		contacts_app_show_individual (_tmp13_, _tmp14_, NULL, NULL);
	}
	_tmp15_ = contacts_app_email_address;
	if (_tmp15_ != NULL) {
		ContactsApp* _tmp16_;
		const gchar* _tmp17_;
		_tmp16_ = contacts_app_app;
		_tmp17_ = contacts_app_email_address;
		contacts_app_show_by_email (_tmp16_, _tmp17_, NULL, NULL);
	}
	result = 0;
	_g_option_context_free0 (context);
	args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
	return result;
}


ContactsApp* contacts_app_construct (GType object_type) {
	ContactsApp * self = NULL;
	self = (ContactsApp*) g_object_new (object_type, "application-id", "org.gnome.Contacts", "flags", G_APPLICATION_HANDLES_COMMAND_LINE, NULL);
	return self;
}


ContactsApp* contacts_app_new (void) {
	return contacts_app_construct (CONTACTS_TYPE_APP);
}


static void contacts_app_class_init (ContactsAppClass * klass) {
	contacts_app_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ContactsAppPrivate));
	G_APPLICATION_CLASS (klass)->startup = contacts_app_real_startup;
	G_APPLICATION_CLASS (klass)->activate = contacts_app_real_activate;
	G_APPLICATION_CLASS (klass)->command_line = contacts_app_real_command_line;
	G_OBJECT_CLASS (klass)->finalize = contacts_app_finalize;
}


static void contacts_app_instance_init (ContactsApp * self) {
	self->priv = CONTACTS_APP_GET_PRIVATE (self);
}


static void contacts_app_finalize (GObject* obj) {
	ContactsApp * self;
	self = CONTACTS_APP (obj);
	_g_object_unref0 (self->window);
	_g_object_unref0 (self->priv->contacts_store);
	_g_object_unref0 (self->priv->list_pane);
	_g_object_unref0 (self->priv->contacts_pane);
	G_OBJECT_CLASS (contacts_app_parent_class)->finalize (obj);
}


GType contacts_app_get_type (void) {
	static volatile gsize contacts_app_type_id__volatile = 0;
	if (g_once_init_enter (&contacts_app_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ContactsAppClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) contacts_app_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ContactsApp), 0, (GInstanceInitFunc) contacts_app_instance_init, NULL };
		GType contacts_app_type_id;
		contacts_app_type_id = g_type_register_static (GTK_TYPE_APPLICATION, "ContactsApp", &g_define_type_info, 0);
		g_once_init_leave (&contacts_app_type_id__volatile, contacts_app_type_id);
	}
	return contacts_app_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



