# This is a shell script that calls functions and scripts from
# tml@iki.fi's personal work envronment. It is not expected to be
# usable unmodified by others, and is included only for reference.

MOD=libglade
VER=2.6.2-20080525
THIS=$MOD-$VER
HEX=`echo $THIS | md5sum | cut -d' ' -f1`
DEPS=`/devel/src/tml/latest.sh glib atk pango cairo gtk+`
sed -e 's/need_relink=yes/need_relink=no # no way --tml/' <ltmain.sh >ltmain.temp && mv ltmain.temp ltmain.sh

# Avoid using "file" in libtool. Otherwise libtool won't create a
# shared library, and give the extremely confusing and annoying
# warning "Trying to link with static lib archive [...] But I
# can only do this if you have shared version of the
# library, which you do not appear to have."

# Screw libtool. I know what I am doing. Yes, I do want to link with a
# static libintl now. (The proxy-libintl libintl wrapper.)

sed -e 's!file /!dont-want-to-use-file!' <configure >configure.temp && mv configure.temp configure

usedev

unset MY_PKG_CONFIG_PATH
for D in $DEPS; do
    PATH=/devel/dist/$D/bin:$PATH
    MY_PKG_CONFIG_PATH=/devel/dist/$D/lib/pkgconfig:$MY_PKG_CONFIG_PATH
done

baseverlen=`expr match $VER '[0-9]*\.[0-9]*\.[0-9]*'`
basever=`expr substr $VER 1 $baseverlen`

[ $basever = 2.6.2 ] &&
patch --verbose -p0 <<'EOF'
--- glade/glade.def
+++ glade/glade.def
@@ -18,6 +18,7 @@
 	glade_standard_build_widget
 	glade_xml_build_widget
 	glade_xml_construct
+	glade_xml_construct_from_buffer
 	glade_xml_ensure_accel
 	glade_xml_get_type
 	glade_xml_get_widget
--- glade/glade-xml.c
+++ glade/glade-xml.c
@@ -256,7 +256,7 @@
     if( !glade_xml_construct_from_buffer(self, buffer, size, root, domain) )
     {
        /* Clean up, the parser was unable to load the object */
-       g_free(self);
+       g_object_unref(self);
        return NULL;
     }
 
EOF

PKG_CONFIG_PATH=$MY_PKG_CONFIG_PATH:$PKG_CONFIG_PATH CC='gcc -mtune=pentium3 -mthreads' CPPFLAGS='-I/opt/win_iconv/include -I/opt/proxy-libintl/include' LDFLAGS='-L/opt/proxy-libintl/lib' CFLAGS=-O2 ./configure --disable-gtk-doc --disable-static --prefix=c:/devel/target/$HEX &&
libtoolcacheize &&
unset MY_PKG_CONFIG_PATH &&

PATH=/devel/target/$HEX/bin:.libs:$PATH make install &&
PATH=/devel/target/$HEX/bin:$PATH make check &&
./libglade-zip &&

( (
[ $VER != $basever ] && {
mv /tmp/$MOD-$basever.zip /tmp/$MOD-$VER.zip &&
mv /tmp/$MOD-dev-$basever.zip /tmp/$MOD-dev-$VER.zip
}
) || true) &&

(cd /devel/src/tml && zip /tmp/$MOD-dev-$VER.zip make/$THIS.sh) &&
manifestify /tmp/$MOD*-$VER.zip
