/*
Copyright (c) 2020-2025 Rupert Carmichael
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

1. Redistributions of source code must retain the above copyright notice, this
   list of conditions and the following disclaimer.

2. Redistributions in binary form must reproduce the above copyright notice,
   this list of conditions and the following disclaimer in the documentation
   and/or other materials provided with the distribution.

3. Neither the name of the copyright holder nor the names of its
   contributors may be used to endorse or promote products derived from
   this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE
FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

#ifndef JCV_CRVISION_H
#define JCV_CRVISION_H

#include "jcv_sizes.h"

#define SIZE_CRVBIOS    SIZE_2K
#define SIZE_CRVRAM     SIZE_1K

void jcv_crvision_input_set_callback(unsigned (*)(const void*, int), void*);

void* jcv_crvision_get_ram_data(void);

size_t jcv_crvision_state_size(void);
void jcv_crvision_state_load_raw(const void*);
const void* jcv_crvision_state_save_raw(void);

int jcv_crvision_bios_load_file(const char*);
int jcv_crvision_bios_load(void*, size_t);
int jcv_crvision_rom_load(void*, size_t);

uint8_t jcv_crvision_mem_rd(uint16_t);
void jcv_crvision_mem_wr(uint16_t, uint8_t);

void jcv_crvision_exec(void);
void jcv_crvision_init(void);
void jcv_crvision_deinit(void);

#endif
