/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.log;

import java.net.URI;
import java.net.URISyntaxException;
import net.sf.saxon.s9api.XdmNode;
import org.apache.tools.ant.Location;
import org.dita.dost.exception.DITAOTException;
import org.dita.dost.util.URLUtils;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXParseException;

public final class MessageBean {
    public static final String FATAL = Type.FATAL.name();
    public static final String ERROR = Type.ERROR.name();
    public static final String WARN = Type.WARN.name();
    public static final String INFO = Type.INFO.name();
    public static final String DEBUG = Type.DEBUG.name();
    public final String id;
    public final Type type;
    public final String reason;
    private final String response;
    private URI srcFile;
    private int srcLine = -1;
    private int srcColumn = -1;

    @Deprecated
    public MessageBean(String mbId, String mbType, String mbReason, String mbResponse) {
        this.id = mbId;
        this.type = Type.valueOf(mbType);
        this.reason = mbReason;
        this.response = mbResponse;
    }

    public MessageBean(String mbId, Type mbType, String mbReason, String mbResponse) {
        this.id = mbId;
        this.type = mbType;
        this.reason = mbReason;
        this.response = mbResponse;
    }

    public MessageBean(MessageBean message) {
        this(message.id, message.type, message.reason, message.response);
    }

    @Deprecated
    public String getId() {
        return this.id;
    }

    @Deprecated
    public String getReason() {
        return this.reason;
    }

    @Deprecated
    public String getResponse() {
        return this.response;
    }

    @Deprecated
    public String getType() {
        return this.type != null ? this.type.name() : null;
    }

    public MessageBean setLocation(Locator locator) {
        if (locator == null) {
            return this;
        }
        MessageBean ret = new MessageBean(this);
        if (locator.getSystemId() != null) {
            try {
                ret.srcFile = new URI(locator.getSystemId());
            }
            catch (URISyntaxException e) {
                throw new RuntimeException("Failed to parse URI '" + locator.getSystemId() + "': " + e.getMessage(), e);
            }
        }
        ret.srcLine = locator.getLineNumber();
        ret.srcColumn = locator.getColumnNumber();
        return ret;
    }

    public MessageBean setLocation(Attributes atts) {
        int delim;
        int sep;
        String xtrc;
        MessageBean ret = new MessageBean(this);
        URI xtrf = URLUtils.toURI(atts.getValue("xtrf"));
        if (xtrf != null) {
            ret.srcFile = xtrf;
        }
        if ((xtrc = atts.getValue("xtrc")) != null && (sep = xtrc.indexOf(59)) != -1 && (delim = xtrc.indexOf(":", sep + 1)) != -1) {
            ret.srcLine = Integer.parseInt(xtrc.substring(sep + 1, delim));
            ret.srcColumn = Integer.parseInt(xtrc.substring(delim + 1));
        }
        return ret;
    }

    public MessageBean setLocation(Element elem) {
        int delim;
        int sep;
        String xtrc;
        MessageBean ret = new MessageBean(this);
        String xtrf = elem.getAttribute("xtrf");
        if (!xtrf.isEmpty()) {
            ret.srcFile = URLUtils.toURI(xtrf);
        }
        if (!(xtrc = elem.getAttribute("xtrc")).isEmpty() && (sep = xtrc.indexOf(59)) != -1 && (delim = xtrc.indexOf(":", sep + 1)) != -1) {
            ret.srcLine = Integer.parseInt(xtrc.substring(sep + 1, delim));
            ret.srcColumn = Integer.parseInt(xtrc.substring(delim + 1));
        }
        return ret;
    }

    public MessageBean setLocation(XdmNode elem) {
        int delim;
        int sep;
        String xtrc;
        MessageBean ret = new MessageBean(this);
        String xtrf = elem.attribute("xtrf");
        if (xtrf != null && !xtrf.isEmpty()) {
            ret.srcFile = URLUtils.toURI(xtrf);
        }
        if ((xtrc = elem.attribute("xtrc")) != null && !xtrc.isEmpty() && (sep = xtrc.indexOf(59)) != -1 && (delim = xtrc.indexOf(":", sep + 1)) != -1) {
            ret.srcLine = Integer.parseInt(xtrc.substring(sep + 1, delim));
            ret.srcColumn = Integer.parseInt(xtrc.substring(delim + 1));
        }
        return ret;
    }

    public MessageBean setLocation(Location location) {
        MessageBean ret = new MessageBean(this);
        ret.srcFile = URLUtils.toURI(location.getFileName());
        ret.srcLine = location.getLineNumber();
        ret.srcColumn = location.getColumnNumber();
        return ret;
    }

    public MessageBean setLocation(SAXParseException exception) {
        MessageBean ret = new MessageBean(this);
        ret.srcFile = URLUtils.toURI(exception.getSystemId());
        ret.srcLine = exception.getLineNumber();
        ret.srcColumn = exception.getColumnNumber();
        return ret;
    }

    public String toString() {
        StringBuilder buff = new StringBuilder(256);
        if (this.srcFile != null) {
            buff.append(this.srcFile);
            if (this.srcLine != -1 && this.srcColumn != -1) {
                buff.append(':').append((Object)this.srcLine).append(':').append((Object)this.srcColumn);
            }
            buff.append(": ");
        }
        buff.append("[").append(this.id).append("]");
        buff.append("[").append((Object)this.type).append("] ");
        buff.append(this.reason);
        if (this.response != null) {
            buff.append(" ").append(this.response);
        }
        return buff.toString();
    }

    public DITAOTException toException() {
        return new DITAOTException(this.toString());
    }

    public static enum Type {
        FATAL,
        ERROR,
        WARN,
        INFO,
        DEBUG;

    }
}

