/*
 * Decompiled with CFR 0.152.
 */
package gnu.bytecode;

import gnu.bytecode.Attribute;
import gnu.bytecode.ClassType;
import gnu.bytecode.ClassTypeWriter;
import gnu.bytecode.ConstantPool;
import gnu.bytecode.CpoolClass;
import gnu.bytecode.CpoolEntry;
import gnu.bytecode.Method;
import java.io.DataOutputStream;
import java.io.IOException;

public class EnclosingMethodAttr
extends Attribute {
    int class_index;
    int method_index;
    Method method;

    public EnclosingMethodAttr(ClassType classType) {
        super("EnclosingMethod");
        this.addToFrontOf(classType);
    }

    public EnclosingMethodAttr(int n, int n2, ClassType classType) {
        this(classType);
        this.class_index = n;
        this.method_index = n2;
    }

    public static EnclosingMethodAttr getFirstEnclosingMethod(Attribute attribute) {
        while (attribute != null && !(attribute instanceof EnclosingMethodAttr)) {
            attribute = attribute.next;
        }
        return (EnclosingMethodAttr)attribute;
    }

    public int getLength() {
        return 4;
    }

    public void assignConstants(ClassType classType) {
        super.assignConstants(classType);
        if (this.method != null) {
            ConstantPool constantPool = classType.getConstants();
            this.class_index = constantPool.addClass(this.method.getDeclaringClass()).getIndex();
            this.method_index = constantPool.addNameAndType(this.method).getIndex();
        }
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeShort(this.class_index);
        dataOutputStream.writeShort(this.method_index);
    }

    public void print(ClassTypeWriter classTypeWriter) {
        ClassType classType = (ClassType)this.container;
        ConstantPool constantPool = classType.getConstants();
        classTypeWriter.print("Attribute \"");
        classTypeWriter.print(this.getName());
        classTypeWriter.print("\", length:");
        classTypeWriter.println(this.getLength());
        classTypeWriter.print("  class: ");
        classTypeWriter.printOptionalIndex(this.class_index);
        CpoolEntry cpoolEntry = constantPool.getForced(this.class_index, 7);
        classTypeWriter.print(((CpoolClass)cpoolEntry).getStringName());
        classTypeWriter.print(", method: ");
        classTypeWriter.printOptionalIndex(this.method_index);
        cpoolEntry = constantPool.getForced(this.method_index, 12);
        cpoolEntry.print(classTypeWriter, 0);
        classTypeWriter.println();
    }
}

