/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.util.threads;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.apache.sshd.common.util.ReflectionUtils;
import org.apache.sshd.common.util.threads.CloseableExecutorService;
import org.apache.sshd.common.util.threads.NoCloseExecutor;
import org.apache.sshd.common.util.threads.SshThreadPoolExecutor;
import org.apache.sshd.common.util.threads.SshdThreadFactory;

public final class ThreadUtils {
    private ThreadUtils() {
        throw new UnsupportedOperationException("No instance");
    }

    public static CloseableExecutorService protectExecutorServiceShutdown(CloseableExecutorService executorService, boolean shutdownOnExit) {
        if (executorService == null || shutdownOnExit || executorService instanceof NoCloseExecutor) {
            return executorService;
        }
        return new NoCloseExecutor(executorService);
    }

    public static CloseableExecutorService noClose(CloseableExecutorService executorService) {
        return ThreadUtils.protectExecutorServiceShutdown(executorService, false);
    }

    public static ClassLoader resolveDefaultClassLoader(Object anchor) {
        return ThreadUtils.resolveDefaultClassLoader(anchor == null ? null : anchor.getClass());
    }

    public static Iterable<ClassLoader> resolveDefaultClassLoaders(Object anchor) {
        return ThreadUtils.resolveDefaultClassLoaders(anchor == null ? null : anchor.getClass());
    }

    public static Iterable<ClassLoader> resolveDefaultClassLoaders(Class<?> anchor) {
        return () -> ThreadUtils.iterateDefaultClassLoaders(anchor);
    }

    public static Class<?> resolveDefaultClass(Class<?> anchor, String className) {
        return ThreadUtils.resolveDefaultClass(ThreadUtils.resolveDefaultClassLoaders(anchor), className);
    }

    public static Class<?> resolveDefaultClass(Iterable<? extends ClassLoader> cls, String className) {
        for (ClassLoader classLoader : cls) {
            try {
                return classLoader.loadClass(className);
            }
            catch (Throwable throwable) {
            }
        }
        return null;
    }

    public static <T> T createDefaultInstance(Class<?> anchor, Class<? extends T> targetType, String className) throws ReflectiveOperationException {
        return ThreadUtils.createDefaultInstance(ThreadUtils.resolveDefaultClassLoaders(anchor), targetType, className);
    }

    public static <T> T createDefaultInstance(ClassLoader cl, Class<? extends T> targetType, String className) throws ReflectiveOperationException {
        Class<?> instanceType = cl.loadClass(className);
        return ReflectionUtils.newInstance(instanceType, targetType);
    }

    public static <T> T createDefaultInstance(Iterable<? extends ClassLoader> cls, Class<? extends T> targetType, String className) throws ReflectiveOperationException {
        for (ClassLoader classLoader : cls) {
            try {
                return ThreadUtils.createDefaultInstance(classLoader, targetType, className);
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
        }
        throw new ClassNotFoundException(className);
    }

    public static ClassLoader resolveDefaultClassLoader(Class<?> anchor) {
        Thread thread = Thread.currentThread();
        ClassLoader cl = thread.getContextClassLoader();
        if (cl != null) {
            return cl;
        }
        if (anchor != null) {
            cl = anchor.getClassLoader();
        }
        if (cl == null) {
            cl = ClassLoader.getSystemClassLoader();
        }
        return cl;
    }

    public static Iterator<ClassLoader> iterateDefaultClassLoaders(Class<?> anchor) {
        final Class effectiveAnchor = anchor == null ? ThreadUtils.class : anchor;
        return new Iterator<ClassLoader>(){
            private final Supplier<? extends ClassLoader>[] suppliers = new Supplier[]{() -> {
                Thread thread = Thread.currentThread();
                return thread.getContextClassLoader();
            }, () -> effectiveAnchor.getClassLoader(), ClassLoader::getSystemClassLoader};
            private int index;

            @Override
            public boolean hasNext() {
                while (this.index < this.suppliers.length) {
                    Supplier<? extends ClassLoader> scl = this.suppliers[this.index];
                    ClassLoader cl = scl.get();
                    if (cl != null) {
                        return true;
                    }
                    ++this.index;
                }
                return false;
            }

            @Override
            public ClassLoader next() {
                if (this.index >= this.suppliers.length) {
                    throw new NoSuchElementException("All elements exhausted");
                }
                Supplier<? extends ClassLoader> scl = this.suppliers[this.index];
                ++this.index;
                return scl.get();
            }
        };
    }

    public static CloseableExecutorService newFixedThreadPoolIf(CloseableExecutorService executorService, String poolName, int nThreads) {
        return executorService == null ? ThreadUtils.newFixedThreadPool(poolName, nThreads) : executorService;
    }

    public static CloseableExecutorService newFixedThreadPool(String poolName, int nThreads) {
        return new SshThreadPoolExecutor(nThreads, nThreads, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), new SshdThreadFactory(poolName), new ThreadPoolExecutor.CallerRunsPolicy());
    }

    public static CloseableExecutorService newCachedThreadPoolIf(CloseableExecutorService executorService, String poolName) {
        return executorService == null ? ThreadUtils.newCachedThreadPool(poolName) : executorService;
    }

    public static CloseableExecutorService newCachedThreadPool(String poolName) {
        return new SshThreadPoolExecutor(0, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), new SshdThreadFactory(poolName), new ThreadPoolExecutor.CallerRunsPolicy());
    }

    public static ScheduledExecutorService newSingleThreadScheduledExecutor(String poolName) {
        return new ScheduledThreadPoolExecutor(1, new SshdThreadFactory(poolName));
    }

    public static CloseableExecutorService newSingleThreadExecutor(String poolName) {
        return ThreadUtils.newFixedThreadPool(poolName, 1);
    }
}

