/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.staging;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.egit.core.AdapterUtils;
import org.eclipse.egit.core.RepositoryUtil;
import org.eclipse.egit.core.UnitOfWork;
import org.eclipse.egit.core.internal.Utils;
import org.eclipse.egit.core.internal.gerrit.GerritUtil;
import org.eclipse.egit.core.internal.indexdiff.IndexDiffCache;
import org.eclipse.egit.core.internal.indexdiff.IndexDiffCacheEntry;
import org.eclipse.egit.core.internal.indexdiff.IndexDiffChangedListener;
import org.eclipse.egit.core.internal.indexdiff.IndexDiffData;
import org.eclipse.egit.core.internal.job.JobUtil;
import org.eclipse.egit.core.internal.job.RuleUtil;
import org.eclipse.egit.core.internal.signing.GpgSetup;
import org.eclipse.egit.core.op.AssumeUnchangedOperation;
import org.eclipse.egit.core.op.CommitOperation;
import org.eclipse.egit.core.op.DiscardChangesOperation;
import org.eclipse.egit.core.op.IEGitOperation;
import org.eclipse.egit.core.op.UntrackOperation;
import org.eclipse.egit.core.project.RepositoryMapping;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.JobFamilies;
import org.eclipse.egit.ui.UIUtils;
import org.eclipse.egit.ui.internal.ActionUtils;
import org.eclipse.egit.ui.internal.CommonUtils;
import org.eclipse.egit.ui.internal.UIIcons;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.actions.BooleanPrefAction;
import org.eclipse.egit.ui.internal.commands.shared.AbortRebaseCommand;
import org.eclipse.egit.ui.internal.commands.shared.AbstractRebaseCommandHandler;
import org.eclipse.egit.ui.internal.commands.shared.ContinueRebaseCommand;
import org.eclipse.egit.ui.internal.commands.shared.SkipRebaseCommand;
import org.eclipse.egit.ui.internal.commit.CommitHelper;
import org.eclipse.egit.ui.internal.commit.CommitJob;
import org.eclipse.egit.ui.internal.commit.CommitMessageHistory;
import org.eclipse.egit.ui.internal.commit.CommitProposalProcessor;
import org.eclipse.egit.ui.internal.commit.DiffViewer;
import org.eclipse.egit.ui.internal.commit.PushSettings;
import org.eclipse.egit.ui.internal.components.DropDownMenuAction;
import org.eclipse.egit.ui.internal.components.PartVisibilityListener;
import org.eclipse.egit.ui.internal.components.RepositoryMenuUtil;
import org.eclipse.egit.ui.internal.decorators.IProblemDecoratable;
import org.eclipse.egit.ui.internal.decorators.ProblemLabelDecorator;
import org.eclipse.egit.ui.internal.dialogs.CommandConfirmation;
import org.eclipse.egit.ui.internal.dialogs.CommitMessageArea;
import org.eclipse.egit.ui.internal.dialogs.CommitMessageComponent;
import org.eclipse.egit.ui.internal.dialogs.CommitMessageComponentState;
import org.eclipse.egit.ui.internal.dialogs.CommitMessageComponentStateManager;
import org.eclipse.egit.ui.internal.dialogs.ICommitMessageComponentNotifications;
import org.eclipse.egit.ui.internal.dialogs.SpellcheckableMessageArea;
import org.eclipse.egit.ui.internal.operations.DeletePathsOperationUI;
import org.eclipse.egit.ui.internal.operations.IgnoreOperationUI;
import org.eclipse.egit.ui.internal.push.PushMode;
import org.eclipse.egit.ui.internal.push.PushWizardDialog;
import org.eclipse.egit.ui.internal.push.SimpleConfigurePushDialog;
import org.eclipse.egit.ui.internal.repository.RepositoryTreeNodeLabelProvider;
import org.eclipse.egit.ui.internal.repository.tree.RepositoryNode;
import org.eclipse.egit.ui.internal.repository.tree.RepositoryTreeNode;
import org.eclipse.egit.ui.internal.selection.MultiViewerSelectionProvider;
import org.eclipse.egit.ui.internal.selection.RepositorySelectionProvider;
import org.eclipse.egit.ui.internal.staging.CommitMessagePreviewer;
import org.eclipse.egit.ui.internal.staging.ConflictStateHoverManager;
import org.eclipse.egit.ui.internal.staging.ReplaceConflictMenu;
import org.eclipse.egit.ui.internal.staging.StagingEntry;
import org.eclipse.egit.ui.internal.staging.StagingFolderEntry;
import org.eclipse.egit.ui.internal.staging.StagingViewContentProvider;
import org.eclipse.egit.ui.internal.staging.StagingViewLabelProvider;
import org.eclipse.egit.ui.internal.staging.StagingViewTooltips;
import org.eclipse.egit.ui.internal.staging.ToggleableLabel;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.ControlContribution;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.DialogSettings;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.LayoutConstants;
import org.eclipse.jface.preference.IPersistentPreferenceStore;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.util.Util;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ContentViewer;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.IViewerLabelProvider;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerLabel;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jgit.annotations.NonNull;
import org.eclipse.jgit.annotations.Nullable;
import org.eclipse.jgit.api.AddCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.ResetCommand;
import org.eclipse.jgit.api.RmCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.api.errors.NoFilepatternException;
import org.eclipse.jgit.events.ListenerHandle;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.CommitConfig;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.IndexDiff;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.RepositoryState;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.transport.RemoteConfig;
import org.eclipse.jgit.util.StringUtils;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IPartService;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.operations.UndoRedoActionGroup;
import org.eclipse.ui.part.IShowInSource;
import org.eclipse.ui.part.IShowInTarget;
import org.eclipse.ui.part.ShowInContext;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.progress.IWorkbenchSiteProgressService;
import org.eclipse.ui.progress.WorkbenchJob;
import org.eclipse.ui.services.IServiceLocator;

public class StagingView
extends ViewPart
implements IShowInSource,
IShowInTarget {
    public static final String VIEW_ID = "org.eclipse.egit.ui.StagingView";
    private static final String CSS_CLASS = "org-eclipse-egit-ui-StagingView";
    private static final String EMPTY_STRING = "";
    private static final String SORT_ITEM_TOOLBAR_ID = "sortItem";
    private static final String HIDE_UNTRACKED_TOOLBAR_ID = "hideUntracked";
    private static final String EXPAND_ALL_ITEM_TOOLBAR_ID = "expandAllItem";
    private static final String COLLAPSE_ALL_ITEM_TOOLBAR_ID = "collapseAllItem";
    private static final String STORE_SORT_STATE = "sortItemState";
    private static final String MAIN_SASH_FORM_ORIENTATION_VERTICAL = "MAIN_SASH_FORM_ORIENTATION_VERTICAL";
    private static final String HORIZONTAL_SASH_FORM_WEIGHT = "HORIZONTAL_SASH_FORM_WEIGHT";
    private static final String STAGING_SASH_FORM_WEIGHT = "STAGING_SASH_FORM_WEIGHT";
    private FormToolkit toolkit;
    private Form form;
    private RepositoryNode titleNode;
    private final Map<File, ViewerLabel> titleLabels = new HashMap<File, ViewerLabel>();
    private DecoratingLabelProvider titleLabelProvider;
    private SashForm mainSashForm;
    private Section stagedSection;
    private Section unstagedSection;
    private Section commitMessageSection;
    private TreeViewer stagedViewer;
    private TreeViewer unstagedViewer;
    private ToggleableLabel warningLabel;
    private Text filterText;
    private Pattern filterPattern;
    private SpellcheckableMessageArea commitMessageText;
    private Composite commitMessagePreview;
    private StackLayout previewLayout;
    private CommitMessagePreviewer previewer;
    private Text committerText;
    private Text authorText;
    private CommitMessageComponent commitMessageComponent;
    private boolean reactOnSelection = true;
    private StructuredSelection lastSelection;
    private ISelectionListener selectionChangedListener;
    private PartVisibilityListener partListener;
    private ToolBarManager unstagedToolBarManager;
    private ToolBarManager stagedToolBarManager;
    private IAction listPresentationAction;
    private IAction treePresentationAction;
    private IAction compactTreePresentationAction;
    private IAction unstagedExpandAllAction;
    private IAction unstagedCollapseAllAction;
    private IAction stagedExpandAllAction;
    private IAction stagedCollapseAllAction;
    private IAction unstageAction;
    private IAction stageAction;
    private IAction unstageAllAction;
    private IAction stageAllAction;
    private IAction compareModeAction;
    private ActionFactory.IWorkbenchAction switchRepositoriesAction;
    private Repository realRepository;
    @Nullable
    private Repository currentRepository;
    private final Map<Boolean, PushMode> currentPushMode = new HashMap<Boolean, PushMode>();
    private boolean pushesHeadOnly;
    private Presentation presentation = Presentation.LIST;
    private PresentationAction presentationAction;
    private Set<IPath> pathsToExpandInStaged = new HashSet<IPath>();
    private Set<IPath> pathsToExpandInUnstaged = new HashSet<IPath>();
    private boolean isUnbornHead;
    private String currentBranch;
    private final IEclipsePreferences.IPreferenceChangeListener prefListener = new IEclipsePreferences.IPreferenceChangeListener(){

        public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
            if (!"GitRepositoriesView.GitDirectories.relative".equals(event.getKey())) {
                return;
            }
            Repository repo = StagingView.this.currentRepository;
            if (repo == null || RepositoryUtil.INSTANCE.contains(repo)) {
                return;
            }
            StagingView.this.reload(null);
        }
    };
    private final IPropertyChangeListener uiPrefsListener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            if ("commit_dialog_warn_about_message_second_line".equals(event.getProperty())) {
                StagingView.this.asyncExec(() -> {
                    if (!StagingView.this.commitMessageSection.isDisposed()) {
                        StagingView.this.updateMessage();
                    }
                });
            }
        }
    };
    private Action signedOffByAction;
    private Action addChangeIdAction;
    private Action amendPreviousCommitAction;
    private Action previewAction;
    private Action signCommitAction;
    private Action openNewCommitsAction;
    private Action columnLayoutAction;
    private Action fileNameModeAction;
    private Action refreshAction;
    private Action sortAction;
    private Action hideUntrackedAction;
    private SashForm stagingSashForm;
    private IndexDiffChangedListener myIndexDiffListener = new IndexDiffChangedListener(){

        public void indexDiffChanged(Repository repository, IndexDiffData indexDiffData) {
            StagingView.this.reload(repository);
        }
    };
    private IndexDiffCacheEntry cacheEntry;
    private UndoRedoActionGroup undoRedoActionGroup;
    private Button commitButton;
    private Button commitAndPushButton;
    private PushSettings pushSettings;
    private Section rebaseSection;
    private Button rebaseContinueButton;
    private Button rebaseSkipButton;
    private Button rebaseAbortButton;
    private Button ignoreErrors;
    private ListenerHandle refsChangedListener;
    private ListenerHandle configChangedListener;
    private LocalResourceManager resources = new LocalResourceManager(JFaceResources.getResources());
    private boolean disposed;

    private Image getImage(ImageDescriptor descriptor) {
        return (Image)this.resources.get((DeviceResourceDescriptor)descriptor);
    }

    private void createPersonLabel(Composite parent, ImageDescriptor image, String text) {
        Label imageLabel = new Label(parent, 0);
        imageLabel.setImage(UIIcons.getImage((ResourceManager)this.resources, image));
        Label textLabel = this.toolkit.createLabel(parent, text);
        textLabel.setForeground(this.toolkit.getColors().getColor("org.eclipse.ui.forms.TB_TOGGLE"));
    }

    public void createPartControl(final Composite parent) {
        GridLayoutFactory.fillDefaults().applyTo(parent);
        this.titleNode = null;
        this.titleLabelProvider = new DecoratingLabelProvider((ILabelProvider)new RepositoryTreeNodeLabelProvider(), (ILabelDecorator)PlatformUI.getWorkbench().getDecoratorManager());
        this.titleLabelProvider.addListener(e -> {
            if (this.titleNode != null && this.form != null && !this.form.isDisposed()) {
                this.updateTitle(false);
            }
        });
        this.toolkit = new FormToolkit(parent.getDisplay());
        parent.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (StagingView.this.commitMessageComponent.isAmending() || StagingView.this.userEnteredCommitMessage()) {
                    StagingView.this.saveCommitMessageComponentState();
                } else {
                    StagingView.this.deleteCommitMessageComponentState();
                }
                StagingView.this.resources.dispose();
                StagingView.this.toolkit.dispose();
            }
        });
        this.form = this.toolkit.createForm(parent);
        parent.addControlListener(new ControlListener(){
            private int[] defaultWeights = new int[]{1, 1};

            public void controlResized(ControlEvent e) {
                Rectangle b = parent.getBounds();
                int oldOrientation = StagingView.this.mainSashForm.getOrientation();
                if (oldOrientation == 256 && b.height > b.width) {
                    StagingView.this.mainSashForm.setOrientation(512);
                    StagingView.this.mainSashForm.setWeights(this.defaultWeights);
                } else if (oldOrientation == 512 && b.height <= b.width) {
                    StagingView.this.mainSashForm.setOrientation(256);
                    StagingView.this.mainSashForm.setWeights(this.defaultWeights);
                }
            }

            public void controlMoved(ControlEvent e) {
            }
        });
        this.form.setImage(this.getImage(UIIcons.REPOSITORY));
        this.form.setText(UIText.StagingView_NoSelectionTitle);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.form);
        this.toolkit.decorateFormHeading(this.form);
        GridLayoutFactory.swtDefaults().applyTo(this.form.getBody());
        this.mainSashForm = new SashForm(this.form.getBody(), this.getMainSashFormOrientation());
        this.saveSashFormOrientationOnDisposal(this.mainSashForm, MAIN_SASH_FORM_ORIENTATION_VERTICAL);
        this.saveSashFormWeightsOnDisposal(this.mainSashForm, HORIZONTAL_SASH_FORM_WEIGHT);
        this.toolkit.adapt((Control)this.mainSashForm, true, true);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.mainSashForm);
        this.stagingSashForm = new SashForm((Composite)this.mainSashForm, this.getStagingFormOrientation());
        this.saveSashFormWeightsOnDisposal(this.stagingSashForm, STAGING_SASH_FORM_WEIGHT);
        this.toolkit.adapt((Control)this.stagingSashForm, true, true);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.stagingSashForm);
        this.unstageAction = new Action(UIText.StagingView_UnstageItemMenuLabel, UIIcons.UNSTAGE){

            public void run() {
                StagingView.this.unstage(StagingView.this.stagedViewer.getStructuredSelection().toList());
            }
        };
        this.unstageAction.setToolTipText(UIText.StagingView_UnstageItemTooltip);
        this.stageAction = new Action(UIText.StagingView_StageItemMenuLabel, UIIcons.ELCL16_ADD){

            public void run() {
                StagingView.this.stage(StagingView.this.unstagedViewer.getStructuredSelection().toList());
            }
        };
        this.stageAction.setToolTipText(UIText.StagingView_StageItemTooltip);
        this.unstageAction.setEnabled(false);
        this.stageAction.setEnabled(false);
        this.unstageAllAction = new Action(UIText.StagingView_UnstageAllItemMenuLabel, UIIcons.UNSTAGE_ALL){

            public void run() {
                StagingView.this.unstage(StagingView.this.getContentProvider((ContentViewer)StagingView.this.stagedViewer).getStagingEntriesFiltered());
            }
        };
        this.unstageAllAction.setToolTipText(UIText.StagingView_UnstageAllItemTooltip);
        this.stageAllAction = new Action(UIText.StagingView_StageAllItemMenuLabel, UIIcons.ELCL16_ADD_ALL){

            public void run() {
                StagingView.this.stage(StagingView.this.getContentProvider((ContentViewer)StagingView.this.unstagedViewer).getStagingEntriesFiltered());
            }
        };
        this.stageAllAction.setToolTipText(UIText.StagingView_StageAllItemTooltip);
        this.unstageAllAction.setEnabled(false);
        this.stageAllAction.setEnabled(false);
        this.createPresentationActions();
        this.unstagedSection = this.toolkit.createSection((Composite)this.stagingSashForm, 512);
        this.unstagedSection.clientVerticalSpacing = 0;
        this.unstagedSection.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).create());
        this.createUnstagedToolBarComposite();
        Composite unstagedComposite = this.toolkit.createComposite((Composite)this.unstagedSection);
        this.toolkit.paintBordersFor(unstagedComposite);
        this.unstagedSection.setClient((Control)unstagedComposite);
        GridLayoutFactory.fillDefaults().applyTo(unstagedComposite);
        this.unstagedViewer = this.createViewer(unstagedComposite, true, selection -> this.unstage(selection.toList()), this.stageAction);
        this.unstagedViewer.addSelectionChangedListener(event -> {
            boolean hasSelection;
            boolean bl = hasSelection = !event.getSelection().isEmpty();
            if (hasSelection != this.stageAction.isEnabled()) {
                this.stageAction.setEnabled(hasSelection);
                this.unstagedToolBarManager.update(true);
            }
            this.workaroundMissingSwtRefresh(this.unstagedViewer);
        });
        Composite rebaseAndCommitComposite = this.toolkit.createComposite((Composite)this.mainSashForm);
        rebaseAndCommitComposite.setLayout((Layout)GridLayoutFactory.fillDefaults().create());
        this.rebaseSection = this.toolkit.createSection(rebaseAndCommitComposite, 512);
        this.rebaseSection.clientVerticalSpacing = 0;
        this.rebaseSection.setText(UIText.StagingView_RebaseLabel);
        Composite rebaseComposite = this.toolkit.createComposite((Composite)this.rebaseSection);
        this.toolkit.paintBordersFor(rebaseComposite);
        this.rebaseSection.setClient((Control)rebaseComposite);
        this.rebaseSection.setLayoutData((Object)GridDataFactory.fillDefaults().create());
        rebaseComposite.setLayout((Layout)GridLayoutFactory.fillDefaults().numColumns(3).equalWidth(true).create());
        GridDataFactory buttonGridData = GridDataFactory.fillDefaults().align(4, 0x1000000);
        this.rebaseAbortButton = this.toolkit.createButton(rebaseComposite, UIText.StagingView_RebaseAbort, 8);
        this.rebaseAbortButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                StagingView.this.rebaseAbort();
            }
        });
        this.rebaseAbortButton.setImage(this.getImage(UIIcons.REBASE_ABORT));
        buttonGridData.applyTo((Control)this.rebaseAbortButton);
        this.rebaseSkipButton = this.toolkit.createButton(rebaseComposite, UIText.StagingView_RebaseSkip, 8);
        this.rebaseSkipButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                StagingView.this.rebaseSkip();
            }
        });
        this.rebaseSkipButton.setImage(this.getImage(UIIcons.REBASE_SKIP));
        buttonGridData.applyTo((Control)this.rebaseSkipButton);
        this.rebaseContinueButton = this.toolkit.createButton(rebaseComposite, UIText.StagingView_RebaseContinue, 8);
        this.rebaseContinueButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                StagingView.this.rebaseContinue();
            }
        });
        this.rebaseContinueButton.setImage(this.getImage(UIIcons.REBASE_CONTINUE));
        buttonGridData.applyTo((Control)this.rebaseContinueButton);
        StagingView.showControl((Control)this.rebaseSection, false);
        this.commitMessageSection = this.toolkit.createSection(rebaseAndCommitComposite, 512);
        this.commitMessageSection.clientVerticalSpacing = 0;
        this.commitMessageSection.setText(UIText.StagingView_CommitMessage);
        this.commitMessageSection.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).create());
        Composite commitMessageToolbarComposite = this.toolkit.createComposite((Composite)this.commitMessageSection);
        commitMessageToolbarComposite.setBackground(null);
        commitMessageToolbarComposite.setLayout((Layout)StagingView.createRowLayoutWithoutMargin());
        this.commitMessageSection.setTextClient((Control)commitMessageToolbarComposite);
        ToolBarManager commitMessageToolBarManager = new ToolBarManager(0x800100);
        this.previewAction = new Action(UIText.StagingView_Preview_Commit_Message, 2){

            public void run() {
                if (this.isChecked()) {
                    StagingView.this.previewLayout.topControl = StagingView.this.commitMessagePreview;
                    StagingView.this.commitMessageSection.setText(UIText.StagingView_CommitMessagePreview);
                    StagingView.this.previewer.setText(StagingView.this.commitMessageComponent.getRepository(), StagingView.this.commitMessageComponent.getCommitMessage());
                } else {
                    StagingView.this.previewLayout.topControl = StagingView.this.commitMessageText;
                    StagingView.this.commitMessageSection.setText(UIText.StagingView_CommitMessage);
                }
                StagingView.this.previewLayout.topControl.getParent().layout(true, true);
                StagingView.this.commitMessageSection.redraw();
                if (!this.isChecked()) {
                    StagingView.this.commitMessageText.setFocus();
                }
            }
        };
        this.previewAction.setImageDescriptor(UIIcons.ELCL16_PREVIEW);
        commitMessageToolBarManager.add((IAction)this.previewAction);
        commitMessageToolBarManager.add((IContributionItem)new Separator());
        this.amendPreviousCommitAction = new Action(UIText.StagingView_Ammend_Previous_Commit, 2){

            public void run() {
                StagingView.this.commitMessageComponent.setAmendingButtonSelection(this.isChecked());
                StagingView.this.updateMessage();
                StagingView.this.updateCommitButtons();
            }
        };
        this.amendPreviousCommitAction.setImageDescriptor(UIIcons.AMEND_COMMIT);
        commitMessageToolBarManager.add((IAction)this.amendPreviousCommitAction);
        this.signedOffByAction = new Action(UIText.StagingView_Add_Signed_Off_By, 2){

            public void run() {
                StagingView.this.commitMessageComponent.setSignedOffButtonSelection(this.isChecked());
            }
        };
        this.signedOffByAction.setImageDescriptor(UIIcons.SIGNED_OFF);
        commitMessageToolBarManager.add((IAction)this.signedOffByAction);
        this.signCommitAction = new Action(UIText.StagingView_Sign_Commit, 2){

            public void run() {
                StagingView.this.commitMessageComponent.setSignCommitButtonSelection(this.isChecked());
            }
        };
        this.signCommitAction.setImageDescriptor(UIIcons.SIGN_COMMIT);
        commitMessageToolBarManager.add((IAction)this.signCommitAction);
        boolean canSign = GpgSetup.getDefault() != null;
        this.signCommitAction.setEnabled(canSign);
        if (!canSign) {
            this.signCommitAction.setToolTipText(UIText.StagingView_Sign_Not_Available);
        }
        this.addChangeIdAction = new Action(UIText.StagingView_Add_Change_ID, 2){

            public void run() {
                StagingView.this.commitMessageComponent.setChangeIdButtonSelection(this.isChecked());
            }
        };
        this.addChangeIdAction.setImageDescriptor(UIIcons.GERRIT);
        commitMessageToolBarManager.add((IAction)this.addChangeIdAction);
        commitMessageToolBarManager.createControl(commitMessageToolbarComposite);
        Composite commitMessageComposite = this.toolkit.createComposite((Composite)this.commitMessageSection);
        this.commitMessageSection.setClient((Control)commitMessageComposite);
        GridLayoutFactory.fillDefaults().numColumns(1).applyTo(commitMessageComposite);
        this.warningLabel = new ToggleableLabel(commitMessageComposite, 0);
        GridDataFactory.fillDefaults().grab(true, false).exclude(true).applyTo((Control)this.warningLabel);
        Composite commitMessageTextComposite = this.toolkit.createComposite(commitMessageComposite);
        this.toolkit.paintBordersFor(commitMessageTextComposite);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)commitMessageTextComposite);
        this.previewLayout = new StackLayout();
        this.previewLayout.marginHeight = 2;
        this.previewLayout.marginWidth = 2;
        commitMessageTextComposite.setLayout((Layout)this.previewLayout);
        final CommitProposalProcessor commitProposalProcessor = new CommitProposalProcessor(){

            @Override
            protected Collection<String> computeFileNameProposals() {
                return StagingView.this.getStagedFileNames();
            }

            @Override
            protected Collection<String> computeMessageProposals() {
                return CommitMessageHistory.getCommitHistory();
            }
        };
        this.commitMessageText = new CommitMessageArea(commitMessageTextComposite, EMPTY_STRING, 0){

            @Override
            protected CommitProposalProcessor getCommitProposalProcessor() {
                return commitProposalProcessor;
            }

            @Override
            protected IHandlerService getHandlerService() {
                return (IHandlerService)StagingView.this.getSite().getService(IHandlerService.class);
            }
        };
        this.commitMessageText.setData("FormWidgetFactory.drawBorder", "textBorder");
        UIUtils.setCssStyling((Widget)this.commitMessageText.getTextWidget(), false);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.commitMessageText);
        UIUtils.addBulbDecorator((Control)this.commitMessageText.getTextWidget(), UIText.CommitDialog_ContentAssist);
        this.commitMessagePreview = new Composite(commitMessageTextComposite, 0);
        this.commitMessagePreview.setLayout((Layout)new FillLayout());
        this.commitMessagePreview.setData("FormWidgetFactory.drawBorder", (Object)"textBorder");
        this.previewer = new CommitMessagePreviewer();
        this.previewer.createControl(this.commitMessagePreview);
        this.previewLayout.topControl = this.commitMessageText;
        Composite composite = this.toolkit.createComposite(commitMessageComposite);
        this.toolkit.paintBordersFor(composite);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)composite);
        GridLayoutFactory.swtDefaults().margins(1, 2).numColumns(3).spacing(1, LayoutConstants.getSpacing().y).applyTo(composite);
        this.createPersonLabel(composite, UIIcons.ELCL16_AUTHOR, UIText.StagingView_Author);
        this.authorText = this.toolkit.createText(composite, null);
        this.authorText.setData("FormWidgetFactory.drawBorder", (Object)"textBorder");
        this.authorText.setLayoutData((Object)GridDataFactory.fillDefaults().indent(5, 0).grab(true, false).align(4, 0x1000000).create());
        this.createPersonLabel(composite, UIIcons.ELCL16_COMMITTER, UIText.StagingView_Committer);
        this.committerText = this.toolkit.createText(composite, null);
        this.committerText.setData("FormWidgetFactory.drawBorder", (Object)"textBorder");
        this.committerText.setLayoutData((Object)GridDataFactory.fillDefaults().indent(5, 0).grab(true, false).align(4, 0x1000000).create());
        Composite buttonsContainer = this.toolkit.createComposite(composite);
        GridDataFactory.fillDefaults().grab(true, false).span(3, 1).indent(0, 3).applyTo((Control)buttonsContainer);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(buttonsContainer);
        this.ignoreErrors = this.toolkit.createButton(buttonsContainer, UIText.StagingView_IgnoreErrors, 32);
        this.ignoreErrors.setSelection(false);
        this.ignoreErrors.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                StagingView.this.updateMessage();
                StagingView.this.updateCommitButtons();
            }
        });
        this.getPreferenceStore().addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (StagingView.this.isDisposed()) {
                    StagingView.this.getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
                    return;
                }
                StagingView.this.asyncExec(() -> {
                    StagingView.this.updateIgnoreErrorsButtonVisibility();
                    StagingView.this.updateMessage();
                    StagingView.this.updateCommitButtons();
                });
            }
        });
        GridDataFactory.fillDefaults().align(1, 1).grab(true, true).applyTo((Control)this.ignoreErrors);
        this.updateIgnoreErrorsButtonVisibility();
        Label filler = this.toolkit.createLabel(buttonsContainer, EMPTY_STRING);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)filler);
        Composite commitButtonsContainer = this.toolkit.createComposite(buttonsContainer);
        GridDataFactory.fillDefaults().align(4, 0x1000000).applyTo((Control)commitButtonsContainer);
        GridLayoutFactory.fillDefaults().numColumns(3).applyTo(commitButtonsContainer);
        this.pushSettings = new PushSettings();
        Control pushSettingsUi = this.pushSettings.createControl(commitButtonsContainer);
        GridDataFactory.fillDefaults().align(4, 0x1000000).applyTo(pushSettingsUi);
        this.commitAndPushButton = this.toolkit.createButton(commitButtonsContainer, UIText.StagingView_CommitAndPushWithEllipsis, 8);
        this.commitAndPushButton.setImage(this.getImage(UIIcons.PUSH));
        this.commitAndPushButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (StagingView.this.canPushHeadOnly()) {
                    this.pushHead(StagingView.this.currentRepository);
                } else {
                    StagingView.this.commit(true);
                }
            }

            private void pushHead(Repository repository) {
                if (repository == null) {
                    return;
                }
                PushMode mode = StagingView.this.getPushMode(repository);
                if (mode == null) {
                    return;
                }
                try {
                    Wizard wizard = mode.getWizard(repository, null, StagingView.this.pushSettings.isForce());
                    if (wizard != null) {
                        PushWizardDialog dialog = new PushWizardDialog(StagingView.this.commitAndPushButton.getShell(), (IWizard)wizard);
                        dialog.open();
                    }
                }
                catch (IOException e) {
                    Activator.handleError(e.getMessage(), e, true);
                }
            }
        });
        GridDataFactory.fillDefaults().align(4, 0x1000000).applyTo((Control)this.commitAndPushButton);
        this.commitButton = this.toolkit.createButton(commitButtonsContainer, UIText.StagingView_Commit, 8);
        this.commitButton.setImage(this.getImage(UIIcons.COMMIT));
        this.commitButton.setText(UIText.StagingView_Commit);
        this.commitButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                StagingView.this.commit(false);
            }
        });
        GridDataFactory.fillDefaults().align(4, 0x1000000).applyTo((Control)this.commitButton);
        this.stagedSection = this.toolkit.createSection((Composite)this.stagingSashForm, 512);
        this.stagedSection.clientVerticalSpacing = 0;
        this.createStagedToolBarComposite();
        Composite stagedComposite = this.toolkit.createComposite((Composite)this.stagedSection);
        this.toolkit.paintBordersFor(stagedComposite);
        this.stagedSection.setClient((Control)stagedComposite);
        GridLayoutFactory.fillDefaults().applyTo(stagedComposite);
        this.stagedViewer = this.createViewer(stagedComposite, false, selection -> this.stage(selection.toList()), this.unstageAction);
        this.stagedViewer.getLabelProvider().addListener(event -> {
            if (event.getSource() instanceof ProblemLabelDecorator && !this.isDisposed()) {
                this.updateMessage();
                this.updateCommitButtons();
            }
        });
        this.stagedViewer.addSelectionChangedListener(event -> {
            boolean hasSelection;
            boolean bl = hasSelection = !event.getSelection().isEmpty();
            if (hasSelection != this.unstageAction.isEnabled()) {
                this.unstageAction.setEnabled(hasSelection);
                this.stagedToolBarManager.update(true);
            }
            this.workaroundMissingSwtRefresh(this.stagedViewer);
        });
        this.selectionChangedListener = new ISelectionListener(){

            public void selectionChanged(IWorkbenchPart part, ISelection selection) {
                if (part == StagingView.this) {
                    return;
                }
                if (part instanceof IEditorPart) {
                    IEditorInput input = ((IEditorPart)part).getEditorInput();
                    Repository repository = (Repository)Adapters.adapt((Object)input, Repository.class);
                    if (repository != null) {
                        StagingView.this.reactOnSelection((ISelection)new StructuredSelection((Object)repository));
                    }
                } else {
                    StagingView.this.reactOnSelection(selection);
                }
            }
        };
        this.initPresentation();
        this.partListener = new PartListener();
        IPreferenceStore preferenceStore = this.getPreferenceStore();
        if (preferenceStore.contains("StagingView_SyncWithSelection")) {
            this.reactOnSelection = preferenceStore.getBoolean("StagingView_SyncWithSelection");
        } else {
            preferenceStore.setDefault("StagingView_SyncWithSelection", true);
        }
        preferenceStore.addPropertyChangeListener(this.uiPrefsListener);
        InstanceScope.INSTANCE.getNode("org.eclipse.egit.core").addPreferenceChangeListener(this.prefListener);
        this.updateSectionText();
        this.stagedSection.setToolTipText(UIText.StagingView_StagedChangesTooltip);
        this.unstagedSection.setToolTipText(UIText.StagingView_UnstagedChangesTooltip);
        this.updateToolbar();
        this.enableCommitWidgets(false);
        this.refreshAction.setEnabled(false);
        this.createPopupMenu(this.unstagedViewer);
        this.createPopupMenu(this.stagedViewer);
        ICommitMessageComponentNotifications listener = new ICommitMessageComponentNotifications(){
            private boolean addChangeState;
            {
                this.addChangeState = StagingView.this.addChangeIdAction.isChecked();
            }

            @Override
            public void updateSignedOffToggleSelection(boolean selection) {
                StagingView.this.signedOffByAction.setChecked(selection);
            }

            @Override
            public void updateChangeIdToggleSelection(boolean selection) {
                if (selection != this.addChangeState) {
                    StagingView.this.addChangeIdAction.setChecked(selection);
                    this.addChangeState = selection;
                    StagingView.this.updateCommitAndPush(StagingView.this.currentRepository);
                }
            }

            @Override
            public void updateSignCommitToggleSelection(boolean selection) {
                StagingView.this.signCommitAction.setChecked(selection);
            }

            @Override
            public void statusUpdated() {
                StagingView.this.updateMessage();
            }
        };
        this.commitMessageComponent = new CommitMessageComponent(listener);
        this.commitMessageComponent.attachControls(this.commitMessageText, this.authorText, this.committerText);
        this.commitMessageText.getTextWidget().addVerifyKeyListener(new VerifyKeyListener(){

            public void verifyKey(VerifyEvent event) {
                if (UIUtils.isSubmitKeyEvent((KeyEvent)event)) {
                    event.doit = false;
                    StagingView.this.commit(false);
                }
            }
        });
        this.commitMessageText.getTextWidget().addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                String commitButtonTooltip = MessageFormat.format(UIText.StagingView_CommitToolTip, UIUtils.SUBMIT_KEY_STROKE.format());
                StagingView.this.commitButton.setToolTipText(commitButtonTooltip);
            }

            public void focusLost(FocusEvent e) {
                StagingView.this.commitButton.setToolTipText(null);
            }
        });
        IWorkbenchPartSite site = this.getSite();
        UIUtils.notifySelectionChangedWithCurrentSelection(this.selectionChangedListener, (IServiceLocator)site);
        ISelectionService srv = (ISelectionService)site.getService(ISelectionService.class);
        srv.addPostSelectionListener(this.selectionChangedListener);
        ((IPartService)site.getService(IPartService.class)).addPartListener((IPartListener2)this.partListener);
        site.setSelectionProvider((ISelectionProvider)new RepositorySelectionProvider((ISelectionProvider)new MultiViewerSelectionProvider(new Viewer[]{this.unstagedViewer, this.stagedViewer}), () -> this.realRepository));
        ViewerFilter filter = new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                StagingViewContentProvider contentProvider = StagingView.this.getContentProvider((ContentViewer)((TreeViewer)viewer));
                if (element instanceof StagingEntry) {
                    return contentProvider.isInFilter((StagingEntry)element);
                }
                if (element instanceof StagingFolderEntry) {
                    return contentProvider.hasVisibleChildren((StagingFolderEntry)element);
                }
                return true;
            }
        };
        this.unstagedViewer.addFilter(filter);
        this.stagedViewer.addFilter(filter);
        this.restoreSashFormWeights();
        IWorkbenchSiteProgressService service = (IWorkbenchSiteProgressService)this.getSite().getService(IWorkbenchSiteProgressService.class);
        if (service != null && this.reactOnSelection) {
            service.showBusyForFamily(org.eclipse.egit.core.JobFamilies.INDEX_DIFF_CACHE_UPDATE);
        }
    }

    private void updateTitle(boolean force) {
        ViewerLabel label = this.titleLabels.computeIfAbsent(this.titleNode.getRepository().getDirectory(), r -> new ViewerLabel(null, null));
        if (force) {
            if (label.getImage() != null) {
                this.form.setImage(label.getImage());
            }
            if (!StringUtils.isEmptyOrNull((String)label.getText())) {
                this.form.setText(label.getText());
            }
        }
        this.titleLabelProvider.updateLabel(label, (Object)this.titleNode);
        if (label.hasNewImage()) {
            this.form.setImage(label.getImage());
        }
        if (label.hasNewText()) {
            this.form.setText(label.getText());
        }
    }

    private void workaroundMissingSwtRefresh(TreeViewer viewer) {
        if (Util.isWindows()) {
            viewer.getControl().redraw();
        }
    }

    private void updateIgnoreErrorsButtonVisibility() {
        boolean visible = this.getPreferenceStore().getBoolean("checkBeforeCommitting") && this.getPreferenceStore().getBoolean("blockCommit");
        StagingView.showControl((Control)this.ignoreErrors, visible);
        this.mainSashForm.layout();
    }

    private boolean hasProblemSeverity(int severity) {
        StagingEntry[] entries;
        StagingViewContentProvider stagedContentProvider = this.getContentProvider((ContentViewer)this.stagedViewer);
        StagingEntry[] stagingEntryArray = entries = stagedContentProvider.getStagingEntries();
        int n = entries.length;
        int n2 = 0;
        while (n2 < n) {
            StagingEntry entry = stagingEntryArray[n2];
            if (entry.getProblemSeverity() >= severity) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private void updateCommitButtons() {
        Repository repo;
        Object indexDiff = this.cacheEntry != null ? this.cacheEntry.getIndexDiff() : ((repo = this.currentRepository) == null ? null : this.doReload(repo));
        boolean indexDiffAvailable = StagingView.indexDiffAvailable(indexDiff);
        boolean noConflicts = StagingView.noConflicts(indexDiff);
        UnitOfWork.execute((Repository)this.currentRepository, () -> {
            boolean commitEnabled = noConflicts && indexDiffAvailable && this.isCommitPossible() && !this.isCommitBlocked();
            this.commitButton.setEnabled(commitEnabled);
            Repository repo = this.currentRepository;
            this.pushesHeadOnly = this.canPushHeadOnly();
            this.commitAndPushButton.setEnabled(repo != null && (commitEnabled || this.pushesHeadOnly) && !repo.getRepositoryState().isRebasing());
            this.updateCommitAndPush(repo);
        });
    }

    private void updateCommitAndPush(Repository repository) {
        PushMode pushMode = this.getPushMode(repository);
        if (pushMode == PushMode.GERRIT) {
            this.pushSettings.setVisible(false);
            this.commitAndPushButton.setImage(this.getImage(UIIcons.GERRIT));
        } else {
            this.pushSettings.setVisible(true);
            this.pushSettings.setEnabled(this.commitAndPushButton.isEnabled());
            this.commitAndPushButton.setImage(this.getImage(UIIcons.PUSH));
        }
        this.commitAndPushButton.setText(this.pushesHeadOnly ? UIText.StagingView_PushHEAD : (this.canPushWithoutConfirmation(pushMode) ? UIText.StagingView_CommitAndPush : UIText.StagingView_CommitAndPushWithEllipsis));
        this.commitAndPushButton.getParent().requestLayout();
    }

    private void saveSashFormWeightsOnDisposal(final SashForm sashForm, final String settingsKey) {
        sashForm.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                StagingView.this.getDialogSettings().put(settingsKey, StagingView.intArrayToString(sashForm.getWeights()));
            }
        });
    }

    private void saveSashFormOrientationOnDisposal(final SashForm sashForm, final String verticalOrientationSettingsKey) {
        sashForm.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                StagingView.this.getDialogSettings().put(verticalOrientationSettingsKey, sashForm.getOrientation() == 512);
            }
        });
    }

    private IDialogSettings getDialogSettings() {
        return DialogSettings.getOrCreateSection((IDialogSettings)Activator.getDefault().getDialogSettings(), (String)StagingView.class.getName());
    }

    private static String intArrayToString(int[] ints) {
        StringBuilder res = new StringBuilder();
        if (ints != null && ints.length > 0) {
            res.append(String.valueOf(ints[0]));
            int i = 1;
            while (i < ints.length) {
                res.append(',');
                res.append(String.valueOf(ints[i]));
                ++i;
            }
        }
        return res.toString();
    }

    private void restoreSashFormWeights() {
        this.restoreSashFormWeights(this.mainSashForm, HORIZONTAL_SASH_FORM_WEIGHT);
        this.restoreSashFormWeights(this.stagingSashForm, STAGING_SASH_FORM_WEIGHT);
    }

    private void restoreSashFormWeights(SashForm sashForm, String settingsKey) {
        IDialogSettings settings = this.getDialogSettings();
        String weights = settings.get(settingsKey);
        if (weights != null && !weights.isEmpty()) {
            sashForm.setWeights(StagingView.stringToIntArray(weights));
        }
    }

    private static int[] stringToIntArray(String s) {
        String[] parts = s.split(",");
        int[] ints = new int[parts.length];
        int i = 0;
        while (i < parts.length) {
            ints[i] = Integer.parseInt(parts[i]);
            ++i;
        }
        return ints;
    }

    private StructuredSelection getSelectionOfActiveEditor() {
        IWorkbenchPartSite site = this.getSite();
        if (site == null) {
            return null;
        }
        IEditorPart activeEditor = site.getPage().getActiveEditor();
        if (activeEditor == null) {
            return null;
        }
        return StagingView.getSelectionOfPart((IWorkbenchPart)activeEditor);
    }

    private static StructuredSelection getSelectionOfPart(IWorkbenchPart part) {
        if (part == null) {
            return null;
        }
        StructuredSelection sel = null;
        if (part instanceof IEditorPart) {
            IResource resource = StagingView.getResource((IEditorPart)part);
            if (resource != null) {
                sel = new StructuredSelection((Object)resource);
            } else {
                Repository repository = (Repository)Adapters.adapt((Object)((IEditorPart)part).getEditorInput(), Repository.class);
                if (repository != null) {
                    sel = new StructuredSelection((Object)repository);
                }
            }
        } else {
            ISelection selection = part.getSite().getPage().getSelection();
            if (selection instanceof StructuredSelection) {
                sel = (StructuredSelection)selection;
            }
        }
        return sel;
    }

    private static IResource getResource(IEditorPart part) {
        IEditorInput input = part.getEditorInput();
        if (input instanceof IFileEditorInput) {
            return ((IFileEditorInput)input).getFile();
        }
        return AdapterUtils.adaptToAnyResource((Object)input);
    }

    private boolean getSortCheckState() {
        return this.getDialogSettings().getBoolean(STORE_SORT_STATE);
    }

    private void executeRebaseOperation(AbstractRebaseCommandHandler command) {
        try {
            command.execute(this.currentRepository);
        }
        catch (ExecutionException e) {
            Activator.showError(e.getMessage(), e);
        }
    }

    protected void rebaseAbort() {
        AbortRebaseCommand abortCommand = new AbortRebaseCommand();
        this.executeRebaseOperation(abortCommand);
    }

    protected void rebaseSkip() {
        SkipRebaseCommand skipCommand = new SkipRebaseCommand();
        this.executeRebaseOperation(skipCommand);
    }

    protected void rebaseContinue() {
        ContinueRebaseCommand continueCommand = new ContinueRebaseCommand();
        this.executeRebaseOperation(continueCommand);
    }

    private void createUnstagedToolBarComposite() {
        Composite unstagedToolbarComposite = this.toolkit.createComposite((Composite)this.unstagedSection);
        unstagedToolbarComposite.setBackground(null);
        unstagedToolbarComposite.setLayout((Layout)StagingView.createRowLayoutWithoutMargin());
        this.unstagedSection.setTextClient((Control)unstagedToolbarComposite);
        this.unstagedExpandAllAction = new Action(UIText.UIUtils_ExpandAll, 1){

            public void run() {
                UIUtils.expandAll((AbstractTreeViewer)StagingView.this.unstagedViewer);
                StagingView.enableAutoExpand((AbstractTreeViewer)StagingView.this.unstagedViewer);
            }
        };
        this.unstagedExpandAllAction.setImageDescriptor(UIIcons.EXPAND_ALL);
        this.unstagedExpandAllAction.setId(EXPAND_ALL_ITEM_TOOLBAR_ID);
        this.unstagedCollapseAllAction = new Action(UIText.UIUtils_CollapseAll, 1){

            public void run() {
                UIUtils.collapseAll((AbstractTreeViewer)StagingView.this.unstagedViewer);
                StagingView.disableAutoExpand((AbstractTreeViewer)StagingView.this.unstagedViewer);
            }
        };
        this.unstagedCollapseAllAction.setImageDescriptor(UIIcons.COLLAPSEALL);
        this.unstagedCollapseAllAction.setId(COLLAPSE_ALL_ITEM_TOOLBAR_ID);
        this.hideUntrackedAction = new Action(UIText.StagingView_HideUntrackedFiles, 2){

            public void run() {
                StagingView.this.updateUnstagedViewer();
                StagingView.this.refreshViewersPreservingExpandedElements();
            }
        };
        this.hideUntrackedAction.setImageDescriptor(UIIcons.ELCL16_HIDE_UNTRACKED);
        this.hideUntrackedAction.setId(HIDE_UNTRACKED_TOOLBAR_ID);
        this.hideUntrackedAction.setChecked(false);
        this.sortAction = new Action(UIText.StagingView_UnstagedSort, 2){

            public void run() {
                StagingEntryComparator comparator = (StagingEntryComparator)StagingView.this.unstagedViewer.getComparator();
                comparator.setAlphabeticSort(!this.isChecked());
                comparator = (StagingEntryComparator)StagingView.this.stagedViewer.getComparator();
                comparator.setAlphabeticSort(!this.isChecked());
                StagingView.this.unstagedViewer.refresh();
                StagingView.this.stagedViewer.refresh();
            }
        };
        this.sortAction.setImageDescriptor(UIIcons.STATE_SORT);
        this.sortAction.setId(SORT_ITEM_TOOLBAR_ID);
        this.sortAction.setChecked(this.getSortCheckState());
        this.unstagedToolBarManager = new ToolBarManager(0x800100);
        this.unstagedToolBarManager.add(this.stageAction);
        this.unstagedToolBarManager.add(this.stageAllAction);
        this.unstagedToolBarManager.add((IAction)this.hideUntrackedAction);
        this.unstagedToolBarManager.add((IAction)this.presentationAction);
        this.unstagedToolBarManager.add((IAction)this.sortAction);
        this.unstagedToolBarManager.add(this.unstagedExpandAllAction);
        this.unstagedToolBarManager.add(this.unstagedCollapseAllAction);
        this.unstagedToolBarManager.update(true);
        this.unstagedToolBarManager.createControl(unstagedToolbarComposite);
    }

    private void updateUnstagedViewer() {
        StagingViewContentProvider stagingViewContentProvider = (StagingViewContentProvider)this.unstagedViewer.getContentProvider();
        stagingViewContentProvider.setShowUntracked(!this.hideUntrackedAction.isChecked());
        this.updateSectionText();
        this.setRedraw(false);
        try {
            this.unstagedViewer.refresh();
            Object[] expandFolders = stagingViewContentProvider.getUntrackedFileFolders().toArray(new StagingFolderEntry[0]);
            if (!this.hideUntrackedAction.isChecked() && expandFolders.length > 0) {
                this.unstagedViewer.setExpandedElements(expandFolders);
            }
        }
        finally {
            this.setRedraw(true);
        }
    }

    private void createStagedToolBarComposite() {
        Composite stagedToolbarComposite = this.toolkit.createComposite((Composite)this.stagedSection);
        stagedToolbarComposite.setBackground(null);
        stagedToolbarComposite.setLayout((Layout)StagingView.createRowLayoutWithoutMargin());
        this.stagedSection.setTextClient((Control)stagedToolbarComposite);
        this.stagedExpandAllAction = new Action(UIText.UIUtils_ExpandAll, 1){

            public void run() {
                UIUtils.expandAll((AbstractTreeViewer)StagingView.this.stagedViewer);
                StagingView.enableAutoExpand((AbstractTreeViewer)StagingView.this.stagedViewer);
            }
        };
        this.stagedExpandAllAction.setImageDescriptor(UIIcons.EXPAND_ALL);
        this.stagedExpandAllAction.setId(EXPAND_ALL_ITEM_TOOLBAR_ID);
        this.stagedCollapseAllAction = new Action(UIText.UIUtils_CollapseAll, 1){

            public void run() {
                UIUtils.collapseAll((AbstractTreeViewer)StagingView.this.stagedViewer);
                StagingView.disableAutoExpand((AbstractTreeViewer)StagingView.this.stagedViewer);
            }
        };
        this.stagedCollapseAllAction.setImageDescriptor(UIIcons.COLLAPSEALL);
        this.stagedCollapseAllAction.setId(COLLAPSE_ALL_ITEM_TOOLBAR_ID);
        this.stagedToolBarManager = new ToolBarManager(0x800100);
        this.stagedToolBarManager.add(this.unstageAction);
        this.stagedToolBarManager.add(this.unstageAllAction);
        this.stagedToolBarManager.add(this.stagedExpandAllAction);
        this.stagedToolBarManager.add(this.stagedCollapseAllAction);
        this.stagedToolBarManager.update(true);
        this.stagedToolBarManager.createControl(stagedToolbarComposite);
    }

    private static RowLayout createRowLayoutWithoutMargin() {
        RowLayout layout = new RowLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.marginTop = 0;
        layout.marginBottom = 0;
        layout.marginLeft = 0;
        layout.marginRight = 0;
        return layout;
    }

    private static void addListenerToDisableAutoExpandOnCollapse(TreeViewer treeViewer) {
        treeViewer.addTreeListener(new ITreeViewerListener(){

            public void treeCollapsed(TreeExpansionEvent event) {
                StagingView.disableAutoExpand(event.getTreeViewer());
            }

            public void treeExpanded(TreeExpansionEvent event) {
            }
        });
    }

    private static void enableAutoExpand(AbstractTreeViewer treeViewer) {
        treeViewer.setAutoExpandLevel(-1);
    }

    private static void disableAutoExpand(AbstractTreeViewer treeViewer) {
        treeViewer.setAutoExpandLevel(0);
    }

    public Repository getCurrentRepository() {
        return this.currentRepository;
    }

    public ShowInContext getShowInContext() {
        if (this.stagedViewer != null && this.stagedViewer.getTree().isFocusControl()) {
            return this.getShowInContext(this.stagedViewer);
        }
        if (this.unstagedViewer != null && this.unstagedViewer.getTree().isFocusControl()) {
            return this.getShowInContext(this.unstagedViewer);
        }
        return null;
    }

    public boolean show(ShowInContext context) {
        ISelection selection = context.getSelection();
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            for (Object element : structuredSelection.toList()) {
                if (!(element instanceof RepositoryTreeNode)) continue;
                RepositoryTreeNode node = (RepositoryTreeNode)element;
                this.reload(node.getRepository());
                return true;
            }
        }
        return false;
    }

    private ShowInContext getShowInContext(TreeViewer treeViewer) {
        ITreeSelection selection = treeViewer.getStructuredSelection();
        ArrayList<Object> elements = new ArrayList<Object>();
        for (Object selectedElement : selection.toList()) {
            IProblemDecoratable entry;
            if (selectedElement instanceof StagingEntry) {
                entry = (StagingEntry)selectedElement;
                IFile file = ((StagingEntry)entry).getFile();
                if (file != null) {
                    elements.add(file);
                    continue;
                }
                elements.add(((StagingEntry)entry).getLocation());
                continue;
            }
            if (!(selectedElement instanceof StagingFolderEntry)) continue;
            entry = (StagingFolderEntry)selectedElement;
            IContainer container = ((StagingFolderEntry)entry).getContainer();
            if (container != null) {
                elements.add(container);
                continue;
            }
            elements.add(((StagingFolderEntry)entry).getLocation());
        }
        return new ShowInContext(null, (ISelection)new StructuredSelection(elements));
    }

    private int getStagingFormOrientation() {
        boolean columnLayout = Activator.getDefault().getPreferenceStore().getBoolean("StagingView_ColumnLayout");
        if (columnLayout) {
            return 256;
        }
        return 512;
    }

    private int getMainSashFormOrientation() {
        IDialogSettings settings = this.getDialogSettings();
        return settings.getBoolean(MAIN_SASH_FORM_ORIENTATION_VERTICAL) ? 512 : 256;
    }

    private void enableAllWidgets(boolean enabled) {
        if (this.isDisposed()) {
            return;
        }
        this.enableCommitWidgets(enabled);
        this.commitMessageText.setEnabled(enabled);
        this.enableStagingWidgets(enabled);
    }

    private void enableStagingWidgets(boolean enabled) {
        if (this.isDisposed()) {
            return;
        }
        this.unstagedViewer.getControl().setEnabled(enabled);
        this.stagedViewer.getControl().setEnabled(enabled);
    }

    private void enableCommitWidgets(boolean enabled) {
        if (this.isDisposed()) {
            return;
        }
        this.committerText.setEnabled(enabled);
        this.enableAuthorText(enabled);
        this.amendPreviousCommitAction.setEnabled(enabled);
        this.signedOffByAction.setEnabled(enabled);
        this.signCommitAction.setEnabled(enabled && GpgSetup.getDefault() != null);
        this.addChangeIdAction.setEnabled(enabled);
        if (enabled) {
            this.updateCommitButtons();
        } else {
            this.commitButton.setEnabled(enabled);
            this.commitAndPushButton.setEnabled(enabled);
        }
    }

    private void enableAuthorText(boolean enabled) {
        Repository repo = this.currentRepository;
        if (repo != null && repo.getRepositoryState().equals((Object)RepositoryState.CHERRY_PICKING_RESOLVED)) {
            this.authorText.setEnabled(false);
        } else {
            this.authorText.setEnabled(enabled);
        }
    }

    private void createPresentationActions() {
        this.listPresentationAction = new Action(UIText.StagingView_List, 8){

            public void run() {
                if (!this.isChecked()) {
                    return;
                }
                StagingView.this.switchToListMode();
                StagingView.this.refreshViewers();
            }
        };
        this.listPresentationAction.setImageDescriptor(UIIcons.FLAT);
        this.treePresentationAction = new Action(UIText.StagingView_Tree, 8){

            public void run() {
                if (!this.isChecked()) {
                    return;
                }
                StagingView.this.presentation = Presentation.TREE;
                StagingView.this.setPresentation(StagingView.this.presentation, false);
                StagingView.this.listPresentationAction.setChecked(false);
                StagingView.this.compactTreePresentationAction.setChecked(false);
                StagingView.this.setExpandCollapseActionsVisible(false, StagingView.this.isExpandAllowed(false), true);
                StagingView.this.setExpandCollapseActionsVisible(true, StagingView.this.isExpandAllowed(true), true);
                StagingView.this.refreshViewers();
            }
        };
        this.treePresentationAction.setImageDescriptor(UIIcons.HIERARCHY);
        this.compactTreePresentationAction = new Action(UIText.StagingView_CompactTree, 8){

            public void run() {
                if (!this.isChecked()) {
                    return;
                }
                StagingView.this.switchToCompactModeInternal(false);
                StagingView.this.refreshViewers();
            }
        };
        this.compactTreePresentationAction.setImageDescriptor(UIIcons.COMPACT);
        this.presentationAction = new PresentationAction(this.getPreferenceStore(), this.listPresentationAction, this.treePresentationAction, this.compactTreePresentationAction);
        this.presentationAction.setImageDescriptor(UIIcons.FLAT);
    }

    private void initPresentation() {
        this.presentation = this.readPresentation("StagingView_Presentation", Presentation.LIST);
        switch (this.presentation) {
            case LIST: {
                this.presentationAction.setImageDescriptor(UIIcons.FLAT);
                this.listPresentationAction.setChecked(true);
                this.setExpandCollapseActionsVisible(false, false, false);
                this.setExpandCollapseActionsVisible(true, false, false);
                break;
            }
            case TREE: {
                this.presentationAction.setImageDescriptor(UIIcons.HIERARCHY);
                this.treePresentationAction.setChecked(true);
                break;
            }
            case COMPACT_TREE: {
                this.presentationAction.setImageDescriptor(UIIcons.COMPACT);
                this.compactTreePresentationAction.setChecked(true);
                break;
            }
        }
    }

    private void updateToolbar() {
        ControlContribution controlContribution = new ControlContribution("StagingView.searchText"){

            protected Control createControl(Composite parent) {
                Composite toolbarComposite = new Composite(parent, 0);
                toolbarComposite.setBackground(null);
                GridLayout headLayout = new GridLayout();
                headLayout.marginHeight = 0;
                headLayout.marginBottom = 1;
                headLayout.marginWidth = 0;
                toolbarComposite.setLayout((Layout)headLayout);
                StagingView.this.filterText = new Text(toolbarComposite, 896);
                StagingView.this.filterText.setMessage(UIText.StagingView_Find);
                GridData data = new GridData(16384, 128, true, false);
                data.minimumWidth = 150;
                StagingView.this.filterText.setLayoutData((Object)data);
                StagingView.this.filterText.addModifyListener(e -> {
                    StagingView.this.filterPattern = StagingView.this.wildcardToRegex(StagingView.this.filterText.getText());
                    StagingViewSearchThread searchThread = new StagingViewSearchThread(StagingView.this);
                    StagingView.this.filterText.getDisplay().timerExec(200, searchThread::start);
                });
                return toolbarComposite;
            }
        };
        IActionBars actionBars = this.getViewSite().getActionBars();
        IToolBarManager toolbar = actionBars.getToolBarManager();
        toolbar.add((IContributionItem)controlContribution);
        this.refreshAction = new Action(UIText.StagingView_Refresh, 1){

            public void run() {
                Repository repo;
                if (StagingView.this.cacheEntry != null) {
                    StagingView.this.schedule(StagingView.this.cacheEntry.createRefreshResourcesAndIndexDiffJob(), false);
                }
                if ((repo = StagingView.this.currentRepository) != null) {
                    StagingView.this.setCleanup(repo);
                }
            }
        };
        this.refreshAction.setImageDescriptor(UIIcons.ELCL16_REFRESH);
        this.refreshAction.setActionDefinitionId("org.eclipse.ui.file.refresh");
        toolbar.add((IAction)this.refreshAction);
        actionBars.setGlobalActionHandler(ActionFactory.REFRESH.getId(), (IAction)this.refreshAction);
        BooleanPrefAction linkSelectionAction = new BooleanPrefAction((IPersistentPreferenceStore)this.getPreferenceStore(), "StagingView_SyncWithSelection", UIText.StagingView_LinkSelection){

            @Override
            public void apply(boolean value) {
                StagingView.this.reactOnSelection = value;
                if (value && StagingView.this.currentRepository == null) {
                    if (StagingView.this.lastSelection != null) {
                        StagingView.this.reactOnSelection((ISelection)StagingView.this.lastSelection);
                    } else {
                        StructuredSelection selection = StagingView.this.getSelectionOfActiveEditor();
                        if (selection != null) {
                            StagingView.this.reactOnSelection((ISelection)selection);
                        }
                    }
                }
            }
        };
        linkSelectionAction.setImageDescriptor(UIIcons.ELCL16_SYNCED);
        toolbar.add((IAction)linkSelectionAction);
        toolbar.add((IContributionItem)new Separator());
        this.switchRepositoriesAction = new RepositoryMenuUtil.RepositoryToolbarAction(false, () -> this.realRepository, repo -> {
            if (this.realRepository != repo) {
                this.reload((Repository)repo);
            }
        });
        toolbar.add((IAction)this.switchRepositoriesAction);
        this.compareModeAction = new Action(UIText.StagingView_CompareMode, 2){

            public void run() {
                StagingView.this.getPreferenceStore().setValue("StagingView_CompareMode", this.isChecked());
            }
        };
        this.compareModeAction.setImageDescriptor(UIIcons.ELCL16_COMPARE_VIEW);
        this.compareModeAction.setChecked(this.getPreferenceStore().getBoolean("StagingView_CompareMode"));
        toolbar.add(this.compareModeAction);
        toolbar.add((IContributionItem)new Separator());
        this.openNewCommitsAction = new Action(UIText.StagingView_OpenNewCommits, 2){

            public void run() {
                StagingView.this.getPreferenceStore().setValue("StagingView_ShowNewCommits", this.isChecked());
            }
        };
        this.openNewCommitsAction.setChecked(this.getPreferenceStore().getBoolean("StagingView_ShowNewCommits"));
        this.columnLayoutAction = new Action(UIText.StagingView_ColumnLayout, 2){

            public void run() {
                StagingView.this.getPreferenceStore().setValue("StagingView_ColumnLayout", this.isChecked());
                StagingView.this.stagingSashForm.setOrientation(this.isChecked() ? 256 : 512);
            }
        };
        this.columnLayoutAction.setImageDescriptor(UIIcons.ELCL16_COLUMN_LAYOUT);
        this.columnLayoutAction.setChecked(this.getPreferenceStore().getBoolean("StagingView_ColumnLayout"));
        this.fileNameModeAction = new Action(UIText.StagingView_ShowFileNamesFirst, 2){

            public void run() {
                boolean enable = this.isChecked();
                StagingView.this.getLabelProvider(StagingView.this.stagedViewer).setFileNameMode(enable);
                StagingView.this.getLabelProvider(StagingView.this.unstagedViewer).setFileNameMode(enable);
                StagingView.this.getContentProvider((ContentViewer)StagingView.this.stagedViewer).setFileNameMode(enable);
                StagingView.this.getContentProvider((ContentViewer)StagingView.this.unstagedViewer).setFileNameMode(enable);
                StagingEntryComparator comparator = (StagingEntryComparator)StagingView.this.unstagedViewer.getComparator();
                comparator.setFileNamesFirst(enable);
                comparator = (StagingEntryComparator)StagingView.this.stagedViewer.getComparator();
                comparator.setFileNamesFirst(enable);
                StagingView.this.getPreferenceStore().setValue("StagingView_FileNameMode", enable);
                StagingView.this.refreshViewersPreservingExpandedElements();
            }
        };
        this.fileNameModeAction.setChecked(this.getPreferenceStore().getBoolean("StagingView_FileNameMode"));
        IMenuManager dropdownMenu = actionBars.getMenuManager();
        dropdownMenu.add((IAction)this.presentationAction);
        dropdownMenu.add((IContributionItem)new Separator());
        dropdownMenu.add((IAction)this.openNewCommitsAction);
        dropdownMenu.add((IAction)this.columnLayoutAction);
        dropdownMenu.add((IAction)this.fileNameModeAction);
        dropdownMenu.add(this.compareModeAction);
        actionBars.setGlobalActionHandler(ActionFactory.DELETE.getId(), (IAction)new GlobalDeleteActionHandler());
        IUndoContext workspaceContext = (IUndoContext)Adapters.adapt((Object)ResourcesPlugin.getWorkspace(), IUndoContext.class);
        this.undoRedoActionGroup = new UndoRedoActionGroup((IWorkbenchPartSite)this.getViewSite(), workspaceContext, true);
        this.undoRedoActionGroup.fillActionBars(actionBars);
        actionBars.updateActionBars();
    }

    private Presentation readPresentation(String key, Presentation def) {
        return StagingView.getPresentation(this.getPreferenceStore().getString(key), def);
    }

    private static Presentation getPresentation(String value, Presentation def) {
        if (!value.isEmpty()) {
            try {
                return Presentation.valueOf(value);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return def;
    }

    private void setPresentation(Presentation newOne, boolean auto) {
        Presentation old = this.presentation;
        this.presentation = newOne;
        IPreferenceStore store = this.getPreferenceStore();
        store.setValue("StagingView_Presentation", newOne.name());
        if (auto && old != newOne) {
            store.setValue("StagingView_Presentation_Changed", true);
        } else {
            store.setToDefault("StagingView_Presentation_Changed");
        }
    }

    private void setExpandCollapseActionsVisible(boolean staged, boolean visibleExpandAll, boolean visibleCollapseAll) {
        ToolBarManager toolBarManager = staged ? this.stagedToolBarManager : this.unstagedToolBarManager;
        IContributionItem[] iContributionItemArray = toolBarManager.getItems();
        int n = iContributionItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            IContributionItem item = iContributionItemArray[n2];
            String id = item.getId();
            if (EXPAND_ALL_ITEM_TOOLBAR_ID.equals(id)) {
                item.setVisible(visibleExpandAll);
            } else if (COLLAPSE_ALL_ITEM_TOOLBAR_ID.equals(id)) {
                item.setVisible(visibleCollapseAll);
            }
            ++n2;
        }
        (staged ? this.stagedExpandAllAction : this.unstagedExpandAllAction).setEnabled(visibleExpandAll);
        (staged ? this.stagedCollapseAllAction : this.unstagedCollapseAllAction).setEnabled(visibleCollapseAll);
        toolBarManager.update(true);
    }

    private boolean isExpandAllowed(boolean staged) {
        StagingViewContentProvider contentProvider = this.getContentProvider((ContentViewer)(staged ? this.stagedViewer : this.unstagedViewer));
        return contentProvider.getCount() <= this.getMaxLimitForListMode();
    }

    private TreeViewer createTree(Composite composite) {
        Tree tree = this.toolkit.createTree(composite, 65538);
        TreeViewer treeViewer = new TreeViewer(tree);
        treeViewer.setUseHashlookup(true);
        return treeViewer;
    }

    private ColumnLabelProvider createLabelProvider(TreeViewer treeViewer) {
        StagingViewLabelProvider baseProvider = new StagingViewLabelProvider(this);
        baseProvider.setFileNameMode(this.getPreferenceStore().getBoolean("StagingView_FileNameMode"));
        ProblemLabelDecorator decorator = new ProblemLabelDecorator((StructuredViewer)treeViewer);
        return new TreeDecoratingLabelProvider(baseProvider, decorator);
    }

    private StagingViewContentProvider createStagingContentProvider(final boolean unstaged) {
        StagingViewContentProvider provider = new StagingViewContentProvider(this, unstaged){

            @Override
            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                super.inputChanged(viewer, oldInput, newInput);
                if (unstaged) {
                    StagingView.this.stageAllAction.setEnabled(this.hasVisibleItems());
                    StagingView.this.unstagedToolBarManager.update(true);
                } else {
                    StagingView.this.unstageAllAction.setEnabled(this.hasVisibleItems());
                    StagingView.this.stagedToolBarManager.update(true);
                }
            }
        };
        provider.setFileNameMode(this.getPreferenceStore().getBoolean("StagingView_FileNameMode"));
        return provider;
    }

    private static String getConflictText(StagingEntry entry) {
        if (entry.hasConflicts()) {
            IndexDiff.StageState conflictType = entry.getConflictType();
            switch (conflictType) {
                case DELETED_BY_THEM: {
                    return UIText.StagingView_Conflict_MD_short;
                }
                case DELETED_BY_US: {
                    return UIText.StagingView_Conflict_DM_short;
                }
                case BOTH_MODIFIED: {
                    return UIText.StagingView_Conflict_M_short;
                }
                case BOTH_ADDED: {
                    return UIText.StagingView_Conflict_A_short;
                }
            }
        }
        return EMPTY_STRING;
    }

    private TreeViewer createViewer(Composite parent, final boolean unstaged, final Consumer<IStructuredSelection> dropAction, IAction ... tooltipActions) {
        TreeViewer viewer = this.createTree(parent);
        GridDataFactory.fillDefaults().grab(true, true).applyTo(viewer.getControl());
        viewer.getTree().setData("FormWidgetFactory.drawBorder", (Object)"treeBorder");
        UIUtils.setCssClass((Widget)viewer.getTree(), CSS_CLASS);
        StagingViewContentProvider contentProvider = this.createStagingContentProvider(unstaged);
        viewer.setContentProvider((IContentProvider)contentProvider);
        if (tooltipActions != null && tooltipActions.length > 0) {
            StagingViewTooltips tooltips = new StagingViewTooltips(viewer, tooltipActions);
            tooltips.setShift(new Point(1, 1));
        }
        viewer.setLabelProvider((IBaseLabelProvider)this.createLabelProvider(viewer));
        if (unstaged) {
            final Tree tree = viewer.getTree();
            tree.addListener(41, event -> {
                Object obj = ((TreeItem)event.item).getData();
                if (obj instanceof StagingEntry) {
                    StagingEntry entry = (StagingEntry)obj;
                    String text = StagingView.getConflictText(entry);
                    if (text.isEmpty()) {
                        entry.setExtraWidth(0);
                        return;
                    }
                    int width = event.gc.textExtent((String)text).x + 8;
                    event.width += width;
                    entry.setExtraWidth(width);
                }
            });
            tree.addListener(42, event -> {
                if (!event.gc.isClipped()) {
                    return;
                }
                Object obj = ((TreeItem)event.item).getData();
                if (obj instanceof StagingEntry) {
                    StagingEntry entry = (StagingEntry)obj;
                    String text = StagingView.getConflictText(entry);
                    if (text.isEmpty()) {
                        entry.setExtraWidth(0);
                        return;
                    }
                    Rectangle bounds = tree.getClientArea();
                    Rectangle clip = event.gc.getClipping();
                    if (clip.width < bounds.width) {
                        clip.width = bounds.width;
                        event.gc.setClipping(clip);
                    }
                    Rectangle cellBounds = ((TreeItem)event.item).getBounds();
                    Point extent = event.gc.textExtent(text);
                    int width = extent.x + 8;
                    entry.setExtraWidth(width);
                    int rightEdge = bounds.x + bounds.width;
                    event.gc.fillRectangle(rightEdge - width, cellBounds.y, width, cellBounds.height);
                    event.gc.drawString(text, rightEdge - extent.x - 4, cellBounds.y + (cellBounds.height - extent.y) / 2);
                }
            });
            ScrollBar bar = tree.getHorizontalBar();
            if (bar != null) {
                bar.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        super.widgetSelected(e);
                        tree.getDisplay().asyncExec(() -> {
                            if (!tree.isDisposed()) {
                                tree.redraw();
                            }
                        });
                    }
                });
            }
            ConflictStateHoverManager hovers = new ConflictStateHoverManager(viewer);
            hovers.install(viewer.getControl());
        }
        viewer.addDragSupport(7, new Transfer[]{LocalSelectionTransfer.getTransfer(), FileTransfer.getInstance()}, (DragSourceListener)new StagingDragListener((ISelectionProvider)viewer, contentProvider, unstaged));
        viewer.addDropSupport(7, new Transfer[]{LocalSelectionTransfer.getTransfer()}, (DropTargetListener)new DropTargetAdapter(){

            public void drop(DropTargetEvent event) {
                event.detail = 1;
                if (event.data instanceof IStructuredSelection) {
                    IStructuredSelection selection = (IStructuredSelection)event.data;
                    if (selection instanceof StagingDragSelection && ((StagingDragSelection)selection).isFromUnstaged() == unstaged) {
                        return;
                    }
                    dropAction.accept(selection);
                }
            }
        });
        viewer.addOpenListener(this::compareWith);
        viewer.setComparator((ViewerComparator)new StagingEntryComparator(!this.getSortCheckState(), this.getPreferenceStore().getBoolean("StagingView_FileNameMode")));
        viewer.addDoubleClickListener(event -> {
            IStructuredSelection selection = (IStructuredSelection)event.getSelection();
            Object selectedNode = selection.getFirstElement();
            if (selectedNode instanceof StagingFolderEntry) {
                viewer.setExpandedState(selectedNode, !viewer.getExpandedState(selectedNode));
            }
        });
        this.addCopyAction(viewer);
        StagingView.enableAutoExpand((AbstractTreeViewer)viewer);
        StagingView.addListenerToDisableAutoExpandOnCollapse(viewer);
        return viewer;
    }

    private void addCopyAction(TreeViewer viewer) {
        IAction copyAction = this.createSelectionPathCopyAction(viewer);
        ActionUtils.setGlobalActions(viewer.getControl(), (IHandlerService)this.getSite().getService(IHandlerService.class), copyAction);
    }

    private IAction createSelectionPathCopyAction(TreeViewer viewer) {
        ITreeSelection selection = viewer.getStructuredSelection();
        String copyPathActionText = MessageFormat.format(UIText.StagingView_CopyPaths, selection.size());
        IAction copyAction = ActionUtils.createGlobalAction(ActionFactory.COPY, () -> this.copyPathOfSelectionToClipboard(viewer));
        copyAction.setText(copyPathActionText);
        return copyAction;
    }

    private void copyPathOfSelectionToClipboard(TreeViewer viewer) {
        Clipboard cb = new Clipboard(viewer.getControl().getDisplay());
        try {
            TextTransfer t = TextTransfer.getInstance();
            String text = this.getTextFrom((IStructuredSelection)viewer.getSelection());
            if (text != null) {
                cb.setContents(new Object[]{text}, new Transfer[]{t});
            }
        }
        finally {
            cb.dispose();
        }
    }

    @Nullable
    private String getTextFrom(IStructuredSelection selection) {
        Object[] selectionEntries = selection.toArray();
        if (selectionEntries.length <= 0) {
            return null;
        }
        if (selectionEntries.length == 1) {
            return this.getPathFrom(selectionEntries[0]);
        }
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < selectionEntries.length) {
            String text = this.getPathFrom(selectionEntries[i]);
            if (text != null) {
                if (i < selectionEntries.length - 1) {
                    sb.append(text).append(System.lineSeparator());
                } else {
                    sb.append(text);
                }
            }
            ++i;
        }
        return sb.toString();
    }

    @Nullable
    private String getPathFrom(Object obj) {
        if (obj instanceof StagingEntry) {
            return ((StagingEntry)obj).getPath();
        }
        if (obj instanceof StagingFolderEntry) {
            return ((StagingFolderEntry)obj).getPath().toString();
        }
        return null;
    }

    private void setStagingViewerInput(TreeViewer stagingViewer, StagingViewUpdate newInput, Object[] previous, Set<IPath> additionalPaths) {
        final Tree tree = stagingViewer.getTree();
        tree.setRedraw(false);
        Cursor oldCursor = tree.getCursor();
        tree.setCursor(tree.getDisplay().getSystemCursor(1));
        try {
            TreeItem topItem = tree.getTopItem();
            final LinkedHashSet precedingObjects = new LinkedHashSet();
            if (topItem != null) {
                new TreeItemVisitor(tree.getItems()){

                    @Override
                    public boolean visit(TreeItem treeItem) {
                        precedingObjects.add(treeItem.getData());
                        return true;
                    }
                }.traverse(topItem);
                precedingObjects.remove(null);
            }
            boolean preserveTop = true;
            boolean keepSelectionVisible = false;
            StagingViewUpdate oldInput = (StagingViewUpdate)stagingViewer.getInput();
            if (oldInput != null && oldInput.repository == newInput.repository && oldInput.indexDiff != null) {
                Map<String, Object> newPaths;
                StagingViewContentProvider contentProvider = this.getContentProvider((ContentViewer)stagingViewer);
                ViewerComparator comparator = stagingViewer.getComparator();
                Map<String, Object> oldPaths = StagingView.buildElementMap(stagingViewer, contentProvider, comparator);
                stagingViewer.setInput((Object)newInput);
                if (previous != null) {
                    this.expandPreviousExpandedAndPaths(previous, stagingViewer, additionalPaths);
                }
                if ((newPaths = StagingView.buildElementMap(stagingViewer, contentProvider, comparator)).isEmpty()) {
                    preserveTop = false;
                } else {
                    StagingViewerUpdate stagingViewerUpdate = StagingView.updateSelection(stagingViewer, contentProvider, oldPaths, newPaths);
                    if (stagingViewerUpdate == StagingViewerUpdate.REMOVED) {
                        keepSelectionVisible = true;
                    } else if (stagingViewerUpdate == StagingViewerUpdate.ADDED) {
                        preserveTop = false;
                    }
                }
            } else {
                stagingViewer.setInput((Object)newInput);
                if (previous != null) {
                    this.expandPreviousExpandedAndPaths(previous, stagingViewer, additionalPaths);
                }
            }
            if (preserveTop) {
                TreeItem[] selection = tree.getSelection();
                TreeItem initialItem = keepSelectionVisible && selection.length > 0 ? selection[0] : null;
                new TreeItemVisitor(tree.getItems()){

                    @Override
                    public boolean visit(TreeItem treeItem) {
                        if (precedingObjects.contains(treeItem.getData())) {
                            tree.setTopItem(treeItem);
                            return false;
                        }
                        return true;
                    }
                }.traverse(initialItem);
            }
        }
        finally {
            tree.setRedraw(true);
            tree.setCursor(oldCursor);
        }
    }

    private static Map<String, Object> buildElementMap(TreeViewer stagingViewer, StagingViewContentProvider contentProvider, ViewerComparator comparator) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        Object[] elements = contentProvider.getElements(null);
        comparator.sort((Viewer)stagingViewer, elements);
        Object[] objectArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            StagingView.visitElement(stagingViewer, contentProvider, comparator, element, result);
            ++n2;
        }
        return result;
    }

    private static boolean visitElement(TreeViewer stagingViewer, StagingViewContentProvider contentProvider, ViewerComparator comparator, Object element, Map<String, Object> paths) {
        if (element instanceof StagingEntry) {
            StagingEntry stagingEntry = (StagingEntry)element;
            if (contentProvider.isInFilter(stagingEntry)) {
                String path = stagingEntry.getPath();
                paths.put(path, stagingEntry);
                return true;
            }
            return false;
        }
        if (element instanceof StagingFolderEntry) {
            StagingFolderEntry stagingFolderEntry = (StagingFolderEntry)element;
            Object[] children = contentProvider.getChildren(stagingFolderEntry);
            comparator.sort((Viewer)stagingViewer, children);
            IPath path = stagingFolderEntry.getPath();
            String pathString = path.toString();
            paths.put(pathString, stagingFolderEntry);
            boolean hasVisibleChildren = false;
            Object[] objectArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                Object child = objectArray[n2];
                if (StagingView.visitElement(stagingViewer, contentProvider, comparator, child, paths)) {
                    hasVisibleChildren = true;
                }
                ++n2;
            }
            if (hasVisibleChildren) {
                return true;
            }
            paths.remove(pathString);
            return false;
        }
        return false;
    }

    private static StagingViewerUpdate updateSelection(TreeViewer stagingViewer, StagingViewContentProvider contentProvider, Map<String, Object> oldPaths, Map<String, Object> newPaths) {
        LinkedHashMap<String, Object> addedPaths = new LinkedHashMap<String, Object>(newPaths);
        addedPaths.keySet().removeAll(oldPaths.keySet());
        if (!addedPaths.isEmpty()) {
            ArrayList<IProblemDecoratable> newSelection = new ArrayList<IProblemDecoratable>();
            LinkedHashSet elements = new LinkedHashSet(addedPaths.values());
            LinkedHashSet<StagingFolderEntry> excludeChildren = new LinkedHashSet<StagingFolderEntry>();
            for (Object element : elements) {
                if (element instanceof StagingEntry) {
                    StagingEntry stagingEntry = (StagingEntry)element;
                    if (excludeChildren.contains(stagingEntry.getParent())) continue;
                    newSelection.add(stagingEntry);
                    continue;
                }
                if (!(element instanceof StagingFolderEntry)) continue;
                StagingFolderEntry stagingFolderEntry = (StagingFolderEntry)element;
                StagingFolderEntry parent = stagingFolderEntry.getParent();
                if (excludeChildren.contains(parent)) {
                    excludeChildren.add(stagingFolderEntry);
                    continue;
                }
                if (!elements.containsAll(contentProvider.getStagingEntriesFiltered(stagingFolderEntry))) continue;
                newSelection.add(stagingFolderEntry);
                excludeChildren.add(stagingFolderEntry);
            }
            stagingViewer.setSelection((ISelection)new StructuredSelection(newSelection), true);
            return StagingViewerUpdate.ADDED;
        }
        LinkedHashMap<String, Object> removedPaths = new LinkedHashMap<String, Object>(oldPaths);
        removedPaths.keySet().removeAll(newPaths.keySet());
        if (!removedPaths.isEmpty()) {
            LinkedHashSet removedElements = new LinkedHashSet(removedPaths.values());
            Object firstRemovedElement = removedElements.iterator().next();
            Object parent = contentProvider.getParent(firstRemovedElement);
            Object candidate = null;
            boolean visitSubsequentSiblings = false;
            for (Object oldElement : oldPaths.values()) {
                if (oldElement == firstRemovedElement) {
                    visitSubsequentSiblings = true;
                }
                if (visitSubsequentSiblings) {
                    if (removedElements.contains(oldElement)) continue;
                    if (contentProvider.getParent(oldElement) == parent) {
                        candidate = oldElement;
                        break;
                    }
                    if (candidate == null) continue;
                    break;
                }
                if (candidate != null && oldElement != parent && contentProvider.getParent(oldElement) != parent) continue;
                candidate = oldElement;
            }
            if (candidate == null && !newPaths.isEmpty()) {
                candidate = newPaths.values().iterator().next();
            }
            if (candidate != null) {
                stagingViewer.setSelection((ISelection)new StructuredSelection(candidate), true);
                return StagingViewerUpdate.REMOVED;
            }
        }
        return StagingViewerUpdate.UNCHANGED;
    }

    private IPreferenceStore getPreferenceStore() {
        return Activator.getDefault().getPreferenceStore();
    }

    private StagingViewLabelProvider getLabelProvider(TreeViewer viewer) {
        CellLabelProvider base = viewer.getLabelProvider(0);
        if (base == null) {
            base = viewer.getLabelProvider();
        }
        return ((TreeDecoratingLabelProvider)base).getBaseLabelProvider();
    }

    private StagingViewContentProvider getContentProvider(ContentViewer viewer) {
        return (StagingViewContentProvider)viewer.getContentProvider();
    }

    private void updateSectionText() {
        this.stagedSection.setText(MessageFormat.format(UIText.StagingView_StagedChanges, this.getSectionCount(this.stagedViewer, false)));
        this.unstagedSection.setText(MessageFormat.format(UIText.StagingView_UnstagedChanges, this.getSectionCount(this.unstagedViewer, true)));
    }

    private String getSectionCount(TreeViewer viewer, boolean unstagedCount) {
        StagingViewContentProvider contentProvider = this.getContentProvider((ContentViewer)viewer);
        int count = contentProvider.getCount();
        int shownCount = contentProvider.getShownCount();
        if ((this.getFilterPattern() != null || unstagedCount && this.hideUntrackedAction.isChecked() && shownCount < count) && count > 0) {
            return String.valueOf(shownCount) + "/" + count;
        }
        return Integer.toString(count);
    }

    private void updateMessage() {
        String message;
        boolean needsRefresh = false;
        needsRefresh = this.hasErrorsOrWarnings() ? this.warningLabel.showMessage(UIText.StagingView_MessageErrors) : ((message = this.commitMessageComponent.getStatus().getMessage()) != null ? this.warningLabel.showMessage(message) : (this.isUnbornHead ? this.warningLabel.showInfo(MessageFormat.format(UIText.StagingView_InitialCommitText, this.currentBranch)) : this.warningLabel.hideMessage()));
        if (needsRefresh) {
            this.commitMessageSection.requestLayout();
            this.commitMessageSection.redraw();
        }
    }

    private void compareWith(OpenEvent event) {
        IStructuredSelection selection = (IStructuredSelection)event.getSelection();
        if (selection.isEmpty() || !(selection.getFirstElement() instanceof StagingEntry)) {
            return;
        }
        StagingEntry stagingEntry = (StagingEntry)selection.getFirstElement();
        if (stagingEntry.isSubmodule()) {
            return;
        }
        switch (stagingEntry.getState()) {
            case ADDED: 
            case CHANGED: 
            case REMOVED: {
                CommonUtils.runCommand("org.eclipse.egit.ui.team.CompareIndexWithHead", selection);
                break;
            }
            case CONFLICTING: {
                CommonUtils.runCommand("org.eclipse.egit.ui.team.MergeTool", selection);
                break;
            }
            default: {
                if (Activator.getDefault().getPreferenceStore().getBoolean("StagingView_CompareMode")) {
                    CommonUtils.runCommand("org.eclipse.egit.ui.team.CompareWithIndex", selection);
                    break;
                }
                this.openSelectionInEditor((ISelection)selection);
            }
        }
    }

    private void createPopupMenu(final TreeViewer treeViewer) {
        final MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        final Control control = treeViewer.getControl();
        control.setMenu(menuMgr.createContextMenu(control));
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                control.setFocus();
                ITreeSelection selection = treeViewer.getStructuredSelection();
                if (selection.isEmpty()) {
                    return;
                }
                LinkedHashSet<StagingEntry> stagingEntrySet = new LinkedHashSet<StagingEntry>();
                LinkedHashSet<StagingFolderEntry> stagingFolderSet = new LinkedHashSet<StagingFolderEntry>();
                boolean submoduleSelected = false;
                boolean folderSelected = false;
                boolean onlyFoldersSelected = true;
                Object[] objectArray = selection.toArray();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object element = objectArray[n2];
                    if (element instanceof StagingFolderEntry) {
                        StagingFolderEntry folder = (StagingFolderEntry)element;
                        folderSelected = true;
                        if (onlyFoldersSelected) {
                            stagingFolderSet.add(folder);
                        }
                        StagingViewContentProvider contentProvider = StagingView.this.getContentProvider((ContentViewer)treeViewer);
                        stagingEntrySet.addAll(contentProvider.getStagingEntriesFiltered(folder));
                    } else if (element instanceof StagingEntry) {
                        if (onlyFoldersSelected) {
                            stagingFolderSet.clear();
                        }
                        onlyFoldersSelected = false;
                        StagingEntry entry = (StagingEntry)element;
                        if (entry.isSubmodule()) {
                            submoduleSelected = true;
                        }
                        stagingEntrySet.add(entry);
                    }
                    ++n2;
                }
                ArrayList<StagingEntry> stagingEntryList = new ArrayList<StagingEntry>(stagingEntrySet);
                StructuredSelection fileSelection = new StructuredSelection(stagingEntryList);
                stagingEntrySet = null;
                if (!folderSelected) {
                    Action openWorkingTreeVersion = new Action(UIText.CommitFileDiffViewer_OpenWorkingTreeVersionInEditorMenuLabel, UIIcons.GOTO_INPUT, (IStructuredSelection)fileSelection){
                        private final /* synthetic */ IStructuredSelection val$fileSelection;
                        {
                            this.val$fileSelection = iStructuredSelection;
                            super($anonymous0, $anonymous1);
                        }

                        public void run() {
                            StagingView.this.openSelectionInEditor((ISelection)this.val$fileSelection);
                        }
                    };
                    openWorkingTreeVersion.setEnabled(!submoduleSelected && StagingView.this.anyElementIsExistingFile((IStructuredSelection)fileSelection));
                    menuMgr.add((IAction)openWorkingTreeVersion);
                    String label = ((StagingEntry)stagingEntryList.get(0)).isStaged() ? UIText.CommitFileDiffViewer_CompareWorkingDirectoryMenuLabel : UIText.StagingView_CompareWithIndexMenuLabel;
                    Action openCompareWithIndex = new Action(label, UIIcons.ELCL16_COMPARE_VIEW, (IStructuredSelection)fileSelection){
                        private final /* synthetic */ IStructuredSelection val$fileSelection;
                        {
                            this.val$fileSelection = iStructuredSelection;
                            super($anonymous0, $anonymous1);
                        }

                        public void run() {
                            CommonUtils.runCommand("org.eclipse.egit.ui.team.CompareWithIndex", this.val$fileSelection);
                        }
                    };
                    menuMgr.add((IAction)openCompareWithIndex);
                    if (stagingEntryList.size() == 1 && ((StagingEntry)stagingEntryList.get(0)).isStaged()) {
                        Action compareWithHead = new Action(UIText.StagingView_CompareWithHeadMenuLabel, UIIcons.ELCL16_COMPARE_VIEW, (IStructuredSelection)fileSelection){
                            private final /* synthetic */ IStructuredSelection val$fileSelection;
                            {
                                this.val$fileSelection = iStructuredSelection;
                                super($anonymous0, $anonymous1);
                            }

                            public void run() {
                                CommonUtils.runCommand("org.eclipse.egit.ui.team.CompareIndexWithHead", this.val$fileSelection);
                            }
                        };
                        menuMgr.add((IAction)compareWithHead);
                    }
                }
                Set<StagingEntry.Action> availableActions = StagingView.getAvailableActions((IStructuredSelection)fileSelection);
                boolean addReplaceWithFileInGitIndex = availableActions.contains((Object)StagingEntry.Action.REPLACE_WITH_FILE_IN_GIT_INDEX);
                boolean addReplaceWithHeadRevision = availableActions.contains((Object)StagingEntry.Action.REPLACE_WITH_HEAD_REVISION);
                boolean addStage = availableActions.contains((Object)StagingEntry.Action.STAGE);
                boolean addUnstage = availableActions.contains((Object)StagingEntry.Action.UNSTAGE);
                boolean addDelete = availableActions.contains((Object)StagingEntry.Action.DELETE);
                boolean addIgnore = availableActions.contains((Object)StagingEntry.Action.IGNORE);
                boolean addLaunchMergeTool = availableActions.contains((Object)StagingEntry.Action.LAUNCH_MERGE_TOOL);
                boolean addReplaceWithOursTheirsMenu = availableActions.contains((Object)StagingEntry.Action.REPLACE_WITH_OURS_THEIRS_MENU);
                boolean addAssumeUnchanged = availableActions.contains((Object)StagingEntry.Action.ASSUME_UNCHANGED);
                boolean addUntrack = availableActions.contains((Object)StagingEntry.Action.UNTRACK);
                if (addStage) {
                    menuMgr.add((IAction)new Action(UIText.StagingView_StageItemMenuLabel, UIIcons.ELCL16_ADD, (IStructuredSelection)selection){
                        private final /* synthetic */ IStructuredSelection val$selection;
                        {
                            this.val$selection = iStructuredSelection;
                            super($anonymous0, $anonymous1);
                        }

                        public void run() {
                            StagingView.this.stage(this.val$selection.toList());
                        }
                    });
                }
                if (addUnstage) {
                    menuMgr.add((IAction)new Action(UIText.StagingView_UnstageItemMenuLabel, UIIcons.UNSTAGE, (IStructuredSelection)selection){
                        private final /* synthetic */ IStructuredSelection val$selection;
                        {
                            this.val$selection = iStructuredSelection;
                            super($anonymous0, $anonymous1);
                        }

                        public void run() {
                            StagingView.this.unstage(this.val$selection.toList());
                        }
                    });
                }
                boolean selectionIncludesNonWorkspaceResources = StagingView.this.selectionIncludesNonWorkspaceResources((ISelection)fileSelection);
                if (addReplaceWithFileInGitIndex) {
                    if (selectionIncludesNonWorkspaceResources) {
                        menuMgr.add((IAction)new ReplaceAction(UIText.StagingView_replaceWithFileInGitIndex, (IStructuredSelection)fileSelection, false));
                    } else {
                        menuMgr.add(StagingView.this.createItem(UIText.StagingView_replaceWithFileInGitIndex, "org.eclipse.egit.ui.team.Discard", (IStructuredSelection)fileSelection));
                    }
                }
                if (addReplaceWithHeadRevision) {
                    if (selectionIncludesNonWorkspaceResources) {
                        menuMgr.add((IAction)new ReplaceAction(UIText.StagingView_replaceWithHeadRevision, (IStructuredSelection)fileSelection, true));
                    } else {
                        menuMgr.add(StagingView.this.createItem(UIText.StagingView_replaceWithHeadRevision, "org.eclipse.egit.ui.team.ReplaceWithHead", (IStructuredSelection)fileSelection));
                    }
                }
                if (addIgnore) {
                    if (!stagingFolderSet.isEmpty()) {
                        menuMgr.add((IAction)new IgnoreFoldersAction(stagingFolderSet));
                    }
                    menuMgr.add((IAction)new IgnoreAction((IStructuredSelection)fileSelection));
                }
                if (addDelete) {
                    menuMgr.add((IAction)new DeleteAction((IStructuredSelection)fileSelection));
                }
                if (addLaunchMergeTool) {
                    menuMgr.add((IAction)new Action(UIText.StagingView_MergeTool, UIIcons.MERGE_TOOL, (IStructuredSelection)fileSelection){
                        private final /* synthetic */ IStructuredSelection val$fileSelection;
                        {
                            this.val$fileSelection = iStructuredSelection;
                            super($anonymous0, $anonymous1);
                        }

                        public void run() {
                            CommonUtils.runCommand("org.eclipse.egit.ui.team.MergeTool", this.val$fileSelection);
                        }
                    });
                }
                if (addReplaceWithOursTheirsMenu) {
                    MenuManager replaceWithMenu = new MenuManager(UIText.StagingView_ReplaceWith);
                    ReplaceConflictMenu oursTheirsMenu = new ReplaceConflictMenu(StagingView.this.currentRepository, stagingEntryList);
                    replaceWithMenu.add((IContributionItem)oursTheirsMenu);
                    menuMgr.add((IContributionItem)replaceWithMenu);
                }
                if (addAssumeUnchanged) {
                    menuMgr.add((IAction)new Action(UIText.StagingView_Assume_Unchanged, UIIcons.ASSUME_UNCHANGED, (IStructuredSelection)selection){
                        private final /* synthetic */ IStructuredSelection val$selection;
                        {
                            this.val$selection = iStructuredSelection;
                            super($anonymous0, $anonymous1);
                        }

                        public void run() {
                            StagingView.this.assumeUnchanged(this.val$selection);
                        }
                    });
                }
                if (addUntrack) {
                    menuMgr.add((IAction)new Action(UIText.StagingView_Untrack, UIIcons.UNTRACK, (IStructuredSelection)selection){
                        private final /* synthetic */ IStructuredSelection val$selection;
                        {
                            this.val$selection = iStructuredSelection;
                            super($anonymous0, $anonymous1);
                        }

                        public void run() {
                            StagingView.this.untrack(this.val$selection);
                        }
                    });
                }
                menuMgr.add((IContributionItem)new Separator());
                menuMgr.add(StagingView.this.createShowInMenu());
                menuMgr.add(StagingView.this.createSelectionPathCopyAction(treeViewer));
            }
        });
    }

    private boolean anyElementIsExistingFile(IStructuredSelection s) {
        for (Object element : s.toList()) {
            StagingEntry entry;
            if (!(element instanceof StagingEntry) || (entry = (StagingEntry)element).getType() != 1 || !entry.getLocation().toFile().exists()) continue;
            return true;
        }
        return false;
    }

    Presentation getPresentation() {
        return this.presentation;
    }

    Pattern getFilterPattern() {
        return this.filterPattern;
    }

    private Pattern wildcardToRegex(String filter) {
        String trimmed = filter.trim();
        if (trimmed.isEmpty()) {
            return null;
        }
        String regex = String.valueOf(trimmed.contains("*") ? "^" : EMPTY_STRING) + "\\Q" + trimmed.replaceAll("\\*", Matcher.quoteReplacement("\\E.*?\\Q")) + "\\E";
        regex = regex.replaceAll(Pattern.quote("\\Q\\E"), EMPTY_STRING);
        return Pattern.compile(regex, 2);
    }

    public void refreshViewers() {
        StagingView.syncExec(() -> {
            this.setRedraw(false);
            try {
                this.refreshViewersInternal();
            }
            finally {
                this.setRedraw(true);
            }
        });
    }

    private void setRedraw(boolean redraw) {
        this.unstagedViewer.getControl().setRedraw(redraw);
        this.stagedViewer.getControl().setRedraw(redraw);
    }

    public void refreshViewersPreservingExpandedElements() {
        StagingView.syncExec(() -> {
            Object[] unstagedExpanded = this.unstagedViewer.getVisibleExpandedElements();
            Object[] stagedExpanded = this.stagedViewer.getVisibleExpandedElements();
            this.setRedraw(false);
            try {
                this.refreshViewersInternal();
                this.unstagedViewer.setExpandedElements(unstagedExpanded);
                this.stagedViewer.setExpandedElements(stagedExpanded);
            }
            finally {
                this.setRedraw(true);
            }
            this.stageAllAction.setEnabled(this.unstagedViewer.getTree().getItemCount() > 0);
            this.unstagedToolBarManager.update(true);
            this.unstageAllAction.setEnabled(this.stagedViewer.getTree().getItemCount() > 0);
            this.stagedToolBarManager.update(true);
        });
    }

    private void refreshViewersInternal() {
        ITreeSelection selection = this.unstagedViewer.getStructuredSelection();
        this.unstagedViewer.setSelection((ISelection)StructuredSelection.EMPTY);
        this.unstagedViewer.refresh();
        this.unstagedViewer.setSelection((ISelection)new StructuredSelection(selection.toList()));
        selection = this.stagedViewer.getStructuredSelection();
        this.stagedViewer.setSelection((ISelection)StructuredSelection.EMPTY);
        this.stagedViewer.refresh();
        this.stagedViewer.setSelection((ISelection)new StructuredSelection(selection.toList()));
        this.updateSectionText();
    }

    private IContributionItem createShowInMenu() {
        IWorkbenchWindow workbenchWindow = this.getSite().getWorkbenchWindow();
        return UIUtils.createShowInMenu(workbenchWindow);
    }

    private static List<IPath> getSelectedPaths(IStructuredSelection selection) {
        ArrayList<IPath> paths = new ArrayList<IPath>();
        for (StagingEntry stagingEntry : selection) {
            paths.add(stagingEntry.getLocation());
        }
        return paths;
    }

    private boolean selectionIncludesNonWorkspaceResources(ISelection selection) {
        if (!(selection instanceof IStructuredSelection)) {
            return false;
        }
        IStructuredSelection structuredSelection = (IStructuredSelection)selection;
        for (Object selectedObject : structuredSelection) {
            if (!(selectedObject instanceof StagingEntry)) {
                return false;
            }
            StagingEntry stagingEntry = (StagingEntry)selectedObject;
            IFile file = stagingEntry.getFile();
            if (file != null && file.isAccessible()) continue;
            return true;
        }
        return false;
    }

    private void openSelectionInEditor(ISelection s) {
        Repository repo = this.currentRepository;
        if (repo == null || s.isEmpty() || !(s instanceof IStructuredSelection)) {
            return;
        }
        IStructuredSelection iss = (IStructuredSelection)s;
        for (Object element : iss.toList()) {
            if (!(element instanceof StagingEntry)) continue;
            StagingEntry entry = (StagingEntry)element;
            String relativePath = entry.getPath();
            File file = new Path(repo.getWorkTree().getAbsolutePath()).append(relativePath).toFile();
            DiffViewer.openFileInEditor(file, -1);
        }
    }

    private static Set<StagingEntry.Action> getAvailableActions(IStructuredSelection selection) {
        EnumSet<StagingEntry.Action> availableActions = EnumSet.noneOf(StagingEntry.Action.class);
        for (StagingEntry stagingEntry : selection) {
            if (availableActions.isEmpty()) {
                availableActions.addAll(stagingEntry.getAvailableActions());
                continue;
            }
            availableActions.retainAll(stagingEntry.getAvailableActions());
        }
        return availableActions;
    }

    private IAction createItem(String text, final String commandId, final IStructuredSelection selection) {
        return new Action(text){

            public void run() {
                CommonUtils.runCommand(commandId, selection);
            }
        };
    }

    private boolean shouldUpdateSelection() {
        return !this.isDisposed() && this.partListener.isVisible() && this.reactOnSelection;
    }

    private void reactOnSelection(ISelection sel) {
        if (!(sel instanceof StructuredSelection)) {
            return;
        }
        StructuredSelection selection = (StructuredSelection)sel;
        if (selection.size() != 1 || this.isDisposed()) {
            return;
        }
        if (!this.shouldUpdateSelection()) {
            this.lastSelection = this.reactOnSelection ? selection : null;
            return;
        }
        this.lastSelection = null;
        Object firstElement = selection.getFirstElement();
        if (firstElement instanceof RepositoryTreeNode) {
            RepositoryTreeNode repoNode = (RepositoryTreeNode)firstElement;
            if (this.currentRepository != repoNode.getRepository()) {
                this.reload(repoNode.getRepository());
            }
        } else if (firstElement instanceof Repository) {
            Repository repo = (Repository)firstElement;
            if (this.currentRepository != repo) {
                this.reload(repo);
            }
        } else {
            Repository repo = (Repository)Adapters.adapt((Object)firstElement, Repository.class);
            if (repo != null) {
                if (this.currentRepository != repo) {
                    this.reload(repo);
                }
            } else {
                IResource resource = AdapterUtils.adaptToAnyResource((Object)firstElement);
                if (resource != null) {
                    this.showResource(resource);
                }
            }
        }
    }

    private void showResource(final IResource resource) {
        if (resource == null || !resource.isAccessible()) {
            return;
        }
        Job.getJobManager().cancel(JobFamilies.UPDATE_SELECTION);
        Job job = new Job(UIText.StagingView_GetRepo){

            protected IStatus run(IProgressMonitor monitor) {
                Repository newRep;
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                RepositoryMapping mapping = RepositoryMapping.getMapping((IResource)resource);
                if (mapping != null && (newRep = mapping.getRepository()) != null && newRep != StagingView.this.currentRepository) {
                    if (monitor.isCanceled()) {
                        return Status.CANCEL_STATUS;
                    }
                    StagingView.this.reload(newRep);
                }
                return Status.OK_STATUS;
            }

            public boolean belongsTo(Object family) {
                return JobFamilies.UPDATE_SELECTION == family;
            }

            public boolean shouldRun() {
                return StagingView.this.shouldUpdateSelection();
            }
        };
        job.setSystem(true);
        this.schedule(job, false);
    }

    private void stage(Collection<?> selectedEntries) {
        StagingViewContentProvider contentProvider = this.getContentProvider((ContentViewer)this.unstagedViewer);
        final Repository repository = this.currentRepository;
        Iterator<?> iterator = selectedEntries.iterator();
        final HashSet<String> addPaths = new HashSet<String>();
        final HashSet<String> rmPaths = new HashSet<String>();
        this.resetPathsToExpand();
        while (iterator.hasNext()) {
            RepositoryMapping mapping;
            Object element = iterator.next();
            if (element instanceof StagingEntry) {
                StagingEntry entry = (StagingEntry)element;
                this.selectEntryForStaging(entry, addPaths, rmPaths);
                StagingView.addPathAndParentPaths(entry.getParentPath(), this.pathsToExpandInStaged);
                continue;
            }
            if (element instanceof StagingFolderEntry) {
                StagingFolderEntry folder = (StagingFolderEntry)element;
                List<StagingEntry> entries = contentProvider.getStagingEntriesFiltered(folder);
                for (StagingEntry entry : entries) {
                    this.selectEntryForStaging(entry, addPaths, rmPaths);
                }
                StagingView.addExpandedPathsBelowFolder(folder, this.unstagedViewer, this.pathsToExpandInStaged);
                continue;
            }
            IResource resource = AdapterUtils.adaptToAnyResource(element);
            if (resource == null || (mapping = RepositoryMapping.getMapping((IResource)resource)) == null || mapping.getRepository() != this.currentRepository) continue;
            String path = mapping.getRepoRelativePath(resource);
            if (path == null || path.isEmpty()) {
                addPaths.add(".");
                continue;
            }
            addPaths.add(path);
        }
        if (!addPaths.isEmpty()) {
            Job addJob = new Job(UIText.StagingView_AddJob){

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        Throwable throwable = null;
                        Object var3_7 = null;
                        try (Git git = new Git(repository);){
                            AddCommand add = git.add();
                            for (String addPath : addPaths) {
                                add.addFilepattern(addPath);
                            }
                            add.call();
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                    }
                    catch (NoFilepatternException noFilepatternException) {
                    }
                    catch (JGitInternalException e1) {
                        Activator.handleError(e1.getCause().getMessage(), e1.getCause(), true);
                    }
                    catch (Exception e1) {
                        Activator.handleError(e1.getMessage(), e1, true);
                    }
                    return Status.OK_STATUS;
                }

                public boolean belongsTo(Object family) {
                    return family == JobFamilies.ADD_TO_INDEX;
                }
            };
            this.schedule(addJob, true);
        }
        if (!rmPaths.isEmpty()) {
            Job removeJob = new Job(UIText.StagingView_RemoveJob){

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        Throwable throwable = null;
                        Object var3_7 = null;
                        try (Git git = new Git(repository);){
                            RmCommand rm = git.rm().setCached(true);
                            for (String rmPath : rmPaths) {
                                rm.addFilepattern(rmPath);
                            }
                            rm.call();
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                    }
                    catch (NoFilepatternException noFilepatternException) {
                    }
                    catch (JGitInternalException e) {
                        Activator.handleError(e.getCause().getMessage(), e.getCause(), true);
                    }
                    catch (Exception e) {
                        Activator.handleError(e.getMessage(), e, true);
                    }
                    return Status.OK_STATUS;
                }

                public boolean belongsTo(Object family) {
                    return family == JobFamilies.REMOVE_FROM_INDEX;
                }
            };
            this.schedule(removeJob, true);
        }
    }

    private void selectEntryForStaging(StagingEntry entry, Collection<String> addPaths, Collection<String> rmPaths) {
        switch (entry.getState()) {
            case ADDED: 
            case CHANGED: 
            case REMOVED: {
                break;
            }
            case CONFLICTING: {
                if (!entry.getLocation().toFile().exists()) {
                    rmPaths.add(entry.getPath());
                    break;
                }
                addPaths.add(entry.getPath());
                break;
            }
            case MODIFIED: 
            case MODIFIED_AND_CHANGED: 
            case MODIFIED_AND_ADDED: 
            case UNTRACKED: {
                addPaths.add(entry.getPath());
                break;
            }
            case MISSING: 
            case MISSING_AND_CHANGED: {
                rmPaths.add(entry.getPath());
            }
        }
    }

    private void unstage(Collection<?> selectedEntries) {
        if (selectedEntries.isEmpty()) {
            return;
        }
        final Collection<String> paths = this.processUnstageSelection(selectedEntries);
        if (paths.isEmpty()) {
            return;
        }
        final Repository repository = this.currentRepository;
        Job resetJob = new Job(UIText.StagingView_ResetJob){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    Throwable throwable = null;
                    Object var3_5 = null;
                    try (Git git = new Git(repository);){
                        ResetCommand reset = git.reset();
                        for (String path : paths) {
                            reset.addPath(path);
                        }
                        reset.call();
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (GitAPIException e) {
                    Activator.handleError(e.getMessage(), e, true);
                }
                return Status.OK_STATUS;
            }

            public boolean belongsTo(Object family) {
                return family == JobFamilies.RESET;
            }
        };
        this.schedule(resetJob, true);
    }

    private Collection<String> processUnstageSelection(Collection<?> selectedEntries) {
        HashSet<String> paths = new HashSet<String>();
        this.resetPathsToExpand();
        for (Object element : selectedEntries) {
            if (element instanceof StagingEntry) {
                StagingEntry entry = (StagingEntry)element;
                this.addUnstagePath(entry, paths);
                StagingView.addPathAndParentPaths(entry.getParentPath(), this.pathsToExpandInUnstaged);
                continue;
            }
            if (!(element instanceof StagingFolderEntry)) continue;
            StagingFolderEntry folder = (StagingFolderEntry)element;
            List<StagingEntry> entries = this.getContentProvider((ContentViewer)this.stagedViewer).getStagingEntriesFiltered(folder);
            for (StagingEntry entry : entries) {
                this.addUnstagePath(entry, paths);
            }
            StagingView.addExpandedPathsBelowFolder(folder, this.stagedViewer, this.pathsToExpandInUnstaged);
        }
        return paths;
    }

    private void addUnstagePath(StagingEntry entry, Collection<String> paths) {
        switch (entry.getState()) {
            case ADDED: 
            case CHANGED: 
            case REMOVED: {
                paths.add(entry.getPath());
                return;
            }
        }
    }

    private void assumeUnchanged(@NonNull IStructuredSelection selection) {
        ArrayList<IPath> locations = new ArrayList<IPath>();
        this.collectPaths(selection.toList(), locations);
        if (locations.isEmpty()) {
            return;
        }
        JobUtil.scheduleUserJob((IEGitOperation)new AssumeUnchangedOperation(this.currentRepository, locations, true), (String)UIText.AssumeUnchanged_assumeUnchanged, (Object)JobFamilies.ASSUME_NOASSUME_UNCHANGED);
    }

    private void untrack(@NonNull IStructuredSelection selection) {
        ArrayList<IPath> locations = new ArrayList<IPath>();
        this.collectPaths(selection.toList(), locations);
        if (locations.isEmpty()) {
            return;
        }
        JobUtil.scheduleUserJob((IEGitOperation)new UntrackOperation(this.currentRepository, locations), (String)UIText.Untrack_untrack, (Object)JobFamilies.UNTRACK);
    }

    private void collectPaths(Object o, List<IPath> result) {
        if (o instanceof Iterable) {
            ((Iterable)o).forEach(child -> this.collectPaths(child, result));
        } else if (o instanceof StagingFolderEntry) {
            StagingViewContentProvider contentProvider = this.getContentProvider((ContentViewer)this.unstagedViewer);
            List<StagingEntry> entries = contentProvider.getStagingEntriesFiltered((StagingFolderEntry)o);
            this.collectPaths(entries, result);
        } else if (o instanceof StagingEntry) {
            result.add((IPath)Adapters.adapt((Object)o, IPath.class));
        }
    }

    private void resetPathsToExpand() {
        this.pathsToExpandInStaged = new HashSet<IPath>();
        this.pathsToExpandInUnstaged = new HashSet<IPath>();
    }

    private static void addExpandedPathsBelowFolder(StagingFolderEntry folder, TreeViewer treeViewer, Set<IPath> addToSet) {
        if (treeViewer.getExpandedState((Object)folder)) {
            StagingView.addPathAndParentPaths(folder.getPath(), addToSet);
        }
        StagingView.addExpandedSubfolders(folder, treeViewer, addToSet);
    }

    private static void addExpandedSubfolders(StagingFolderEntry folder, TreeViewer treeViewer, Set<IPath> addToSet) {
        Object[] objectArray = folder.getChildren();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object child = objectArray[n2];
            if (child instanceof StagingFolderEntry && treeViewer.getExpandedState(child)) {
                addToSet.add(((StagingFolderEntry)child).getPath());
                StagingView.addExpandedSubfolders((StagingFolderEntry)child, treeViewer, addToSet);
            }
            ++n2;
        }
    }

    private static void addPathAndParentPaths(IPath initialPath, Set<IPath> addToSet) {
        IPath p = initialPath;
        while (p.segmentCount() > 0 && addToSet.add(p)) {
            p = p.removeLastSegments(1);
        }
    }

    private boolean isValidRepo(Repository repository) {
        return repository != null && !repository.isBare() && repository.getWorkTree().exists();
    }

    private void clearRepository(@Nullable Repository repository) {
        this.saveCommitMessageComponentState();
        this.removeRepositoryListeners();
        this.realRepository = repository;
        this.currentRepository = null;
        this.currentPushMode.clear();
        if (this.isDisposed()) {
            return;
        }
        StagingViewUpdate update = new StagingViewUpdate(null, null, null);
        this.setStagingViewerInput(this.unstagedViewer, update, null, null);
        this.setStagingViewerInput(this.stagedViewer, update, null, null);
        this.pushSettings.load((Repository)null);
        this.enableCommitWidgets(false);
        this.refreshAction.setEnabled(false);
        this.updateSectionText();
        this.titleNode = null;
        this.form.setImage(this.getImage(UIIcons.REPOSITORY));
        if (repository != null && repository.isBare()) {
            this.form.setText(UIText.StagingView_BareRepoSelection);
        } else {
            this.form.setText(UIText.StagingView_NoSelectionTitle);
        }
        this.updateIgnoreErrorsButtonVisibility();
        this.updateRebaseButtonVisibility(false);
        this.unstagedViewer.setSelection(this.unstagedViewer.getSelection());
    }

    protected void updateRebaseButtonVisibility(boolean isRebasing) {
        this.asyncExec(() -> {
            StagingView.showControl((Control)this.rebaseSection, isRebasing);
            this.rebaseSection.getParent().layout(true);
        });
    }

    private static void showControl(Control c, boolean show) {
        c.setVisible(show);
        GridData g = (GridData)c.getLayoutData();
        g.exclude = !show;
    }

    public void setAmending(boolean isAmending) {
        if (this.isDisposed()) {
            return;
        }
        if (this.amendPreviousCommitAction.isChecked() != isAmending) {
            this.amendPreviousCommitAction.setChecked(isAmending);
            this.amendPreviousCommitAction.run();
        }
    }

    public void setCommitText(String message) {
        this.commitMessageText.setText(message);
    }

    public void reload(Repository repository) {
        if (this.isDisposed()) {
            return;
        }
        if (repository == null) {
            this.asyncUpdate(() -> this.clearRepository(null));
            return;
        }
        if (!this.isValidRepo(repository)) {
            this.asyncUpdate(() -> this.clearRepository(repository));
            return;
        }
        boolean repositoryChanged = this.currentRepository != repository;
        this.realRepository = repository;
        this.currentRepository = repository;
        this.asyncUpdate(() -> {
            if (this.isDisposed()) {
                return;
            }
            IndexDiffData indexDiff = this.doReload(repository);
            boolean indexDiffAvailable = StagingView.indexDiffAvailable(indexDiff);
            boolean noConflicts = StagingView.noConflicts(indexDiff);
            if (repositoryChanged) {
                this.titleNode = new RepositoryNode(null, repository);
                this.updateTitle(true);
                this.pushSettings.load(repository);
                this.currentPushMode.clear();
                this.resetPathsToExpand();
                this.removeRepositoryListeners();
                this.refsChangedListener = repository.getListenerList().addRefsChangedListener(event -> this.updateRebaseButtonVisibility(repository.getRepositoryState().isRebasing()));
                this.configChangedListener = repository.getListenerList().addConfigChangedListener(event -> {
                    this.updateCommitAuthorAndCommitter(repository);
                    this.asyncExec(() -> {
                        this.currentPushMode.clear();
                        this.updateCommitAndPush(repository);
                        this.setCleanup(repository);
                    });
                });
            } else if (this.titleNode != null) {
                this.updateTitle(false);
            }
            StagingViewUpdate update = new StagingViewUpdate(repository, indexDiff, null);
            Object[] unstagedExpanded = this.unstagedViewer.getVisibleExpandedElements();
            Object[] stagedExpanded = this.stagedViewer.getVisibleExpandedElements();
            int unstagedElementsCount = this.updateAutoExpand(this.unstagedViewer, StagingView.getUnstaged(indexDiff));
            int stagedElementsCount = this.updateAutoExpand(this.stagedViewer, StagingView.getStaged(indexDiff));
            int elementsCount = unstagedElementsCount + stagedElementsCount;
            if (elementsCount > this.getMaxLimitForListMode()) {
                this.listPresentationAction.setEnabled(false);
                if (this.presentation == Presentation.LIST) {
                    this.compactTreePresentationAction.setChecked(true);
                    this.switchToCompactModeInternal(true);
                } else {
                    this.setExpandCollapseActionsVisible(false, unstagedElementsCount <= this.getMaxLimitForListMode(), true);
                    this.setExpandCollapseActionsVisible(true, stagedElementsCount <= this.getMaxLimitForListMode(), true);
                }
            } else {
                this.listPresentationAction.setEnabled(true);
                boolean changed = this.getPreferenceStore().getBoolean("StagingView_Presentation_Changed");
                if (changed) {
                    this.listPresentationAction.setChecked(true);
                    this.switchToListMode();
                } else if (this.presentation != Presentation.LIST) {
                    this.setExpandCollapseActionsVisible(false, true, true);
                    this.setExpandCollapseActionsVisible(true, true, true);
                }
            }
            this.setStagingViewerInput(this.unstagedViewer, update, unstagedExpanded, this.pathsToExpandInUnstaged);
            this.setStagingViewerInput(this.stagedViewer, update, stagedExpanded, this.pathsToExpandInStaged);
            this.resetPathsToExpand();
            this.unstagedViewer.setSelection(this.unstagedViewer.getSelection());
            this.refreshAction.setEnabled(true);
            this.updateRebaseButtonVisibility(repository.getRepositoryState().isRebasing());
            this.updateIgnoreErrorsButtonVisibility();
            boolean rebaseContinueEnabled = indexDiffAvailable && repository.getRepositoryState().isRebasing() && noConflicts;
            this.rebaseContinueButton.setEnabled(rebaseContinueEnabled);
            this.isUnbornHead = false;
            if (repository.getRepositoryState() == RepositoryState.SAFE) {
                try {
                    Ref head = repository.exactRef("HEAD");
                    if (head != null && head.isSymbolic() && head.getObjectId() == null) {
                        this.isUnbornHead = true;
                    }
                    this.currentBranch = repository.getBranch();
                }
                catch (IOException e) {
                    Activator.logError(e.getLocalizedMessage(), e);
                }
            }
            this.updateCommitMessageComponent(repositoryChanged, indexDiffAvailable);
            this.enableCommitWidgets(indexDiffAvailable && noConflicts);
            this.updateCommitButtons();
            this.updateSectionText();
            if (repositoryChanged && this.hideUntrackedAction.isChecked()) {
                this.hideUntrackedAction.setChecked(false);
                this.updateUnstagedViewer();
            }
        });
    }

    private void removeRepositoryListeners() {
        if (this.refsChangedListener != null) {
            this.refsChangedListener.remove();
            this.refsChangedListener = null;
        }
        if (this.configChangedListener != null) {
            this.configChangedListener.remove();
            this.configChangedListener = null;
        }
    }

    private int getMaxLimitForListMode() {
        return Activator.getDefault().getPreferenceStore().getInt("StagingView_MaxLimitListMode");
    }

    private static int getUnstaged(@Nullable IndexDiffData indexDiff) {
        if (indexDiff == null) {
            return 0;
        }
        int size = indexDiff.getUntracked().size();
        size += indexDiff.getMissing().size();
        size += indexDiff.getModified().size();
        return size += indexDiff.getConflicting().size();
    }

    private static int getStaged(@Nullable IndexDiffData indexDiff) {
        if (indexDiff == null) {
            return 0;
        }
        int size = indexDiff.getAdded().size();
        size += indexDiff.getChanged().size();
        return size += indexDiff.getRemoved().size();
    }

    private int updateAutoExpand(TreeViewer viewer, int newSize) {
        if (newSize > this.getMaxLimitForListMode()) {
            StagingView.disableAutoExpand((AbstractTreeViewer)viewer);
        }
        return newSize;
    }

    private void switchToCompactModeInternal(boolean auto) {
        this.setPresentation(Presentation.COMPACT_TREE, auto);
        this.listPresentationAction.setChecked(false);
        this.treePresentationAction.setChecked(false);
        if (auto) {
            this.setExpandCollapseActionsVisible(false, false, true);
            this.setExpandCollapseActionsVisible(true, false, true);
        } else {
            this.setExpandCollapseActionsVisible(false, this.isExpandAllowed(false), true);
            this.setExpandCollapseActionsVisible(true, this.isExpandAllowed(true), true);
        }
    }

    private void switchToListMode() {
        this.setPresentation(Presentation.LIST, false);
        this.treePresentationAction.setChecked(false);
        this.compactTreePresentationAction.setChecked(false);
        this.setExpandCollapseActionsVisible(false, false, false);
        this.setExpandCollapseActionsVisible(true, false, false);
    }

    private static boolean noConflicts(IndexDiffData indexDiff) {
        return indexDiff == null ? true : indexDiff.getConflicting().isEmpty();
    }

    private static boolean indexDiffAvailable(IndexDiffData indexDiff) {
        return indexDiff != null;
    }

    private boolean hasErrorsOrWarnings() {
        return this.getPreferenceStore().getBoolean("checkBeforeCommitting") && !this.ignoreErrors.getSelection() && this.hasProblemSeverity(Integer.parseInt(this.getPreferenceStore().getString("warnBeforeCommitting")));
    }

    private boolean isCommitBlocked() {
        return this.getPreferenceStore().getBoolean("blockCommit") && !this.ignoreErrors.getSelection() && this.hasProblemSeverity(Integer.parseInt(this.getPreferenceStore().getString("blockCommitCombo")));
    }

    private IndexDiffData doReload(@NonNull Repository repository) {
        IndexDiffCacheEntry entry = IndexDiffCache.INSTANCE.getIndexDiffCacheEntry(repository);
        if (this.cacheEntry != null && this.cacheEntry != entry) {
            this.cacheEntry.removeIndexDiffChangedListener(this.myIndexDiffListener);
        }
        this.cacheEntry = entry;
        this.cacheEntry.addIndexDiffChangedListener(this.myIndexDiffListener);
        return this.cacheEntry.getIndexDiff();
    }

    private void expandPreviousExpandedAndPaths(Object[] previous, TreeViewer viewer, Set<IPath> additionalPaths) {
        Object element;
        StagingViewContentProvider stagedContentProvider = this.getContentProvider((ContentViewer)viewer);
        int count = stagedContentProvider.getCount();
        this.updateAutoExpand(viewer, count);
        if (viewer.getAutoExpandLevel() == -1) {
            return;
        }
        if (this.getPresentation() == Presentation.LIST) {
            return;
        }
        HashSet<IPath> paths = new HashSet<IPath>(additionalPaths);
        Object[] objectArray = previous;
        int n = previous.length;
        int n2 = 0;
        while (n2 < n) {
            element = objectArray[n2];
            if (element instanceof StagingFolderEntry) {
                StagingView.addPathAndParentPaths(((StagingFolderEntry)element).getPath(), paths);
            }
            ++n2;
        }
        objectArray = viewer.getVisibleExpandedElements();
        n = objectArray.length;
        n2 = 0;
        while (n2 < n) {
            element = objectArray[n2];
            if (element instanceof StagingFolderEntry) {
                StagingView.addPathAndParentPaths(((StagingFolderEntry)element).getPath(), paths);
            }
            ++n2;
        }
        ArrayList<StagingFolderEntry> expand = new ArrayList<StagingFolderEntry>();
        this.calculateNodesToExpand(paths, stagedContentProvider.getElements(null), expand);
        viewer.setExpandedElements(expand.toArray());
    }

    private void calculateNodesToExpand(Set<IPath> paths, Object[] elements, List<StagingFolderEntry> result) {
        if (elements == null) {
            return;
        }
        Object[] objectArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            StagingFolderEntry folder;
            Object element = objectArray[n2];
            if (element instanceof StagingFolderEntry && paths.contains((folder = (StagingFolderEntry)element).getPath())) {
                result.add(folder);
                this.calculateNodesToExpand(paths, folder.getChildren(), result);
            }
            ++n2;
        }
    }

    private void clearCommitMessageToggles() {
        this.amendPreviousCommitAction.setChecked(false);
        this.addChangeIdAction.setChecked(false);
        this.signedOffByAction.setChecked(false);
        this.signCommitAction.setChecked(false);
    }

    void updateCommitMessageComponent(boolean repositoryChanged, boolean indexDiffAvailable) {
        if (repositoryChanged) {
            if (this.commitMessageComponent.isAmending() || this.userEnteredCommitMessage()) {
                this.saveCommitMessageComponentState();
            } else {
                this.deleteCommitMessageComponentState();
            }
        }
        if (!indexDiffAvailable) {
            return;
        }
        CommitHelper helper = new CommitHelper(this.currentRepository);
        CommitMessageComponentState oldState = null;
        boolean changed = false;
        if (repositoryChanged || this.commitMessageComponent.getRepository() != this.currentRepository) {
            oldState = this.loadCommitMessageComponentState();
            this.commitMessageComponent.setRepository(this.currentRepository);
            if (oldState == null) {
                this.loadInitialState(helper);
            } else {
                this.loadExistingState(helper, oldState);
            }
            changed = true;
        } else if (!this.commitMessageComponent.getHeadCommit().equals((AnyObjectId)helper.getPreviousCommit()) || !this.commitMessageComponent.isAmending()) {
            if (!this.commitMessageComponent.isAmending() && this.userEnteredCommitMessage()) {
                this.addHeadChangedWarning(this.commitMessageText.getText(), this.commitMessageComponent.getCommentChar());
            } else {
                this.loadInitialState(helper);
            }
            changed = true;
        }
        if (changed && this.previewAction.isChecked()) {
            this.previewAction.setChecked(false);
            this.previewAction.run();
        }
        this.amendPreviousCommitAction.setChecked(this.commitMessageComponent.isAmending());
        this.amendPreviousCommitAction.setEnabled(helper.amendAllowed());
        this.updateMessage();
    }

    private void updateCommitAuthorAndCommitter(Repository repository) {
        CommitHelper helper = new CommitHelper(repository);
        this.asyncExec(() -> {
            boolean authorEqualsCommitter = this.commitMessageComponent.getAuthor().equals(this.commitMessageComponent.getCommitter());
            if (authorEqualsCommitter) {
                this.commitMessageComponent.setAuthor(helper.getAuthor());
            }
            this.commitMessageComponent.setCommitter(helper.getCommitter());
            this.commitMessageComponent.updateUIFromState(false);
        });
    }

    public void resetCommitMessageComponent() {
        if (this.currentRepository != null) {
            String commitMessage = this.commitMessageComponent.getCommitMessage();
            if (commitMessage.trim().length() > 0) {
                CommitMessageHistory.saveCommitHistory(commitMessage);
            }
            this.loadInitialState(new CommitHelper(this.currentRepository));
        }
    }

    private void loadExistingState(CommitHelper helper, CommitMessageComponentState oldState) {
        boolean headCommitChanged = !oldState.getHeadCommit().equals((AnyObjectId)this.getCommitId(helper.getPreviousCommit()));
        this.commitMessageComponent.enableListeners(false);
        this.commitMessageComponent.setAuthor(oldState.getAuthor());
        String oldMessage = oldState.getCommitMessage();
        CommitConfig config = (CommitConfig)this.commitMessageComponent.getRepository().getConfig().get(CommitConfig.KEY);
        char commentChar = oldState.getAutoCommentChar();
        if (config.isAutoCommentChar() || commentChar != '\u0000') {
            if (commentChar == '\u0000') {
                commentChar = config.getCommentChar(Utils.normalizeLineEndings((String)oldMessage));
            }
            this.commitMessageComponent.setAutoCommentChar(commentChar);
        } else {
            commentChar = config.getCommentChar();
            this.commitMessageComponent.setAutoCommentChar('\u0000');
        }
        this.commitMessageComponent.setCommentChar(commentChar);
        CommitConfig.CleanupMode mode = config.resolve(CommitConfig.CleanupMode.DEFAULT, true);
        this.commitMessageText.setCleanupMode(mode, commentChar);
        if (headCommitChanged) {
            this.addHeadChangedWarning(oldMessage, commentChar);
        } else {
            this.commitMessageComponent.setCommitMessage(oldMessage);
            this.commitMessageComponent.setCaretPosition(oldState.getCaretPosition());
        }
        this.commitMessageComponent.setCommitter(oldState.getCommitter());
        this.commitMessageComponent.setHeadCommit(this.getCommitId(helper.getPreviousCommit()));
        this.commitMessageComponent.setCommitAllowed(helper.canCommit());
        this.commitMessageComponent.setCannotCommitMessage(helper.getCannotCommitMessage());
        boolean amendAllowed = helper.amendAllowed();
        this.commitMessageComponent.setAmendAllowed(amendAllowed);
        if (!amendAllowed) {
            this.commitMessageComponent.setAmending(false);
        } else if (!headCommitChanged && oldState.getAmend()) {
            this.commitMessageComponent.setAmending(true);
        } else {
            this.commitMessageComponent.setAmending(false);
        }
        this.commitMessageComponent.setSignCommit(oldState.getSign());
        this.commitMessageComponent.updateUIFromState();
        this.commitMessageComponent.updateSignedOffAndChangeIdButton();
        this.commitMessageComponent.enableListeners(true);
    }

    private void addHeadChangedWarning(String commitMessage, char commentStart) {
        String warning = EMPTY_STRING + commentStart + ' ' + UIText.StagingView_headCommitChanged;
        if (!commitMessage.startsWith(warning)) {
            String message = String.valueOf(warning) + Text.DELIMITER + Text.DELIMITER + commitMessage;
            this.commitMessageComponent.setCommitMessage(message);
        }
    }

    private void loadInitialState(CommitHelper helper) {
        char commentChar;
        String initialMessage;
        this.commitMessageComponent.enableListeners(false);
        this.commitMessageComponent.resetState();
        this.commitMessageComponent.setAuthor(helper.getAuthor());
        CommitConfig config = (CommitConfig)this.commitMessageComponent.getRepository().getConfig().get(CommitConfig.KEY);
        if (helper.shouldUseCommitTemplate()) {
            initialMessage = helper.getCommitTemplate();
            commentChar = '\u0000';
        } else {
            initialMessage = helper.getCommitMessage();
            commentChar = helper.getCommentChar();
        }
        if (config.isAutoCommentChar() || commentChar != '\u0000') {
            if (commentChar == '\u0000') {
                commentChar = config.getCommentChar(Utils.normalizeLineEndings((String)initialMessage));
            }
            this.commitMessageComponent.setAutoCommentChar(commentChar);
        } else {
            commentChar = config.getCommentChar();
            this.commitMessageComponent.setAutoCommentChar('\u0000');
        }
        this.commitMessageComponent.setCommentChar(commentChar);
        CommitConfig.CleanupMode mode = config.resolve(CommitConfig.CleanupMode.DEFAULT, true);
        this.commitMessageText.setCleanupMode(mode, commentChar);
        this.commitMessageComponent.setCommitMessage(initialMessage);
        this.commitMessageComponent.setCommitter(helper.getCommitter());
        this.commitMessageComponent.setHeadCommit(this.getCommitId(helper.getPreviousCommit()));
        this.commitMessageComponent.setCommitAllowed(helper.canCommit());
        this.commitMessageComponent.setCannotCommitMessage(helper.getCannotCommitMessage());
        this.commitMessageComponent.setAmendAllowed(helper.amendAllowed());
        this.commitMessageComponent.setAmending(false);
        this.commitMessageComponent.setDefaults();
        this.commitMessageComponent.updateUI();
        this.commitMessageComponent.enableListeners(true);
    }

    private void setCleanup(Repository repo) {
        if (repo != null) {
            char commentChar;
            CommitConfig config = (CommitConfig)repo.getConfig().get(CommitConfig.KEY);
            CommitConfig.CleanupMode mode = config.resolve(CommitConfig.CleanupMode.DEFAULT, true);
            if (config.isAutoCommentChar()) {
                commentChar = this.commitMessageComponent.getAutoCommentChar();
                if (commentChar == '\u0000') {
                    String currentMessage = Utils.normalizeLineEndings((String)this.commitMessageText.getText());
                    commentChar = config.getCommentChar(currentMessage);
                    this.commitMessageComponent.setCommentChar(commentChar);
                    this.commitMessageComponent.setAutoCommentChar(commentChar);
                }
            } else {
                commentChar = config.getCommentChar();
                this.commitMessageComponent.setCommentChar(commentChar);
                this.commitMessageComponent.setAutoCommentChar('\u0000');
            }
            this.commitMessageText.setCleanupMode(mode, commentChar);
        } else {
            this.commitMessageText.setCleanupMode(CommitConfig.CleanupMode.STRIP, '#');
        }
        this.commitMessageText.invalidatePresentation();
    }

    private boolean userEnteredCommitMessage() {
        if (this.commitMessageComponent.getRepository() == null) {
            return false;
        }
        String warning = EMPTY_STRING + this.commitMessageComponent.getCommentChar() + ' ' + UIText.StagingView_headCommitChanged;
        String message = this.commitMessageComponent.getCommitMessage().replace(warning, EMPTY_STRING);
        if (message.trim().isEmpty()) {
            return false;
        }
        String chIdLine = "Change-Id: I" + ObjectId.zeroId().name();
        Repository repo = this.currentRepository;
        if (repo != null && GerritUtil.getCreateChangeId((Config)repo.getConfig()) && this.commitMessageComponent.getCreateChangeId()) {
            if (message.trim().equals(chIdLine)) {
                return false;
            }
            message = message.replace(chIdLine, EMPTY_STRING);
        }
        return !Activator.getDefault().getPreferenceStore().getBoolean("commit_dialog_signed_off_by") || !this.commitMessageComponent.isSignedOff() || !message.trim().equals("Signed-off-by: " + this.commitMessageComponent.getCommitter());
    }

    private ObjectId getCommitId(RevCommit commit) {
        if (commit == null) {
            return ObjectId.zeroId();
        }
        return commit.getId();
    }

    private void saveCommitMessageComponentState() {
        Repository repo = this.commitMessageComponent.getRepository();
        if (repo != null) {
            CommitMessageComponentStateManager.persistState(repo, this.commitMessageComponent.getState());
        }
    }

    private void deleteCommitMessageComponentState() {
        if (this.commitMessageComponent.getRepository() != null) {
            CommitMessageComponentStateManager.deleteState(this.commitMessageComponent.getRepository());
        }
    }

    private CommitMessageComponentState loadCommitMessageComponentState() {
        return CommitMessageComponentStateManager.loadState(this.currentRepository);
    }

    private Collection<String> getStagedFileNames() {
        StagingViewContentProvider stagedContentProvider = this.getContentProvider((ContentViewer)this.stagedViewer);
        StagingEntry[] entries = stagedContentProvider.getStagingEntries();
        ArrayList<String> files = new ArrayList<String>();
        StagingEntry[] stagingEntryArray = entries;
        int n = entries.length;
        int n2 = 0;
        while (n2 < n) {
            StagingEntry entry = stagingEntryArray[n2];
            files.add(entry.getPath());
            ++n2;
        }
        return files;
    }

    private void commit(boolean pushUpstream) {
        boolean reEnable = false;
        this.enableAllWidgets(false);
        try {
            try {
                boolean jobScheduled = this.internalCommit(pushUpstream, () -> this.enableAllWidgets(true));
                reEnable = !jobScheduled;
            }
            catch (RuntimeException e) {
                reEnable = true;
                Activator.handleError(e.getLocalizedMessage(), e, true);
                if (reEnable) {
                    this.enableAllWidgets(true);
                }
            }
        }
        finally {
            if (reEnable) {
                this.enableAllWidgets(true);
            }
        }
    }

    private boolean internalCommit(boolean pushUpstream, final Runnable afterJob) {
        if (!this.isCommitPossible()) {
            MessageDialog md = new MessageDialog(this.getSite().getShell(), UIText.StagingView_committingNotPossible, null, UIText.StagingView_noStagedFiles, 1, new String[]{IDialogConstants.CLOSE_LABEL}, 0);
            md.open();
            return false;
        }
        if (!this.commitMessageComponent.checkCommitInfo()) {
            return false;
        }
        if (!UIUtils.saveAllEditors(this.currentRepository, UIText.StagingView_cancelCommitAfterSaving)) {
            return false;
        }
        String commitMessage = this.commitMessageComponent.getCommitMessage();
        CommitOperation commitOperation = null;
        try {
            commitOperation = new CommitOperation(this.currentRepository, this.commitMessageComponent.getAuthor(), this.commitMessageComponent.getCommitter(), commitMessage);
        }
        catch (CoreException e) {
            Activator.handleError(UIText.StagingView_commitFailed, e, true);
            return false;
        }
        if (this.amendPreviousCommitAction.isChecked()) {
            commitOperation.setAmending(true);
        }
        boolean withChangeId = this.addChangeIdAction.isChecked();
        commitOperation.setComputeChangeId(withChangeId);
        commitOperation.setSign(this.signCommitAction.isChecked());
        PushMode pushMode = null;
        if (pushUpstream) {
            pushMode = this.getPushMode(this.currentRepository);
        }
        CommitJob commitJob = new CommitJob(this.currentRepository, commitOperation).setOpenCommitEditor(this.openNewCommitsAction.isChecked()).setPushUpstream(pushMode).setForce(this.pushSettings.isForce()).setDialog(this.pushSettings.alwaysShowDialog());
        commitJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                StagingView.this.asyncExec(() -> {
                    afterJob.run();
                    if (event.getResult().isOK()) {
                        StagingView.this.commitMessageText.setText(StagingView.EMPTY_STRING);
                    }
                });
            }
        });
        this.schedule(commitJob, true);
        CommitMessageHistory.saveCommitHistory(commitMessage);
        this.clearCommitMessageToggles();
        return true;
    }

    private PushMode getPushMode(Repository repository) {
        PushMode pushMode = null;
        if (repository != null) {
            PushMode cached;
            pushMode = PushMode.UPSTREAM;
            boolean withChangeId = this.addChangeIdAction.isChecked();
            if (repository == this.currentRepository && (cached = this.currentPushMode.get(withChangeId)) != null) {
                return cached;
            }
            try {
                if (withChangeId && RemoteConfig.getAllRemoteConfigs((Config)repository.getConfig()).stream().anyMatch(GerritUtil::isGerritPush)) {
                    pushMode = PushMode.GERRIT;
                }
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
            if (repository == this.currentRepository) {
                this.currentPushMode.put(withChangeId, pushMode);
            }
        }
        return pushMode;
    }

    private void schedule(Job job, boolean useRepositoryRule) {
        IWorkbenchSiteProgressService service;
        if (useRepositoryRule) {
            job.setRule(RuleUtil.getRule((Repository)this.currentRepository));
        }
        if ((service = (IWorkbenchSiteProgressService)this.getSite().getService(IWorkbenchSiteProgressService.class)) != null) {
            service.schedule(job, 0L, true);
        } else {
            job.schedule();
        }
    }

    private boolean isCommitPossible() {
        return this.stagedViewer.getTree().getItemCount() > 0 || this.amendPreviousCommitAction.isChecked() || CommitHelper.isCommitWithoutFilesAllowed(this.currentRepository);
    }

    public void setFocus() {
        Tree tree = this.unstagedViewer.getTree();
        if (tree.getItemCount() > 0 && !this.isAutoStageOnCommitEnabled()) {
            this.unstagedViewer.getControl().setFocus();
            return;
        }
        this.commitMessageText.setFocus();
    }

    private boolean isAutoStageOnCommitEnabled() {
        IPreferenceStore uiPreferences = Activator.getDefault().getPreferenceStore();
        return uiPreferences.getBoolean("auto_stage_on_commit");
    }

    public void dispose() {
        super.dispose();
        ISelectionService srv = (ISelectionService)this.getSite().getService(ISelectionService.class);
        srv.removePostSelectionListener(this.selectionChangedListener);
        ((IPartService)this.getSite().getService(IPartService.class)).removePartListener((IPartListener2)this.partListener);
        if (this.cacheEntry != null) {
            this.cacheEntry.removeIndexDiffChangedListener(this.myIndexDiffListener);
        }
        if (this.pushSettings != null) {
            this.pushSettings.dispose();
        }
        if (this.undoRedoActionGroup != null) {
            this.undoRedoActionGroup.dispose();
        }
        InstanceScope.INSTANCE.getNode("org.eclipse.egit.core").removePreferenceChangeListener(this.prefListener);
        this.removeRepositoryListeners();
        if (this.switchRepositoriesAction != null) {
            this.switchRepositoriesAction.dispose();
            this.switchRepositoriesAction = null;
        }
        if (this.presentationAction != null) {
            this.presentationAction.dispose();
            this.presentationAction = null;
        }
        this.getPreferenceStore().removePropertyChangeListener(this.uiPrefsListener);
        this.getDialogSettings().put(STORE_SORT_STATE, this.sortAction.isChecked());
        if (this.titleLabelProvider != null) {
            this.titleLabelProvider.dispose();
            this.titleLabelProvider = null;
        }
        this.titleNode = null;
        this.titleLabels.clear();
        this.currentRepository = null;
        this.lastSelection = null;
        this.disposed = true;
    }

    private boolean isDisposed() {
        return this.disposed;
    }

    private static void syncExec(Runnable runnable) {
        PlatformUI.getWorkbench().getDisplay().syncExec(runnable);
    }

    private void asyncExec(Runnable runnable) {
        if (!this.isDisposed()) {
            PlatformUI.getWorkbench().getDisplay().asyncExec(() -> {
                if (!this.isDisposed()) {
                    runnable.run();
                }
            });
        }
    }

    private void asyncUpdate(final Runnable runnable) {
        if (this.isDisposed()) {
            return;
        }
        WorkbenchJob update = new WorkbenchJob(UIText.StagingView_LoadJob){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                try {
                    runnable.run();
                    return Status.OK_STATUS;
                }
                catch (Exception e) {
                    return Activator.createErrorStatus(e.getLocalizedMessage(), e);
                }
            }

            public boolean shouldSchedule() {
                return super.shouldSchedule() && !StagingView.this.isDisposed();
            }

            public boolean shouldRun() {
                return super.shouldRun() && !StagingView.this.isDisposed();
            }

            public boolean belongsTo(Object family) {
                return family == JobFamilies.STAGING_VIEW_RELOAD || super.belongsTo(family);
            }
        };
        update.setSystem(true);
        update.schedule();
    }

    private boolean canPushHeadOnly() {
        Repository repo = this.currentRepository;
        try {
            return repo != null && repo.resolve("HEAD") != null && !this.isCommitPossible();
        }
        catch (IOException e) {
            return false;
        }
    }

    private boolean canPushWithoutConfirmation(PushMode pushMode) {
        Repository repo = this.currentRepository;
        if (repo != null && pushMode != PushMode.GERRIT) {
            RemoteConfig config = SimpleConfigurePushDialog.getConfiguredRemote(repo);
            boolean alwaysShowPushWizard = this.pushSettings.alwaysShowDialog();
            return config != null && !alwaysShowPushWizard;
        }
        return false;
    }

    @Nullable
    static StagingEntry getStagingEntry(Object element) {
        TreeItem item;
        StagingEntry entry = null;
        if (element instanceof StagingEntry) {
            entry = (StagingEntry)element;
        }
        if (element instanceof TreeItem && (item = (TreeItem)element).getData() instanceof StagingEntry) {
            entry = (StagingEntry)item.getData();
        }
        return entry;
    }

    private class DeleteAction
    extends Action {
        private final IStructuredSelection selection;

        DeleteAction(IStructuredSelection selection) {
            super(UIText.StagingView_DeleteItemMenuLabel, UIIcons.ELCL16_DELETE);
            this.selection = selection;
        }

        public void run() {
            DeletePathsOperationUI operation = new DeletePathsOperationUI(StagingView.getSelectedPaths(this.selection), (IShellProvider)StagingView.this.getSite());
            operation.run();
        }
    }

    private class GlobalDeleteActionHandler
    extends Action {
        private GlobalDeleteActionHandler() {
        }

        public void run() {
            DeletePathsOperationUI operation = new DeletePathsOperationUI(StagingView.getSelectedPaths(this.getSelection()), (IShellProvider)StagingView.this.getSite());
            operation.run();
        }

        public boolean isEnabled() {
            if (!StagingView.this.unstagedViewer.getTree().isFocusControl()) {
                return false;
            }
            IStructuredSelection selection = this.getSelection();
            if (selection.isEmpty()) {
                return false;
            }
            for (Object element : selection.toList()) {
                if (!(element instanceof StagingEntry)) {
                    return false;
                }
                StagingEntry entry = (StagingEntry)element;
                if (entry.getAvailableActions().contains((Object)StagingEntry.Action.DELETE)) continue;
                return false;
            }
            return true;
        }

        private IStructuredSelection getSelection() {
            return (IStructuredSelection)StagingView.this.unstagedViewer.getSelection();
        }
    }

    private static class IgnoreAction
    extends Action {
        private final IStructuredSelection selection;

        IgnoreAction(IStructuredSelection selection) {
            super(UIText.StagingView_IgnoreItemMenuLabel, UIIcons.IGNORE);
            this.selection = selection;
        }

        public void run() {
            IgnoreOperationUI operation = new IgnoreOperationUI(StagingView.getSelectedPaths(this.selection));
            operation.run();
        }
    }

    private static class IgnoreFoldersAction
    extends Action {
        private final Set<StagingFolderEntry> selection;

        IgnoreFoldersAction(Set<StagingFolderEntry> selection) {
            super(UIText.StagingView_IgnoreFolderMenuLabel);
            this.selection = selection;
        }

        public void run() {
            ArrayList<IPath> paths = new ArrayList<IPath>();
            for (StagingFolderEntry folder : this.selection) {
                paths.add(folder.getLocation());
            }
            IgnoreOperationUI operation = new IgnoreOperationUI(paths);
            operation.run();
        }
    }

    private final class PartListener
    extends PartVisibilityListener {
        public PartListener() {
            super((IWorkbenchPart)StagingView.this);
        }

        public void partActivated(IWorkbenchPartReference partRef) {
            if (this.isMe(partRef)) {
                if (StagingView.this.lastSelection != null) {
                    StagingView.this.reactOnSelection((ISelection)StagingView.this.lastSelection);
                    StagingView.this.lastSelection = null;
                }
                return;
            }
            IWorkbenchPart part = partRef.getPart(false);
            StructuredSelection sel = StagingView.getSelectionOfPart(part);
            if (!this.isVisible()) {
                StagingView.this.lastSelection = sel;
            } else {
                StagingView.this.lastSelection = null;
                if (sel != null) {
                    StagingView.this.reactOnSelection((ISelection)sel);
                }
            }
        }
    }

    public static enum Presentation {
        LIST,
        TREE,
        COMPACT_TREE;

    }

    private static class PresentationAction
    extends DropDownMenuAction
    implements IPropertyChangeListener {
        private final IPreferenceStore store;
        @NonNull
        private final List<IAction> actions;

        public PresentationAction(IPreferenceStore store, IAction ... actions) {
            super(UIText.StagingView_Presentation);
            List<Object> a = actions != null ? Arrays.asList(actions) : Collections.emptyList();
            this.actions = a;
            this.store = store;
            store.addPropertyChangeListener((IPropertyChangeListener)this);
        }

        @Override
        protected Collection<IContributionItem> getActions() {
            return this.actions.stream().map(ActionContributionItem::new).collect(Collectors.toList());
        }

        @Override
        public void dispose() {
            this.store.removePropertyChangeListener((IPropertyChangeListener)this);
            super.dispose();
        }

        public void propertyChange(PropertyChangeEvent event) {
            if ("StagingView_Presentation".equals(event.getProperty())) {
                Presentation current = StagingView.getPresentation(event.getNewValue().toString(), Presentation.LIST);
                switch (current) {
                    case LIST: {
                        this.setImageDescriptor(UIIcons.FLAT);
                        break;
                    }
                    case TREE: {
                        this.setImageDescriptor(UIIcons.HIERARCHY);
                        break;
                    }
                    case COMPACT_TREE: {
                        this.setImageDescriptor(UIIcons.COMPACT);
                        break;
                    }
                    default: {
                        return;
                    }
                }
            }
        }
    }

    private class ReplaceAction
    extends Action {
        private final IStructuredSelection selection;
        private final boolean headRevision;

        ReplaceAction(@NonNull String text, IStructuredSelection selection, boolean headRevision) {
            super(text);
            this.selection = selection;
            this.headRevision = headRevision;
        }

        private void getSelectedFiles(@NonNull List<String> files, @NonNull List<String> inaccessibleFiles) {
            for (Object selectedItem : this.selection) {
                if (!(selectedItem instanceof StagingEntry)) continue;
                StagingEntry stagingEntry = (StagingEntry)selectedItem;
                String path = stagingEntry.getPath();
                files.add(path);
                IFile resource = stagingEntry.getFile();
                if (resource != null && resource.isAccessible()) continue;
                inaccessibleFiles.add(path);
            }
        }

        public void run() {
            final Repository repo = StagingView.this.getCurrentRepository();
            if (repo == null) {
                return;
            }
            ArrayList<String> files = new ArrayList<String>();
            final ArrayList<String> inaccessibleFiles = new ArrayList<String>();
            this.getSelectedFiles(files, inaccessibleFiles);
            if (files.isEmpty()) {
                return;
            }
            if (!CommandConfirmation.confirmCheckout(StagingView.this.form.getShell(), repo)) {
                return;
            }
            DiscardChangesOperation operation = new DiscardChangesOperation(repo, files);
            if (this.headRevision) {
                operation.setRevision("HEAD");
            }
            JobChangeAdapter refresher = null;
            if (!inaccessibleFiles.isEmpty()) {
                refresher = new JobChangeAdapter(){

                    public void done(IJobChangeEvent event) {
                        IndexDiffCacheEntry indexDiffCacheForRepository = IndexDiffCache.INSTANCE.getIndexDiffCacheEntry(repo);
                        if (indexDiffCacheForRepository != null) {
                            indexDiffCacheForRepository.refreshFiles((Collection)inaccessibleFiles);
                        }
                    }
                };
            }
            JobUtil.scheduleUserWorkspaceJob((IEGitOperation)operation, (String)UIText.DiscardChangesAction_discardChanges, (Object)JobFamilies.DISCARD_CHANGES, refresher);
        }
    }

    private static class StagingDragListener
    extends DragSourceAdapter {
        private final ISelectionProvider provider;
        private final StagingViewContentProvider contentProvider;
        private final boolean unstaged;

        public StagingDragListener(ISelectionProvider provider, StagingViewContentProvider contentProvider, boolean unstaged) {
            this.provider = provider;
            this.contentProvider = contentProvider;
            this.unstaged = unstaged;
        }

        public void dragStart(DragSourceEvent event) {
            event.doit = !this.provider.getSelection().isEmpty();
        }

        public void dragFinished(DragSourceEvent event) {
            if (LocalSelectionTransfer.getTransfer().isSupportedType(event.dataType)) {
                LocalSelectionTransfer.getTransfer().setSelection(null);
            }
        }

        public void dragSetData(DragSourceEvent event) {
            IStructuredSelection selection = (IStructuredSelection)this.provider.getSelection();
            if (selection.isEmpty()) {
                return;
            }
            if (LocalSelectionTransfer.getTransfer().isSupportedType(event.dataType)) {
                LocalSelectionTransfer.getTransfer().setSelection((ISelection)new StagingDragSelection(selection, this.unstaged));
                return;
            }
            if (FileTransfer.getInstance().isSupportedType(event.dataType)) {
                HashSet<String> files = new HashSet<String>();
                for (Object selected : selection.toList()) {
                    if (selected instanceof StagingEntry) {
                        this.add((StagingEntry)selected, files);
                        continue;
                    }
                    if (!(selected instanceof StagingFolderEntry)) continue;
                    StagingFolderEntry folder = (StagingFolderEntry)selected;
                    for (StagingEntry entry : this.contentProvider.getStagingEntriesFiltered(folder)) {
                        this.add(entry, files);
                    }
                }
                if (!files.isEmpty()) {
                    event.data = files.toArray(new String[0]);
                    return;
                }
            }
        }

        private void add(StagingEntry entry, Collection<String> files) {
            File file = entry.getLocation().toFile();
            if (file.exists()) {
                files.add(file.getAbsolutePath());
            }
        }
    }

    private static class StagingDragSelection
    implements IStructuredSelection {
        private final IStructuredSelection delegate;
        private final boolean fromUnstaged;

        public StagingDragSelection(IStructuredSelection original, boolean fromUnstaged) {
            this.delegate = original;
            this.fromUnstaged = fromUnstaged;
        }

        public boolean isEmpty() {
            return this.delegate.isEmpty();
        }

        public Object getFirstElement() {
            return this.delegate.getFirstElement();
        }

        public Iterator iterator() {
            return this.delegate.iterator();
        }

        public int size() {
            return this.delegate.size();
        }

        public Object[] toArray() {
            return this.delegate.toArray();
        }

        public List toList() {
            return this.delegate.toList();
        }

        public boolean isFromUnstaged() {
            return this.fromUnstaged;
        }
    }

    private static class StagingEntryComparator
    extends ViewerComparator {
        private boolean alphabeticSort;
        private Comparator<String> comparator;
        private boolean fileNamesFirst;

        private StagingEntryComparator(boolean alphabeticSort, boolean fileNamesFirst) {
            this.alphabeticSort = alphabeticSort;
            this.setFileNamesFirst(fileNamesFirst);
            this.comparator = CommonUtils.STRING_ASCENDING_COMPARATOR;
        }

        public boolean isFileNamesFirst() {
            return this.fileNamesFirst;
        }

        public void setFileNamesFirst(boolean fileNamesFirst) {
            this.fileNamesFirst = fileNamesFirst;
        }

        private void setAlphabeticSort(boolean sort) {
            this.alphabeticSort = sort;
        }

        private boolean isAlphabeticSort() {
            return this.alphabeticSort;
        }

        public int category(Object element) {
            StagingEntry stagingEntry;
            if (!this.isAlphabeticSort() && (stagingEntry = StagingView.getStagingEntry(element)) != null) {
                return this.getState(stagingEntry);
            }
            return super.category(element);
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            int cat2;
            int cat1 = this.category(e1);
            if (cat1 != (cat2 = this.category(e2))) {
                return cat1 - cat2;
            }
            String name1 = this.getStagingEntryText(e1);
            String name2 = this.getStagingEntryText(e2);
            return this.comparator.compare(name1, name2);
        }

        private String getStagingEntryText(Object element) {
            String text = StagingView.EMPTY_STRING;
            StagingEntry stagingEntry = StagingView.getStagingEntry(element);
            if (stagingEntry != null) {
                text = stagingEntry.getPath().replace('/', '\u0001');
                if (this.isFileNamesFirst()) {
                    text = String.valueOf(stagingEntry.getName()) + '\u0001' + text;
                }
            } else if (element instanceof StagingFolderEntry) {
                text = ((StagingFolderEntry)element).getLabel().replace('/', '\u0001');
            }
            return text;
        }

        private int getState(StagingEntry entry) {
            switch (entry.getState()) {
                case CONFLICTING: {
                    return 1;
                }
                case MODIFIED: {
                    return 2;
                }
                case MODIFIED_AND_ADDED: {
                    return 3;
                }
                case MODIFIED_AND_CHANGED: {
                    return 4;
                }
                case ADDED: {
                    return 5;
                }
                case CHANGED: {
                    return 6;
                }
                case MISSING: {
                    return 7;
                }
                case MISSING_AND_CHANGED: {
                    return 8;
                }
                case REMOVED: {
                    return 9;
                }
                case UNTRACKED: {
                    return 10;
                }
            }
            return super.category((Object)entry);
        }
    }

    static class StagingViewSearchThread
    extends Thread {
        private StagingView stagingView;
        private static final Object lock = new Object();
        private static volatile int globalThreadIndex = 0;
        private int currentThreadIx;

        public StagingViewSearchThread(StagingView stagingView) {
            super("staging_view_filter_thread" + ++globalThreadIndex);
            this.stagingView = stagingView;
            this.currentThreadIx = globalThreadIndex;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object = lock;
            synchronized (object) {
                if (this.currentThreadIx < globalThreadIndex) {
                    return;
                }
                this.stagingView.refreshViewersPreservingExpandedElements();
            }
        }
    }

    static class StagingViewUpdate {
        Repository repository;
        IndexDiffData indexDiff;
        Collection<String> changedResources;

        StagingViewUpdate(Repository theRepository, IndexDiffData theIndexDiff, Collection<String> theChanges) {
            this.repository = theRepository;
            this.indexDiff = theIndexDiff;
            this.changedResources = theChanges;
        }
    }

    private static enum StagingViewerUpdate {
        ADDED,
        REMOVED,
        UNCHANGED;

    }

    private static class TreeDecoratingLabelProvider
    extends ColumnLabelProvider
    implements IViewerLabelProvider {
        private final DecoratingLabelProvider provider;
        private final StagingViewLabelProvider base;

        public TreeDecoratingLabelProvider(StagingViewLabelProvider base, ILabelDecorator decorator) {
            this.base = base;
            this.provider = new DecoratingLabelProvider((ILabelProvider)base, decorator);
        }

        public StagingViewLabelProvider getBaseLabelProvider() {
            return this.base;
        }

        public Image getImage(Object element) {
            return this.provider.getImage(element);
        }

        public String getText(Object element) {
            return this.provider.getText(element);
        }

        public void addListener(ILabelProviderListener listener) {
            this.provider.addListener(listener);
        }

        public void removeListener(ILabelProviderListener listener) {
            this.provider.removeListener(listener);
        }

        public void dispose() {
            this.provider.dispose();
        }

        public void updateLabel(ViewerLabel label, Object element) {
            this.provider.updateLabel(label, element);
        }
    }

    private static abstract class TreeItemVisitor {
        private final TreeItem[] roots;

        public TreeItemVisitor(TreeItem[] roots) {
            this.roots = roots;
        }

        public abstract boolean visit(TreeItem var1);

        public void traverse(TreeItem treeItem) {
            if (treeItem == null && (treeItem = this.getLastItem(this.roots)) == null) {
                return;
            }
            if (treeItem.isDisposed()) {
                return;
            }
            if (treeItem.getData() != null && this.visit(treeItem)) {
                this.traversePrecedingSiblings(treeItem);
            }
        }

        private TreeItem getLastItem(TreeItem[] treeItems) {
            TreeItem result;
            if (treeItems.length == 0) {
                return null;
            }
            TreeItem lastItem = treeItems[treeItems.length - 1];
            if (lastItem.getExpanded() && (result = this.getLastItem(lastItem.getItems())) != null) {
                return result;
            }
            return lastItem;
        }

        private boolean traversePrecedingSiblings(TreeItem treeItem) {
            TreeItem parent = treeItem.getParentItem();
            if (parent == null) {
                return this.traversePrecedingSiblings(this.roots, treeItem);
            }
            if (!this.traversePrecedingSiblings(parent.getItems(), treeItem)) {
                return false;
            }
            return this.traversePrecedingSiblings(parent);
        }

        private boolean traversePrecedingSiblings(TreeItem[] siblings, TreeItem treeItem) {
            boolean start = false;
            int i = siblings.length - 1;
            while (i >= 0) {
                TreeItem sibling = siblings[i];
                if (start) {
                    if (!this.traverseChildren(sibling)) {
                        return false;
                    }
                } else if (sibling == treeItem) {
                    start = true;
                }
                --i;
            }
            return true;
        }

        private boolean traverseChildren(TreeItem treeItem) {
            if (treeItem.getExpanded()) {
                TreeItem[] children = treeItem.getItems();
                int i = children.length - 1;
                while (i >= 0) {
                    if (!this.traverseChildren(children[i])) {
                        return false;
                    }
                    --i;
                }
            }
            return this.visit(treeItem);
        }
    }
}

